/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class PaintUtils {
    private static Border defaultBorder = BorderFactory.createBevelBorder(0);

    public static Border getDefaultBorder() {
        return defaultBorder;
    }

    public static Rectangle getTextBounds(Graphics graphics, JLabel jLabel) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(jLabel.getText(), graphics);
        Rectangle rectangle = rectangle2D.getBounds();
        int n = 0;
        switch (jLabel.getHorizontalAlignment()) {
            case 4: 
            case 11: {
                n = jLabel.getBounds().width - rectangle.width;
                break;
            }
            case 0: {
                n = (jLabel.getBounds().width - rectangle.width) / 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        int n2 = 0;
        switch (jLabel.getVerticalAlignment()) {
            case 1: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = (jLabel.getBounds().height - rectangle.height) / 2;
                break;
            }
            case 3: {
                n2 = jLabel.getBounds().height - rectangle.height;
            }
        }
        return new Rectangle(n, n2, rectangle.width, rectangle.height);
    }

    public static void paintGradient(Graphics graphics, JComponent jComponent, Color color, Color color2) {
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 0.0f, jComponent.getHeight(), color2, true);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        graphics2D.setPaint(paint);
    }

    public static void setBackgroundColor(Container container, Color color) {
        container.setBackground(color);
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof Container) {
                PaintUtils.setBackgroundColor((Container)componentArray[i], color);
                continue;
            }
            componentArray[i].setBackground(color);
        }
    }

    public static void setForegroundColor(Container container, Color color) {
        container.setForeground(color);
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof Container) {
                PaintUtils.setForegroundColor((Container)componentArray[i], color);
                continue;
            }
            componentArray[i].setForeground(color);
        }
    }

    public static void setFont(Container container, Font font) {
        container.setFont(font);
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof Container) {
                PaintUtils.setFont((Container)componentArray[i], font);
                continue;
            }
            componentArray[i].setFont(font);
        }
    }
}

