/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.Comparator;
import java.util.Hashtable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.decorator.Sorter;

public class TableColumnExt
extends TableColumn
implements Cloneable {
    public static final String SORTER_COMPARATOR = "Sorter.COMPARATOR";
    protected boolean editable = true;
    protected boolean visible = true;
    protected Object prototypeValue = null;
    private Hashtable clientProperties = null;
    protected Sorter sorter = null;
    private Constructor sorterConstructor = defaultSorterConstructor;
    private static final Constructor defaultSorterConstructor;
    private static final Class[] sorterConstructorSignature;

    public TableColumnExt() {
        this(0);
    }

    public TableColumnExt(int n) {
        this(n, 75);
    }

    public TableColumnExt(int n, int n2) {
        this(n, n2, null, null);
    }

    public TableColumnExt(int n, int n2, TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor) {
        super(n, n2, tableCellRenderer, tableCellEditor);
    }

    public boolean getResizable() {
        return super.getResizable() && this.getMinWidth() < this.getMaxWidth();
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.editable;
        this.editable = bl;
        this.firePropertyChange("editable", bl2, bl);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setPrototypeValue(Object object) {
        Object object2 = this.prototypeValue;
        this.prototypeValue = object;
        this.firePropertyChange("prototypeValue", object2, object);
    }

    public Object getPrototypeValue() {
        return this.prototypeValue;
    }

    public void setSorterClass(String string) {
        if (string == null || string.length() == 0) {
            this.sorterConstructor = null;
        } else {
            try {
                Class<?> clazz = Class.forName(string, true, this.getClass().getClassLoader());
                this.sorterConstructor = clazz.getConstructor(sorterConstructorSignature);
            }
            catch (Exception exception) {
                this.sorterConstructor = null;
            }
        }
    }

    public String getSorterClass() {
        return this.sorterConstructor == null ? null : this.sorterConstructor.getDeclaringClass().getName();
    }

    public Sorter getSorter() {
        if (this.sorter == null && this.sorterConstructor != null) {
            try {
                this.sorter = (Sorter)this.sorterConstructor.newInstance(new Integer(this.getModelIndex()), new Boolean(true));
                Object object = this.getClientProperty(SORTER_COMPARATOR);
                if (object instanceof Comparator) {
                    this.sorter.setComparator((Comparator)object);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.sorter;
    }

    public boolean isSortable() {
        return this.sorterConstructor != null;
    }

    public void setTitle(String string) {
        this.setHeaderValue(string);
    }

    public String getTitle() {
        return this.getHeaderValue().toString();
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.visible;
        this.visible = bl;
        this.firePropertyChange("visible", bl2, bl);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void putClientProperty(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("null key");
        }
        if (object2 == null && this.getClientProperty(object) == null) {
            return;
        }
        if (object2 == null) {
            this.getClientProperties().remove(object);
        } else {
            this.getClientProperties().put(object, object2);
        }
    }

    public Object getClientProperty(Object object) {
        return object == null || this.clientProperties == null ? null : this.clientProperties.get(object);
    }

    private Hashtable getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable();
        }
        return this.clientProperties;
    }

    public Object clone() {
        TableColumnExt tableColumnExt = new TableColumnExt(this.getModelIndex(), this.getWidth(), this.getCellRenderer(), this.getCellEditor());
        tableColumnExt.setEditable(this.isEditable());
        tableColumnExt.setHeaderValue(this.getHeaderValue());
        tableColumnExt.setIdentifier(this.getIdentifier());
        tableColumnExt.setMaxWidth(this.getMaxWidth());
        tableColumnExt.setMinWidth(this.getMinWidth());
        tableColumnExt.setPreferredWidth(this.getPreferredWidth());
        tableColumnExt.setPrototypeValue(this.getPrototypeValue());
        tableColumnExt.setResizable(super.getResizable());
        tableColumnExt.setVisible(this.isVisible());
        tableColumnExt.setSorterClass(this.getSorterClass());
        tableColumnExt.sorterConstructor = this.sorterConstructor;
        return tableColumnExt;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeListener[] propertyChangeListenerArray;
        if ((object != null && !object.equals(object2) || object == null && object2 != null) && (propertyChangeListenerArray = this.getPropertyChangeListeners()) != null && propertyChangeListenerArray.length != 0) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
                propertyChangeListenerArray[i].propertyChange(propertyChangeEvent);
            }
        }
    }

    static {
        sorterConstructorSignature = new Class[]{Integer.TYPE, Boolean.TYPE};
        Constructor<?> constructor = null;
        try {
            Class<?> clazz = Class.forName("org.jdesktop.swingx.decorator.ShuttleSorter", true, TableColumnExt.class.getClassLoader());
            constructor = clazz.getConstructor(sorterConstructorSignature);
        }
        catch (Exception exception) {
            // empty catch block
        }
        defaultSorterConstructor = constructor;
    }
}

