/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.event;

import java.util.logging.Level;
import javax.swing.event.EventListenerList;
import org.jdesktop.swingx.event.MessageEvent;
import org.jdesktop.swingx.event.MessageListener;
import org.jdesktop.swingx.event.MessageSource;
import org.jdesktop.swingx.event.ProgressEvent;
import org.jdesktop.swingx.event.ProgressListener;
import org.jdesktop.swingx.event.ProgressSource;

public class MessageSourceSupport
implements MessageSource,
ProgressSource {
    private EventListenerList listeners;
    private Object source;

    public MessageSourceSupport(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("source Object cannot be null");
        }
        this.source = object;
        this.listeners = new EventListenerList();
    }

    public void addMessageListener(MessageListener messageListener) {
        if (messageListener != null) {
            this.listeners.add(MessageListener.class, messageListener);
        }
    }

    public void removeMessageListener(MessageListener messageListener) {
        if (messageListener != null) {
            this.listeners.remove(MessageListener.class, messageListener);
        }
    }

    public MessageListener[] getMessageListeners() {
        return (MessageListener[])this.listeners.getListeners(MessageListener.class);
    }

    public void addProgressListener(ProgressListener progressListener) {
        if (progressListener != null) {
            this.listeners.add(ProgressListener.class, progressListener);
        }
    }

    public void removeProgressListener(ProgressListener progressListener) {
        if (progressListener != null) {
            this.listeners.remove(ProgressListener.class, progressListener);
        }
    }

    public ProgressListener[] getProgressListeners() {
        return (ProgressListener[])this.listeners.getListeners(ProgressListener.class);
    }

    public void fireProgressStarted(int n, int n2) {
        this.fireProgressStarted(new ProgressEvent(this.source, n, n2));
    }

    public void fireProgressIncremented(int n) {
        this.fireProgressIncremented(new ProgressEvent(this.source, n));
    }

    public void fireProgressEnded() {
        this.fireProgressEnded(new ProgressEvent(this.source));
    }

    public void fireException(Throwable throwable) {
        this.fireMessage(new MessageEvent(this.source, throwable, Level.SEVERE));
    }

    public void fireMessage(String string) {
        this.fireMessage(string, Level.INFO);
    }

    public void fireMessage(Object object, Level level) {
        this.fireMessage(object, level, 0L);
    }

    public void fireMessage(Object object, Level level, long l) {
        this.fireMessage(new MessageEvent(this.source, object, level, l));
    }

    public void fireMessage(MessageEvent messageEvent) {
        if (messageEvent == null) {
            throw new IllegalArgumentException("the event should not be null");
        }
        MessageListener[] messageListenerArray = this.getMessageListeners();
        for (int i = 0; i < messageListenerArray.length; ++i) {
            messageListenerArray[i].message(messageEvent);
        }
    }

    public void fireProgressIncremented(ProgressEvent progressEvent) {
        if (progressEvent == null) {
            throw new IllegalArgumentException("the event should not be null");
        }
        ProgressListener[] progressListenerArray = this.getProgressListeners();
        for (int i = 0; i < progressListenerArray.length; ++i) {
            progressListenerArray[i].progressIncremented(progressEvent);
        }
    }

    public void fireProgressStarted(ProgressEvent progressEvent) {
        if (progressEvent == null) {
            throw new IllegalArgumentException("the event should not be null");
        }
        ProgressListener[] progressListenerArray = this.getProgressListeners();
        for (int i = 0; i < progressListenerArray.length; ++i) {
            progressListenerArray[i].progressStarted(progressEvent);
        }
    }

    public void fireProgressEnded(ProgressEvent progressEvent) {
        if (progressEvent == null) {
            throw new IllegalArgumentException("the event should not be null");
        }
        ProgressListener[] progressListenerArray = this.getProgressListeners();
        for (int i = 0; i < progressListenerArray.length; ++i) {
            progressListenerArray[i].progressEnded(progressEvent);
        }
    }
}

