/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.FilterPipeline;

public abstract class Sorter
extends Filter {
    private boolean ascending = true;
    private Collator collator;
    private Locale currentLocale;
    private Comparator comparator;

    public Sorter() {
        this(0, true);
    }

    public Sorter(int n, boolean bl) {
        this(n, bl, null);
    }

    public Sorter(int n, boolean bl, Comparator comparator) {
        super(n);
        this.comparator = comparator;
        this.setAscending(bl);
    }

    protected void refresh(boolean bl) {
        this.refreshCollator();
        super.refresh(bl);
    }

    protected void refreshCollator() {
        if (!Locale.getDefault().equals(this.currentLocale)) {
            this.currentLocale = Locale.getDefault();
            this.collator = Collator.getInstance();
        }
    }

    protected Collator getCollator() {
        return this.collator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
        this.refresh();
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    protected abstract void adopt(Sorter var1);

    public void interpose(FilterPipeline filterPipeline, ComponentAdapter componentAdapter, Sorter sorter) {
        if (filterPipeline != null) {
            filterPipeline.setSorter(this);
        } else {
            this.releasePipeline();
            this.assign(componentAdapter);
            this.adopt(sorter);
            this.assign(filterPipeline);
            this.refresh(sorter == null);
        }
    }

    protected void releasePipeline() {
        if (this.getPipeline() != null) {
            this.getPipeline().setSorter(null);
            this.assign((FilterPipeline)null);
        }
    }

    public int compare(int n, int n2) {
        int n3 = this.compare(n, n2, this.getColumnIndex());
        return this.ascending ? n3 : -n3;
    }

    private int compare(int n, int n2, int n3) {
        Object object = this.getInputValue(n, n3);
        Object object2 = this.getInputValue(n2, n3);
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (this.comparator != null) {
            return this.comparator.compare(object, object2);
        }
        if (object.getClass() == String.class && object2.getClass() == String.class) {
            return this.collator.compare((String)object, (String)object2);
        }
        if (object.getClass().isInstance(object2) && object instanceof Comparable) {
            Comparable comparable = (Comparable)object;
            return comparable.compareTo(object2);
        }
        if (object2.getClass().isInstance(object) && object2 instanceof Comparable) {
            Comparable comparable = (Comparable)object2;
            return -comparable.compareTo(object);
        }
        return this.collator.compare(object.toString(), object2.toString());
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean bl) {
        this.ascending = bl;
        this.refresh();
    }

    public void toggle() {
        this.ascending = !this.ascending;
        this.refresh();
    }
}

