/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Color;
import java.awt.Component;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.jdesktop.swingx.decorator.ComponentAdapter;

public class Highlighter {
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    protected final boolean immutable;
    public static final Highlighter ledgerBackground = new Highlighter(new Color(245, 255, 245), null, true);
    public static final Highlighter notePadBackground = new Highlighter(new Color(255, 255, 204), null, true);
    private Color background = null;
    private Color foreground = null;
    private Color selectedBackground = null;
    private Color selectedForeground = null;

    public Highlighter() {
        this(null, null);
    }

    public Highlighter(Color color, Color color2) {
        this(color, color2, false);
    }

    public Highlighter(Color color, Color color2, boolean bl) {
        this(color, color2, null, null, bl);
    }

    public Highlighter(Color color, Color color2, Color color3, Color color4) {
        this(color, color2, color3, color4, false);
    }

    public Highlighter(Color color, Color color2, Color color3, Color color4, boolean bl) {
        this.immutable = bl;
        this.background = color;
        this.foreground = color2;
        this.selectedBackground = color3;
        this.selectedForeground = color4;
    }

    public Component highlight(Component component, ComponentAdapter componentAdapter) {
        return this.doHighlight(component, componentAdapter);
    }

    protected Component doHighlight(Component component, ComponentAdapter componentAdapter) {
        this.applyBackground(component, componentAdapter);
        this.applyForeground(component, componentAdapter);
        this.applyFont(component, componentAdapter);
        return component;
    }

    protected void applyBackground(Component component, ComponentAdapter componentAdapter) {
        Color color = this.computeBackground(component, componentAdapter);
        if (color != null) {
            component.setBackground(color);
        }
    }

    protected void applyForeground(Component component, ComponentAdapter componentAdapter) {
        Color color = this.computeForeground(component, componentAdapter);
        if (color != null) {
            component.setForeground(color);
        }
    }

    protected void applyFont(Component component, ComponentAdapter componentAdapter) {
    }

    protected Color computeBackground(Component component, ComponentAdapter componentAdapter) {
        Color color = this.background == null ? componentAdapter.target.getBackground() : this.background;
        return componentAdapter.isSelected() ? this.computeSelectedBackground(color) : color;
    }

    protected Color computeForeground(Component component, ComponentAdapter componentAdapter) {
        Color color = this.foreground == null ? componentAdapter.target.getForeground() : this.foreground;
        return componentAdapter.isSelected() ? this.computeSelectedForeground(color) : color;
    }

    protected Color computeSelectedBackground(Color color) {
        return this.selectedBackground;
    }

    protected Color computeSelectedForeground(Color color) {
        return this.selectedForeground;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        if (this.isImmutable()) {
            return;
        }
        this.background = color;
        this.fireStateChanged();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        if (this.isImmutable()) {
            return;
        }
        this.foreground = color;
        this.fireStateChanged();
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public void setSelectedBackground(Color color) {
        if (this.isImmutable()) {
            return;
        }
        this.selectedBackground = color;
        this.fireStateChanged();
    }

    public Color getSelectedForeground() {
        return this.selectedForeground;
    }

    public void setSelectedForeground(Color color) {
        if (this.isImmutable()) {
            return;
        }
        this.selectedForeground = color;
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.isImmutable()) {
            return;
        }
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.isImmutable()) {
            return;
        }
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        if (this.isImmutable()) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public static interface UIHighlighter {
        public void updateUI();
    }
}

