/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Container;
import javax.swing.BoxLayout;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.MouseMessagingHandler;
import org.jdesktop.swingx.event.MessageSource;
import org.jdesktop.swingx.event.ProgressSource;

public class JXRootPane
extends JRootPane {
    private JXStatusBar statusBar;
    private JToolBar toolBar;
    private JPanel contentPanel = new JPanel();
    private MouseMessagingHandler handler;

    public JXRootPane() {
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.getContentPane().add((Component)this.contentPanel, "Center");
    }

    public void addComponent(Component component) {
        this.contentPanel.add(component);
        this.registerStatusBar(component);
    }

    public void removeComponent(Component component) {
        this.contentPanel.remove(component);
        this.unregisterStatusBar(this.statusBar, component);
    }

    public Component[] getContentComponents() {
        return this.contentPanel.getComponents();
    }

    private void registerStatusBar(Component component) {
        Component[] componentArray;
        if (this.statusBar == null || component == null) {
            return;
        }
        if (component instanceof MessageSource) {
            componentArray = (MessageSource)((Object)component);
            componentArray.addMessageListener(this.statusBar);
        }
        if (component instanceof ProgressSource) {
            componentArray = (ProgressSource)((Object)component);
            componentArray.addProgressListener(this.statusBar);
        }
        if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.registerStatusBar(componentArray[i]);
            }
        }
    }

    private void unregisterStatusBar(JXStatusBar jXStatusBar, Component component) {
        Component[] componentArray;
        if (jXStatusBar == null || component == null) {
            return;
        }
        if (component instanceof MessageSource) {
            componentArray = (MessageSource)((Object)component);
            componentArray.removeMessageListener(jXStatusBar);
        }
        if (component instanceof ProgressSource) {
            componentArray = (ProgressSource)((Object)component);
            componentArray.removeProgressListener(jXStatusBar);
        }
        if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.unregisterStatusBar(jXStatusBar, componentArray[i]);
            }
        }
    }

    public void setStatusBar(JXStatusBar jXStatusBar) {
        JXStatusBar jXStatusBar2 = this.statusBar;
        this.statusBar = jXStatusBar;
        if (jXStatusBar != null) {
            if (this.handler == null) {
                this.handler = new MouseMessagingHandler((Object)this, jXStatusBar);
                if (this.toolBar != null) {
                    this.handler.registerListeners(this.toolBar.getComponents());
                }
                if (this.menuBar != null) {
                    this.handler.registerListeners(this.menuBar.getSubElements());
                }
            } else {
                this.handler.setMessageListener(jXStatusBar);
            }
        }
        Component[] componentArray = this.contentPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            this.unregisterStatusBar(jXStatusBar2, componentArray[i]);
            this.registerStatusBar(componentArray[i]);
        }
        if (jXStatusBar2 != null) {
            this.getContentPane().remove(jXStatusBar2);
        }
        if (jXStatusBar != null) {
            this.getContentPane().add("South", jXStatusBar);
        }
    }

    public JXStatusBar getStatusBar() {
        return this.statusBar;
    }

    public void setToolBar(JToolBar jToolBar) {
        JToolBar jToolBar2 = this.toolBar;
        this.toolBar = jToolBar;
        if (this.handler != null && jToolBar2 != null) {
            this.handler.unregisterListeners(jToolBar2.getComponents());
        }
        if (this.handler != null && jToolBar != null) {
            this.handler.registerListeners(jToolBar.getComponents());
        }
        this.getContentPane().add("North", jToolBar);
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        JMenuBar jMenuBar2 = this.menuBar;
        super.setJMenuBar(jMenuBar);
        if (this.handler != null && jMenuBar2 != null) {
            this.handler.unregisterListeners(jMenuBar2.getSubElements());
        }
        if (this.handler != null && jMenuBar != null) {
            this.handler.registerListeners(jMenuBar.getSubElements());
        }
    }
}

