/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXComboBox;
import org.jdesktop.swingx.JXImagePanel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.auth.DefaultUserNameStore;
import org.jdesktop.swingx.auth.LoginAdapter;
import org.jdesktop.swingx.auth.LoginEvent;
import org.jdesktop.swingx.auth.LoginService;
import org.jdesktop.swingx.auth.PasswordStore;
import org.jdesktop.swingx.auth.UserNameStore;
import org.jdesktop.swingx.plaf.JXLoginPanelAddon;
import org.jdesktop.swingx.plaf.LoginPanelUI;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.util.WindowUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXLoginPanel
extends JXImagePanel {
    private static final Logger LOG = Logger.getLogger(JXLoginPanel.class.getName());
    private static final long serialVersionUID = 3544949969896288564L;
    public static final String uiClassID = "LoginPanelUI";
    public static final String LOGIN_ACTION_COMMAND = "login";
    public static final String CANCEL_LOGIN_ACTION_COMMAND = "cancel-login";
    private static String CLASS_NAME;
    private Status status = Status.NOT_STARTED;
    private JXImagePanel banner;
    private String bannerText = "Login";
    private JLabel messageLabel;
    private JLabel errorMessageLabel;
    private JXPanel loginPanel;
    private JXPanel contentPanel;
    private NameComponent namePanel;
    private JPasswordField passwordField;
    private JXComboBox serverCombo;
    private JCheckBox saveCB;
    private JXPanel progressPanel;
    private JLabel progressMessageLabel;
    private LoginService loginService;
    private PasswordStore passwordStore;
    private UserNameStore userNameStore;
    private List<String> servers;
    private SaveMode saveMode;
    private LoginListenerImpl loginListener;
    private Cursor oldCursor;

    public JXLoginPanel() {
        this((LoginService)null);
    }

    public JXLoginPanel(LoginService loginService) {
        this(loginService, null, null);
    }

    public JXLoginPanel(LoginService loginService, PasswordStore passwordStore, UserNameStore userNameStore) {
        this(loginService, passwordStore, userNameStore, null);
    }

    public JXLoginPanel(LoginService loginService, PasswordStore passwordStore, UserNameStore userNameStore, List<String> arrayList) {
        this.loginService = loginService == null ? new NullLoginService() : loginService;
        this.passwordStore = passwordStore == null ? new NullPasswordStore() : passwordStore;
        this.userNameStore = userNameStore == null ? new DefaultUserNameStore() : userNameStore;
        this.servers = arrayList == null ? new ArrayList() : arrayList;
        this.getActionMap().put(LOGIN_ACTION_COMMAND, this.createLoginAction());
        this.getActionMap().put(CANCEL_LOGIN_ACTION_COMMAND, this.createCancelAction());
        this.saveMode = passwordStore != null && userNameStore != null ? SaveMode.BOTH : (passwordStore != null ? SaveMode.PASSWORD : (userNameStore != null ? SaveMode.USER_NAME : SaveMode.NONE));
        this.loginListener = new LoginListenerImpl();
        this.loginService.addLoginListener(this.loginListener);
        this.updateUI();
        this.initComponents();
    }

    @Override
    public LoginPanelUI getUI() {
        return (LoginPanelUI)super.getUI();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    protected void recreateLoginPanel() {
        this.contentPanel.remove(this.loginPanel);
        this.loginPanel = this.createLoginPanel();
        this.loginPanel.setBorder(BorderFactory.createEmptyBorder(0, 36, 7, 11));
        this.contentPanel.add((Component)this.loginPanel, 1);
    }

    private JXPanel createLoginPanel() {
        JXPanel jXPanel = new JXPanel();
        this.namePanel = this.saveMode == SaveMode.NONE ? new SimpleNamePanel() : new ComboNamePanel(this.userNameStore);
        JLabel jLabel = new JLabel(UIManager.getString(CLASS_NAME + ".nameString"));
        jLabel.setLabelFor(this.namePanel.getComponent());
        this.passwordField = new JPasswordField("", 15);
        JLabel jLabel2 = new JLabel(UIManager.getString(CLASS_NAME + ".passwordString"));
        jLabel2.setLabelFor(this.passwordField);
        JLabel jLabel3 = new JLabel("Server");
        if (this.servers.size() > 1) {
            this.serverCombo = new JXComboBox(this.servers.toArray());
            jLabel3.setLabelFor(this.serverCombo);
        } else {
            this.serverCombo = null;
        }
        this.saveCB = new JCheckBox(UIManager.getString(CLASS_NAME + ".rememberPasswordString"));
        this.saveCB.setSelected(false);
        this.saveCB.setVisible(this.saveMode == SaveMode.PASSWORD || this.saveMode == SaveMode.BOTH);
        jXPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        jXPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jXPanel.add((Component)this.namePanel.getComponent(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        jXPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jXPanel.add((Component)this.passwordField, gridBagConstraints);
        if (this.serverCombo != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 5, 11);
            jXPanel.add((Component)jLabel3, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            jXPanel.add((Component)this.serverCombo, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            jXPanel.add((Component)this.saveCB, gridBagConstraints);
        } else {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            jXPanel.add((Component)this.saveCB, gridBagConstraints);
        }
        return jXPanel;
    }

    private void initComponents() {
        this.banner = new JXImagePanel();
        this.banner.setImage(this.createLoginBanner());
        this.messageLabel = new JLabel(" ");
        this.messageLabel.setOpaque(true);
        this.messageLabel.setFont(this.messageLabel.getFont().deriveFont(1));
        this.loginPanel = this.createLoginPanel();
        this.errorMessageLabel = new JLabel("<html><b>Couldn't log in</b><br><br>Check your user name and password. Check to see if Caps Lock is<br>turned on.</html>");
        this.errorMessageLabel.setIcon(UIManager.getIcon("JXLoginDialog.error.icon"));
        this.errorMessageLabel.setVerticalTextPosition(1);
        this.errorMessageLabel.setOpaque(true);
        this.errorMessageLabel.setBackground(new Color(255, 215, 215));
        this.errorMessageLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.errorMessageLabel.getBackground().darker()), BorderFactory.createEmptyBorder(5, 7, 5, 5)));
        this.errorMessageLabel.setVisible(false);
        this.contentPanel = new JXPanel(new VerticalLayout());
        this.messageLabel.setBorder(BorderFactory.createEmptyBorder(12, 12, 7, 11));
        this.contentPanel.add(this.messageLabel);
        this.loginPanel.setBorder(BorderFactory.createEmptyBorder(0, 36, 7, 11));
        this.contentPanel.add(this.loginPanel);
        this.errorMessageLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 36, 0, 11, this.contentPanel.getBackground()), this.errorMessageLabel.getBorder()));
        this.contentPanel.add(this.errorMessageLabel);
        this.progressPanel = new JXPanel(new GridBagLayout());
        this.progressMessageLabel = new JLabel("Please wait, logging in....");
        this.progressMessageLabel.setFont(this.progressMessageLabel.getFont().deriveFont(1));
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        JButton jButton = new JButton(this.getActionMap().get(CANCEL_LOGIN_ACTION_COMMAND));
        this.progressPanel.add((Component)this.progressMessageLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(12, 12, 11, 11), 0, 0));
        this.progressPanel.add((Component)jProgressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 24, 11, 7), 0, 0));
        this.progressPanel.add((Component)jButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 11, 11), 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)this.banner, "North");
        this.add((Component)this.contentPanel, "Center");
    }

    protected Image createLoginBanner() {
        return this.getUI() == null ? null : this.getUI().getBanner();
    }

    protected Action createLoginAction() {
        return new LoginAction(this);
    }

    protected Action createCancelAction() {
        return new CancelAction(this);
    }

    public SaveMode getSaveMode() {
        return this.saveMode;
    }

    public void setSaveMode(SaveMode saveMode) {
        this.saveMode = saveMode;
        this.recreateLoginPanel();
    }

    public List<String> getServers() {
        return Collections.unmodifiableList(this.servers);
    }

    public void setServers(List<String> arrayList) {
        if (this.servers != arrayList) {
            List<String> list = this.servers;
            this.servers = arrayList == null ? new ArrayList() : arrayList;
            this.recreateLoginPanel();
            this.firePropertyChange("servers", list, arrayList);
        }
    }

    public void setLoginService(LoginService loginService) {
        this.loginService = loginService;
    }

    public LoginService getLoginService() {
        return this.loginService;
    }

    public void setPasswordStore(PasswordStore passwordStore) {
        this.passwordStore = passwordStore;
    }

    public PasswordStore getPasswordStore() {
        return this.passwordStore;
    }

    public void setUserName(String string) {
        if (this.namePanel != null) {
            this.namePanel.setUserName(string);
        }
    }

    public String getUserName() {
        return this.namePanel == null ? null : this.namePanel.getUserName();
    }

    public void setPassword(char[] cArray) {
        this.passwordField.setText(new String(cArray));
    }

    public char[] getPassword() {
        return this.passwordField.getPassword();
    }

    public Image getBanner() {
        return this.banner.getImage();
    }

    public void setBanner(Image image) {
        this.banner.setImage(image);
    }

    public void setBannerText(String string) {
        if (string == null) {
            string = "";
        }
        if (!this.bannerText.equals(string)) {
            String string2 = this.bannerText;
            this.bannerText = string;
            this.banner.setImage(this.createLoginBanner());
            this.firePropertyChange("bannerText", string2, string);
        }
    }

    public String getBannerText() {
        return this.bannerText;
    }

    public String getMessage() {
        return this.messageLabel.getText();
    }

    public void setMessage(String string) {
        this.messageLabel.setText(string);
    }

    public String getErrorMessage() {
        return this.errorMessageLabel.getText();
    }

    public void setErrorMessage(String string) {
        this.errorMessageLabel.setText(string);
    }

    public Status getStatus() {
        return this.status;
    }

    protected void setStatus(Status status) {
        if (this.status != status) {
            Status status2 = this.status;
            this.status = status;
            this.firePropertyChange("status", (Object)status2, (Object)status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startLogin() {
        this.oldCursor = this.getCursor();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.progressMessageLabel.setText("Please wait, logging in....");
            String string = this.getUserName();
            char[] cArray = this.getPassword();
            String string2 = this.servers.size() == 1 ? this.servers.get(0) : (this.serverCombo == null ? null : (String)this.serverCombo.getSelectedItem());
            this.loginService.startAuthentication(string, cArray, string2);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Authentication exception while logging in", exception);
        }
        finally {
            this.setCursor(this.oldCursor);
        }
    }

    protected void cancelLogin() {
        this.progressMessageLabel.setText("Cancelling login, please wait....");
        this.getActionMap().get(CANCEL_LOGIN_ACTION_COMMAND).setEnabled(false);
        this.loginService.cancelAuthentication();
        this.setCursor(this.oldCursor);
    }

    protected void savePassword() {
        if (this.saveCB.isSelected() && (this.saveMode == SaveMode.BOTH || this.saveMode == SaveMode.PASSWORD) && this.passwordStore != null) {
            this.passwordStore.set(this.getUserName(), this.getLoginService().getServer(), this.getPassword());
        }
    }

    public static Status showLoginDialog(JComponent jComponent, LoginService loginService) {
        return JXLoginPanel.showLoginDialog(jComponent, loginService, null, null);
    }

    public static Status showLoginDialog(JComponent jComponent, LoginService loginService, PasswordStore passwordStore, UserNameStore userNameStore) {
        return JXLoginPanel.showLoginDialog(jComponent, loginService, passwordStore, userNameStore, null);
    }

    public static Status showLoginDialog(JComponent jComponent, LoginService loginService, PasswordStore passwordStore, UserNameStore userNameStore, List<String> list) {
        JXLoginPanel jXLoginPanel = new JXLoginPanel(loginService, passwordStore, userNameStore, list);
        return JXLoginPanel.showLoginDialog(jComponent, jXLoginPanel);
    }

    public static Status showLoginDialog(JComponent jComponent, JXLoginPanel jXLoginPanel) {
        Window window = WindowUtils.findWindow(jComponent);
        JXLoginDialog jXLoginDialog = null;
        if (window == null) {
            jXLoginDialog = new JXLoginDialog((Frame)null, jXLoginPanel);
        } else if (window instanceof Dialog) {
            jXLoginDialog = new JXLoginDialog((Dialog)window, jXLoginPanel);
        } else if (window instanceof Frame) {
            jXLoginDialog = new JXLoginDialog((Frame)window, jXLoginPanel);
        }
        jXLoginDialog.setVisible(true);
        return jXLoginDialog.getStatus();
    }

    public static JXLoginFrame showLoginFrame(LoginService loginService) {
        return JXLoginPanel.showLoginFrame(loginService, null, null);
    }

    public static JXLoginFrame showLoginFrame(LoginService loginService, PasswordStore passwordStore, UserNameStore userNameStore) {
        return JXLoginPanel.showLoginFrame(loginService, passwordStore, userNameStore, null);
    }

    public static JXLoginFrame showLoginFrame(LoginService loginService, PasswordStore passwordStore, UserNameStore userNameStore, List<String> list) {
        JXLoginPanel jXLoginPanel = new JXLoginPanel(loginService, passwordStore, userNameStore, list);
        return JXLoginPanel.showLoginFrame(jXLoginPanel);
    }

    public static JXLoginFrame showLoginFrame(JXLoginPanel jXLoginPanel) {
        return new JXLoginFrame(jXLoginPanel);
    }

    static void initWindow(final Window window, final JXLoginPanel jXLoginPanel) {
        window.setLayout(new BorderLayout());
        window.add((Component)jXLoginPanel, "Center");
        JButton jButton = new JButton(jXLoginPanel.getActionMap().get(LOGIN_ACTION_COMMAND));
        final JButton jButton2 = new JButton("Close");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jXLoginPanel.status = Status.CANCELLED;
                window.setVisible(false);
                window.dispose();
            }
        });
        jXLoginPanel.addPropertyChangeListener("status", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Status status = (Status)((Object)propertyChangeEvent.getNewValue());
                switch (status) {
                    case NOT_STARTED: {
                        break;
                    }
                    case IN_PROGRESS: {
                        jButton2.setEnabled(false);
                        break;
                    }
                    case CANCELLED: {
                        jButton2.setEnabled(true);
                        window.pack();
                        break;
                    }
                    case FAILED: {
                        jButton2.setEnabled(true);
                        window.pack();
                        break;
                    }
                    case SUCCEEDED: {
                        window.setVisible(false);
                        window.dispose();
                    }
                }
            }
        });
        jButton2.setText("Close");
        int n = Math.max(jButton2.getPreferredSize().width, jButton.getPreferredSize().width);
        jButton2.setPreferredSize(new Dimension(n, jButton.getPreferredSize().height));
        jButton.setPreferredSize(new Dimension(n, jButton.getPreferredSize().height));
        JXPanel jXPanel = new JXPanel(new GridBagLayout());
        jXPanel.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(17, 12, 11, 5), 0, 0));
        jXPanel.add((Component)jButton2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(17, 0, 11, 11), 0, 0));
        window.add((Component)jXPanel, "South");
        window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jXLoginPanel.cancelLogin();
            }
        });
        if (window instanceof JFrame) {
            final JFrame jFrame = (JFrame)window;
            jFrame.getRootPane().setDefaultButton(jButton);
            jFrame.setResizable(false);
            jFrame.setDefaultCloseOperation(2);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jFrame.setVisible(false);
                    jFrame.dispose();
                }
            };
            jFrame.getRootPane().registerKeyboardAction(actionListener, keyStroke, 2);
        } else if (window instanceof JDialog) {
            final JDialog jDialog = (JDialog)window;
            jDialog.getRootPane().setDefaultButton(jButton);
            jDialog.setResizable(false);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.setVisible(false);
                }
            };
            jDialog.getRootPane().registerKeyboardAction(actionListener, keyStroke, 2);
        }
        window.pack();
        window.setLocation(WindowUtils.getPointForCentering(window));
    }

    static {
        LookAndFeelAddons.contribute(new JXLoginPanelAddon());
        CLASS_NAME = JXLoginPanel.class.getCanonicalName();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.jdesktop.swingx.auth.resources.resources");
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String string2 = CLASS_NAME + "." + string;
            if (UIManager.getString(string2) != null) continue;
            UIManager.put(string2, resourceBundle.getString(string));
        }
    }

    public static final class JXLoginFrame
    extends JFrame {
        private JXLoginPanel panel;

        public JXLoginFrame(JXLoginPanel jXLoginPanel) {
            super("Login");
            this.panel = jXLoginPanel;
            JXLoginPanel.initWindow(this, this.panel);
        }

        public Status getStatus() {
            return this.panel.getStatus();
        }

        public JXLoginPanel getPanel() {
            return this.panel;
        }
    }

    public static final class JXLoginDialog
    extends JDialog {
        private JXLoginPanel panel;

        public JXLoginDialog(Frame frame, JXLoginPanel jXLoginPanel) {
            super(frame, true);
            this.init(jXLoginPanel);
        }

        public JXLoginDialog(Dialog dialog, JXLoginPanel jXLoginPanel) {
            super(dialog, true);
            this.init(jXLoginPanel);
        }

        protected void init(JXLoginPanel jXLoginPanel) {
            this.setTitle("Login");
            this.panel = jXLoginPanel;
            JXLoginPanel.initWindow(this, this.panel);
        }

        public Status getStatus() {
            return this.panel.getStatus();
        }
    }

    public static final class ComboNamePanel
    extends JXComboBox
    implements NameComponent {
        private UserNameStore userNameStore;

        public ComboNamePanel(UserNameStore userNameStore) {
            this.userNameStore = userNameStore;
            this.setModel(new NameComboBoxModel());
            this.setEditable(true);
        }

        public String getUserName() {
            Object object = this.getModel().getSelectedItem();
            return object == null ? null : object.toString();
        }

        public void setUserName(String string) {
            this.getModel().setSelectedItem(string);
        }

        public void setUserNames(String[] stringArray) {
            this.setModel(new DefaultComboBoxModel<String>(stringArray));
        }

        public JComponent getComponent() {
            return this;
        }

        private final class NameComboBoxModel
        extends AbstractListModel
        implements ComboBoxModel {
            private Object selectedItem;

            private NameComboBoxModel() {
            }

            public void setSelectedItem(Object object) {
                this.selectedItem = object;
                this.fireContentsChanged(this, -1, -1);
            }

            public Object getSelectedItem() {
                return this.selectedItem;
            }

            public Object getElementAt(int n) {
                return ComboNamePanel.this.userNameStore.getUserNames()[n];
            }

            public int getSize() {
                return ComboNamePanel.this.userNameStore.getUserNames().length;
            }
        }
    }

    public static final class SimpleNamePanel
    extends JTextField
    implements NameComponent {
        public SimpleNamePanel() {
            super("", 15);
        }

        public String getUserName() {
            return this.getText();
        }

        public void setUserName(String string) {
            this.setText(string);
        }

        public JComponent getComponent() {
            return this;
        }
    }

    public static interface NameComponent {
        public String getUserName();

        public void setUserName(String var1);

        public JComponent getComponent();
    }

    private static final class NullPasswordStore
    extends PasswordStore {
        private static final char[] EMPTY = new char[0];

        private NullPasswordStore() {
        }

        public boolean set(String string, String string2, char[] cArray) {
            return false;
        }

        public char[] get(String string, String string2) {
            return EMPTY;
        }
    }

    private static final class NullLoginService
    extends LoginService {
        private NullLoginService() {
        }

        public boolean authenticate(String string, char[] cArray, String string2) throws Exception {
            return true;
        }
    }

    private static final class CancelAction
    extends AbstractActionExt {
        private JXLoginPanel panel;

        public CancelAction(JXLoginPanel jXLoginPanel) {
            super("Cancel Login", JXLoginPanel.CANCEL_LOGIN_ACTION_COMMAND);
            this.panel = jXLoginPanel;
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.panel.cancelLogin();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }
    }

    private static final class LoginAction
    extends AbstractActionExt {
        private JXLoginPanel panel;

        public LoginAction(JXLoginPanel jXLoginPanel) {
            super("Login", JXLoginPanel.LOGIN_ACTION_COMMAND);
            this.panel = jXLoginPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.panel.startLogin();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }
    }

    protected class LoginListenerImpl
    extends LoginAdapter {
        protected LoginListenerImpl() {
        }

        public void loginSucceeded(LoginEvent loginEvent) {
            String string = JXLoginPanel.this.namePanel.getUserName();
            JXLoginPanel.this.savePassword();
            if (JXLoginPanel.this.getSaveMode() == SaveMode.USER_NAME && string != null && !string.trim().equals("")) {
                JXLoginPanel.this.userNameStore.addUserName(string);
                JXLoginPanel.this.userNameStore.saveUserNames();
            }
            JXLoginPanel.this.setStatus(Status.SUCCEEDED);
        }

        public void loginStarted(LoginEvent loginEvent) {
            JXLoginPanel.this.getActionMap().get(JXLoginPanel.LOGIN_ACTION_COMMAND).setEnabled(false);
            JXLoginPanel.this.getActionMap().get(JXLoginPanel.CANCEL_LOGIN_ACTION_COMMAND).setEnabled(true);
            JXLoginPanel.this.remove(JXLoginPanel.this.contentPanel);
            JXLoginPanel.this.add((Component)JXLoginPanel.this.progressPanel, "Center");
            JXLoginPanel.this.revalidate();
            JXLoginPanel.this.repaint();
            JXLoginPanel.this.setStatus(Status.IN_PROGRESS);
        }

        public void loginFailed(LoginEvent loginEvent) {
            JXLoginPanel.this.remove(JXLoginPanel.this.progressPanel);
            JXLoginPanel.this.add((Component)JXLoginPanel.this.contentPanel, "Center");
            JXLoginPanel.this.getActionMap().get(JXLoginPanel.LOGIN_ACTION_COMMAND).setEnabled(true);
            JXLoginPanel.this.errorMessageLabel.setVisible(true);
            JXLoginPanel.this.revalidate();
            JXLoginPanel.this.repaint();
            JXLoginPanel.this.setStatus(Status.FAILED);
        }

        public void loginCanceled(LoginEvent loginEvent) {
            JXLoginPanel.this.remove(JXLoginPanel.this.progressPanel);
            JXLoginPanel.this.add((Component)JXLoginPanel.this.contentPanel, "Center");
            JXLoginPanel.this.getActionMap().get(JXLoginPanel.LOGIN_ACTION_COMMAND).setEnabled(true);
            JXLoginPanel.this.errorMessageLabel.setVisible(false);
            JXLoginPanel.this.revalidate();
            JXLoginPanel.this.repaint();
            JXLoginPanel.this.setStatus(Status.CANCELLED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NOT_STARTED,
        IN_PROGRESS,
        FAILED,
        CANCELLED,
        SUCCEEDED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SaveMode {
        NONE,
        USER_NAME,
        PASSWORD,
        BOTH;

    }
}

