/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.jdesktop.swingx.ErrorReporter;
import org.jdesktop.swingx.IncidentInfo;
import org.jdesktop.swingx.util.WindowUtils;

public class JXErrorDialog
extends JDialog {
    private static final String DETAILS_EXPAND_TEXT = "Details >>";
    private static final String DETAILS_CONTRACT_TEXT = "Details <<";
    private static final String OK_BUTTON_TEXT = "Ok";
    private static final Icon icon = UIManager.getIcon("OptionPane.warningIcon");
    private static final String REPORT_BUTTON_TEXT = "Report...";
    private JLabel errorMessage;
    private JTextArea details;
    private JButton detailButton;
    private JScrollPane detailsScrollPane;
    private JButton reportButton;
    private static ErrorReporter reporter;
    private IncidentInfo incidentInfo;

    public JXErrorDialog(Frame frame) {
        super(frame, true);
        this.initGui();
    }

    public JXErrorDialog(Dialog dialog) {
        super(dialog, true);
        this.initGui();
    }

    private void initGui() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(22, 12, 11, 17);
        this.getContentPane().add((Component)new JLabel(icon), gridBagConstraints);
        this.errorMessage = new JLabel();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 11);
        this.getContentPane().add((Component)this.errorMessage, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 0, 11, 5);
        JButton jButton = new JButton(OK_BUTTON_TEXT);
        this.getContentPane().add((Component)jButton, gridBagConstraints);
        this.reportButton = new JButton(new ReportAction());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(12, 0, 11, 5);
        this.getContentPane().add((Component)this.reportButton, gridBagConstraints);
        this.reportButton.setVisible(false);
        this.detailButton = new JButton(DETAILS_EXPAND_TEXT);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(12, 0, 11, 11);
        this.getContentPane().add((Component)this.detailButton, gridBagConstraints);
        this.details = new JTextArea(7, 60);
        this.detailsScrollPane = new JScrollPane(this.details);
        this.detailsScrollPane.setVerticalScrollBarPolicy(22);
        this.details.setEditable(false);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 11, 11, 11);
        this.getContentPane().add((Component)this.detailsScrollPane, gridBagConstraints);
        Dimension dimension = this.detailsScrollPane.getPreferredSize();
        Dimension dimension2 = new Dimension(dimension.width + 15, 0);
        Container container = new Container();
        container.setMinimumSize(dimension2);
        container.setPreferredSize(dimension2);
        container.setMaximumSize(dimension2);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 11, 11, 0);
        this.getContentPane().add((Component)container, gridBagConstraints);
        int n = this.detailButton.getPreferredSize().width;
        int n2 = this.detailButton.getPreferredSize().height;
        Dimension dimension3 = new Dimension(n, n2);
        jButton.setPreferredSize(dimension3);
        this.reportButton.setPreferredSize(dimension3);
        this.detailButton.setPreferredSize(dimension3);
        jButton.addActionListener(new OkClickEvent());
        this.detailButton.addActionListener(new DetailsClickEvent());
    }

    private void setDetails(String string) {
        if (string == null || string.equals("")) {
            this.setDetailsVisible(false);
            this.detailButton.setVisible(false);
        } else {
            this.details.setText(string);
            this.setDetailsVisible(false);
            this.detailButton.setVisible(true);
        }
    }

    private void setDetailsVisible(boolean bl) {
        if (bl) {
            this.details.setCaretPosition(0);
            this.detailsScrollPane.setVisible(true);
            this.detailButton.setText(DETAILS_CONTRACT_TEXT);
        } else {
            this.detailsScrollPane.setVisible(false);
            this.detailButton.setText(DETAILS_EXPAND_TEXT);
        }
        this.pack();
    }

    private void setErrorMessage(String string) {
        this.errorMessage.setText(string);
    }

    private void setIncidentInfo(IncidentInfo incidentInfo) {
        this.incidentInfo = incidentInfo;
        this.reportButton.setVisible(JXErrorDialog.getReporter() != null);
    }

    private IncidentInfo getIncidentInfo() {
        return this.incidentInfo;
    }

    public static void showDialog(Component component, String string, Throwable throwable) {
        IncidentInfo incidentInfo = new IncidentInfo(string, null, null, throwable);
        JXErrorDialog.showDialog(component, incidentInfo);
    }

    public static void showDialog(Component component, String string, String string2, Throwable throwable) {
        IncidentInfo incidentInfo = new IncidentInfo(string, string2, null, throwable);
        JXErrorDialog.showDialog(component, incidentInfo);
    }

    public static void showDialog(Component component, String string, String string2, String string3) {
        IncidentInfo incidentInfo = new IncidentInfo(string, string2, string3);
        JXErrorDialog.showDialog(component, incidentInfo);
    }

    public static void showDialog(Component component, IncidentInfo incidentInfo) {
        Window window = WindowUtils.findWindow(component);
        JXErrorDialog jXErrorDialog = component instanceof Dialog ? new JXErrorDialog((Dialog)component) : new JXErrorDialog((Frame)component);
        jXErrorDialog.setTitle(incidentInfo.getHeader());
        jXErrorDialog.setErrorMessage(incidentInfo.getBasicErrorMessage());
        String string = incidentInfo.getDetailedErrorMessage();
        if (string == null) {
            if (incidentInfo.getErrorException() != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                incidentInfo.getErrorException().printStackTrace(printWriter);
                string = stringWriter.toString();
            } else {
                string = "";
            }
        }
        jXErrorDialog.setDetails(string);
        jXErrorDialog.setIncidentInfo(incidentInfo);
        jXErrorDialog.setDefaultCloseOperation(2);
        jXErrorDialog.pack();
        jXErrorDialog.setLocationRelativeTo(component);
        jXErrorDialog.setVisible(true);
    }

    public static ErrorReporter getReporter() {
        return reporter;
    }

    public static void setReporter(ErrorReporter errorReporter) {
        reporter = errorReporter;
    }

    public class ReportAction
    extends AbstractAction {
        public boolean isEnabled() {
            return JXErrorDialog.getReporter() != null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JXErrorDialog.getReporter().reportIncident(JXErrorDialog.this.getIncidentInfo());
        }

        public Object getValue(String string) {
            if (string == "Name") {
                if (JXErrorDialog.getReporter() != null && JXErrorDialog.getReporter().getActionName() != null) {
                    return JXErrorDialog.getReporter().getActionName();
                }
                return JXErrorDialog.REPORT_BUTTON_TEXT;
            }
            return super.getValue(string);
        }
    }

    private final class DetailsClickEvent
    implements ActionListener {
        private DetailsClickEvent() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JXErrorDialog.this.setDetailsVisible(!JXErrorDialog.this.detailsScrollPane.isVisible());
        }
    }

    private final class OkClickEvent
    implements ActionListener {
        private OkClickEvent() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JXErrorDialog.this.setVisible(false);
            JXErrorDialog.this.dispose();
        }
    }
}

