/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.awt.CImage;
import com.apple.laf.AquaImageFactory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.Kernel;
import java.awt.image.RGBImageFilter;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.swing.GrayFilter;
import javax.swing.JComponent;
import javax.swing.border.Border;
import sun.awt.AppContext;
import sun.misc.Launcher;
import sun.security.action.GetPropertyAction;

public class AquaUtils {
    static final String ANIMATIONS_SYSTEM_PROPERTY = "swing.enableAnimations";
    protected static boolean IS_JAVA5 = System.getProperty("java.version").startsWith("1.5.");
    private static CImage.Creator cImageCreator = AquaUtils.getCImageCreatorInternal();
    static Boolean enableAnimations;
    static final int MENU_BLINK_DELAY = 50;
    private static LazySingleton<Method> getJComponentGetFlagMethod;
    private static final Integer OPAQUE_SET_FLAG;

    public static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    protected static boolean isJava5() {
        return IS_JAVA5;
    }

    private static CImage.Creator getCImageCreatorInternal() {
        return AccessController.doPrivileged(new PrivilegedAction<CImage.Creator>(){

            @Override
            public CImage.Creator run() {
                try {
                    Method method = CImage.class.getDeclaredMethod("getCreator", new Class[0]);
                    method.setAccessible(true);
                    return (CImage.Creator)method.invoke(null, new Object[0]);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    static CImage.Creator getCImageCreator() {
        return cImageCreator;
    }

    public static Object beginFont(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return null;
        }
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return object;
    }

    public static void endFont(Graphics2D graphics2D, Object object) {
        if (graphics2D == null) {
            return;
        }
        if (object == null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
            return;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
    }

    protected static Image generateSelectedDarkImage(Image image) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new IconImageFilter(){

            @Override
            int getGreyFor(int n) {
                return n * 75 / 100;
            }
        });
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    protected static Image generateDisabledImage(Image image) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new IconImageFilter(){

            @Override
            int getGreyFor(int n) {
                return 255 - (255 - n) * 65 / 100;
            }
        });
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    protected static Image generateLightenedImage(Image image, int n) {
        GrayFilter grayFilter = new GrayFilter(true, n);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), grayFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    static boolean animationsEnabled() {
        if (enableAnimations != null) {
            return enableAnimations;
        }
        String string = AccessController.doPrivileged(new GetPropertyAction(ANIMATIONS_SYSTEM_PROPERTY));
        enableAnimations = new Boolean(!"false".equals(string));
        return enableAnimations;
    }

    protected static void blinkMenu(Selectable selectable) {
        if (!AquaUtils.animationsEnabled()) {
            return;
        }
        try {
            selectable.paintSelected(false);
            Thread.sleep(50L);
            selectable.paintSelected(true);
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static boolean shouldUseOpaqueButtons() {
        ClassLoader classLoader = Launcher.getLauncher().getClassLoader();
        return AquaUtils.classExists(classLoader, "com.installshield.wizard.platform.macosx.MacOSXUtils");
    }

    static boolean classExists(ClassLoader classLoader, String string) {
        try {
            return Class.forName(string, false, classLoader) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected static boolean hasOpaqueBeenExplicitlySet(JComponent jComponent) {
        Method method = getJComponentGetFlagMethod.get();
        if (method == null) {
            return false;
        }
        try {
            return Boolean.TRUE.equals(method.invoke((Object)jComponent, OPAQUE_SET_FLAG));
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static {
        getJComponentGetFlagMethod = new LazySingleton<Method>(){

            @Override
            protected Method getInstance() {
                return AccessController.doPrivileged(new PrivilegedAction<Method>(){

                    @Override
                    public Method run() {
                        try {
                            Method method = JComponent.class.getDeclaredMethod("getFlag", Integer.TYPE);
                            method.setAccessible(true);
                            return method;
                        }
                        catch (Throwable throwable) {
                            return null;
                        }
                    }
                });
            }
        };
        OPAQUE_SET_FLAG = new Integer(24);
    }

    public static class SlicedShadowBorder
    extends ShadowBorder {
        final AquaImageFactory.SlicedImageControl slices;

        public SlicedShadowBorder(Painter painter, Painter painter2, int n, int n2, float f, float f2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            super(painter, painter2, n, n2, f, f2, n3);
            BufferedImage bufferedImage = new BufferedImage(n4, n5, 3);
            super.paintBorder(null, bufferedImage.getGraphics(), 0, 0, n4, n5);
            this.slices = new AquaImageFactory.SlicedImageControl(bufferedImage, n6, n7, n8, n9, false);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            this.slices.paint(graphics, n, n2, n3, n4);
        }
    }

    public static class ShadowBorder
    implements Border {
        final Painter prePainter;
        final Painter postPainter;
        final int offsetX;
        final int offsetY;
        final float distance;
        final int blur;
        final Insets insets;
        final ConvolveOp blurOp;

        public ShadowBorder(Painter painter, Painter painter2, int n, int n2, float f, float f2, int n3) {
            this.prePainter = painter;
            this.postPainter = painter2;
            this.offsetX = n;
            this.offsetY = n2;
            this.distance = f;
            this.blur = n3;
            int n4 = n3 / 2;
            this.insets = new Insets(n4 - n2, n4 - n, n4 + n2, n4 + n);
            float f3 = f2 / (float)(n3 * n3);
            float[] fArray = new float[n3 * n3];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = f3;
            }
            this.blurOp = new ConvolveOp(new Kernel(n3, n3, fArray));
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            BufferedImage bufferedImage = new BufferedImage(n3 + this.blur * 2, n4 + this.blur * 2, 3);
            this.paintToImage(bufferedImage, n, n2, n3, n4);
            graphics.drawImage(bufferedImage, -this.blur, -this.blur, null);
        }

        protected void paintToImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.setColor(Color.black);
            graphics2D.fillRect(0, 0, n3 + this.blur * 2, n4 + this.blur * 2);
            int n5 = (int)((float)(n + this.blur + this.offsetX) + (float)this.insets.left * this.distance);
            int n6 = (int)((float)(n2 + this.blur + this.offsetY) + (float)this.insets.top * this.distance);
            int n7 = (int)((float)n3 - (float)(this.insets.left + this.insets.right) * this.distance);
            int n8 = (int)((float)n4 - (float)(this.insets.top + this.insets.bottom) * this.distance);
            graphics2D.setComposite(AlphaComposite.DstAtop);
            if (this.prePainter != null) {
                this.prePainter.paint(graphics2D, n5, n6, n7, n8);
            }
            graphics2D.dispose();
            graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setComposite(AlphaComposite.DstAtop);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            graphics2D.drawImage(bufferedImage, this.blurOp, 0, 0);
            if (this.postPainter != null) {
                this.postPainter.paint(graphics2D, n5, n6, n7, n8);
            }
            graphics2D.dispose();
        }
    }

    static interface Painter {
        public void paint(Graphics var1, int var2, int var3, int var4, int var5);
    }

    static interface JComponentPainter {
        public void paint(JComponent var1, Graphics var2, int var3, int var4, int var5, int var6);
    }

    static interface Selectable {
        public void paintSelected(boolean var1);
    }

    public static abstract class LazyKeyedSingleton<K, V> {
        protected Map<K, V> refs;

        public V get(K k) {
            V v;
            if (this.refs == null) {
                this.refs = new HashMap();
            }
            if ((v = this.refs.get(k)) != null) {
                return v;
            }
            V v2 = this.getInstance(k);
            this.refs.put(k, v2);
            return v2;
        }

        protected abstract V getInstance(K var1);
    }

    public static class LazySingletonFromDefaultContructor<T>
    extends LazySingleton<T> {
        protected final Class<T> clazz;

        public LazySingletonFromDefaultContructor(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        protected T getInstance() {
            try {
                return this.clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            return null;
        }
    }

    public static abstract class LazySingleton<T> {
        public T get() {
            Object t;
            AppContext appContext = AppContext.getAppContext();
            SoftReference softReference = (SoftReference)appContext.get(this);
            if (softReference != null && (t = softReference.get()) != null) {
                return t;
            }
            t = this.getInstance();
            softReference = new SoftReference(t);
            appContext.put(this, softReference);
            return t;
        }

        public void reset() {
            AppContext appContext = AppContext.getAppContext();
            appContext.remove(this);
        }

        protected abstract T getInstance();
    }

    static abstract class IconImageFilter
    extends RGBImageFilter {
        public IconImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            int n4 = n3 >> 16 & 0xFF;
            int n5 = n3 >> 8 & 0xFF;
            int n6 = n3 & 0xFF;
            int n7 = this.getGreyFor((int)((0.3 * (double)n4 + 0.59 * (double)n5 + 0.11 * (double)n6) / 3.0));
            return n3 & 0xFF000000 | IconImageFilter.grayTransform(n4, n7) << 16 | IconImageFilter.grayTransform(n5, n7) << 8 | IconImageFilter.grayTransform(n6, n7) << 0;
        }

        private static int grayTransform(int n, int n2) {
            int n3 = n - n2;
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            }
            return n3;
        }

        abstract int getGreyFor(int var1);
    }
}

