/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.awt.ClientPropertyApplicator;
import com.apple.laf.AquaTableHeaderBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class AquaTableHeaderUI
extends BasicTableHeaderUI {
    private int originalHeaderAlignment;
    protected int sortColumn;
    protected int sortOrder;
    static final ClientPropertyApplicator<JTableHeader, JTableHeader> TABLE_HEADER_APPLICATORS = new ClientPropertyApplicator(new ClientPropertyApplicator.Property<JTableHeader>("JTableHeader.selectedColumn"){

        @Override
        public void applyProperty(JTableHeader jTableHeader, Object object) {
            AquaTableHeaderUI.tickle(jTableHeader, object, jTableHeader.getClientProperty("JTableHeader.sortDirection"));
        }
    }, new ClientPropertyApplicator.Property<JTableHeader>("JTableHeader.sortDirection"){

        @Override
        public void applyProperty(JTableHeader jTableHeader, Object object) {
            AquaTableHeaderUI.tickle(jTableHeader, jTableHeader.getClientProperty("JTableHeader.selectedColumn"), object);
        }
    });

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTableHeaderUI();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        TableCellRenderer tableCellRenderer = this.header.getDefaultRenderer();
        if (tableCellRenderer instanceof UIResource && tableCellRenderer instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)tableCellRenderer;
            this.originalHeaderAlignment = defaultTableCellRenderer.getHorizontalAlignment();
            defaultTableCellRenderer.setHorizontalAlignment(10);
        }
    }

    @Override
    public void uninstallDefaults() {
        TableCellRenderer tableCellRenderer = this.header.getDefaultRenderer();
        if (tableCellRenderer instanceof UIResource && tableCellRenderer instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)tableCellRenderer;
            defaultTableCellRenderer.setHorizontalAlignment(this.originalHeaderAlignment);
        }
        super.uninstallDefaults();
    }

    static void tickle(JTableHeader jTableHeader, Object object, Object object2) {
        TableColumn tableColumn = AquaTableHeaderUI.getTableColumn(jTableHeader, object);
        if (tableColumn == null) {
            return;
        }
        int n = 0;
        if ("ascending".equalsIgnoreCase(object2 + "")) {
            n = 1;
        } else if ("descending".equalsIgnoreCase(object2 + "")) {
            n = -1;
        } else if ("decending".equalsIgnoreCase(object2 + "")) {
            n = -1;
        }
        TableHeaderUI tableHeaderUI = jTableHeader.getUI();
        if (tableHeaderUI == null || !(tableHeaderUI instanceof AquaTableHeaderUI)) {
            return;
        }
        AquaTableHeaderUI aquaTableHeaderUI = (AquaTableHeaderUI)tableHeaderUI;
        aquaTableHeaderUI.sortColumn = tableColumn.getModelIndex();
        aquaTableHeaderUI.sortOrder = n;
        AquaTableCellRenderer aquaTableCellRenderer = aquaTableHeaderUI.new AquaTableCellRenderer();
        tableColumn.setHeaderRenderer(aquaTableCellRenderer);
    }

    protected static TableColumn getTableColumn(JTableHeader jTableHeader, Object object) {
        if (object == null || !(object instanceof Integer)) {
            return null;
        }
        int n = (Integer)object;
        TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
        if (n < 0 || n >= tableColumnModel.getColumnCount()) {
            return null;
        }
        return tableColumnModel.getColumn(n);
    }

    protected static AquaTableHeaderBorder getAquaBorderFrom(JTableHeader jTableHeader, TableColumn tableColumn) {
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            return null;
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(jTableHeader.getTable(), tableColumn.getHeaderValue(), false, false, -1, tableColumn.getModelIndex());
        if (!(component instanceof JComponent)) {
            return null;
        }
        Border border = ((JComponent)component).getBorder();
        if (!(border instanceof AquaTableHeaderBorder)) {
            return null;
        }
        return (AquaTableHeaderBorder)border;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        TABLE_HEADER_APPLICATORS.attachAndApplyClientProperties(this.header);
    }

    @Override
    protected void uninstallListeners() {
        TABLE_HEADER_APPLICATORS.removeFrom(this.header);
        super.uninstallListeners();
    }

    private int getHeaderHeightAqua() {
        int n = 0;
        boolean bl = false;
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (tableColumn.getHeaderRenderer() == null && bl) continue;
            Component component = this.getHeaderRendererAqua(i);
            int n2 = component.getPreferredSize().height;
            n = Math.max(n, n2);
            if (n2 <= 4) continue;
            bl = true;
        }
        return n;
    }

    private Component getHeaderRendererAqua(int n) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        return tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
    }

    private Dimension createHeaderSizeAqua(long l) {
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        return new Dimension((int)l, this.getHeaderHeightAqua());
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getMinWidth();
        }
        return this.createHeaderSizeAqua(l);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createHeaderSizeAqua(l);
    }

    class AquaTableCellRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        AquaTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable != null && AquaTableHeaderUI.this.header != null) {
                this.setForeground(AquaTableHeaderUI.this.header.getForeground());
                this.setBackground(AquaTableHeaderUI.this.header.getBackground());
                this.setFont(UIManager.getFont("TableHeader.font"));
            }
            this.setText(object == null ? "" : object.toString());
            AquaTableHeaderBorder aquaTableHeaderBorder = AquaTableHeaderBorder.getListHeaderBorder();
            boolean bl3 = jTable.getColumnModel().getColumn(n2).getModelIndex() == AquaTableHeaderUI.this.sortColumn;
            aquaTableHeaderBorder.setSelected(bl3);
            if (bl3) {
                aquaTableHeaderBorder.setSortOrder(AquaTableHeaderUI.this.sortOrder);
            } else {
                aquaTableHeaderBorder.setSortOrder(0);
            }
            this.setBorder(aquaTableHeaderBorder);
            return this;
        }
    }
}

