/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;

public class AquaKeyBindings {
    static DefaultEditorKit.DefaultKeyTypedAction defaultKeyTypedAction = new DefaultEditorKit.DefaultKeyTypedAction();
    static final String upMultilineAction = "aqua-move-up";
    static final String downMultilineAction = "aqua-move-down";
    static final String pageUpMultiline = "aqua-page-up";
    static final String pageDownMultiline = "aqua-page-down";
    static final String deleteNextWord = "delete-next-word";
    static final String deletePrevWord = "delete-previous-word";
    static final String[] commonTextEditorBindings = new String[]{"ENTER", "notify-field-accept", "COPY", "copy-to-clipboard", "CUT", "cut-to-clipboard", "PASTE", "paste-from-clipboard", "meta A", "select-all", "meta C", "copy-to-clipboard", "meta V", "paste-from-clipboard", "meta X", "cut-to-clipboard", "meta BACK_SLASH", "unselect", "DELETE", "delete-next", "alt DELETE", "delete-next-word", "BACK_SPACE", "delete-previous", "alt BACK_SPACE", "delete-previous-word", "LEFT", "caret-backward", "KP_LEFT", "caret-backward", "RIGHT", "caret-forward", "KP_RIGHT", "caret-forward", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "meta LEFT", "caret-begin-line", "meta KP_LEFT", "caret-begin-line", "meta RIGHT", "caret-end-line", "meta KP_RIGHT", "caret-end-line", "shift meta LEFT", "selection-begin-line", "shift meta KP_LEFT", "selection-begin-line", "shift meta RIGHT", "selection-end-line", "shift meta KP_RIGHT", "selection-end-line", "alt LEFT", "caret-previous-word", "alt KP_LEFT", "caret-previous-word", "alt RIGHT", "caret-next-word", "alt KP_RIGHT", "caret-next-word", "shift alt LEFT", "selection-previous-word", "shift alt KP_LEFT", "selection-previous-word", "shift alt RIGHT", "selection-next-word", "shift alt KP_RIGHT", "selection-next-word", "control A", "caret-begin-line", "control B", "caret-backward", "control D", "delete-next", "control E", "caret-end-line", "control F", "caret-forward", "control H", "delete-previous", "control W", "delete-previous-word", "control shift O", "toggle-componentOrientation", "END", "caret-end", "HOME", "caret-begin", "shift END", "selection-end", "shift HOME", "selection-begin", "PAGE_DOWN", "aqua-page-down", "PAGE_UP", "aqua-page-up", "shift PAGE_DOWN", "selection-page-down", "shift PAGE_UP", "selection-page-up", "meta shift PAGE_DOWN", "selection-page-right", "meta shift PAGE_UP", "selection-page-left", "meta DOWN", "caret-end", "meta KP_DOWN", "caret-end", "meta UP", "caret-begin", "meta KP_UP", "caret-begin", "shift meta DOWN", "selection-end", "shift meta KP_DOWN", "selection-end", "shift meta UP", "selection-begin", "shift meta KP_UP", "selection-begin"};
    static final TextAction deletePrevWordAction = new DeleteWordAction("delete-previous-word"){

        @Override
        int getEnd(JTextComponent jTextComponent, Element element, int n) throws BadLocationException {
            int n2 = Utilities.getPreviousWord(jTextComponent, n);
            if (n2 != -1) {
                return n2;
            }
            int n3 = element.getStartOffset();
            if (n == n3) {
                return n3 - 1;
            }
            return n3;
        }
    };
    static final TextAction deleteNextWordAction = new DeleteWordAction("delete-next-word"){

        @Override
        int getEnd(JTextComponent jTextComponent, Element element, int n) throws BadLocationException {
            int n2 = Utilities.getNextWord(jTextComponent, n);
            if (n2 != -1) {
                return n2;
            }
            int n3 = element.getEndOffset();
            if (n == n3 - 1) {
                return n3;
            }
            return n3 - 1;
        }
    };
    static final TextAction moveUpMultilineAction = new AquaMultilineAction("aqua-move-up", "caret-up", "caret-begin");
    static final TextAction moveDownMultilineAction = new AquaMultilineAction("aqua-move-down", "caret-down", "caret-end");
    static final TextAction pageUpMultilineAction = new AquaMultilineAction("aqua-page-up", "page-up", "caret-begin");
    static final TextAction pageDownMultilineAction = new AquaMultilineAction("aqua-page-down", "page-down", "caret-end");

    static void setDefaultAction(String string) {
        Keymap keymap = JTextComponent.getKeymap(string);
        keymap.setDefaultAction(defaultKeyTypedAction);
    }

    static LateBoundInputMap getTextFieldInputMap() {
        return new LateBoundInputMap(new SimpleBinding(commonTextEditorBindings), new SimpleBinding(new String[]{"DOWN", "caret-end-line", "KP_DOWN", "caret-end-line", "UP", "caret-begin-line", "KP_UP", "caret-begin-line", "shift DOWN", "selection-end-line", "shift KP_DOWN", "selection-end-line", "shift UP", "selection-begin-line", "shift KP_UP", "selection-begin-line", "control P", "caret-begin", "control N", "caret-end", "control V", "caret-end"}));
    }

    static LateBoundInputMap getMultiLineTextInputMap() {
        return new LateBoundInputMap(new SimpleBinding(commonTextEditorBindings), new SimpleBinding(new String[]{"ENTER", "insert-break", "DOWN", downMultilineAction, "KP_DOWN", downMultilineAction, "UP", upMultilineAction, "KP_UP", upMultilineAction, "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "shift UP", "selection-up", "shift KP_UP", "selection-up", "alt shift DOWN", "selection-end-paragraph", "alt shift KP_DOWN", "selection-end-paragraph", "alt shift UP", "selection-begin-paragraph", "alt shift KP_UP", "selection-begin-paragraph", "control P", "caret-up", "control N", "caret-down", "control V", pageDownMultiline, "TAB", "insert-tab", "meta SPACE", "activate-link-action", "meta T", "next-link-action", "meta shift T", "previous-link-action", "END", "caret-end", "HOME", "caret-begin", "shift END", "selection-end", "shift HOME", "selection-begin", "PAGE_DOWN", pageDownMultiline, "PAGE_UP", pageUpMultiline, "shift PAGE_DOWN", "selection-page-down", "shift PAGE_UP", "selection-page-up", "meta shift PAGE_DOWN", "selection-page-right", "meta shift PAGE_UP", "selection-page-left"}));
    }

    static LateBoundInputMap getFormattedTextFieldInputMap() {
        return new LateBoundInputMap(AquaKeyBindings.getTextFieldInputMap(), new SimpleBinding(new String[]{"UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement", "ESCAPE", "reset-field-edit"}));
    }

    static LateBoundInputMap getComboBoxInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"ESCAPE", "hidePopup", "PAGE_UP", "aquaSelectPageUp", "PAGE_DOWN", "aquaSelectPageDown", "HOME", "aquaSelectHome", "END", "aquaSelectEnd", "ENTER", "aquaEnterPressed", "UP", "aquaSelectPrevious", "KP_UP", "aquaSelectPrevious", "DOWN", "aquaSelectNext", "KP_DOWN", "aquaSelectNext", "SPACE", "aquaSpacePressed"}));
    }

    static LateBoundInputMap getListInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"meta C", "copy", "meta V", "paste", "meta X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "meta A", "selectAll", "HOME", "aquaHome", "shift HOME", "selectFirstRowExtendSelection", "END", "aquaEnd", "shift END", "selectLastRowExtendSelection", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection"}));
    }

    static LateBoundInputMap getScrollBarInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "positiveUnitIncrement", "KP_DOWN", "positiveUnitIncrement", "PAGE_DOWN", "positiveBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "negativeUnitIncrement", "KP_UP", "negativeUnitIncrement", "PAGE_UP", "negativeBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}));
    }

    static LateBoundInputMap getScrollBarRightToLeftInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"RIGHT", "negativeUnitIncrement", "KP_RIGHT", "negativeUnitIncrement", "LEFT", "positiveUnitIncrement", "KP_LEFT", "positiveUnitIncrement"}));
    }

    static LateBoundInputMap getScrollPaneInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"RIGHT", "unitScrollRight", "KP_RIGHT", "unitScrollRight", "DOWN", "unitScrollDown", "KP_DOWN", "unitScrollDown", "LEFT", "unitScrollLeft", "KP_LEFT", "unitScrollLeft", "UP", "unitScrollUp", "KP_UP", "unitScrollUp", "PAGE_UP", "scrollUp", "PAGE_DOWN", "scrollDown", "HOME", "scrollHome", "END", "scrollEnd"}));
    }

    static LateBoundInputMap getSliderInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "negativeUnitIncrement", "KP_DOWN", "negativeUnitIncrement", "PAGE_DOWN", "negativeBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "positiveUnitIncrement", "KP_UP", "positiveUnitIncrement", "PAGE_UP", "positiveBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}));
    }

    static LateBoundInputMap getSliderRightToLeftInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"RIGHT", "negativeUnitIncrement", "KP_RIGHT", "negativeUnitIncrement", "LEFT", "positiveUnitIncrement", "KP_LEFT", "positiveUnitIncrement"}));
    }

    static LateBoundInputMap getSpinnerInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}));
    }

    static LateBoundInputMap getTableInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"meta C", "copy", "meta V", "paste", "meta X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "PAGE_UP", "scrollUpChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "HOME", "selectFirstColumn", "END", "selectLastColumn", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift HOME", "selectFirstColumnExtendSelection", "shift END", "selectLastColumnExtendSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "meta A", "selectAll", "ESCAPE", "cancel", "ENTER", "selectNextRowCell", "shift ENTER", "selectPreviousRowCell", "alt TAB", "focusHeader", "alt shift TAB", "focusHeader"}));
    }

    static LateBoundInputMap getTableRightToLeftInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"RIGHT", "selectPreviousColumn", "KP_RIGHT", "selectPreviousColumn", "LEFT", "selectNextColumn", "KP_LEFT", "selectNextColumn", "shift RIGHT", "selectPreviousColumnExtendSelection", "shift KP_RIGHT", "selectPreviousColumnExtendSelection", "shift LEFT", "selectNextColumnExtendSelection", "shift KP_LEFT", "selectNextColumnExtendSelection", "ctrl PAGE_UP", "scrollRightChangeSelection", "ctrl PAGE_DOWN", "scrollLeftChangeSelection", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection"}));
    }

    static LateBoundInputMap getTreeInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"meta C", "copy", "meta V", "paste", "meta X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "UP", "selectPrevious", "KP_UP", "selectPrevious", "shift UP", "selectPreviousExtendSelection", "shift KP_UP", "selectPreviousExtendSelection", "DOWN", "selectNext", "KP_DOWN", "selectNext", "shift DOWN", "selectNextExtendSelection", "shift KP_DOWN", "selectNextExtendSelection", "RIGHT", "aquaExpandNode", "KP_RIGHT", "aquaExpandNode", "LEFT", "aquaCollapseNode", "KP_LEFT", "aquaCollapseNode", "shift RIGHT", "aquaExpandNode", "shift KP_RIGHT", "aquaExpandNode", "shift LEFT", "aquaCollapseNode", "shift KP_LEFT", "aquaCollapseNode", "ctrl LEFT", "aquaCollapseNode", "ctrl KP_LEFT", "aquaCollapseNode", "ctrl RIGHT", "aquaExpandNode", "ctrl KP_RIGHT", "aquaExpandNode", "alt RIGHT", "aquaFullyExpandNode", "alt KP_RIGHT", "aquaFullyExpandNode", "alt LEFT", "aquaFullyCollapseNode", "alt KP_LEFT", "aquaFullyCollapseNode", "meta A", "selectAll", "RETURN", "startEditing"}));
    }

    static LateBoundInputMap getTreeRightToLeftInputMap() {
        return new LateBoundInputMap(new SimpleBinding(new String[]{"RIGHT", "aquaCollapseNode", "KP_RIGHT", "aquaCollapseNode", "LEFT", "aquaExpandNode", "KP_LEFT", "aquaExpandNode", "shift RIGHT", "aquaCollapseNode", "shift KP_RIGHT", "aquaCollapseNode", "shift LEFT", "aquaExpandNode", "shift KP_LEFT", "aquaExpandNode", "ctrl LEFT", "aquaExpandNode", "ctrl KP_LEFT", "aquaExpandNode", "ctrl RIGHT", "aquaCollapseNode", "ctrl KP_RIGHT", "aquaCollapseNode"}));
    }

    static void installFullWordDeleteAction(JTextComponent jTextComponent) {
        if (!AquaUtils.IS_JAVA5) {
            return;
        }
        ActionMap actionMap = jTextComponent.getActionMap();
        actionMap.put(deleteNextWord, deleteNextWordAction);
        actionMap.put(deletePrevWord, deletePrevWordAction);
    }

    static void installAquaUpDownActions(JTextComponent jTextComponent) {
        ActionMap actionMap = jTextComponent.getActionMap();
        actionMap.put(upMultilineAction, moveUpMultilineAction);
        actionMap.put(downMultilineAction, moveDownMultilineAction);
        actionMap.put(pageUpMultiline, pageUpMultilineAction);
        actionMap.put(pageDownMultiline, pageDownMultilineAction);
    }

    static class AquaMultilineAction
    extends TextAction {
        final String targetActionName;
        final String proxyActionName;

        public AquaMultilineAction(String string, String string2, String string3) {
            super(string);
            this.targetActionName = string2;
            this.proxyActionName = string3;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            ActionMap actionMap = jTextComponent.getActionMap();
            Action action = actionMap.get(this.targetActionName);
            int n = jTextComponent.getCaretPosition();
            action.actionPerformed(actionEvent);
            if (n != jTextComponent.getCaretPosition()) {
                return;
            }
            Action action2 = actionMap.get(this.proxyActionName);
            action2.actionPerformed(actionEvent);
        }
    }

    static abstract class DeleteWordAction
    extends TextAction {
        public DeleteWordAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent == null) {
                return;
            }
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent == null) {
                return;
            }
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                return;
            }
            try {
                int n = jTextComponent.getSelectionStart();
                Element element = Utilities.getParagraphElement(jTextComponent, n);
                int n2 = this.getEnd(jTextComponent, element, n);
                int n3 = Math.min(n, n2);
                int n4 = Math.abs(n2 - n);
                if (n3 >= 0) {
                    jTextComponent.getDocument().remove(n3, n4);
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
        }

        abstract int getEnd(JTextComponent var1, Element var2, int var3) throws BadLocationException;
    }

    static class LateBoundInputMap
    implements UIDefaults.LazyValue,
    BindingsProvider {
        private final BindingsProvider[] providerList;
        private String[] mergedBindings;

        public LateBoundInputMap(BindingsProvider ... bindingsProviderArray) {
            this.providerList = bindingsProviderArray;
        }

        @Override
        public Object createValue(UIDefaults uIDefaults) {
            return LookAndFeel.makeInputMap(this.getBindings());
        }

        @Override
        public String[] getBindings() {
            if (this.mergedBindings != null) {
                return this.mergedBindings;
            }
            String[][] stringArrayArray = new String[this.providerList.length][];
            int n = 0;
            for (int i = 0; i < this.providerList.length; ++i) {
                stringArrayArray[i] = this.providerList[i].getBindings();
                n += stringArrayArray[i].length;
            }
            if (stringArrayArray.length == 1) {
                this.mergedBindings = stringArrayArray[0];
                return this.mergedBindings;
            }
            ArrayList<String> arrayList = new ArrayList<String>(n);
            Collections.addAll(arrayList, stringArrayArray[0]);
            for (int i = 1; i < this.providerList.length; ++i) {
                LateBoundInputMap.mergeBindings(arrayList, stringArrayArray[i]);
            }
            this.mergedBindings = arrayList.toArray(new String[arrayList.size()]);
            return this.mergedBindings;
        }

        static void mergeBindings(ArrayList<String> arrayList, String[] stringArray) {
            for (int i = 0; i < stringArray.length; i += 2) {
                String string = stringArray[i];
                String string2 = stringArray[i + 1];
                int n = arrayList.indexOf(string);
                if (n == -1) {
                    arrayList.add(string);
                    arrayList.add(string2);
                    continue;
                }
                arrayList.set(n, string);
                arrayList.set(n + 1, string2);
            }
        }
    }

    static class SimpleBinding
    implements BindingsProvider {
        final String[] bindings;

        public SimpleBinding(String[] stringArray) {
            this.bindings = stringArray;
        }

        @Override
        public String[] getBindings() {
            return this.bindings;
        }
    }

    static interface BindingsProvider {
        public String[] getBindings();
    }
}

