/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CGraphicsDevice;
import apple.awt.CGraphicsEnvironment;
import apple.awt.OSXOffScreenSurfaceData;
import apple.awt.OSXSurfaceData;
import apple.awt.OSXVolatileSurfaceManager;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.Window;
import java.awt.image.ColorModel;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.SurfaceManager;
import sun.awt.image.VolatileSurfaceManager;
import sun.java2d.SurfaceData;

public class OSXBackBuffer
extends SunVolatileImage {
    public OSXBackBuffer(Component component, OSXSurfaceData oSXSurfaceData) {
        super(component, component.getWidth(), component.getHeight(), oSXSurfaceData);
    }

    @Override
    protected VolatileSurfaceManager createSurfaceManager(Object object, ImageCapabilities imageCapabilities) {
        boolean bl;
        CGraphicsDevice cGraphicsDevice = (CGraphicsDevice)this.getGraphicsConfig().getDevice();
        while (this.comp != null && !(this.comp instanceof Window)) {
            this.comp = this.comp.getParent();
        }
        boolean bl2 = bl = this.comp == cGraphicsDevice.getFullScreenWindow();
        if (bl) {
            return new OSXFullscreenSurfaceManager(this, object);
        }
        return new OSXBackBufferSurfaceManager(this, object);
    }

    public SurfaceData getHWSurfaceData() {
        SurfaceManager surfaceManager = SurfaceManager.getManager(this);
        SurfaceData surfaceData = surfaceManager.getDestSurfaceData();
        return surfaceData instanceof OSXOffScreenSurfaceData ? (OSXOffScreenSurfaceData)surfaceData : null;
    }

    private class OSXFullscreenSurfaceManager
    extends OSXBackBufferSurfaceManager {
        public OSXFullscreenSurfaceManager(SunVolatileImage sunVolatileImage, Object object) {
            super(sunVolatileImage, object);
        }

        @Override
        protected SurfaceData getBackupSurface() {
            return (SurfaceData)this.context;
        }

        @Override
        protected SurfaceData createAccelSurface() {
            return null;
        }
    }

    private class OSXBackBufferSurfaceManager
    extends OSXVolatileSurfaceManager {
        public OSXBackBufferSurfaceManager(SunVolatileImage sunVolatileImage, Object object) {
            super(sunVolatileImage, object);
        }

        @Override
        protected SurfaceData createAccelSurface() {
            GraphicsConfiguration graphicsConfiguration = this.vImg.getGraphicsConfig();
            ColorModel colorModel = this.getDeviceColorModel();
            OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)this.context;
            SurfaceData surfaceData = null;
            if (surfaceData == null) {
                // empty if block
            }
            return surfaceData;
        }

        @Override
        public void flush() {
            CGraphicsEnvironment cGraphicsEnvironment = (CGraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
            cGraphicsEnvironment.removeDisplayChangedListener(this);
        }
    }
}

