/*
 * Decompiled with CFR 0.152.
 */
package com.standbysoft.component.date.swing.plaf.basic;

import com.standbysoft.component.date.swing.JDatePicker;
import com.standbysoft.component.date.swing.JMonthView;
import com.standbysoft.component.date.swing.plaf.DateUI;
import com.standbysoft.component.util.swing.JComboBoxExt;
import java.awt.Color;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;

public abstract class AbstractDatePickerUI
extends DateUI {
    protected JDatePicker datePicker;
    protected JComboBoxExt comboBox;
    protected JMonthView monthView;
    private PropertyChangeListener c;
    private static final String b = "JDatePicker.backgroundOnEditable";

    protected Object[] createDefaults() {
        Object[] objectArray = new Object[]{"DatePicker.font", new FontUIResource("Dialog", 0, 12), "DatePicker.foreground", new ColorUIResource(UIManager.getColor("ComboBox.foreground")), "DatePicker.background", new ColorUIResource(UIManager.getColor("ComboBox.background"))};
        return objectArray;
    }

    protected void initializeDefaults() {
        Object[] objectArray = this.createDefaults();
        int n = objectArray.length;
        for (int i = 0; i < n; i += 2) {
            UIManager.put(objectArray[i], objectArray[i + 1]);
        }
    }

    public void installUI(JComponent jComponent) {
        this.datePicker = (JDatePicker)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        Color color;
        Color color2;
        this.initializeDefaults();
        Font font = this.datePicker.getFont();
        if (font == null || font instanceof UIResource) {
            this.datePicker.setFont(UIManager.getFont("DatePicker.font"));
        }
        if ((color2 = this.datePicker.getForeground()) == null || color2 instanceof UIResource) {
            this.datePicker.setForeground(UIManager.getColor("DatePicker.foreground"));
        }
        if ((color = this.datePicker.getBackground()) == null || color instanceof UIResource) {
            this.datePicker.setBackground(UIManager.getColor("DatePicker.background"));
        }
    }

    protected void installComponents() {
        this.monthView = this.createMonthView();
        this.comboBox = this.createComboBox();
        this.datePicker.setLayout(this.createLayout());
        this.datePicker.add("", this.comboBox);
        this.updateFont();
        this.updateDateSelectionModel();
        this.updateEnabled();
        this.updateLocale();
        this.updateEditable();
        this.updateDateFormat();
        this.updateToolTipText();
        this.updateBackground();
        this.updateForeground();
    }

    protected abstract LayoutManager createLayout();

    protected abstract JMonthView createMonthView();

    protected abstract JComboBoxExt createComboBox();

    protected void installListeners() {
        this.c = this.createPropertyChangeListener();
        if (this.c != null) {
            this.datePicker.addPropertyChangeListener(this.c);
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new _B();
    }

    protected void installKeyboardActions() {
        ActionMap actionMap;
        Object[] objectArray;
        InputMap inputMap = this.comboBox.getInputMap(1);
        KeyStroke[] keyStrokeArray = inputMap.allKeys();
        if (keyStrokeArray != null) {
            for (int i = 0; i < keyStrokeArray.length; ++i) {
                if (this.monthView.getInputMap(0).get(keyStrokeArray[i]) != null) continue;
                this.monthView.getInputMap(0).put(keyStrokeArray[i], inputMap.get(keyStrokeArray[i]));
            }
        }
        if ((objectArray = (actionMap = this.comboBox.getActionMap()).allKeys()) != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.monthView.getActionMap().put(objectArray[i], new _A(this.comboBox, objectArray[i]));
            }
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallKeyboardActions();
        this.uninstallComponents();
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.datePicker);
    }

    protected void uninstallComponents() {
        this.datePicker.removeAll();
        this.datePicker.setLayout(null);
        this.datePicker = null;
        this.comboBox = null;
        this.monthView = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.datePicker, 1, null);
        SwingUtilities.replaceUIActionMap(this.datePicker, null);
    }

    protected void uninstallListeners() {
        if (this.c != null) {
            this.datePicker.removePropertyChangeListener(this.c);
        }
    }

    public void setPopupVisible(JDatePicker jDatePicker, boolean bl) {
        this.comboBox.setPopupVisible(bl);
    }

    public boolean isPopupVisible(JDatePicker jDatePicker) {
        return this.comboBox.isPopupVisible();
    }

    protected abstract void updateEnabled();

    protected abstract void updateFont();

    protected abstract void updateDateSelectionModel();

    protected abstract void updateLocale();

    protected abstract void updateEditable();

    protected abstract void updateTimeZone();

    protected abstract void updateToolTipText();

    protected abstract void updateForeground();

    protected abstract void updateBackground();

    protected abstract void updateDateFormat();

    public static void registerDateComboBoxUI(String string, Class clazz) {
        JComboBoxExt.addComboBoxUI(string, clazz);
    }

    public static void unregisterDateComboBoxUI(String string) {
        JComboBoxExt.removeComboBoxUI(string);
    }

    private class _B
    implements PropertyChangeListener {
        private _B() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("font")) {
                AbstractDatePickerUI.this.updateFont();
            } else if (string.equals("ToolTipText")) {
                AbstractDatePickerUI.this.updateToolTipText();
            } else if (string.equals("background")) {
                AbstractDatePickerUI.this.updateBackground();
            } else if (string.equals(AbstractDatePickerUI.b)) {
                AbstractDatePickerUI.this.updateBackground();
            } else if (string.equals("foreground")) {
                AbstractDatePickerUI.this.updateForeground();
            } else if (string.equals("dateSelectionModel")) {
                AbstractDatePickerUI.this.updateDateSelectionModel();
            } else if (string.equals("enabled")) {
                AbstractDatePickerUI.this.updateEnabled();
            } else if (string.equals("locale")) {
                AbstractDatePickerUI.this.updateLocale();
            } else if (string.equals("editable")) {
                AbstractDatePickerUI.this.updateEditable();
            } else if (string.equals("dateFormat")) {
                AbstractDatePickerUI.this.updateDateFormat();
                AbstractDatePickerUI.this.comboBox.repaint();
            } else if (string.equals("timeZone")) {
                AbstractDatePickerUI.this.updateTimeZone();
            } else if (string.equals("emptySelectionText")) {
                AbstractDatePickerUI.this.comboBox.repaint();
            }
        }
    }

    class _A
    extends AbstractAction {
        private JComboBox B;
        private Object A;

        public _A(JComboBox jComboBox, Object object) {
            this.B = jComboBox;
            this.A = object;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionMap actionMap = this.B.getActionMap();
            Action action = actionMap.get(this.A);
            if ("hidePopup".equals(this.A)) {
                AbstractDatePickerUI.this.monthView.getDateSelectionModel().setSelectedDates(AbstractDatePickerUI.this.datePicker.getDateSelectionModel().getSelectedDates());
            }
            action.actionPerformed(new ActionEvent(this.B, actionEvent.getID(), actionEvent.getActionCommand()));
        }
    }
}

