/*
 * Decompiled with CFR 0.152.
 */
package com.standbysoft.component.date.swing;

import com.standbysoft.component.date.DateModel;
import com.standbysoft.component.date.DateParser;
import com.standbysoft.component.date.DateSelectionModel;
import com.standbysoft.component.date.DefaultDateModel;
import com.standbysoft.component.date.DefaultDateParser;
import com.standbysoft.component.date.DefaultDateSelectionModel;
import com.standbysoft.component.date.event.DateAdapter;
import com.standbysoft.component.date.event.DateEvent;
import com.standbysoft.component.date.event.DateListener;
import com.standbysoft.component.date.event.DateSelectionAdapter;
import com.standbysoft.component.date.event.DateSelectionEvent;
import com.standbysoft.component.date.swing.JDateComponent;
import java.awt.Toolkit;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.SwingConstants;

public abstract class JDateEditComponent
extends JDateComponent
implements SwingConstants {
    protected DateFormat dateFormat;
    protected int dateFormatStyle;
    protected int timeFormatStyle;
    protected String dateFormatPattern;
    protected String emptySelectionText;
    protected boolean autoRestore;
    protected boolean autoValidate;
    protected boolean beepOnError;
    protected DateModel dateModel;
    protected DateListener dateModelListener;
    protected DateParser dateParser;
    protected boolean freeText;
    protected int horizontalAlignment;
    protected String text;
    static /* synthetic */ Class class$com$standbysoft$component$date$event$DateListener;

    public JDateEditComponent() {
        this(new DefaultDateSelectionModel());
    }

    public JDateEditComponent(DateSelectionModel dateSelectionModel) {
        super(dateSelectionModel);
        this.addDateSelectionListener(new DateSelectionAdapter(){

            public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
                JDateEditComponent.this.dateModel.setDate(JDateEditComponent.this.getSelectedDate());
            }
        });
        this.dateModel = new DefaultDateModel();
        this.addDateListener(new DateAdapter(){

            public void dateChanged(DateEvent dateEvent) {
                JDateEditComponent.this.setSelectedDate(dateEvent.getDate());
            }
        });
        this.setDateFormat(2);
        this.emptySelectionText = "";
        this.freeText = false;
        this.dateParser = new DefaultDateParser();
        this.autoRestore = true;
        this.autoValidate = true;
        this.beepOnError = false;
        this.horizontalAlignment = 10;
        this.text = "";
        this.dateSelectionModel.setSelectionMode(DateSelectionModel.SelectionMode.SINGLE);
        this.setSelectedDate(new Date());
        this.updateUI();
    }

    public void setSelectedDate(Date date) {
        boolean bl;
        Date date2 = this.getSelectedDate();
        super.setSelectedDate(date);
        boolean bl2 = bl = date != null && date.equals(date2) || date == null && date2 == null;
        if (!this.isEditValid() && bl) {
            this.dateSelectionModel.setDateSelectionIterval(date, date);
        }
    }

    public void setDateModel(DateModel dateModel) {
        if (dateModel == null) {
            throw new IllegalArgumentException("null model");
        }
        if (!dateModel.equals(this.dateModel)) {
            DateModel dateModel2 = this.dateModel;
            this.dateModel = dateModel;
            if (this.dateModelListener != null) {
                this.dateModel.addDateListener(this.dateModelListener);
            }
            this.firePropertyChange("dateModel", dateModel2, this.dateModel);
        }
    }

    public DateModel getDateModel() {
        return this.dateModel;
    }

    public void addDateListener(DateListener dateListener) {
        if (this.dateModelListener == null) {
            this.dateModelListener = new _A();
            this.dateModel.addDateListener(this.dateModelListener);
        }
        this.listenerList.add(class$com$standbysoft$component$date$event$DateListener == null ? (class$com$standbysoft$component$date$event$DateListener = JDateEditComponent.class$("com.standbysoft.component.date.event.DateListener")) : class$com$standbysoft$component$date$event$DateListener, dateListener);
    }

    public void removeDateListener(DateListener dateListener) {
        this.listenerList.remove(class$com$standbysoft$component$date$event$DateListener == null ? (class$com$standbysoft$component$date$event$DateListener = JDateEditComponent.class$("com.standbysoft.component.date.event.DateListener")) : class$com$standbysoft$component$date$event$DateListener, dateListener);
    }

    public void setAutoCentury(boolean bl) {
        this.dateModel.setAutoCentury(bl);
    }

    public boolean isAutoCentury() {
        return this.dateModel.isAutoCentury();
    }

    public void setAutoCenturyYear(int n) {
        this.dateModel.setAutoCenturyYear(n);
    }

    public int getAutoCenturyYear() {
        return this.dateModel.getAutoCenturyYear();
    }

    public String getEmptySelectionText() {
        return this.emptySelectionText;
    }

    public void setEmptySelectionText(String string) {
        String string2 = this.emptySelectionText;
        this.emptySelectionText = string;
        this.firePropertyChange("emptySelectionText", string2, string);
    }

    public String getSelectedDateAsText() {
        Date date = this.getSelectedDate();
        if (date != null) {
            return this.getDateFormat().format(date);
        }
        return this.emptySelectionText;
    }

    public void setDateSelectionModel(DateSelectionModel dateSelectionModel) {
        if (dateSelectionModel == null) {
            throw new IllegalArgumentException("null model");
        }
        if (!dateSelectionModel.equals(this.dateSelectionModel)) {
            DateSelectionModel dateSelectionModel2 = this.dateSelectionModel;
            Date date = this.getSelectedDate();
            this.dateSelectionModel = dateSelectionModel;
            if (this.dateSelectionModelListener != null) {
                this.dateSelectionModel.addDateSelectionListener(this.dateSelectionModelListener);
            }
            this.dateSelectionModel.setSelectionMode(DateSelectionModel.SelectionMode.SINGLE);
            this.dateSelectionModel.setDateSelectionIterval(date, date);
            try {
                this.dateSelectionModel.setEmptySelectionAllowed(dateSelectionModel2.isEmptySelectionAllowed());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.firePropertyChange("dateSelectionModel", dateSelectionModel2, this.dateSelectionModel);
            this.repaint();
            this.revalidate();
        }
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("Cannot use a null object to format dates");
        }
        this.dateFormatStyle = -1;
        this.timeFormatStyle = -1;
        this.dateFormatPattern = null;
        this.A(dateFormat);
    }

    public void setDateFormat(int n) {
        this.setDateFormat(n, -1);
    }

    public void setDateFormat(int n, int n2) {
        this.dateFormatStyle = n;
        this.timeFormatStyle = n2;
        this.dateFormatPattern = null;
        if (n != -1 && n2 != -1) {
            this.A(DateFormat.getDateTimeInstance(n, n2, this.getLocale()));
        } else if (n != -1 && n2 == -1) {
            this.A(DateFormat.getDateInstance(n, this.getLocale()));
        } else if (n == -1 && n2 != -1) {
            this.A(DateFormat.getTimeInstance(n2, this.getLocale()));
        } else {
            this.A(DateFormat.getDateTimeInstance());
        }
    }

    public void setDateFormat(String string) {
        this.dateFormatStyle = -1;
        this.timeFormatStyle = -1;
        this.dateFormatPattern = string;
        this.A(new SimpleDateFormat(string, this.getLocale()));
    }

    private void A(DateFormat dateFormat) {
        DateFormat dateFormat2 = this.dateFormat;
        this.dateFormat = dateFormat;
        this.dateFormat.setTimeZone(this.getTimeZone());
        this.firePropertyChange("dateFormat", dateFormat2, this.dateFormat);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this.dateFormatPattern != null) {
            this.setDateFormat(this.dateFormatPattern);
        } else {
            this.setDateFormat(this.dateFormatStyle, this.timeFormatStyle);
        }
    }

    public void setText(String string) {
        String string2 = this.text;
        this.text = string;
        this.firePropertyChange("text", string2, string);
    }

    public String getText() {
        return this.text;
    }

    public void setDateParser(DateParser dateParser) {
        DateParser dateParser2 = this.dateParser;
        this.dateParser = dateParser;
        this.firePropertyChange("dateParser", dateParser2, this.dateParser);
    }

    public DateParser getDateParser() {
        return this.dateParser;
    }

    public void setFreeText(boolean bl) {
        boolean bl2 = this.freeText;
        this.freeText = bl;
        this.firePropertyChange("freeText", bl2, this.freeText);
    }

    public boolean isFreeText() {
        return this.freeText;
    }

    public void setAutoValidate(boolean bl) {
        boolean bl2 = this.autoValidate;
        this.autoValidate = bl;
        this.firePropertyChange("autoValidate", bl2, bl);
    }

    public boolean isAutoValidate() {
        return this.autoValidate;
    }

    public void setBeepOnError(boolean bl) {
        boolean bl2 = this.beepOnError;
        this.beepOnError = bl;
        this.firePropertyChange("beepOnError", bl2, bl);
    }

    public boolean isBeepOnError() {
        return this.beepOnError;
    }

    protected void invalidEdit() {
        if (this.beepOnError) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public boolean isEditValid() {
        Date date = null;
        if (this.isFreeText()) {
            try {
                date = this.getDateParser().parse(this.getText(), this.getSelectedDate(), this.getDateFormat());
            }
            catch (Exception exception) {
                return false;
            }
        } else if (this.dateModel.isDateValid()) {
            date = this.getDateModel().getDate();
        } else {
            return false;
        }
        return this.getDateSelectionModel().isDateSelectable(date);
    }

    public void commitEdit() {
        if (this.isEditValid()) {
            Date date = null;
            if (this.isFreeText()) {
                try {
                    date = this.getDateParser().parse(this.getText(), this.getSelectedDate(), this.getDateFormat());
                }
                catch (Exception exception) {}
            } else {
                date = this.getDateModel().getDate();
            }
            this.setSelectedDate(date);
        } else {
            this.invalidEdit();
            if (this.isAutoRestore()) {
                this.getDateModel().setDate(this.getSelectedDate());
            }
        }
    }

    public void setAutoRestore(boolean bl) {
        boolean bl2 = this.autoRestore;
        this.autoRestore = bl;
        this.firePropertyChange("autoRestore", bl2, bl);
    }

    public boolean isAutoRestore() {
        return this.autoRestore;
    }

    public void setHorizontalAlignment(int n) {
        if (n == this.horizontalAlignment) {
            return;
        }
        int n2 = this.horizontalAlignment;
        if (n != 2 && n != 0 && n != 4 && n != 10 && n != 11) {
            throw new IllegalArgumentException("horizontalAlignment");
        }
        this.horizontalAlignment = n;
        this.firePropertyChange("horizontalAlignment", n2, this.horizontalAlignment);
        this.invalidate();
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setTimeZone(TimeZone timeZone) {
        TimeZone timeZone2 = this.timeZone;
        super.setTimeZone(timeZone);
        if (timeZone2 != timeZone && timeZone != null) {
            this.dateFormat.setTimeZone(timeZone);
            this.dateModel.setTimeZone(timeZone);
        }
    }

    protected void fireDateFieldChanged(DateEvent dateEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$standbysoft$component$date$event$DateListener == null ? JDateEditComponent.class$("com.standbysoft.component.date.event.DateListener") : class$com$standbysoft$component$date$event$DateListener)) continue;
            ((DateListener)objectArray[i + 1]).dateFieldChanged(dateEvent);
        }
    }

    protected void fireDateFieldCleared(DateEvent dateEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$standbysoft$component$date$event$DateListener == null ? JDateEditComponent.class$("com.standbysoft.component.date.event.DateListener") : class$com$standbysoft$component$date$event$DateListener)) continue;
            ((DateListener)objectArray[i + 1]).dateFieldCleared(dateEvent);
        }
    }

    protected void fireDateChanged(DateEvent dateEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$standbysoft$component$date$event$DateListener == null ? JDateEditComponent.class$("com.standbysoft.component.date.event.DateListener") : class$com$standbysoft$component$date$event$DateListener)) continue;
            ((DateListener)objectArray[i + 1]).dateChanged(dateEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class _A
    implements DateListener {
        _A() {
        }

        public void dateFieldChanged(DateEvent dateEvent) {
            JDateEditComponent.this.fireDateFieldChanged(new DateEvent(JDateEditComponent.this, dateEvent.getField(), dateEvent.getOldValue(), dateEvent.getNewValue()));
        }

        public void dateChanged(DateEvent dateEvent) {
            JDateEditComponent.this.fireDateChanged(new DateEvent((Object)JDateEditComponent.this, dateEvent.getDate()));
        }

        public void dateFieldCleared(DateEvent dateEvent) {
            JDateEditComponent.this.fireDateFieldCleared(new DateEvent((Object)JDateEditComponent.this, dateEvent.getField()));
        }
    }
}

