/*
 * Decompiled with CFR 0.152.
 */
package com.standbysoft.component.date;

import com.standbysoft.component.date.DateSelectionException;
import com.standbysoft.component.date.DateSelectionModel;
import com.standbysoft.component.date.event.DateSelectionEvent;
import com.standbysoft.component.date.event.DateSelectionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;

public abstract class AbstractDateSelectionModel
implements DateSelectionModel {
    private List A = new ArrayList();
    private DateSelectionModel.SelectionMode I;
    private Date E;
    private Date D;
    private Set H;
    private Date J;
    private Date K;
    private boolean G = true;
    private Calendar C;
    private Calendar B;
    private TimeZone F = TimeZone.getDefault();
    static /* synthetic */ Class class$com$standbysoft$component$date$event$DateSelectionListener;

    public AbstractDateSelectionModel() {
        this.I = DateSelectionModel.SelectionMode.MULTIPLE_INTERVAL;
        this.H = new TreeSet();
        this.C = Calendar.getInstance();
        this.B = Calendar.getInstance();
    }

    public void setTimeZone(TimeZone timeZone) {
        if (!this.F.equals(timeZone)) {
            this.F = timeZone;
            this.C.setTimeZone(timeZone);
            this.B.setTimeZone(timeZone);
        }
    }

    public TimeZone getTimeZone() {
        return this.F;
    }

    public boolean isDateSelectable(Date date) {
        if (date == null) {
            return this.isEmptySelectionAllowed();
        }
        if (this.E != null && this.E.after(date) && !this.A(this.E, date)) {
            return false;
        }
        if (this.D != null && this.D.before(date) && !this.A(this.D, date)) {
            return false;
        }
        return !this.isDisabled(date);
    }

    public abstract boolean isDisabled(Date var1);

    public boolean isDateSelected(Date date) {
        Iterator iterator = this.H.iterator();
        while (iterator.hasNext()) {
            Date date2 = (Date)iterator.next();
            if (!this.A(date2, date)) continue;
            return true;
        }
        return false;
    }

    public void setMinimumAllowed(Date date) {
        this.E = date;
        this.fireDisabledDatesChanged(new DateSelectionEvent(this, date, date));
    }

    public void setMaximumAllowed(Date date) {
        this.D = date;
        this.fireDisabledDatesChanged(new DateSelectionEvent(this, date, date));
    }

    public Date getMinimumAllowed() {
        return this.E;
    }

    public Date getMaximumAllowed() {
        return this.D;
    }

    private boolean A(Date date, Date date2) {
        this.B.setTime(date);
        int n = this.B.get(1);
        int n2 = this.B.get(2);
        int n3 = this.B.get(5);
        this.B.setTime(date2);
        if (n != this.B.get(1)) {
            return false;
        }
        if (n2 != this.B.get(2)) {
            return false;
        }
        return n3 == this.B.get(5);
    }

    public void setSelectionMode(DateSelectionModel.SelectionMode selectionMode) {
        this.I = selectionMode;
        this.fireSelectionModeChanged(new DateSelectionEvent(this, null, null));
    }

    public DateSelectionModel.SelectionMode getSelectionMode() {
        return this.I;
    }

    public void setSelectedDates(Date[] dateArray) {
        if (dateArray == null) {
            return;
        }
        if (dateArray.length == 0) {
            this.removeAllDates();
        } else {
            this.J = null;
            this.K = null;
            this.H.clear();
            for (int i = 0; i < dateArray.length; ++i) {
                Date date = dateArray[i];
                if (this.isDateSelectable(date)) {
                    if (this.J == null) {
                        this.J = date;
                    }
                    if (this.K == null) {
                        this.K = date;
                    }
                    this.H.add(date);
                    continue;
                }
                this.fireDisabledDateSelectionAttempted(new DateSelectionEvent(this, date, date));
            }
            this.fireDateSelectionChanged(new DateSelectionEvent(this, this.J, this.K));
        }
    }

    public Date[] getSelectedDates() {
        return this.H.toArray(new Date[0]);
    }

    public void setLeadSelectionDate(Date date) {
        if (date == null) {
            return;
        }
        Date date2 = this.J;
        if (!this.isDateSelectable(date)) {
            this.fireDisabledDateSelectionAttempted(new DateSelectionEvent(this, date, date));
            return;
        }
        if (this.getSelectionMode().equals(DateSelectionModel.SelectionMode.SINGLE)) {
            date2 = date;
        }
        this.removeDateSelectionInterval(this.J, this.K);
        this.J = date2;
        this.addDateSelectionInterval(this.J, date);
        this.J = date2;
        this.K = date;
    }

    public Date getLeadSelectionDate() {
        return this.K;
    }

    public void setAnchorSelectionDate(Date date) {
        if (date == null) {
            return;
        }
        if (!this.isDateSelectable(date)) {
            this.fireDisabledDateSelectionAttempted(new DateSelectionEvent(this, date, date));
            return;
        }
        this.J = date;
        this.setDateSelectionIterval(this.J, this.J);
    }

    public Date getAnchorSelectionDate() {
        return this.J;
    }

    public void setEmptySelectionAllowed(boolean bl) throws DateSelectionException {
        if (this.G == bl) {
            return;
        }
        if (!bl && this.H.size() == 0) {
            throw new DateSelectionException("Trying to disallow empty selection but there is no date selected");
        }
        this.G = bl;
        this.fireEmptySelectionAllowedChanged(new DateSelectionEvent(this, null, null));
    }

    public boolean isEmptySelectionAllowed() {
        return this.G;
    }

    public void setDateSelectionIterval(Date date, Date date2) {
        if (date == null || date2 == null) {
            return;
        }
        if (!this.isDateSelectable(date) && !this.isDateSelectable(date2)) {
            this.fireDisabledDateSelectionAttempted(new DateSelectionEvent(this, date, date2));
            return;
        }
        this.H.clear();
        if (this.I.equals(DateSelectionModel.SelectionMode.SINGLE)) {
            this.H.add(date2);
            this.J = date2;
            this.K = date2;
        } else {
            this.H.addAll(this.C(date, date2));
            this.J = date;
            this.K = date2;
        }
        this.fireDateSelectionChanged(new DateSelectionEvent(this, date, date2));
    }

    public void addDateSelectionInterval(Date date, Date date2) {
        if (date == null || date2 == null) {
            return;
        }
        if (!this.isDateSelectable(date) && !this.isDateSelectable(date2)) {
            this.fireDisabledDateSelectionAttempted(new DateSelectionEvent(this, date, date2));
            return;
        }
        if (this.I.equals(DateSelectionModel.SelectionMode.SINGLE)) {
            this.setDateSelectionIterval(date, date2);
        } else if (this.I.equals(DateSelectionModel.SelectionMode.SINGLE_INTERVAL)) {
            this.setDateSelectionIterval(date, date2);
        } else {
            this.H.addAll(this.C(date, date2));
            this.J = date;
            this.K = date2;
            this.fireDateSelectionChanged(new DateSelectionEvent(this, date, date2));
        }
    }

    public void removeDateSelectionInterval(Date date, Date date2) {
        if (date == null || date2 == null) {
            return;
        }
        if (this.I.equals(DateSelectionModel.SelectionMode.SINGLE)) {
            Date date3 = this.J;
            this.H.removeAll(this.C(date, date2));
            if (this.H.size() == 0) {
                if (!this.isEmptySelectionAllowed()) {
                    this.setDateSelectionIterval(date3, date3);
                } else {
                    this.J = null;
                    this.K = null;
                    this.fireDateSelectionChanged(new DateSelectionEvent(this, date, date2));
                }
            }
        } else if (this.I.equals(DateSelectionModel.SelectionMode.SINGLE_INTERVAL)) {
            if (this.isDateSelected(date) || this.isDateSelected(date2)) {
                this.removeAllDates();
            }
        } else {
            Date date4 = this.J;
            this.H.removeAll(this.C(date, date2));
            if (this.H.size() == 0) {
                if (!this.isEmptySelectionAllowed()) {
                    this.setDateSelectionIterval(date4, date4);
                } else {
                    this.J = null;
                    this.K = null;
                    this.fireDateSelectionChanged(new DateSelectionEvent(this, date, date2));
                }
            } else {
                this.J = this.K = date;
                this.fireDateSelectionChanged(new DateSelectionEvent(this, date, date2));
            }
        }
    }

    public void removeAllDates() {
        Date date = this.J;
        Date date2 = this.K;
        this.J = null;
        this.K = null;
        this.H.clear();
        if (!this.isEmptySelectionAllowed()) {
            this.H.add(date);
            this.J = date;
            this.K = date;
        }
        this.fireDateSelectionChanged(new DateSelectionEvent(this, date, date2));
    }

    public synchronized void addDateSelectionListener(DateSelectionListener dateSelectionListener) {
        this.A.add(dateSelectionListener);
    }

    public synchronized void removeDateSelectionListener(DateSelectionListener dateSelectionListener) {
        this.A.remove(dateSelectionListener);
    }

    public EventListener[] getListeners(Class clazz) {
        if (clazz.equals(class$com$standbysoft$component$date$event$DateSelectionListener == null ? (class$com$standbysoft$component$date$event$DateSelectionListener = AbstractDateSelectionModel.class$("com.standbysoft.component.date.event.DateSelectionListener")) : class$com$standbysoft$component$date$event$DateSelectionListener)) {
            return this.A.toArray(new EventListener[0]);
        }
        return new EventListener[0];
    }

    protected void fireDateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
        Object[] objectArray = this.A.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            ((DateSelectionListener)objectArray[i]).dateSelectionChanged(dateSelectionEvent);
        }
    }

    protected void fireSelectionModeChanged(DateSelectionEvent dateSelectionEvent) {
        Object[] objectArray = this.A.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            ((DateSelectionListener)objectArray[i]).selectionModeChanged(dateSelectionEvent);
        }
    }

    protected void fireDisabledDatesChanged(DateSelectionEvent dateSelectionEvent) {
        Object[] objectArray = this.A.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            ((DateSelectionListener)objectArray[i]).disabledDatesChanged(dateSelectionEvent);
        }
    }

    protected void fireEmptySelectionAllowedChanged(DateSelectionEvent dateSelectionEvent) {
        Object[] objectArray = this.A.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            ((DateSelectionListener)objectArray[i]).emptySelectionAllowedChanged(dateSelectionEvent);
        }
    }

    protected void fireDisabledDateSelectionAttempted(DateSelectionEvent dateSelectionEvent) {
        Object[] objectArray = this.A.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            ((DateSelectionListener)objectArray[i]).disabledDateSelectionAttempted(dateSelectionEvent);
        }
    }

    private Collection C(Date date, Date date2) {
        Date date3 = AbstractDateSelectionModel.D(date, date2);
        Date date4 = AbstractDateSelectionModel.B(date, date2);
        this.C.setTime(date3);
        ArrayList<Date> arrayList = new ArrayList<Date>();
        while (!this.A(this.C.getTime(), date4)) {
            if (this.isDateSelectable(this.C.getTime())) {
                arrayList.add(this.C.getTime());
            } else {
                this.fireDisabledDateSelectionAttempted(new DateSelectionEvent(this, this.C.getTime(), this.C.getTime()));
            }
            this.C.roll(5, true);
            if (this.C.get(5) != 1) continue;
            this.C.roll(2, true);
            if (this.C.get(2) != 0) continue;
            this.C.roll(1, true);
        }
        arrayList.add(date4);
        return arrayList;
    }

    private static Date D(Date date, Date date2) {
        if (date.before(date2)) {
            return date;
        }
        return date2;
    }

    private static Date B(Date date, Date date2) {
        if (date.before(date2)) {
            return date2;
        }
        return date;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

