/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.border.ClassicInnerBorderPainter;
import org.jvnet.substance.border.GlassInnerBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.LightGrayColorScheme;
import org.jvnet.substance.painter.AlphaControlBackgroundComposite;
import org.jvnet.substance.painter.MatteGradientPainter;
import org.jvnet.substance.painter.SimplisticSoftBorderReverseGradientPainter;
import org.jvnet.substance.painter.decoration.ArcDecorationPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.skin.SubstanceAbstractSkin;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceCremeTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.watermark.SubstanceNullWatermark;

public class CremeCoffeeSkin
extends SubstanceAbstractSkin {
    public static String NAME = "Creme Coffee";

    public CremeCoffeeSkin() {
        SubstanceTheme activeTheme = new SubstanceTheme(new ActiveScheme(), "Creme Coffee Active", SubstanceTheme.ThemeKind.COLD);
        SubstanceCremeTheme defaultTheme = new SubstanceCremeTheme();
        SubstanceTheme disabledTheme = new SubstanceTheme(new LightGrayColorScheme(), "Tint Light Gray", SubstanceTheme.ThemeKind.COLD).tint(0.35);
        SubstanceCremeTheme activeTitleTheme = defaultTheme;
        SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME, SubstanceTheme.ThemeKind.COLD, activeTheme, defaultTheme, disabledTheme, activeTitleTheme);
        theme.registerDecorationAreaTheme(activeTitleTheme, false, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER, DecorationAreaType.GENERAL, DecorationAreaType.TOOLBAR);
        theme.setNonActivePainter(new SimplisticSoftBorderReverseGradientPainter());
        theme.setSelectedTabFadeStart(0.1);
        theme.setSelectedTabFadeEnd(0.3);
        this.theme = theme;
        this.buttonShaper = new ClassicButtonShaper();
        this.watermark = new SubstanceNullWatermark();
        this.gradientPainter = new MatteGradientPainter();
        this.decorationPainter = new ArcDecorationPainter();
        this.borderPainter = new ClassicInnerBorderPainter(0.8f, SubstanceConstants.ColorShiftKind.TINT);
        this.highlightPainter = new ClassicHighlightPainter();
        this.tabBackgroundComposite = new AlphaControlBackgroundComposite(0.75f);
        this.borderPainter = new GlassInnerBorderPainter(0.8f, SubstanceConstants.ColorShiftKind.TINT);
    }

    public String getDisplayName() {
        return NAME;
    }

    protected static class ActiveScheme
    implements ColorScheme {
        private static final Color mainUltraLightColor = new Color(244, 229, 192);
        private static final Color mainExtraLightColor = new Color(240, 222, 179);
        private static final Color mainLightColor = new Color(235, 215, 166);
        private static final Color mainMidColor = new Color(200, 162, 110);
        private static final Color mainDarkColor = new Color(170, 131, 99);
        private static final Color mainUltraDarkColor = new Color(141, 97, 44);
        private static final Color foregroundColor = new Color(50, 34, 15);

        protected ActiveScheme() {
        }

        public Color getForegroundColor() {
            return foregroundColor;
        }

        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        public Color getLightColor() {
            return mainLightColor;
        }

        public Color getMidColor() {
            return mainMidColor;
        }

        public Color getDarkColor() {
            return mainDarkColor;
        }

        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }
}

