/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.jvnet.substance.painter.text.SubstanceTextPainter;

public abstract class AbstractTextPainter
implements SubstanceTextPainter {
    protected List<SubstanceTextPainter.BackgroundPaintingCallback> callbackList = new LinkedList<SubstanceTextPainter.BackgroundPaintingCallback>();
    protected List<TextLineInfo> textLines = new LinkedList<TextLineInfo>();
    protected boolean toEnforceRenderOnNoTexts;
    protected Component comp;

    protected AbstractTextPainter() {
    }

    public void init(JComponent comp, Rectangle clip, boolean toEnforceRenderOnNoTexts) {
        if (!this.toIgnoreBackgroundFill(comp)) {
            this.callbackList.clear();
        }
        this.comp = comp;
        this.textLines.clear();
        this.toEnforceRenderOnNoTexts = toEnforceRenderOnNoTexts;
    }

    public void attachCallback(SubstanceTextPainter.BackgroundPaintingCallback backgroundPaintingCallback) {
        this.callbackList.add(backgroundPaintingCallback);
    }

    public void attachText(JComponent comp, Rectangle textRect, String text, int mnemonicIndex, Font font, Color color, Rectangle clip) {
        this.textLines.add(new TextLineInfo(textRect, text, mnemonicIndex, font, color, clip, null));
    }

    protected boolean toIgnoreBackgroundFill(Component comp) {
        for (Component c = comp; c != null; c = c.getParent()) {
            JComponent jc;
            if (!(c instanceof JComponent) || !Boolean.TRUE.equals((jc = (JComponent)c).getClientProperty("substancelaf.internal.textPainter.doNotFillBackground"))) continue;
            return true;
        }
        return false;
    }

    public static class TextLineInfo {
        public Rectangle textRect;
        public String text;
        public int mnemonicIndex;
        public Font font;
        public Color color;
        public Rectangle clip;
        public AffineTransform transform;

        public TextLineInfo(Rectangle textRect, String text, int mnemonicIndex, Font font, Color color, Rectangle clip, AffineTransform transform) {
            this.textRect = textRect;
            this.text = text;
            this.mnemonicIndex = mnemonicIndex;
            this.font = font;
            this.color = color;
            this.clip = clip;
            this.transform = transform;
        }
    }
}

