/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.scroll;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jvnet.lafwidget.LafWidgetAdapter;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.scroll.AutoScrollActivator;

public class AutoScrollWidget
extends LafWidgetAdapter {
    protected JScrollPane scrollPane;
    protected PropertyChangeListener propertyChangeListener;

    public void setComponent(JComponent jcomp) {
        super.setComponent(jcomp);
        this.scrollPane = (JScrollPane)jcomp;
    }

    public boolean requiresCustomLafSupport() {
        return false;
    }

    public void installUI() {
        if (LafWidgetUtilities.hasAutoScroll(this.scrollPane)) {
            AutoScrollActivator.setAutoScrollEnabled(this.scrollPane, true);
        }
    }

    public void uninstallUI() {
        AutoScrollActivator.setAutoScrollEnabled(this.scrollPane, false);
    }

    public void installListeners() {
        this.propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("lafwidget.scroll.auto".equals(evt.getPropertyName())) {
                    AutoScrollActivator.setAutoScrollEnabled(AutoScrollWidget.this.scrollPane, LafWidgetUtilities.hasAutoScroll(AutoScrollWidget.this.scrollPane));
                }
            }
        };
        this.scrollPane.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void uninstallListeners() {
        this.scrollPane.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }
}

