/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.mdbimport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import prospektservice.Feedback;
import prospektservice.PSEnvironment;
import prospektservice.PSO;

public class MdbImportWin32 {
    private static byte[] buffer = new byte[]{73, 119, 78, 83, 102, 105, 108, 33};

    public static Connection openMdbFile(String file) {
        boolean exceptionRaised = false;
        Connection con = null;
        String mdwPath = MdbImportWin32.getSystemMdw();
        String url = "jdbc:odbc:Driver={MicroSoft Access Driver (*.mdb)};DBQ=" + file + ";SystemDB=" + mdwPath + ";";
        String username = "ps97";
        try {
            String password = new String(buffer, "US-ASCII");
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            con = DriverManager.getConnection(url, username, password);
        }
        catch (SQLException e) {
            System.out.println("Connection exception: " + e);
            exceptionRaised = true;
        }
        catch (ClassNotFoundException e) {
            System.out.println("Connection exception: " + e);
            exceptionRaised = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            exceptionRaised = true;
        }
        if (exceptionRaised) {
            Feedback.showMessage(PSO.mainpanel, 48);
        }
        return con;
    }

    private static String getSystemMdw() {
        String result = "";
        int blockSize = 4096;
        try {
            JarFile jf;
            JarEntry je;
            File f = new File("./");
            String path = f.getAbsolutePath();
            if (path.endsWith(PSEnvironment.FILE_SEPARATOR)) {
                path = path.substring(0, path.length() - 1);
            }
            if ((je = (JarEntry)(jf = new JarFile(String.valueOf(path) + "/classes/import.jar")).getEntry("system.mdw")) != null) {
                InputStream is = jf.getInputStream(je);
                path = PSEnvironment.getPSPath();
                f = new File(String.valueOf(path) + "/data/");
                if (!f.exists()) {
                    f.mkdirs();
                }
                result = f.getCanonicalPath();
                FileOutputStream fos = new FileOutputStream(String.valueOf(path) + "/data/tmpimport");
                byte[] raw = new byte[blockSize];
                int read = -1;
                while ((read = is.read(raw)) > -1) {
                    fos.write(raw, 0, read);
                }
                fos.flush();
                fos.close();
                if (result.charAt(result.length() - 1) != '/' && result.charAt(result.length() - 1) != '\\') {
                    result = String.valueOf(result) + PSEnvironment.FILE_SEPARATOR;
                }
                result = String.valueOf(result) + "tmpimport";
                is.close();
                jf.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static void endImport() {
        try {
            File f = new File(String.valueOf(PSEnvironment.getPSPath()) + "data/tmpimport");
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

