/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.layoutmanager;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.StringTokenizer;
import java.util.Vector;

public final class CellLayout
implements LayoutManager {
    private static final int BOTH = 3;
    private static final int WIDTH = 2;
    private static final int HEIGHT = 1;
    private static final int N = 1;
    private static final int S = 2;
    private static final int W = 3;
    private static final int E = 4;
    private static final int NW = 5;
    private static final int NE = 6;
    private static final int SW = 7;
    private static final int SE = 8;
    private Vector<Component> comps = new Vector(10, 1);
    private Vector<CellParams> params = new Vector(10, 1);
    private int xmax = 0;
    private int ymax = 0;

    @Override
    public void addLayoutComponent(String s, Component component) {
        int x = 0;
        int y = 0;
        int xl = 1;
        int yl = 1;
        int a = 0;
        int f = 0;
        int px = 0;
        int py = 0;
        int wx = 0;
        int wy = 0;
        int it = 0;
        int il = 0;
        int ib = 0;
        int ir = 0;
        Object i = null;
        StringTokenizer st = new StringTokenizer(s, " ");
        while (st.hasMoreTokens()) {
            StringTokenizer st1 = new StringTokenizer(st.nextToken(), "=");
            if (st1.countTokens() < 2) {
                throw new IllegalArgumentException("Add Component: Bad constraints");
            }
            String s1 = st1.nextToken();
            String s2 = st1.nextToken();
            if (s1.equals("x")) {
                x = Integer.valueOf(s2);
            }
            if (s1.equals("y")) {
                y = Integer.valueOf(s2);
            }
            if (s1.equals("padx") || s1.equals("px")) {
                px = Integer.valueOf(s2);
            }
            if (s1.equals("pady") || s1.equals("py")) {
                py = Integer.valueOf(s2);
            }
            if (s1.equals("width") || s1.equals("w")) {
                xl = Integer.valueOf(s2);
            }
            if (s1.equals("height") || s1.equals("h")) {
                yl = Integer.valueOf(s2);
            }
            if (s1.equals("weightx") || s1.equals("wx")) {
                wx = Integer.valueOf(s2);
            }
            if (s1.equals("weighty") || s1.equals("wy")) {
                wy = Integer.valueOf(s2);
            }
            if (s1.equals("fill") || s1.equals("f")) {
                if (s2.equals("both") || s2.equals("b")) {
                    f = 3;
                }
                if (s2.equals("width") || s2.equals("w")) {
                    f = 2;
                }
                if (s2.equals("height") || s2.equals("h")) {
                    f = 1;
                }
            }
            if (s1.equals("anchor") || s1.equals("a")) {
                if (s2.equals("north") || s2.equals("n")) {
                    a = 1;
                }
                if (s2.equals("south") || s2.equals("s")) {
                    a = 2;
                }
                if (s2.equals("west") || s2.equals("w")) {
                    a = 3;
                }
                if (s2.equals("east") || s2.equals("e")) {
                    a = 4;
                }
                if (s2.equals("northwest") || s2.equals("nw")) {
                    a = 5;
                }
                if (s2.equals("northeast") || s2.equals("ne")) {
                    a = 6;
                }
                if (s2.equals("southwest") || s2.equals("sw")) {
                    a = 7;
                }
                if (s2.equals("southeast") || s2.equals("se")) {
                    a = 8;
                }
            }
            if (s1.equals("insettop") || s1.equals("it")) {
                it = Integer.valueOf(s2);
            }
            if (s1.equals("insetleft") || s1.equals("il")) {
                il = Integer.valueOf(s2);
            }
            if (s1.equals("insetright") || s1.equals("ir")) {
                ir = Integer.valueOf(s2);
            }
            if (!s1.equals("insetbottom") && !s1.equals("ib")) continue;
            ib = Integer.valueOf(s2);
        }
        if (x == 0 || y == 0) {
            throw new IllegalArgumentException("Add Component: bad index value");
        }
        if (xl < 1 || yl < 1) {
            throw new IllegalArgumentException("Add Component: bad length value");
        }
        if (wx < 0 || wy < 0 || wx > 100 || wy > 100) {
            throw new IllegalArgumentException("Add Component: bad weight value");
        }
        if (x + xl - 1 > this.xmax) {
            this.xmax = x + xl - 1;
        }
        if (y + yl - 1 > this.ymax) {
            this.ymax = y + yl - 1;
        }
        this.comps.addElement(component);
        this.params.addElement(new CellParams(x, y, xl, yl, a, f, px, py, wx, wy, it, il, ib, ir));
    }

    @Override
    public void removeLayoutComponent(Component component) {
        int i = this.comps.lastIndexOf(component);
        if (i != -1) {
            this.comps.removeElementAt(i);
            this.params.removeElementAt(i);
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        int size = 0;
        int xlen = 0;
        int ylen = 0;
        CellParams param = null;
        Component comp = null;
        int[] sizex = new int[this.xmax];
        int[] sizey = new int[this.ymax];
        int i = 0;
        while (i < this.comps.size()) {
            param = this.params.elementAt(i);
            comp = this.comps.elementAt(i);
            size = (int)(((double)comp.getPreferredSize().width + 2.0 * (double)param.ipadx + (double)param.insetleft + (double)param.insetright) / (double)param.xlen);
            int j = -1;
            while (j < param.xlen - 1) {
                sizex[param.x + j] = sizex[param.x + j] < size ? size : sizex[param.x + j];
                ++j;
            }
            size = (int)(((double)comp.getPreferredSize().height + 2.0 * (double)param.ipady + (double)param.insettop + (double)param.insetbottom) / (double)param.ylen);
            j = -1;
            while (j < param.ylen - 1) {
                sizey[param.y + j] = sizey[param.y + j] < size ? size : sizey[param.y + j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.xmax) {
            xlen += sizex[i];
            ++i;
        }
        i = 0;
        while (i < this.ymax) {
            ylen += sizey[i];
            ++i;
        }
        return new Dimension(xlen += container.getInsets().left + container.getInsets().right, ylen += container.getInsets().top + container.getInsets().bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        int xlen = 0;
        int ylen = 0;
        CellParams param = null;
        Component comp = null;
        int[] sizex = new int[this.xmax];
        int[] sizey = new int[this.ymax];
        int i = 0;
        while (i < this.comps.size()) {
            param = this.params.elementAt(i);
            comp = this.comps.elementAt(i);
            Dimension comp_minsize = comp.getMinimumSize();
            int size = (int)(((double)comp_minsize.width + 2.0 * (double)param.ipadx + (double)param.insetleft + (double)param.insetright) / (double)param.xlen);
            int j = -1;
            while (j < param.xlen - 1) {
                sizex[param.x + j] = sizex[param.x + j] < size ? size : sizex[param.x + j];
                ++j;
            }
            size = (int)(((double)comp_minsize.height + 2.0 * (double)param.ipady + (double)param.insettop + (double)param.insetbottom) / (double)param.ylen);
            j = -1;
            while (j < param.ylen - 1) {
                sizey[param.y + j] = sizey[param.y + j] < size ? size : sizey[param.y + j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.xmax) {
            xlen += sizex[i];
            ++i;
        }
        i = 0;
        while (i < this.ymax) {
            ylen += sizey[i];
            ++i;
        }
        return new Dimension(xlen += container.getInsets().left + container.getInsets().right, ylen += container.getInsets().top + container.getInsets().bottom);
    }

    @Override
    public void layoutContainer(Container container) {
        double wy;
        double wx;
        int j;
        int size;
        Dimension comp_minsize;
        int xpos = 0;
        int ypos = 0;
        int xlen = 0;
        int ylen = 0;
        int it = 0;
        int il = 0;
        int ib = 0;
        int ir = 0;
        CellParams param = null;
        Component comp = null;
        int[] sizex = new int[this.xmax];
        int[] sizey = new int[this.ymax];
        int[] weightx = new int[this.xmax];
        int[] weighty = new int[this.ymax];
        int i = 0;
        while (i < this.comps.size()) {
            param = this.params.elementAt(i);
            comp = this.comps.elementAt(i);
            comp_minsize = comp.getMinimumSize();
            size = (int)(((double)comp_minsize.width + 2.0 * (double)param.ipadx + (double)param.insetleft + (double)param.insetright) / (double)param.xlen);
            j = -1;
            while (j < param.xlen - 1) {
                sizex[param.x + j] = sizex[param.x + j] < size ? size : sizex[param.x + j];
                weightx[param.x + j] = weightx[param.x + j] < param.weightx ? param.weightx : weightx[param.x + j];
                ++j;
            }
            size = (int)(((double)comp_minsize.height + 2.0 * (double)param.ipady + (double)param.insettop + (double)param.insetbottom) / (double)param.ylen);
            j = -1;
            while (j < param.ylen - 1) {
                sizey[param.y + j] = sizey[param.y + j] < size ? size : sizey[param.y + j];
                weighty[param.y + j] = weighty[param.y + j] < param.weighty ? param.weighty : weighty[param.y + j];
                ++j;
            }
            ++i;
        }
        size = 0;
        int weight = 0;
        i = 0;
        while (i < this.xmax) {
            size += sizex[i];
            weight += weightx[i];
            ++i;
        }
        int restx = container.getSize().width - size - container.getInsets().left - container.getInsets().right;
        if (restx < 0) {
            restx = 0;
            wx = 0.0;
        } else {
            wx = weight <= 100 ? (double)restx / 100.0 : (double)restx / (double)weight;
        }
        size = 0;
        weight = 0;
        i = 0;
        while (i < this.ymax) {
            size += sizey[i];
            weight += weighty[i];
            ++i;
        }
        int resty = container.getSize().height - size - container.getInsets().top - container.getInsets().bottom;
        if (resty < 0) {
            resty = 0;
            wy = 0.0;
        } else {
            wy = weight <= 100 ? (double)resty / 100.0 : (double)resty / (double)weight;
        }
        i = 0;
        while (i < this.xmax) {
            int n = i;
            sizex[n] = sizex[n] + (int)((double)weightx[i] * wx);
            restx -= (int)((double)weightx[i] * wx);
            ++i;
        }
        il = (il += restx / 2) < 0 ? 0 : il;
        ir = ir < 0 ? 0 : (ir += restx / 2);
        i = 0;
        while (i < this.ymax) {
            int n = i;
            sizey[n] = sizey[n] + (int)((double)weighty[i] * wy);
            resty -= (int)((double)weighty[i] * wy);
            ++i;
        }
        it = (it += resty / 2) < 0 ? 0 : it;
        ib = ib < 0 ? 0 : (ib += resty / 2);
        i = 0;
        while (i < this.comps.size()) {
            param = this.params.elementAt(i);
            comp = this.comps.elementAt(i);
            comp_minsize = comp.getMinimumSize();
            xpos = 0;
            ypos = 0;
            xlen = 0;
            ylen = 0;
            if (param.fill == 3) {
                j = 0;
                while (j < param.x - 1) {
                    xpos += sizex[j];
                    ++j;
                }
                j = 0;
                while (j < param.y - 1) {
                    ypos += sizey[j];
                    ++j;
                }
                j = param.x - 1;
                while (j < param.x + param.xlen - 1) {
                    xlen += sizex[j];
                    ++j;
                }
                j = param.y - 1;
                while (j < param.y + param.ylen - 1) {
                    ylen += sizey[j];
                    ++j;
                }
                xpos += param.ipadx + param.insetleft;
                if ((xlen -= 2 * param.ipadx + param.insetright + param.insetleft) < comp_minsize.width) {
                    xlen = comp_minsize.width;
                }
                ypos += param.ipady + param.insettop;
                if ((ylen -= 2 * param.ipady + param.insettop + param.insetbottom) < comp_minsize.height) {
                    ylen = comp_minsize.height;
                }
            } else if (param.fill == 2) {
                j = 0;
                while (j < param.x - 1) {
                    xpos += sizex[j];
                    ++j;
                }
                j = 0;
                while (j < param.y - 1) {
                    ypos += sizey[j];
                    ++j;
                }
                j = param.x - 1;
                while (j < param.x + param.xlen - 1) {
                    xlen += sizex[j];
                    ++j;
                }
                j = param.y - 1;
                while (j < param.y + param.ylen - 1) {
                    ylen += sizey[j];
                    ++j;
                }
                xpos += param.ipadx + param.insetleft;
                if ((xlen -= 2 * param.ipadx + param.insetright + param.insetleft) < comp_minsize.width) {
                    xlen = comp_minsize.width;
                }
                ypos += param.insettop;
                ylen -= param.insettop + param.insetbottom;
                switch (param.anchor) {
                    case 1: 
                    case 5: 
                    case 6: {
                        ypos += param.ipady;
                        ylen = comp_minsize.height;
                        break;
                    }
                    case 2: 
                    case 7: 
                    case 8: {
                        ypos += ylen - comp_minsize.height - param.ipady;
                        ylen = comp_minsize.height;
                        break;
                    }
                    default: {
                        ypos += (ylen - comp_minsize.height) / 2;
                        ylen = comp_minsize.height;
                        break;
                    }
                }
            } else if (param.fill == 1) {
                j = 0;
                while (j < param.x - 1) {
                    xpos += sizex[j];
                    ++j;
                }
                j = 0;
                while (j < param.y - 1) {
                    ypos += sizey[j];
                    ++j;
                }
                j = param.x - 1;
                while (j < param.x + param.xlen - 1) {
                    xlen += sizex[j];
                    ++j;
                }
                j = param.y - 1;
                while (j < param.y + param.ylen - 1) {
                    ylen += sizey[j];
                    ++j;
                }
                xpos += param.insetleft;
                xlen -= param.insetright + param.insetleft;
                ypos += param.ipady + param.insettop;
                if ((ylen -= 2 * param.ipady + param.insettop + param.insetbottom) < comp_minsize.height) {
                    ylen = comp_minsize.height;
                }
                switch (param.anchor) {
                    case 3: 
                    case 5: 
                    case 7: {
                        xpos += param.ipadx;
                        xlen = comp_minsize.width;
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 8: {
                        xpos += xlen - comp_minsize.width - param.ipadx;
                        xlen = comp_minsize.width;
                        break;
                    }
                    default: {
                        xpos += (xlen - comp_minsize.width) / 2;
                        xlen = comp_minsize.width;
                        break;
                    }
                }
            } else {
                j = 0;
                while (j < param.x - 1) {
                    xpos += sizex[j];
                    ++j;
                }
                j = 0;
                while (j < param.y - 1) {
                    ypos += sizey[j];
                    ++j;
                }
                j = param.x - 1;
                while (j < param.x + param.xlen - 1) {
                    xlen += sizex[j];
                    ++j;
                }
                j = param.y - 1;
                while (j < param.y + param.ylen - 1) {
                    ylen += sizey[j];
                    ++j;
                }
                xpos += param.insetleft;
                xlen -= param.insetright + param.insetleft;
                ypos += param.insettop;
                ylen -= param.insettop + param.insetbottom;
                switch (param.anchor) {
                    case 1: {
                        xpos += (xlen - comp_minsize.width) / 2;
                        xlen = comp_minsize.width;
                        ypos += param.ipady;
                        ylen = comp_minsize.height;
                        break;
                    }
                    case 5: {
                        xpos += param.ipadx;
                        xlen = comp_minsize.width;
                        ypos += param.ipady;
                        ylen = comp_minsize.height;
                        break;
                    }
                    case 6: {
                        xpos += xlen - comp_minsize.width - param.ipadx;
                        xlen = comp_minsize.width;
                        ypos += param.ipady;
                        ylen = comp_minsize.height;
                        break;
                    }
                    case 2: {
                        xpos += (xlen - comp_minsize.width) / 2;
                        xlen = comp_minsize.width;
                        ypos += ylen - comp_minsize.height - param.ipady;
                        ylen = comp_minsize.height;
                        break;
                    }
                    case 7: {
                        xpos += param.ipadx;
                        xlen = comp_minsize.width;
                        ypos += ylen - comp_minsize.height - param.ipady;
                        ylen = comp_minsize.height;
                        break;
                    }
                    case 8: {
                        xpos += xlen - comp_minsize.width - param.ipadx;
                        xlen = comp_minsize.width;
                        ypos += ylen - comp_minsize.height - param.ipady;
                        ylen = comp_minsize.height;
                        break;
                    }
                    case 3: {
                        xpos += param.ipadx;
                        xlen = comp_minsize.width;
                        ypos += (ylen - comp_minsize.height) / 2;
                        ylen = comp_minsize.height;
                        break;
                    }
                    case 4: {
                        xpos += xlen - comp_minsize.width - param.ipadx;
                        xlen = comp_minsize.width;
                        ypos += (ylen - comp_minsize.height) / 2;
                        ylen = comp_minsize.height;
                        break;
                    }
                    default: {
                        xpos += (xlen - comp_minsize.width) / 2;
                        xlen = comp_minsize.width;
                        ypos += (ylen - comp_minsize.height) / 2;
                        ylen = comp_minsize.height;
                    }
                }
            }
            comp.setBounds(xpos += container.getInsets().left + il, ypos += container.getInsets().top + it, xlen, ylen);
            ++i;
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    class CellParams {
        int x;
        int y;
        int xlen;
        int ylen;
        int anchor;
        int fill;
        int ipadx;
        int ipady;
        int weightx;
        int weighty;
        int insettop;
        int insetleft;
        int insetbottom;
        int insetright;

        CellParams(int x, int y, int xl, int yl, int a, int f, int px, int py, int wx, int wy, int it, int il, int ib, int ir) {
            this.x = x;
            this.y = y;
            this.xlen = xl;
            this.ylen = yl;
            this.anchor = a;
            this.fill = f;
            this.ipadx = px;
            this.ipady = py;
            this.weightx = wx;
            this.weighty = wy;
            this.insettop = it;
            this.insetleft = il;
            this.insetbottom = ib;
            this.insetright = ir;
        }
    }
}

