/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.karte;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.base.PSImageIcon;

public class MapPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 3762532300063127348L;
    private static ResourceBundle localProperty;
    private static PSO psoInstance;
    private static MapPopupMenu mapPopupMenuInstance;
    private static Cursor currentCursor;
    private static String mapKeyString;
    private static PSImageIcon selIcon;
    private static int MAX_MAPFLAGS;
    private static int CURR_MAPFLAGS;
    private static final int UP = 1;
    private static final int DOWN = 2;

    static {
        currentCursor = Cursor.getPredefinedCursor(0);
        mapKeyString = "";
        MAX_MAPFLAGS = 10;
        CURR_MAPFLAGS = 0;
    }

    public void finalize() {
        try {
            if (!mapPopupMenuInstance.isVisible()) {
                localProperty = null;
                mapPopupMenuInstance = null;
                mapKeyString = null;
                super.finalize();
            }
        }
        catch (Throwable tEx) {
            PSEnvironment.printDebugMessage(this.getClass().getName(), tEx.getMessage());
        }
    }

    @Override
    public void show(Component panel, int pX, int pY) {
        int componentHeight = this.getPreferredSize().height;
        int componentWidth = this.getPreferredSize().width;
        if (pY + componentHeight >= panel.getSize().height) {
            pY -= componentHeight;
        }
        if (pX + componentWidth >= panel.getSize().width) {
            pX -= componentWidth;
        }
        super.show(panel, pX, pY);
    }

    private void createZbKartePointHitMapPopupMenu(String propPopupMenuName) throws MissingResourceException {
        if (mapKeyString == null) {
            return;
        }
        String visibleKey = String.valueOf(mapKeyString.substring(0, 5)) + "-" + mapKeyString.substring(5, mapKeyString.length());
        String popupMenuName = String.valueOf(localProperty.getString(String.valueOf(propPopupMenuName) + "_Name")) + " " + visibleKey;
        PSEnvironment.printDebugMessage(" MapPopupMenu.createZbKartePointHitMapPopupMenu()", "localProperty.getString(" + propPopupMenuName + "_Name)=" + popupMenuName);
        this.setName(popupMenuName);
        JMenuItem itemPopMenu = new JMenuItem(popupMenuName);
        itemPopMenu.setFont(new Font("System", 1, 12));
        this.add(itemPopMenu);
        String blocksCountStr = localProperty.getString(String.valueOf(propPopupMenuName) + "_ItemBlockCount");
        PSEnvironment.printDebugMessage(" MapPopupMenu.createZbKartePointHitMapPopupMenu()", "localProperty.getString(" + propPopupMenuName + "_ItemBlockCount)=" + blocksCountStr);
        int blocksCount = PSEnvironment.getIntFromString(blocksCountStr);
        String itemBlockString = String.valueOf(propPopupMenuName) + "_ItemBlock";
        int l = 0;
        while (l < blocksCount) {
            this.addSeparator();
            String currItemBlockString = String.valueOf(itemBlockString) + l;
            String currItemBlockActionName = localProperty.getString(String.valueOf(currItemBlockString) + "_ActionName");
            PSEnvironment.printDebugMessage(" MapPopupMenu.createZbKartePointHitMapPopupMenu()", "localProperty.getString (" + currItemBlockString + "_ActionName)=" + currItemBlockActionName);
            String itemsCountStr = localProperty.getString(String.valueOf(currItemBlockString) + "_ItemCount");
            PSEnvironment.printDebugMessage(" MapPopupMenu.createZbKartePointHitMapPopupMenu()", "localProperty.getString (" + currItemBlockString + "_ItemCount)=" + itemsCountStr);
            int itemsCount = PSEnvironment.getIntFromString(itemsCountStr);
            String itemsString = String.valueOf(currItemBlockString) + "_Item";
            int i = 0;
            while (i < itemsCount) {
                String currItemString = String.valueOf(itemsString) + i;
                String itemText = localProperty.getString(String.valueOf(currItemString) + "_Text");
                PSEnvironment.printDebugMessage(" MapPopupMenu.createZbKartePointHitMapPopupMenu()", "localProperty.getString (" + currItemString + "_Text)=" + itemText);
                String itemActionCommand = localProperty.getString(String.valueOf(currItemString) + "_ActionCommand");
                PSEnvironment.printDebugMessage(" MapPopupMenu.createZbKartePointHitMapPopupMenu()", "localProperty.getString (" + currItemString + "_ActionCommand)=" + itemActionCommand);
                String itemActionName = "";
                try {
                    itemActionName = localProperty.getString(String.valueOf(currItemString) + "_ActionName");
                    PSEnvironment.printDebugMessage(" MapPopupMenu.createZbKartePointHitMapPopupMenu()", "localProperty.getString (" + currItemString + "_ActionName)=" + itemActionName);
                }
                catch (MissingResourceException mrEx) {
                    itemActionName = currItemBlockActionName;
                }
                JMenuItem mi = new JMenuItem(itemText);
                mi.setName(itemActionName);
                mi.setActionCommand(itemActionCommand);
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JMenuItem actionMenuItem = (JMenuItem)e.getSource();
                        String actionCommand = actionMenuItem.getActionCommand();
                        String actionName = actionMenuItem.getName();
                        MapPopupMenu.this.doZbKarteItemAction(mapKeyString, actionName, actionCommand);
                    }
                });
                this.add(mi);
                ++i;
            }
            ++l;
        }
        mapPopupMenuInstance = this;
    }

    private void createZbKarteAreaHitMapPopupMenu(String propPopupMenuName) {
        String popupMenuName = localProperty.getString(String.valueOf(propPopupMenuName) + "_No");
        if (psoInstance.getMapFlagsVector().size() > 0) {
            popupMenuName = localProperty.getString(String.valueOf(propPopupMenuName) + "_Name");
        }
        JMenuItem itemPopMenu = new JMenuItem(popupMenuName);
        itemPopMenu.setFont(new Font("System", 1, 12));
        this.add(itemPopMenu);
        if (psoInstance.getMapFlagsVector().size() > 0) {
            selIcon = new PSImageIcon(localProperty.getString(String.valueOf(propPopupMenuName) + "_ItemImage"));
            PSImageIcon prevIcon = new PSImageIcon(localProperty.getString(String.valueOf(propPopupMenuName) + "_ItemImagePrev"));
            PSImageIcon nextIcon = new PSImageIcon(localProperty.getString(String.valueOf(propPopupMenuName) + "_ItemImageNext"));
            this.addSeparator();
            ItemListener itemDisplayListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    mapPopupMenuInstance.setVisible(true);
                }
            };
            if (psoInstance.getMapFlagsVector().size() > MAX_MAPFLAGS) {
                itemPopMenu = new JMenuItem(localProperty.getString("ZbKarte_AreaHitMapPopupMenu_Item01_Text"), prevIcon);
                itemPopMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapPopupMenu.this.getnewFlags(2);
                    }
                });
                this.add(itemPopMenu);
            }
            int l = CURR_MAPFLAGS;
            while (l < CURR_MAPFLAGS + MAX_MAPFLAGS) {
                if (l < psoInstance.getMapFlagsVector().size()) {
                    String itemName = psoInstance.getMapFlagsVector().elementAt(l);
                    itemName = String.valueOf(itemName.substring(0, 5)) + "-" + itemName.substring(5, itemName.length());
                    JCheckBoxMenuItem checkItemPopMenu = new JCheckBoxMenuItem(itemName, selIcon, false);
                    checkItemPopMenu.addItemListener(itemDisplayListener);
                    this.add(checkItemPopMenu);
                }
                ++l;
            }
            if (psoInstance.getMapFlagsVector().size() > MAX_MAPFLAGS) {
                itemPopMenu = new JMenuItem(localProperty.getString("ZbKarte_AreaHitMapPopupMenu_Item02_Text"), nextIcon);
                itemPopMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapPopupMenu.this.getnewFlags(1);
                    }
                });
                this.add(itemPopMenu);
            }
            this.addSeparator();
            itemPopMenu = new JMenuItem(localProperty.getString(String.valueOf(propPopupMenuName) + "_Item1_Text"));
            itemPopMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int k = 0;
                    while (k < mapPopupMenuInstance.getComponentCount()) {
                        try {
                            JCheckBoxMenuItem currItem = (JCheckBoxMenuItem)mapPopupMenuInstance.getComponent(k);
                            if (currItem != null && currItem.isSelected()) {
                                String goStandort = currItem.getText().substring(0, 5);
                                break;
                            }
                        }
                        catch (ClassCastException classCastException) {
                            // empty catch block
                        }
                        ++k;
                    }
                }
            });
            this.add(itemPopMenu);
            this.addSeparator();
            itemPopMenu = new JMenuItem(localProperty.getString(String.valueOf(propPopupMenuName) + "_Item2_Text"));
            itemPopMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            this.add(itemPopMenu);
            this.addSeparator();
            itemPopMenu = new JMenuItem(localProperty.getString(String.valueOf(propPopupMenuName) + "_Item3_Text"));
            itemPopMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    psoInstance.getMapFlagsVector().removeAllElements();
                    MapPopupMenu.this.resetCurrFlags();
                    psoInstance.delFlag("DELETE_ALL");
                }
            });
            this.add(itemPopMenu);
        }
        mapPopupMenuInstance = this;
    }

    private void doZbKarteItemAction(String mapKeyString, String currActionName, String currActionCommand) {
        PSEnvironment.printDebugMessage(String.valueOf(this.getClass().getName()) + ".doZbKarteItemAction", "mapKeyString=" + mapKeyString + ", currActionName=" + currActionName + ", currActionCommand=" + currActionCommand);
        if (mapKeyString != null) {
            if (currActionName.equals("MAP_FLAG")) {
                boolean currActionStatus;
                boolean bl = currActionStatus = currActionCommand.equals("SET");
                if (currActionStatus) {
                    psoInstance.addMapFlag(mapKeyString);
                } else {
                    psoInstance.removeMapFlag(mapKeyString);
                    this.resetCurrFlags();
                }
            } else if (!currActionName.equals("RADIUS_SELECT")) {
                currActionName.equals("RADIUS_DESELECT");
            }
        }
    }

    private void resetCurrFlags() {
        if (psoInstance.getMapFlagsVector().size() == 0) {
            CURR_MAPFLAGS = 0;
        } else {
            if (CURR_MAPFLAGS > psoInstance.getMapFlagsVector().size() - 1) {
                CURR_MAPFLAGS -= MAX_MAPFLAGS;
            }
            if (CURR_MAPFLAGS < 0) {
                CURR_MAPFLAGS = 0;
            }
        }
    }

    private void removeCurrFlags() {
        Vector<JCheckBoxMenuItem> toRemove = new Vector<JCheckBoxMenuItem>();
        try {
            int k = 0;
            while (k < mapPopupMenuInstance.getComponentCount()) {
                try {
                    JCheckBoxMenuItem currItem = (JCheckBoxMenuItem)mapPopupMenuInstance.getComponent(k);
                    if (currItem != null) {
                        toRemove.addElement(currItem);
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                ++k;
            }
            k = 0;
            while (k < toRemove.size()) {
                mapPopupMenuInstance.remove((JCheckBoxMenuItem)toRemove.elementAt(k));
                ++k;
            }
        }
        catch (Exception ex) {
            PSEnvironment.printExceptionMessage(ex);
        }
    }

    private void getnewFlags(int Direction) {
        int count = 0;
        ItemListener itemDisplayListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                mapPopupMenuInstance.setVisible(true);
            }
        };
        try {
            block1 : switch (Direction) {
                case 1: {
                    if (CURR_MAPFLAGS + MAX_MAPFLAGS > psoInstance.getMapFlagsVector().size() - 1) break;
                    this.removeCurrFlags();
                    int l = CURR_MAPFLAGS + MAX_MAPFLAGS;
                    while (l < psoInstance.getMapFlagsVector().size()) {
                        String itemName = psoInstance.getMapFlagsVector().elementAt(l);
                        itemName = String.valueOf(itemName.substring(0, 5)) + "-" + itemName.substring(5, itemName.length());
                        JCheckBoxMenuItem checkItemPopMenu = new JCheckBoxMenuItem(itemName, selIcon, false);
                        checkItemPopMenu.addItemListener(itemDisplayListener);
                        mapPopupMenuInstance.insert(checkItemPopMenu, count + 3);
                        if (count == 0) {
                            CURR_MAPFLAGS = l;
                        }
                        if (++count == MAX_MAPFLAGS) break block1;
                        ++l;
                    }
                    break;
                }
                case 2: {
                    if (CURR_MAPFLAGS <= 0) break;
                    this.removeCurrFlags();
                    Vector<JCheckBoxMenuItem> toAdd = new Vector<JCheckBoxMenuItem>();
                    int l = CURR_MAPFLAGS - 1;
                    while (l >= 0) {
                        String itemName = psoInstance.getMapFlagsVector().elementAt(l);
                        itemName = String.valueOf(itemName.substring(0, 5)) + "-" + itemName.substring(5, itemName.length());
                        JCheckBoxMenuItem checkItemPopMenu = new JCheckBoxMenuItem(itemName, selIcon, false);
                        checkItemPopMenu.addItemListener(itemDisplayListener);
                        toAdd.addElement(checkItemPopMenu);
                        CURR_MAPFLAGS = l--;
                        if (++count == MAX_MAPFLAGS) break;
                    }
                    count = 0;
                    int k = toAdd.size() - 1;
                    while (k >= 0) {
                        mapPopupMenuInstance.insert((JCheckBoxMenuItem)toAdd.elementAt(k), count + 3);
                        ++count;
                        --k;
                    }
                    toAdd.removeAllElements();
                    toAdd = null;
                }
            }
            mapPopupMenuInstance.setVisible(true);
        }
        catch (Exception ex) {
            PSEnvironment.printExceptionMessage(ex);
        }
    }
}

