/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import de.codesolutions.pam.map.MapPartialSelectionObj;
import de.codesolutions.pam.map.MapPartialSelectionStore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableCellRenderer;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.base.PSJTable;
import prospektservice.datamodels.TableModelDetails;

public class frmDetails
extends JDialog {
    private static final long serialVersionUID = 3257566213352862770L;
    private static frmDetails instance = null;
    private static final int WIDTH = 260;
    private static final int HEIGHT = 248;
    private FontMetrics fm;
    private PSO pso;
    private JPanel titlePanel;
    private JPanel detailPanel;
    private JPanel buttonPanel;
    private JLabel lblTitle;
    private PSJTable detailTable;
    private static ResourceBundle localProperty;
    private static String detailsName;
    private static String propUntertitelPrefix;
    private static String propUntertitel;
    private static String textInitLabel;
    private String plz = "";
    private int[] otIDs;

    static {
        detailsName = "";
        propUntertitelPrefix = "Untertitel_";
        propUntertitel = "";
        textInitLabel = "...";
    }

    public static frmDetails getInstance(PSO mainpanel, JFrame mainform, String detailsType) {
        if (instance != null) {
            if (detailsName != detailsType) {
                propUntertitel = localProperty.getString(String.valueOf(propUntertitelPrefix) + detailsType.trim());
            }
        } else {
            instance = new frmDetails(mainpanel, mainform, detailsType);
        }
        if (!detailsType.equalsIgnoreCase("PLZ")) {
            mainpanel.setZielwahlSelectionMode(false);
        }
        return instance;
    }

    private frmDetails(PSO mainpanel, JFrame mainform, String detailsName) {
        super(mainform, "", false);
        frmDetails.detailsName = detailsName;
        this.pso = mainpanel;
        this.setDefaultCloseOperation(2);
        this.fm = this.getFontMetrics(PSEnvironment.Arial10Table);
        localProperty = ResourceBundle.getBundle("properties.frmDetails", PSUser.getLanguage());
        propUntertitel = localProperty.getString(String.valueOf(propUntertitelPrefix) + detailsName.trim());
        textInitLabel = localProperty.getString("InitDetails");
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle(localProperty.getString("Title"));
        this.setSize(260, 248);
        this.setFont(PSEnvironment.Arial10Table);
        this.setResizable(false);
        this.setLocationRelativeTo(mainform);
        this.titlePanel = new JPanel(new BorderLayout());
        this.titlePanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.lblTitle = new JLabel(propUntertitel);
        this.lblTitle.setFont(PSEnvironment.Arial10Table);
        this.lblTitle.setAlignmentX(0.5f);
        this.titlePanel.add((Component)this.lblTitle, "Center");
        this.detailPanel = new JPanel(new BorderLayout());
        JLabel lblInit = new JLabel(textInitLabel);
        lblInit.setAlignmentX(0.5f);
        this.detailPanel.add((Component)lblInit, "Center");
        this.buttonPanel = new JPanel(new FlowLayout(1));
        JButton closeButton = new JButton(localProperty.getString("CloseButton"));
        if (!detailsName.equals("PLZ")) {
            this.buttonPanel.add(closeButton);
        }
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frmDetails.this.closeFrame();
            }
        });
        if (detailsName.equals("PLZ")) {
            JButton selButton = new JButton(localProperty.getString("selButton"));
            selButton.setToolTipText(localProperty.getString("TTSelect"));
            this.buttonPanel.add(selButton);
            selButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] selRows = frmDetails.this.detailTable.getSelectedRows();
                    if (selRows.length > 0 && selRows.length < frmDetails.this.detailTable.getRowCount()) {
                        Vector<String> v = new Vector<String>();
                        int i = 0;
                        while (i < selRows.length) {
                            v.addElement("" + frmDetails.this.otIDs[selRows[i]]);
                            ++i;
                        }
                        double percent = (double)selRows.length / (double)frmDetails.this.detailTable.getRowCount() * 100.0;
                        MapPartialSelectionObj mpsObj = MapPartialSelectionStore.getObj(frmDetails.this.plz);
                        if (mpsObj == null) {
                            mpsObj = new MapPartialSelectionObj(frmDetails.this.plz, MapPartialSelectionStore.getCount() - 1, percent);
                            MapPartialSelectionStore.addObject(frmDetails.this.plz, mpsObj);
                            mpsObj.setOrtsteileCount(frmDetails.this.detailTable.getRowCount());
                        }
                        frmDetails.this.pso.setKarteSelectionChanged(true);
                        mpsObj.setSelection(v);
                        mpsObj.updatePercent(percent);
                        frmDetails.this.pso.getWmp().selectPartialArea(frmDetails.this.plz, selRows.length, frmDetails.this.detailTable.getRowCount());
                    } else {
                        MapPartialSelectionObj mpsObj = MapPartialSelectionStore.getObj(frmDetails.this.plz);
                        if (mpsObj != null) {
                            MapPartialSelectionStore.removeObject(frmDetails.this.plz);
                            mpsObj.removePartialSelectionObj();
                            frmDetails.this.pso.setKarteSelectionChanged(true);
                        }
                        if (selRows.length == frmDetails.this.detailTable.getRowCount()) {
                            frmDetails.this.pso.getWmp().selectArea(frmDetails.this.plz);
                            frmDetails.this.pso.setKarteSelectionChanged(true);
                        }
                    }
                }
            });
            JButton deselButton = new JButton(localProperty.getString("deselButton"));
            deselButton.setToolTipText(localProperty.getString("TTDeselect"));
            this.buttonPanel.add(deselButton);
            deselButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapPartialSelectionObj mpsObj = MapPartialSelectionStore.getObj(frmDetails.this.plz);
                    if (mpsObj != null) {
                        MapPartialSelectionStore.removeObject(frmDetails.this.plz);
                        mpsObj.removePartialSelectionObj();
                    }
                    frmDetails.this.pso.getWmp().deselectArea(frmDetails.this.plz);
                    frmDetails.this.pso.setKarteSelectionChanged(true);
                    frmDetails.this.detailTable.clearSelection();
                }
            });
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frmDetails.this.closeFrame();
            }
        });
        this.getContentPane().add((Component)this.titlePanel, "North");
        this.getContentPane().add((Component)this.detailPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setVisible(false);
        instance = this;
    }

    public static boolean istInstanziert() {
        return instance != null;
    }

    public void setUntertitel(String unterTitleLabel) {
        this.lblTitle.setText(String.valueOf(propUntertitel) + " " + unterTitleLabel);
        if (detailsName.equals("PLZ")) {
            this.plz = unterTitleLabel;
        }
        this.detailPanel.removeAll();
        JLabel lblInit = new JLabel(textInitLabel);
        lblInit.setAlignmentX(0.5f);
        this.detailPanel.add((Component)lblInit, "Center");
        this.validate();
        this.repaint();
    }

    public void changeDetails(TableModelDetails newTableModel) {
        this.detailPanel.removeAll();
        this.detailTable = new PSJTable();
        this.detailTable.setModel(newTableModel);
        if (detailsName.equalsIgnoreCase("PLZ")) {
            this.otIDs = new int[newTableModel.getRowCount()];
            int i = 0;
            while (i < this.otIDs.length) {
                this.otIDs[i] = PSEnvironment.getIntValue(newTableModel.getValueAt(i, 4).toString());
                ++i;
            }
            MapPartialSelectionObj mpsObj = MapPartialSelectionStore.getObj(this.plz);
            if (mpsObj != null) {
                int i2;
                Vector<String> v = mpsObj.getSelection();
                if (v.size() == 0 || mpsObj.isNeedUpdate()) {
                    i2 = 0;
                    while (i2 < newTableModel.getRowCount()) {
                        int id = PSEnvironment.getIntValue(newTableModel.getValueAt(i2, 4).toString());
                        int selID = PSEnvironment.getIntValue(newTableModel.getValueAt(i2, 5).toString());
                        int aid = PSEnvironment.getIntValue(newTableModel.getValueAt(i2, 6).toString());
                        if (id == selID && aid == 1) {
                            v.addElement("" + id);
                            this.detailTable.addRowSelectionInterval(i2, i2);
                        }
                        ++i2;
                    }
                } else {
                    i2 = 0;
                    while (i2 < this.otIDs.length) {
                        int j = 0;
                        while (j < v.size()) {
                            int id = PSEnvironment.getIntValue(v.elementAt(j).toString());
                            if (id == this.otIDs[i2]) {
                                this.detailTable.addRowSelectionInterval(i2, i2);
                                break;
                            }
                            ++j;
                        }
                        ++i2;
                    }
                }
            } else {
                this.pso.getWmp().isAreaSelected(this.plz);
            }
        }
        DefaultTableCellRenderer[] tableCellRenderer = newTableModel.getTableCellRenderer();
        int i = 0;
        while (i < tableCellRenderer.length) {
            this.detailTable.getColumnModel().getColumn(i).setCellRenderer(tableCellRenderer[i]);
            ++i;
        }
        this.detailTable.setAutoResizeMode(2);
        JScrollPane scrollpaneDetailTable = new JScrollPane(this.detailTable);
        this.detailPanel.add((Component)scrollpaneDetailTable, "Center");
        this.validate();
        this.repaint();
    }

    public void currentAreaSelected(boolean selected) {
        if (selected) {
            this.detailTable.setRowSelectionInterval(0, this.detailTable.getRowCount() - 1);
        }
    }

    private void closeFrame() {
        if (!this.pso.Info_On) {
            this.pso.setZielwahlSelectionMode(true);
        }
        instance = null;
        detailsName = "";
        this.dispose();
    }

    private double calcPercent() {
        double result = 0.0;
        try {
            long totalHH = 0L;
            long selectedHH = 0L;
            int i = 0;
            while (i < this.detailTable.getRowCount()) {
                String hhEntry = this.detailTable.getValueAt(i, 2).toString();
                int pos = hhEntry.indexOf(".");
                if (pos > -1) {
                    hhEntry = String.valueOf(hhEntry.substring(0, pos)) + hhEntry.substring(++pos);
                }
                long hhAdd = Long.parseLong(hhEntry);
                totalHH += hhAdd;
                if (this.detailTable.isRowSelected(i)) {
                    selectedHH += hhAdd;
                }
                ++i;
            }
            result = (double)selectedHH / (double)totalHH * 100.0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public String getPlz() {
        return this.plz;
    }
}

