/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import prospektservice.PSAuftrag;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.base.PSImageIcon;
import prospektservice.base.PSJCheckBox;
import prospektservice.base.PamDialog;

public class DlgStartupOptions
extends PamDialog {
    private static final long serialVersionUID = 3257569516132118581L;
    private static final int WIDTH = 390;
    private static final int HEIGHT = 200;
    private JPanel btnPanel;
    private JLabel lblNewJob;
    private JButton btnNewJob;
    private JLabel lblLastJob;
    private JButton btnLastJob;
    private JLabel lblOpenJob;
    private JButton btnOpenJob;
    private JLabel lblWizard;
    private JButton btnWizard;
    private JLabel lblHint;
    private PSJCheckBox chkShowStartupOptions;
    private PSO pso;
    private String lastAid = "";
    private String lastJobName = "";
    private int numTA = 0;
    private String[] taIDs;
    private ResourceBundle localProperty = ResourceBundle.getBundle("properties.DlgStartupOptions", PSUser.getLanguage());

    public DlgStartupOptions(Frame frame) throws HeadlessException {
        super(frame);
        this.pso = (PSO)frame;
        this.setTitle(this.localProperty.getString("Title"));
        this.setResizable(false);
        this.setSize(390, 200);
        this.setModal(true);
        this.setLocationRelativeTo(this.pso);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DlgStartupOptions.this.pso.setExtendedState(6);
                DlgStartupOptions.this.pso.setVisible(true);
            }
        });
        this.btnPanel = new JPanel();
        this.btnPanel.setLayout(null);
        this.btnPanel.setBounds(0, 0, 390, 200);
        this.lblNewJob = new JLabel(this.localProperty.getString("lblNewJob"));
        this.lblNewJob.setHorizontalAlignment(0);
        this.lblNewJob.setBounds(12, 10, 80, 20);
        this.btnPanel.add(this.lblNewJob);
        this.btnNewJob = new JButton();
        this.btnNewJob.setIcon(new PSImageIcon("./images/neu_big_nor.gif"));
        this.btnNewJob.setRolloverIcon(new PSImageIcon("./images/neu_big_akt.gif"));
        this.btnNewJob.setBorder(BorderFactory.createEmptyBorder());
        this.btnNewJob.setBounds(15, 40, 73, 68);
        this.btnNewJob.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgStartupOptions.this.dispose();
                DlgStartupOptions.this.pso.setExtendedState(6);
                DlgStartupOptions.this.pso.setVisible(true);
            }
        });
        this.btnNewJob.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                DlgStartupOptions.this.lblHint.setText(DlgStartupOptions.this.localProperty.getString("newJobHint"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DlgStartupOptions.this.lblHint.setText("");
            }
        });
        this.btnPanel.add(this.btnNewJob);
        this.lblLastJob = new JLabel(this.localProperty.getString("lblLastJob"));
        this.lblLastJob.setHorizontalAlignment(0);
        this.lblLastJob.setBounds(103, 10, 80, 20);
        this.btnPanel.add(this.lblLastJob);
        this.btnLastJob = new JButton();
        this.btnLastJob.setIcon(new PSImageIcon("./images/lastjob_big_nor.gif"));
        this.btnLastJob.setRolloverIcon(new PSImageIcon("./images/lastjob_big_akt.gif"));
        this.btnLastJob.setBorder(BorderFactory.createEmptyBorder());
        this.btnLastJob.setBounds(105, 40, 73, 68);
        this.btnLastJob.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgStartupOptions.this.dispose();
                DlgStartupOptions.this.pso.setExtendedState(6);
                DlgStartupOptions.this.pso.setVisible(true);
                if (DlgStartupOptions.this.lastJobName.length() > 0) {
                    PSO.cc.SendMessage(64, DlgStartupOptions.this.lastAid);
                    PSAuftrag.setCurrentJobID(DlgStartupOptions.this.lastAid);
                    if (DlgStartupOptions.this.numTA > 0) {
                        PSAuftrag.setNumTAs(DlgStartupOptions.this.numTA);
                        PSAuftrag.setTAIDs(DlgStartupOptions.this.taIDs);
                    }
                    DlgStartupOptions.this.pso.setActuellFilename(DlgStartupOptions.this.lastJobName);
                }
            }
        });
        this.btnLastJob.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                DlgStartupOptions.this.lblHint.setText(String.valueOf(DlgStartupOptions.this.localProperty.getString("lastJobHint")) + " (" + DlgStartupOptions.this.lastJobName + ")");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DlgStartupOptions.this.lblHint.setText("");
            }
        });
        this.btnPanel.add(this.btnLastJob);
        this.lblOpenJob = new JLabel(this.localProperty.getString("lblOpenJob"));
        this.lblOpenJob.setBounds(192, 10, 80, 20);
        this.lblOpenJob.setHorizontalAlignment(0);
        this.btnPanel.add(this.lblOpenJob);
        this.btnOpenJob = new JButton();
        this.btnOpenJob.setIcon(new PSImageIcon("./images/load_big_nor.gif"));
        this.btnOpenJob.setRolloverIcon(new PSImageIcon("./images/load_big_akt.gif"));
        this.btnOpenJob.setBorder(BorderFactory.createEmptyBorder());
        this.btnOpenJob.setBounds(195, 40, 73, 68);
        this.btnOpenJob.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgStartupOptions.this.dispose();
                DlgStartupOptions.this.pso.setExtendedState(6);
                DlgStartupOptions.this.pso.setVisible(true);
                DlgStartupOptions.this.pso.showAuftragsManager(0);
            }
        });
        this.btnOpenJob.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                DlgStartupOptions.this.lblHint.setText(DlgStartupOptions.this.localProperty.getString("openJobHint"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DlgStartupOptions.this.lblHint.setText("");
            }
        });
        this.btnPanel.add(this.btnOpenJob);
        this.lblWizard = new JLabel(this.localProperty.getString("lblWizard"));
        this.lblWizard.setBounds(277, 10, 90, 20);
        this.lblWizard.setHorizontalAlignment(0);
        this.btnPanel.add(this.lblWizard);
        this.btnWizard = new JButton();
        this.btnWizard.setIcon(new PSImageIcon("./images/wizard_big_nor.gif"));
        this.btnWizard.setRolloverIcon(new PSImageIcon("./images/wizard_big_akt.gif"));
        this.btnWizard.setBorder(BorderFactory.createEmptyBorder());
        this.btnWizard.setBounds(285, 40, 73, 68);
        this.btnWizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgStartupOptions.this.dispose();
                DlgStartupOptions.this.pso.showPSOWizard();
            }
        });
        this.btnWizard.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                DlgStartupOptions.this.lblHint.setText(DlgStartupOptions.this.localProperty.getString("wizardHint"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DlgStartupOptions.this.lblHint.setText("");
            }
        });
        this.btnPanel.add(this.btnWizard);
        this.lblHint = new JLabel("");
        this.lblHint.setBounds(50, 120, 330, 20);
        this.lblHint.setHorizontalAlignment(0);
        this.btnPanel.add(this.lblHint);
        this.chkShowStartupOptions = new PSJCheckBox(this.localProperty.getString("chkShowStartupOptions"));
        String selected = PSEnvironment.getPSClientProperty("PS.ShowStartupDlg", "1");
        this.chkShowStartupOptions.setSelected(selected.equals("1"));
        this.chkShowStartupOptions.setBounds(10, 140, 200, 25);
        this.chkShowStartupOptions.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean flag = e.getStateChange() == 1;
                PSEnvironment.setPSClientProperty("PS.ShowStartupDlg", flag ? "1" : "0");
            }
        });
        this.btnPanel.add(this.chkShowStartupOptions);
        this.getContentPane().add(this.btnPanel);
        PSO.cc.SendMessage(337, "");
    }

    public void setLastJobProperties(String data) {
        try {
            StringTokenizer t = new StringTokenizer(data, "|");
            this.numTA = t.countTokens() - 2;
            if (t.hasMoreTokens()) {
                this.lastAid = t.nextToken().trim();
            }
            if (t.hasMoreTokens()) {
                this.lastJobName = t.nextToken().trim();
            }
            if (this.numTA > 0) {
                this.taIDs = new String[this.numTA];
                int i = 0;
                while (t.hasMoreTokens()) {
                    this.taIDs[i++] = t.nextToken().trim();
                }
            }
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

