/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base.pwstrength;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import prospektservice.base.pwstrength.TStrengthIndicator;

public class StrengthIndicatorUI
extends ComponentUI {
    private static StrengthIndicatorUI instance = null;

    public static ComponentUI createUI(JComponent component) {
        if (component instanceof TStrengthIndicator) {
            return StrengthIndicatorUI.getInstance();
        }
        throw new Error("StrengthIndicatorUI.createUI supports TStrengthIndicator only");
    }

    private static synchronized StrengthIndicatorUI getInstance() {
        if (instance == null) {
            instance = new StrengthIndicatorUI();
        }
        return instance;
    }

    private StrengthIndicatorUI() {
    }

    @Override
    public void installUI(JComponent c) {
        if (c instanceof TStrengthIndicator) {
            super.installUI(c);
            this.installColorsAndBorders(c);
            this.installHandlers((TStrengthIndicator)c);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (c instanceof TStrengthIndicator) {
            TStrengthIndicator tsi = (TStrengthIndicator)c;
            Insets margin = c.getInsets();
            margin.top += 2;
            margin.left += 2;
            margin.bottom += 2;
            margin.right += 2;
            int innerWidth = c.getWidth() - margin.left - margin.right;
            int innerHeight = c.getHeight() - margin.top - margin.bottom;
            int minimumValue = tsi.getMinimumValue();
            int maximumValue = tsi.getMaximumValue();
            int value = tsi.getValue();
            int range = maximumValue - minimumValue;
            int valueOffset = (int)((float)innerWidth / (float)range * (float)value);
            g.setColor(this.getColorFromColorRamp((float)(value - minimumValue) / (float)range));
            g.fillRect(margin.left, margin.top, valueOffset, innerHeight);
            String text = null;
            text = tsi.getText();
            if (text != null) {
                g.setFont(c.getFont());
                g.setColor(c.getForeground());
                FontMetrics fontMetrics = g.getFontMetrics();
                Rectangle2D stringBounds = fontMetrics.getStringBounds(text, g);
                g.drawString(text, (int)(((double)innerWidth - stringBounds.getWidth()) / 2.0 - stringBounds.getX()), (int)(((double)innerHeight - stringBounds.getHeight()) / 2.0 - stringBounds.getY() + 4.0));
            }
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (c instanceof TStrengthIndicator) {
            this.uninstallHandlers((TStrengthIndicator)c);
            this.uninstallColorsAndBorders(c);
            super.uninstallUI(c);
        }
    }

    private Color getColorFromColorRamp(float ratio) {
        if (ratio <= 0.5f) {
            return new Color(1.0f, ratio + ratio, 0.0f);
        }
        return new Color(2.0f - ratio - ratio, 1.0f, 0.0f);
    }

    protected void installColorsAndBorders(JComponent component) {
        LookAndFeel.installColorsAndFont(component, "control", "controlText", "defaultFont");
        Border b = component.getBorder();
        if (b == null || b instanceof UIResource) {
            component.setBorder(new BorderUIResource(BorderFactory.createBevelBorder(1)));
        }
    }

    protected void installHandlers(TStrengthIndicator component) {
    }

    protected void uninstallColorsAndBorders(JComponent component) {
        LookAndFeel.uninstallBorder(component);
    }

    protected void uninstallHandlers(TStrengthIndicator component) {
    }
}

