/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import prospektservice.PSEnvironment;
import prospektservice.base.PSImageIcon;

public class JSplitButton
extends JButton {
    private static final long serialVersionUID = 3258688806134821169L;
    private JPopupMenu popupMenu;
    private int splitPosHorizontal = 0;
    private boolean mouseOver = false;

    public JSplitButton(String text, PSImageIcon icon) {
        super(text, icon);
        this.setFocusPainted(false);
    }

    private void drawArrow(Graphics g) {
        int height = this.getHeight();
        if (this.mouseOver && !PSEnvironment.isMacOSPlatform()) {
            Insets ins = this.getBorder().getBorderInsets(this);
            ColorUIResource c = (ColorUIResource)UIManager.getLookAndFeel().getDefaults().get("Button.background");
            c.darker();
            g.setColor(c);
            g.drawLine(this.splitPosHorizontal, ins.top, this.splitPosHorizontal, height - ins.bottom);
            g.setColor(Color.white);
            g.drawLine(this.splitPosHorizontal + 1, ins.top, this.splitPosHorizontal + 1, ins.top);
        }
        g.setColor(Color.black);
        g.drawLine(this.splitPosHorizontal + 5, height / 2 - 1, this.splitPosHorizontal + 9, height / 2 - 1);
        g.drawLine(this.splitPosHorizontal + 6, height / 2, this.splitPosHorizontal + 8, height / 2);
        g.drawLine(this.splitPosHorizontal + 7, height / 2 + 1, this.splitPosHorizontal + 7, height / 2 + 1);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (this.popupMenu != null) {
            int id = e.getID();
            switch (id) {
                case 504: {
                    this.mouseOver = true;
                    break;
                }
                case 501: {
                    if (!this.isEnabled() || e.getPoint().x < this.splitPosHorizontal) break;
                    this.popupMenu.show(this, 0, this.getHeight());
                    e.consume();
                    break;
                }
                case 500: {
                    if (!this.isEnabled() || e.getPoint().x < this.splitPosHorizontal) break;
                    e.consume();
                    break;
                }
                case 502: {
                    if (this.isEnabled() && e.getPoint().x >= this.splitPosHorizontal) {
                        e.consume();
                    }
                }
                case 505: {
                    this.mouseOver = false;
                }
            }
        }
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        if (this.popupMenu == null) {
            super.fireActionPerformed(event);
        } else if (!this.popupMenu.isShowing()) {
            super.fireActionPerformed(event);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.popupMenu != null) {
            this.drawArrow(g);
        }
    }

    public void setMenu(Vector<JMenuItem> items) {
        if (items == null) {
            if (this.popupMenu != null) {
                this.popupMenu.removeAll();
                this.popupMenu = null;
            }
        } else {
            this.popupMenu = new JPopupMenu();
            int i = 0;
            while (i < items.size()) {
                this.popupMenu.add(items.elementAt(i));
                ++i;
            }
        }
    }

    public void setMenu(String[] menuItems, String[] menuActions, int type) {
        this.popupMenu = new JPopupMenu();
        switch (type) {
            case 0: {
                int i = 0;
                while (i < menuItems.length) {
                    JMenuItem mi = new JMenuItem(menuItems[i]);
                    mi.setActionCommand(menuActions[i]);
                    this.popupMenu.add(mi);
                    ++i;
                }
                break;
            }
            case 1: {
                ButtonGroup bg = new ButtonGroup();
                int i = 0;
                while (i < menuItems.length) {
                    JRadioButtonMenuItem mi = new JRadioButtonMenuItem(menuItems[i]);
                    mi.setActionCommand(menuActions[i]);
                    bg.add(mi);
                    this.popupMenu.add(mi);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < menuItems.length) {
                    JCheckBoxMenuItem mi = new JCheckBoxMenuItem(menuItems[i]);
                    mi.setActionCommand(menuActions[i]);
                    this.popupMenu.add(mi);
                    ++i;
                }
                break;
            }
        }
    }

    @Override
    public void setPreferredSize(Dimension d) {
        super.setPreferredSize(d);
        this.splitPosHorizontal = d.width - 14;
    }

    public void setMenuItemListener(ActionListener al) {
        int i = 0;
        while (i < this.popupMenu.getComponentCount()) {
            JMenuItem mi = (JMenuItem)this.popupMenu.getComponent(i);
            if (mi instanceof JMenu) {
                JMenu sub1 = (JMenu)mi;
                int j = 0;
                while (j < sub1.getMenuComponentCount()) {
                    JMenuItem mi2 = (JMenuItem)sub1.getMenuComponent(j);
                    if (mi2 instanceof JMenu) {
                        JMenu sub2 = (JMenu)mi2;
                        int t = 0;
                        while (t < sub2.getMenuComponentCount()) {
                            JMenuItem mi3 = (JMenuItem)sub2.getMenuComponent(t);
                            if (!(mi3 instanceof JMenu)) {
                                mi3.addActionListener(al);
                            }
                            ++t;
                        }
                    } else {
                        mi2.addActionListener(al);
                    }
                    ++j;
                }
            } else {
                mi.addActionListener(al);
            }
            ++i;
        }
    }
}

