/*
 * Decompiled with CFR 0.152.
 */
package prospektservice;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import prospektservice.PSEnvironment;

public class PsoXmlBuilder {
    private Document xmlDoc;
    private Element rootElement;
    public static final String PSO_CLIENT_REQUEST = "psodialog";
    public static final String ATTR_ACTION_NAME = "action";
    public static final String ATTR_ACTION_INDEX = "actionindex";
    public static final String ATTR_ACTION_TYPE = "actiontype";
    public static final String ATTR_ACTION_DATA = "actiondaten";
    public static final String ATTR_DATA_CODED = "datencoded";
    public static final String ATTR_CURR_ROW = "currentrow";
    public static final String ATTR_FETCH_SIZE = "fetchsize";
    public static final String ATTR_RESPONSE = "response";
    public static final String ATTR_REQUEST_AUTH = "auth";
    String attr_action_value;
    String attr_actionindex_value;
    String attr_actiontype_value;
    String attr_actiondaten_value;
    String attr_datencoded_value;
    String attr_currentRow_value;
    String attr_fetch_value;
    String attr_response_value;
    String attr_request_auth;

    public PsoXmlBuilder() {
        block2: {
            this.xmlDoc = null;
            this.rootElement = null;
            try {
                this.attr_action_value = "";
                this.attr_actionindex_value = "0";
                this.attr_actiontype_value = "INIT";
                this.attr_actiondaten_value = "";
                this.attr_datencoded_value = "false";
                this.attr_currentRow_value = "1";
                this.attr_fetch_value = "20";
                this.attr_response_value = "1001";
                this.attr_request_auth = "";
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = docFactory.newDocumentBuilder();
                this.xmlDoc = builder.newDocument();
                this.rootElement = this.xmlDoc.createElement(PSO_CLIENT_REQUEST);
                this.xmlDoc.appendChild(this.rootElement);
            }
            catch (Exception e) {
                if (!PSEnvironment.DEBUG) break block2;
                System.out.println(e);
            }
        }
    }

    public PsoXmlBuilder(Document doc) {
        this.xmlDoc = null;
        this.rootElement = null;
        this.xmlDoc = doc;
    }

    public void setXmlDoc(Document doc) throws Exception {
        if (PSEnvironment.DEBUG) {
            System.out.println("assigning new doc...");
        }
        this.xmlDoc = doc;
    }

    public String createXmlDoc() throws Exception {
        String result = "";
        OutputFormat format = new OutputFormat(this.xmlDoc, "iso-8859-1", true);
        StringWriter stringOut = new StringWriter();
        XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
        serial.asDOMSerializer();
        serial.serialize(this.xmlDoc);
        result = stringOut.toString();
        return result;
    }

    public Document getXmlDoc() throws Exception {
        OutputFormat format = new OutputFormat(this.xmlDoc, "iso-8859-1", true);
        StringWriter stringOut = new StringWriter();
        XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
        serial.asDOMSerializer();
        serial.serialize(this.xmlDoc);
        return this.xmlDoc;
    }

    public void setAction(int actionID) {
        Attr attribute = null;
        this.attr_action_value = "" + actionID;
        attribute = this.xmlDoc.createAttribute(ATTR_ACTION_NAME);
        attribute.setValue(this.attr_action_value);
        this.rootElement.setAttributeNode(attribute);
    }

    public void setActionIndex(int actionIndex) {
        Attr attribute = null;
        this.attr_actionindex_value = "" + actionIndex;
        attribute = this.xmlDoc.createAttribute(ATTR_ACTION_INDEX);
        attribute.setValue(this.attr_actionindex_value);
        this.rootElement.setAttributeNode(attribute);
    }

    public void setActionType(String actionType) {
        Attr attribute = null;
        this.attr_actiontype_value = actionType;
        attribute = this.xmlDoc.createAttribute(ATTR_ACTION_TYPE);
        attribute.setValue(this.attr_actiontype_value);
        this.rootElement.setAttributeNode(attribute);
    }

    public void setVariableAttribute(String varAtributeName, String varAtributeValue) {
        Attr attribute = null;
        attribute = this.xmlDoc.createAttribute(varAtributeName);
        attribute.setValue(varAtributeValue);
        this.rootElement.setAttributeNode(attribute);
    }

    public void removeVariableAttribute(String attributeName) {
        Element ourElement = this.xmlDoc.getDocumentElement();
        ourElement.removeAttribute(attributeName);
    }

    public void setActionDaten(String actionData) {
        this.attr_actiondaten_value = actionData.trim();
        CDATASection actionDaten = this.xmlDoc.createCDATASection(ATTR_ACTION_DATA);
        actionDaten.setData(this.attr_actiondaten_value);
        this.rootElement.appendChild(actionDaten);
    }

    public void setResponse(int response) {
        Attr attribute = null;
        this.attr_response_value = "" + response;
        attribute = this.xmlDoc.createAttribute(ATTR_RESPONSE);
        attribute.setValue(this.attr_response_value);
        this.rootElement.setAttributeNode(attribute);
    }

    public void setDatenCoded(boolean isDatenCoded) {
        Attr attribute = null;
        this.attr_datencoded_value = new Boolean(isDatenCoded).toString();
        attribute = this.xmlDoc.createAttribute(ATTR_DATA_CODED);
        attribute.setValue(this.attr_datencoded_value);
        this.rootElement.setAttributeNode(attribute);
    }

    public void setCurrentRow(int currentRow) {
        Attr attribute = null;
        this.attr_currentRow_value = "" + currentRow;
        attribute = this.xmlDoc.createAttribute(ATTR_CURR_ROW);
        attribute.setValue(this.attr_currentRow_value);
        this.rootElement.setAttributeNode(attribute);
    }

    public void setFetchSize(int fetchSize) {
        Attr attribute = null;
        this.attr_fetch_value = "" + fetchSize;
        attribute = this.xmlDoc.createAttribute(ATTR_FETCH_SIZE);
        attribute.setValue(this.attr_fetch_value);
        this.rootElement.setAttributeNode(attribute);
    }

    public int getAction() {
        int actionID = 0;
        String attrValue = "";
        attrValue = this.getRootAttributeValue(ATTR_ACTION_NAME);
        if (attrValue != null && !attrValue.equals("")) {
            actionID = PSEnvironment.getIntValue(attrValue);
        }
        return actionID;
    }

    public int getActionIndex() {
        int actionIndex = 0;
        String attrValue = "";
        attrValue = this.getRootAttributeValue(ATTR_ACTION_INDEX);
        if (attrValue != null && !attrValue.equals("")) {
            actionIndex = PSEnvironment.getIntValue(attrValue);
        }
        return actionIndex;
    }

    public String getActionName() {
        return this.attr_action_value;
    }

    public String getActionType() {
        return this.getRootAttributeValue(ATTR_ACTION_TYPE);
    }

    public String getActionDaten() {
        String result = "";
        Element rootElement = this.xmlDoc.getDocumentElement();
        Node dataNode = rootElement.getFirstChild();
        if (dataNode != null) {
            result = dataNode.getNodeValue().trim();
            return result;
        }
        return "";
    }

    public Document getDatenAsDoc() {
        String result = "";
        Element rootElement = this.xmlDoc.getDocumentElement();
        Node dataNode = rootElement.getFirstChild();
        if (dataNode != null) {
            result = dataNode.getNodeValue().trim();
            Document doc = null;
            try {
                DOMParser parser = new DOMParser();
                parser.parse(new InputSource(new StringReader(result)));
                doc = parser.getDocument();
            }
            catch (Exception Ex) {
                if (PSEnvironment.DEBUG) {
                    System.out.println(" PsoXmlBuilder::getDatenAsDoc() ->" + Ex.getMessage());
                }
                return null;
            }
            return doc;
        }
        return null;
    }

    public int getResponse() {
        int response = 0;
        String attrValue = "";
        attrValue = this.getRootAttributeValue(ATTR_RESPONSE);
        if (attrValue != null && !attrValue.equals("")) {
            response = PSEnvironment.getIntValue(attrValue);
        }
        return response;
    }

    public boolean isDataCoded() {
        boolean isDatenCoded = false;
        String attrValue = "";
        attrValue = this.getRootAttributeValue(ATTR_DATA_CODED);
        if (attrValue != null && !attrValue.equals("")) {
            isDatenCoded = new Boolean(attrValue);
        }
        return isDatenCoded;
    }

    public int getCurrentRow() {
        int currentRow = 0;
        String attrValue = "";
        attrValue = this.getRootAttributeValue(ATTR_CURR_ROW);
        if (attrValue != null && !attrValue.equals("")) {
            currentRow = PSEnvironment.getIntValue(attrValue);
        }
        return currentRow;
    }

    public int getFetchSize() {
        int fetchSize = 0;
        String attrValue = "";
        attrValue = this.getRootAttributeValue(ATTR_FETCH_SIZE);
        if (attrValue != null && !attrValue.equals("")) {
            fetchSize = PSEnvironment.getIntValue(attrValue);
        }
        return fetchSize;
    }

    private String getRootAttributeValue(String attributeName) {
        Element ourElement = this.xmlDoc.getDocumentElement();
        return ourElement.getAttribute(attributeName);
    }
}

