/*
 * Decompiled with CFR 0.152.
 */
package prospektservice;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import prospektservice.Feedback;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.RegForm;
import prospektservice.dialog.frmHelp;
import prospektservice.textfield.JTextFieldFilter;
import prospektservice.textfield.PSJTextField;

public class LoginForm
extends JFrame {
    private static final long serialVersionUID = 3832618478376268336L;
    private static final int WIDTH = 270;
    private static final int HEIGHT = 200;
    private static final int MAXLENGTH_USERID = 20;
    private static ResourceBundle localProperty;
    private PSO pso;
    private frmHelp licenseFrame;
    private JPasswordField txtPassword;
    private String echte_pwd = "";
    private JFrame parent;
    private JPanel loginpanel;
    private JLabel lblPW;
    private JLabel lblRegHinw;
    private JButton cmdEnde;
    private MouseListener mausi;
    public RegForm regform;
    public PSJTextField txtName;
    public JButton cmdOK;
    public JButton cmdReg;

    public LoginForm(PSO mainpanel) {
        super(" ");
        this.pso = mainpanel;
        this.setDefaultCloseOperation(0);
        JFrame parent = (JFrame)SwingUtilities.getRoot(mainpanel);
        localProperty = ResourceBundle.getBundle("properties.LoginForm", PSEnvironment.getEnvironmentLanguage());
        MediaTracker mt = new MediaTracker(parent);
        Image img = Toolkit.getDefaultToolkit().getImage(String.valueOf(PSEnvironment.getPSStdPath()) + "images/germany2.gif");
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setIconImage(img);
        this.getContentPane().setLayout(new BorderLayout());
        String suffix = "";
        if (PSEnvironment.getPSClientProperty("PS.Server.IP", "").startsWith("ref.")) {
            suffix = localProperty.getString("RefSuffix");
        }
        this.setTitle(String.valueOf(localProperty.getString("Title")) + suffix);
        this.setResizable(false);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - 270) / 2, (d.height - 200) / 2);
        this.loginpanel = new JPanel();
        this.loginpanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.loginpanel.setLayout(new BoxLayout(this.loginpanel, 1));
        JLabel lbl = new JLabel(localProperty.getString("Username"));
        lbl.setAlignmentX(0.0f);
        this.loginpanel.add(lbl);
        this.txtName = new PSJTextField();
        this.txtName.setDocument(new JTextFieldFilter("abcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00dfABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc0123456789 .,-():;_@+&"));
        this.txtName.setMinimumSize(new Dimension(80, 22));
        this.txtName.setAlignmentX(0.0f);
        this.loginpanel.add(this.txtName);
        this.txtName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LoginForm.this.txtPassword.requestFocus();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (LoginForm.this.txtName.getText().length() >= 20) {
                    e.consume();
                }
            }
        });
        this.loginpanel.add(Box.createRigidArea(new Dimension(0, 10)));
        lbl = new JLabel(localProperty.getString("Password"));
        lbl.setAlignmentX(0.0f);
        this.loginpanel.add(lbl);
        this.txtPassword = new JPasswordField();
        this.txtPassword.setMinimumSize(new Dimension(80, 22));
        this.txtPassword.setAlignmentX(0.0f);
        this.loginpanel.add(this.txtPassword);
        this.lblPW = new JLabel(localProperty.getString("Hinweis"));
        this.lblPW.setAlignmentX(0.0f);
        this.lblPW.setCursor(new Cursor(12));
        this.loginpanel.add(this.lblPW);
        this.mausi = new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e) {
                LoginForm.this.lblPW.setForeground(Color.green.darker().darker());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LoginForm.this.lblPW.setForeground(SystemColor.black);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (LoginForm.this.txtName.getText().trim().length() == 0) {
                    Feedback.showMessage(LoginForm.this.pso, 12);
                    return;
                }
                PSO.cc.SendMessage(74, LoginForm.this.txtName.getText().trim());
                LoginForm.this.lblPW.removeMouseListener(LoginForm.this.mausi);
                LoginForm.this.lblPW.setText(localProperty.getString("Warten"));
            }
        };
        this.lblPW.addMouseListener(this.mausi);
        JPanel dmy1 = new JPanel();
        dmy1.setAlignmentX(0.0f);
        dmy1.setBorder(new EmptyBorder(10, 5, 10, 5));
        dmy1.setLayout(new FlowLayout(1));
        this.cmdReg = new JButton(localProperty.getString("Button1"));
        this.cmdReg.setPreferredSize(new Dimension(PSEnvironment.isMacOSPlatform() ? 100 : 90, 25));
        this.cmdReg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginForm.this.actionPerformedRegistrierung();
            }
        });
        this.cmdReg.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LoginForm.this.actionPerformedRegistrierung();
                }
                e.consume();
            }
        });
        this.cmdOK = new JButton(localProperty.getString("Button2"));
        this.cmdOK.setPreferredSize(new Dimension(90, 25));
        this.cmdOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginForm.this.actionPerformedLogin();
            }
        });
        this.cmdOK.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LoginForm.this.actionPerformedLogin();
                }
                e.consume();
            }
        });
        this.cmdEnde = new JButton(localProperty.getString("Button3"));
        this.cmdEnde.setPreferredSize(new Dimension(90, 25));
        this.cmdEnde.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginForm.this.actionPerformedEnde();
            }
        });
        this.cmdEnde.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LoginForm.this.actionPerformedEnde();
                }
                e.consume();
            }
        });
        dmy1.add(this.cmdReg);
        dmy1.add(this.cmdEnde);
        dmy1.add(this.cmdOK);
        this.loginpanel.add(dmy1);
        this.lblRegHinw = new JLabel(localProperty.getString("RegHinweis"));
        this.lblRegHinw.setAlignmentX(0.0f);
        this.lblRegHinw.setCursor(new Cursor(12));
        final LoginForm instance = this;
        this.lblRegHinw.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                LoginForm.this.lblRegHinw.setForeground(Color.green.darker().darker());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LoginForm.this.lblRegHinw.setForeground(SystemColor.black);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                frmHelp hilfewindow = frmHelp.getInstance("hilfe/hilfe_login.html", instance);
            }
        });
        this.loginpanel.add(this.lblRegHinw);
        this.getContentPane().add(this.loginpanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LoginForm.this.actionPerformedEnde();
            }
        });
        this.getRootPane().setDefaultButton(this.cmdOK);
        this.requestFocus();
        this.txtName.requestFocus();
        this.pack();
    }

    private final void actionPerformedEnde() {
        if (PSEnvironment.ServerActive) {
            Feedback.showMessage(this, 19);
            return;
        }
        this.setDefaultCloseOperation(2);
        this.setVisible(false);
        this.dispose();
        this.pso.dispose();
    }

    private final void actionPerformedLogin() {
        int separator = 43;
        this.requestFocus();
        this.txtName.setEditable(false);
        this.txtPassword.setEditable(false);
        this.echte_pwd = new String(this.txtPassword.getPassword());
        this.lblPW.removeMouseListener(this.mausi);
        this.cmdOK.setEnabled(false);
        this.cmdReg.setEnabled(false);
        this.cmdEnde.setEnabled(false);
        PSO.cc.SendMessage(46, String.valueOf(this.txtName.getText().toString()) + '+' + this.echte_pwd + '+' + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + '+' + PSEnvironment.getPSVersionProperty("PS.Client.Version") + "|" + "99.8.0");
        PSUser.setNeedsPwChange(!PSEnvironment.isSecurePassword(this.echte_pwd));
    }

    private final void actionPerformedRegistrierung() {
        this.licenseFrame = new frmHelp(this);
        boolean isLicenseAccept = frmHelp.isAccept;
        this.showRegForm(isLicenseAccept);
    }

    public void enableLogin() {
        this.txtName.setEditable(true);
        this.txtPassword.setEditable(true);
        this.lblPW.addMouseListener(this.mausi);
        this.cmdOK.setEnabled(true);
        this.cmdReg.setEnabled(true);
        this.cmdEnde.setEnabled(true);
        this.txtName.requestFocus();
    }

    public void setFocus() {
        this.requestFocus();
        this.txtName.requestFocus();
    }

    public void mailRecieved() {
        this.lblPW.setText(localProperty.getString("Hinweis"));
        this.lblPW.addMouseListener(this.mausi);
        Feedback.showMessage(this.pso, 13);
    }

    public void mailNotRecieved() {
        this.lblPW.setText(localProperty.getString("Hinweis"));
        this.lblPW.addMouseListener(this.mausi);
        Feedback.showMessage(this.pso, 28);
    }

    public void showRegForm(boolean isLicenceAccept) {
        this.licenseFrame.disposeLicenseInstance();
        if (isLicenceAccept) {
            this.setVisible(false);
            this.cmdReg.setEnabled(false);
            this.regform = new RegForm(this.pso, 0);
            this.regform.setVisible(true);
            this.regform.setFocus();
        } else {
            this.setFocus();
        }
    }
}

