/*
 * Decompiled with CFR 0.152.
 */
package prospektservice;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSOConstants;
import prospektservice.PSUser;
import prospektservice.definitions.DefAK;
import prospektservice.definitions.DefAKcolors;
import prospektservice.definitions.DefAKinfo;

public class AKManager
implements PSOConstants {
    private static final int ORG = 0;
    private static final int OWN = 1;
    private static final int COMBINED = 2;
    private static final String DATADIR = String.valueOf(PSEnvironment.getPSPath()) + "data";
    private static PSO pso;
    private static String userID;
    private static String userDir;
    private static String[] dir;
    private static int AKid;
    private static int AKtyp;
    private static int AKindex;
    private static Vector<DefAK> AKdef;
    private static DefAKinfo AKinfo;
    private static DefAKcolors AKdefaultColors;
    private static DefAKcolors AKcolors;
    public static int AKOwnNextID;
    public static int AKComNextID;
    public static int actMap;
    public static int actClass;
    public static boolean AKdataValid;
    public static boolean createOwnAK;
    public static Vector<DefAK> AKsOrg;
    public static Vector<DefAK> AKsOwn;
    public static Vector<DefAK> AKsCom;
    public static Vector<DefAKcolors> AKsColors;
    public static int getOrgAKs;

    static {
        dir = new String[3];
        AKid = 0;
        AKtyp = 0;
        AKindex = 0;
        AKOwnNextID = 0;
        AKComNextID = 0;
        actMap = -1;
        actClass = 0;
        AKdataValid = false;
        createOwnAK = false;
        AKsOrg = new Vector();
        AKsOwn = new Vector();
        AKsCom = new Vector();
        AKsColors = new Vector();
        getOrgAKs = 0;
    }

    private static void checkDir() {
        File Dir = new File(DATADIR);
        if (!Dir.exists()) {
            Dir.mkdir();
        }
        if (!(Dir = new File(String.valueOf(DATADIR) + "/" + userID)).exists()) {
            Dir.mkdir();
        }
        if (!(Dir = new File(dir[1])).exists()) {
            Dir.mkdir();
        }
        if (!(Dir = new File(dir[2])).exists()) {
            Dir.mkdir();
        }
    }

    private static void getOwnAKs() {
        String path = dir[1];
        Vector<String> names = AKManager.getFiles(path);
        int i = 0;
        while (i < names.size()) {
            StringTokenizer st = new StringTokenizer(names.elementAt(i), ".");
            String id = st.nextToken();
            String ext = st.nextToken();
            if (ext.equals("ak")) {
                DefAK ak = new DefAK();
                ak.id = PSEnvironment.getIntValue(id);
                ak.typ = 1;
                ak.text = AKManager.infoLoad((int)ak.id, (int)1).Titel;
                ak.oldversion = ak.newversion = PSEnvironment.getPSVersionProperty("PS.AKown" + id + ".Version");
                ak.up2date = true;
                AKsOwn.addElement(ak);
            }
            ++i;
        }
        int n = AKOwnNextID = AKsOwn.size() > 0 ? AKManager.AKsOwn.lastElement().id + 1 : 1;
        if (PSEnvironment.DEBUG) {
            System.out.println("AKManager (getOwnAK): " + AKsOwn.size() + " AKsOwn gefunden");
        }
    }

    private static void getCombinedAKs() {
        String path = dir[2];
        Vector<String> names = AKManager.getFiles(path);
        int i = 0;
        while (i < names.size()) {
            StringTokenizer st = new StringTokenizer(names.elementAt(i), ".");
            String id = st.nextToken();
            String ext = st.nextToken();
            if (ext.equals("ak")) {
                DefAK ak = new DefAK();
                ak.id = PSEnvironment.getIntValue(id);
                ak.typ = 2;
                ak.text = AKManager.infoLoad((int)ak.id, (int)2).Titel;
                ak.up2date = true;
                AKsCom.addElement(ak);
            }
            ++i;
        }
        int n = AKComNextID = AKsCom.size() > 0 ? AKManager.AKsCom.lastElement().id + 1 : 1;
        if (PSEnvironment.DEBUG) {
            System.out.println("AKManager (getComAK): " + AKsCom.size() + " AKsCom gefunden");
        }
    }

    private static Vector<String> getFiles(String path) {
        Vector<String> files = new Vector<String>();
        File current = new File(path);
        String[] names = current.list();
        int i = 0;
        while (i < names.length) {
            current = new File(String.valueOf(path) + "/" + names[i]);
            if (current.isFile() && names[i] != null) {
                files.addElement(names[i]);
            }
            ++i;
        }
        return files;
    }

    public static void initialize(PSO main) {
        pso = main;
        userID = PSUser.getUserID();
        if (PSEnvironment.DEBUG) {
            System.out.println(userID);
        }
        userDir = String.valueOf(DATADIR) + "/" + userID;
        AKManager.dir[0] = DATADIR;
        AKManager.dir[1] = String.valueOf(userDir) + "/own";
        AKManager.dir[2] = String.valueOf(userDir) + "/combined";
        AKManager.checkDir();
        PSO.cc.SendMessage(255, " ");
        AKManager.getOwnAKs();
        AKManager.getCombinedAKs();
        AKManager.colorsLoadDefault();
        AKManager.colorsLoad();
    }

    public static void reset() {
        getOrgAKs = 0;
        AKsOrg = null;
        AKsOrg = new Vector();
        AKsOwn = null;
        AKsOwn = new Vector();
        AKsCom = null;
        AKsCom = new Vector();
        AKsColors = null;
        AKsColors = new Vector();
        AKindex = 0;
    }

    public static void checkCombinedAKs() {
        int i = 0;
        while (i < AKsCom.size()) {
            DefAK AKCom = AKsCom.elementAt(i);
            Vector<DefAK> comList = AKManager.defLoad(AKCom.id);
            int j = 0;
            while (j < comList.size()) {
                DefAK AKOrg = comList.elementAt(j);
                if (PSEnvironment.DEBUG) {
                    System.out.println("AKManager CombinedCheck " + AKCom.text + ": " + AKOrg.text + " " + AKOrg.up2date);
                }
                if (!AKOrg.up2date) break;
                ++j;
            }
            AKCom.up2date = j == comList.size();
            AKsCom.setElementAt(AKCom, i);
            ++i;
        }
    }

    public static int getActualIndex() {
        return AKindex;
    }

    public static void setActualIndex(int index) {
        AKindex = index;
    }

    public static DefAK getAK(int id, int typ) {
        Vector<DefAK> aklist = null;
        DefAK ak = null;
        if (typ == 0) {
            aklist = AKsOrg;
        }
        if (typ == 1) {
            aklist = AKsOwn;
        }
        if (typ == 2) {
            aklist = AKsCom;
        }
        int i = 0;
        while (i < aklist.size()) {
            ak = aklist.elementAt(i);
            if (ak.id == id && ak.typ == typ) break;
            ++i;
        }
        return ak;
    }

    public static DefAKcolors getAKdefaultColors() {
        return AKdefaultColors;
    }

    public static void setAKcolors(DefAKcolors colors) {
        AKcolors = colors;
        int i = 0;
        while (i < AKsColors.size()) {
            colors = AKsColors.elementAt(i);
            if (colors.id == AKManager.AKcolors.id && colors.typ == AKManager.AKcolors.typ) {
                AKsColors.removeElementAt(i);
                break;
            }
            ++i;
        }
        AKsColors.addElement(AKcolors);
        AKManager.colorsSave();
    }

    public static DefAKcolors getAKcolors() {
        DefAKcolors colors = new DefAKcolors();
        if (AKcolors != null) {
            colors.id = AKid;
            colors.typ = AKtyp;
            colors.Class = (Vector)AKManager.AKcolors.Class.clone();
            colors.selected = (Vector)AKManager.AKcolors.selected.clone();
            colors.unselected = (Vector)AKManager.AKcolors.unselected.clone();
        } else {
            colors.Class = (Vector)AKManager.AKdefaultColors.Class.clone();
            colors.selected = (Vector)AKManager.AKdefaultColors.selected.clone();
            colors.unselected = (Vector)AKManager.AKdefaultColors.unselected.clone();
        }
        return colors;
    }

    public static Vector<DefAK> getAKdef() {
        return AKdef;
    }

    public static DefAKinfo getAKinfo() {
        return AKinfo;
    }

    public static void AKload(int id, int typ) {
        AKid = id;
        AKtyp = typ;
        if (id == 0) {
            AKcolors = null;
            AKinfo = null;
            AKdef = null;
        } else {
            AKcolors = AKdefaultColors;
            if (AKsColors.size() > 0) {
                int i = 0;
                while (i < AKsColors.size()) {
                    DefAKcolors akc = AKsColors.elementAt(i);
                    if (AKid == akc.id && AKtyp == akc.typ) {
                        AKcolors = akc;
                        break;
                    }
                    ++i;
                }
            }
            AKinfo = AKManager.infoLoad(id, typ);
            if (typ == 2) {
                AKdef = AKManager.defLoad(id);
            }
        }
    }

    public static void colorsLoadDefault() {
        AKdefaultColors = new DefAKcolors();
        int i = 1;
        while (i <= 5) {
            AKManager.AKdefaultColors.Class.addElement(String.valueOf(i));
            String rgb = PSEnvironment.getPSClientProperty("PS.MapColor.Slot" + i + ".NotSelected");
            StringTokenizer trgb = new StringTokenizer(rgb, ",");
            AKManager.AKdefaultColors.unselected.addElement(new Color(PSEnvironment.getIntValue(trgb.nextToken()), PSEnvironment.getIntValue(trgb.nextToken()), PSEnvironment.getIntValue(trgb.nextToken())));
            rgb = PSEnvironment.getPSClientProperty("PS.MapColor.Slot" + i + ".Selected");
            trgb = new StringTokenizer(rgb, ",");
            AKManager.AKdefaultColors.selected.addElement(new Color(PSEnvironment.getIntValue(trgb.nextToken()), PSEnvironment.getIntValue(trgb.nextToken()), PSEnvironment.getIntValue(trgb.nextToken())));
            ++i;
        }
    }

    public static void colorsLoad() {
        String dataFileName = String.valueOf(userDir) + "/" + "colors.def";
        try {
            File f = new File(dataFileName);
            if (!f.exists()) {
                return;
            }
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(dataFileName));
            int count = ois.readInt();
            int i = 0;
            while (i < count) {
                DefAKcolors akC = (DefAKcolors)ois.readObject();
                AKsColors.addElement(akC);
                ++i;
            }
            ois.close();
            if (PSEnvironment.DEBUG) {
                System.out.println("AKManager (colorsLoad): " + dataFileName + " eingelesen (" + count + "AKs)");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void colorsSave() {
        String dataFileName = String.valueOf(userDir) + "/" + "colors.def";
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(dataFileName));
            oos.writeInt(AKsColors.size());
            int i = 0;
            while (i < AKsColors.size()) {
                oos.writeObject(AKsColors.elementAt(i));
                ++i;
            }
            oos.close();
            if (PSEnvironment.DEBUG) {
                System.out.println("AKManager (colorsSave): " + dataFileName + " geschrieben (" + AKsColors.size() + "AKs)");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Hashtable<String, Integer> dataLoad(int id) {
        int typ = 0;
        Hashtable<String, Integer> AKdata = new Hashtable<String, Integer>();
        String dataFileName = String.valueOf(dir[typ]) + "/" + id + ".ak";
        try {
            BufferedReader br = new BufferedReader(new FileReader(dataFileName));
            int gotcha = 0;
            char[] data = new char[6];
            while (gotcha != -1) {
                String key;
                gotcha = br.read(data, 0, 6);
                if (gotcha > 0 && gotcha < 6) {
                    while (!br.ready()) {
                    }
                    gotcha = br.read(data, gotcha, 6 - gotcha);
                }
                if ((key = new String(data, 0, 5)).trim().length() <= 0) continue;
                int index = PSEnvironment.getIntValue(new String(data, 5, 1));
                AKdata.put(key, new Integer(index));
            }
            br.close();
            if (PSEnvironment.DEBUG) {
                System.out.println("AKManager (DataLoad): " + dataFileName + " eingelesen");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return AKdata;
    }

    public static void dataMerge(int id, Vector<DefAK> AKlist) {
        DefAK ak = AKlist.firstElement();
    }

    public static void dataSave(int id, int typ, String value) {
        if (dir[typ] == null) {
            userID = PSUser.getUserID();
            userDir = String.valueOf(DATADIR) + "/" + userID;
            AKManager.dir[0] = DATADIR;
            AKManager.dir[1] = String.valueOf(userDir) + "/own";
            AKManager.dir[2] = String.valueOf(userDir) + "/combined";
            AKManager.checkDir();
        }
        String dataFileName = String.valueOf(dir[typ]) + "/" + id + ".ak";
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(dataFileName));
            int i = 0;
            int l = 1024;
            if (PSEnvironment.isMacOSPlatform()) {
                while (i < value.length()) {
                    if (i + l >= value.length()) {
                        l = value.length() - i;
                    }
                    bw.write(value.substring(i, i + l));
                    bw.flush();
                    i += l;
                }
            } else {
                bw.write(value);
            }
            bw.close();
            if (PSEnvironment.DEBUG) {
                System.out.println("AKManager (DataSave): " + dataFileName + " geschrieben");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Vector<DefAK> defLoad(int id) {
        Vector<DefAK> elements = new Vector<DefAK>();
        String dataFileName = String.valueOf(dir[2]) + "/" + id + ".akd";
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(dataFileName));
            int count = ois.readInt();
            int i = 0;
            while (i < count) {
                id = ois.readInt();
                int typ = ois.readInt();
                String version = (String)ois.readObject();
                DefAK ak = AKManager.getAK(id, typ);
                DefAK cloneAK = new DefAK();
                cloneAK.id = id;
                cloneAK.typ = typ;
                cloneAK.text = ak.text;
                cloneAK.oldversion = version;
                cloneAK.newversion = ak.newversion;
                cloneAK.up2date = cloneAK.oldversion.equals(cloneAK.newversion);
                elements.addElement(cloneAK);
                ++i;
            }
            ois.close();
            if (PSEnvironment.DEBUG) {
                System.out.println("AKManager (DefLoad): " + dataFileName + " eingelesen");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return elements;
    }

    public static void defSave(int id, Vector<DefAK> elements) {
        String dataFileName = String.valueOf(dir[2]) + "/" + id + ".akd";
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(dataFileName));
            oos.writeInt(elements.size());
            int i = 0;
            while (i < elements.size()) {
                DefAK ak = elements.elementAt(i);
                oos.writeInt(ak.id);
                oos.writeInt(ak.typ);
                oos.writeObject(ak.oldversion);
                ++i;
            }
            oos.close();
            if (PSEnvironment.DEBUG) {
                System.out.println("AKManager (DefSave): " + dataFileName + " geschrieben");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deleteAK(int idx, int typ) {
        int id = 0;
        if (typ == 1) {
            id = AKManager.AKsOwn.elementAt((int)idx).id;
            AKsOwn.removeElementAt(idx);
        }
        if (typ == 2) {
            id = AKManager.AKsCom.elementAt((int)idx).id;
            AKsCom.removeElementAt(idx);
        }
        try {
            File file = new File(String.valueOf(dir[typ]) + "/" + id + ".ak");
            if (file.exists()) {
                file.delete();
            }
            if ((file = new File(String.valueOf(dir[typ]) + "/" + id + ".aki")).exists()) {
                file.delete();
            }
            if ((file = new File(String.valueOf(dir[typ]) + "/" + id + ".akd")).exists()) {
                file.delete();
            }
            file = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (PSEnvironment.DEBUG) {
            System.out.println("AKManager (DeleteAK): AK" + id + " gel\u00f6scht");
        }
    }

    public static DefAKinfo infoLoad(int id, int typ) {
        String dataFileName = String.valueOf(dir[typ]) + "/" + id + ".aki";
        DefAKinfo info = new DefAKinfo();
        boolean linenum = false;
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(dataFileName));
            info.Beschreibung = (String)ois.readObject();
            info.Titel = (String)ois.readObject();
            info.Untertitel = (String)ois.readObject();
            info.Summary = (String)ois.readObject();
            info.Feldanzahl = ois.readInt();
            int i = 0;
            while (i < info.Feldanzahl) {
                info.Class.addElement(ois.readObject().toString());
                info.Label.addElement(ois.readObject().toString());
                ++i;
            }
            ois.close();
            if (PSEnvironment.DEBUG) {
                System.out.println("AKManager (InfoLoad): " + dataFileName + " eingelesen");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }

    public static void infoSave(int id, int typ, DefAKinfo AKinfo) {
        String dataFileName = String.valueOf(dir[typ]) + "/" + id + ".aki";
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(dataFileName));
            oos.writeObject(AKinfo.Beschreibung);
            oos.writeObject(AKinfo.Titel);
            oos.writeObject(AKinfo.Untertitel);
            oos.writeObject(AKinfo.Summary);
            oos.writeInt(AKinfo.Feldanzahl);
            int i = 0;
            while (i < AKinfo.Feldanzahl) {
                oos.writeObject(AKinfo.Class.elementAt(i));
                oos.writeObject(AKinfo.Label.elementAt(i));
                ++i;
            }
            oos.close();
            if (PSEnvironment.DEBUG) {
                System.out.println("AKManager (InfoSave): " + dataFileName + " geschrieben");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeSelection(int Class2) {
    }

    public static void resetAKTempData() {
    }

    public static void updateVersion(int id, int typ) {
        Vector<DefAK> list = null;
        if (typ == 0) {
            list = AKsOrg;
        }
        if (typ == 1) {
            list = AKsOwn;
        }
        if (typ == 2) {
            list = AKsCom;
        }
        int i = 0;
        while (i < list.size()) {
            DefAK ak = list.elementAt(i);
            if (ak.id == id) {
                ak.oldversion = ak.newversion;
                ak.up2date = true;
                list.setElementAt(ak, i);
                if (typ == 0) {
                    PSEnvironment.setPSVersionProperty("PS.AKorg" + ak.id + ".Version", ak.newversion);
                }
                if (typ == 1) {
                    PSEnvironment.setPSVersionProperty("PS.AKown" + ak.id + ".Version", ak.newversion);
                }
                if (PSEnvironment.DEBUG) {
                    System.out.println("AKManager (updateVersion): Version f\u00fcr AK " + ak.id + " aktualisiert (V" + ak.newversion + ")");
                }
            }
            ++i;
        }
    }

    public static Color[] getCurrColors(boolean selected) {
        Color[] colors = new Color[6];
        Vector tmp = new Vector();
        tmp = AKcolors != null ? (selected ? (Vector)AKManager.AKcolors.selected.clone() : (Vector)AKManager.AKcolors.unselected.clone()) : (selected ? (Vector)AKManager.AKdefaultColors.selected.clone() : (Vector)AKManager.AKdefaultColors.unselected.clone());
        int i = 0;
        while (i <= 5) {
            if (i == 0) {
                String rgb = PSEnvironment.getPSClientProperty(selected ? "PS.MapColor.Slot0.Selected" : "PS.MapColor.Slot0.NotSelected");
                StringTokenizer trgb = new StringTokenizer(rgb, ",");
                colors[i] = new Color(PSEnvironment.getIntValue(trgb.nextToken()), PSEnvironment.getIntValue(trgb.nextToken()), PSEnvironment.getIntValue(trgb.nextToken()), 0);
            } else {
                Color cAlpha;
                Color c = (Color)tmp.elementAt(i - 1);
                boolean flag = true;
                colors[i] = cAlpha = new Color(c.getRed(), c.getGreen(), c.getBlue(), flag ? PSEnvironment.globalAlpha : 255);
            }
            ++i;
        }
        tmp = null;
        return colors;
    }

    public static void YoAK(String value) {
        StringTokenizer tmain = new StringTokenizer(value, "+");
        int z = tmain.countTokens();
        AKsOrg.removeAllElements();
        int i = 0;
        while (i < z) {
            DefAK ak = new DefAK();
            StringTokenizer t = new StringTokenizer(tmain.nextToken(), "|");
            ak.id = PSEnvironment.getIntValue(t.nextToken());
            ak.typ = 0;
            ak.text = t.nextToken();
            AKsOrg.addElement(ak);
            PSO.cc.SendMessage(276, String.valueOf(ak.id));
            ++i;
        }
        if (PSEnvironment.DEBUG) {
            System.out.println("AKManager (YoAK): " + z + " AKsOrg gespeichert");
        }
    }

    public static void YoAKInfo(String value) {
        StringTokenizer tmain = new StringTokenizer(value, "|");
        int id = PSEnvironment.getIntValue(tmain.nextToken());
        DefAKinfo AKinfo = new DefAKinfo();
        AKinfo.Beschreibung = tmain.nextToken();
        AKinfo.Titel = tmain.nextToken();
        AKinfo.Untertitel = tmain.nextToken();
        AKinfo.Summary = tmain.nextToken();
        AKinfo.Feldanzahl = PSEnvironment.getIntValue(tmain.nextToken());
        int i = 0;
        while (i < AKinfo.Feldanzahl) {
            AKinfo.Class.addElement(String.valueOf(i + 1));
            AKinfo.Label.addElement(tmain.nextToken());
            ++i;
        }
        AKManager.infoSave(id, 0, AKinfo);
    }

    public static void YoAKVersion(String value) {
        ++getOrgAKs;
        StringTokenizer tmain = new StringTokenizer(value, "|");
        int id = PSEnvironment.getIntValue(tmain.nextToken());
        String newVersion = tmain.nextToken();
        String oldVersion = PSEnvironment.getPSVersionProperty("PS.AKorg" + id + ".Version");
        if (oldVersion == null) {
            oldVersion = "Neu";
        }
        int i = 0;
        while (i < AKsOrg.size()) {
            DefAK ak = AKsOrg.elementAt(i);
            if (ak.id == id) {
                ak.oldversion = oldVersion;
                ak.newversion = newVersion;
                ak.up2date = newVersion.equals(oldVersion);
                AKsOrg.setElementAt(ak, i);
                break;
            }
            ++i;
        }
        if (getOrgAKs == AKsOrg.size()) {
            AKManager.pso.mapOptions.getUpdatedAKs();
        }
    }

    public static boolean downloadNecessary() {
        return AKsCom.size() == 0;
    }
}

