/*
 * Decompiled with CFR 0.152.
 */
package de.codesolutions.pam.map;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import de.codesolutions.pam.map.CefMapRequestHandler;
import de.codesolutions.pam.map.MapContextMenuHandler;
import de.codesolutions.pam.map.MapDataLoader;
import de.codesolutions.pam.map.MapEventHandler;
import de.codesolutions.pam.map.MapStateHelper;
import de.codesolutions.pam.map.ScriptBuilder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefPdfPrintCallback;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.misc.CefPdfPrintSettings;
import prospektservice.AKManager;
import prospektservice.Feedback;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.base.BrowserLauncher;
import prospektservice.base.PSFileFilter;
import prospektservice.dialog.DlgProgressKarte;
import prospektservice.textfield.PSJTextField;

public class WebMapPanel
extends JPanel {
    private static final long serialVersionUID = 3638750882504073177L;
    private static final String MAP_PROTOCOL = PSEnvironment.getPSClientProperty("PS.SSL").equals("1") ? "https://" : "http://";
    static final String MAP_BASE_ADDRESS = String.valueOf(PSEnvironment.getPSClientProperty("PS.Server.IP")) + "/";
    static String MAP_BASE_URL = "/PAMServlets/MapRequest/mapbase/index.html";
    public static final String WMP_SELECT = "select";
    public static final String WMP_DESELECT = "deselect";
    private static CefApp myApp;
    private static CefClient cefClient;
    private static String errorMsg;
    private CefBrowser cefBrowser;
    private static boolean osrEnabled;
    private String actUrl = "";
    private static Logger logger;
    private Component browserUI;
    private int mapMode = 0;
    private boolean zbnEnabled;
    private boolean mapReady = false;
    private boolean lrSelectionMode;
    private double currentZoom;
    private static String mapAccessKey;
    private static List<String> rasterIdentifiers;
    private static MapStateHelper.MapView initialView;
    private DlgProgressKarte dlgProgress;

    static {
        errorMsg = "";
        osrEnabled = false;
        logger = Logger.getLogger("WebMapPanel");
        mapAccessKey = "";
    }

    public static void init(String[] args) {
        String mapUrl = PSEnvironment.getPSClientProperty("PS.Server.Servlet");
        int pos = mapUrl.indexOf("/");
        MAP_BASE_URL = String.valueOf(mapUrl.substring(0, pos)) + "/MapRequest/mapbase/index.html";
        CefApp.startup((String[])args);
        CefSettings settings = new CefSettings();
        settings.windowless_rendering_enabled = osrEnabled;
        CefSettings cefSettings = settings;
        cefSettings.getClass();
        settings.background_color = new CefSettings.ColorType(cefSettings, 100, 255, 242, 211);
        settings.log_severity = CefSettings.LogSeverity.LOGSEVERITY_DISABLE;
        myApp = CefApp.getInstance((String[])args, (CefSettings)settings);
        CefApp.CefVersion version = myApp.getVersion();
        System.out.println("Using:\n" + version);
        MapDataLoader.init();
        rasterIdentifiers = new ArrayList<String>();
        rasterIdentifiers.add("bing");
        rasterIdentifiers.add("osm");
        rasterIdentifiers.add("tpo");
    }

    public WebMapPanel() {
        AKManager.initialize(PSO.mainpanel);
        ScriptBuilder.init();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (WebMapPanel.this.browserUI != null) {
                    WebMapPanel.this.browserUI.setPreferredSize(WebMapPanel.this.getSize());
                    WebMapPanel.this.browserUI.revalidate();
                }
            }
        });
    }

    public void preparePanel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebMapPanel.this.dlgProgress = new DlgProgressKarte(PSO.mainpanel);
                WebMapPanel.this.dlgProgress.setProgressTitle("Lade Karte");
                WebMapPanel.this.dlgProgress.setLabelContent("");
                WebMapPanel.this.dlgProgress.getProgressBar().setIndeterminate(true);
                WebMapPanel.this.dlgProgress.setVisible(true);
            }
        });
        this.setUrl(String.valueOf(MAP_PROTOCOL) + MAP_BASE_ADDRESS + MAP_BASE_URL);
        this.initializeJCef();
    }

    private void initializeJCef() {
        cefClient = myApp.createClient();
        CefMessageRouter msgRouter = CefMessageRouter.create();
        msgRouter.addHandler((CefMessageRouterHandler)new MapEventHandler(), false);
        cefClient.addMessageRouter(msgRouter);
        cefClient.addContextMenuHandler((CefContextMenuHandler)new MapContextMenuHandler());
        cefClient.addDisplayHandler((CefDisplayHandler)new CefDisplayHandlerAdapter(){

            public void onAddressChange(CefBrowser browser, CefFrame frame, String url) {
                logger.fine("addressChange" + url);
            }

            public void onTitleChange(CefBrowser browser, String title) {
            }

            public void onStatusMessage(CefBrowser browser, String value) {
                logger.fine("statusMsg:" + value);
            }
        });
        cefClient.addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                if (!isLoading && !errorMsg.isEmpty()) {
                    logger.fine("error: " + errorMsg);
                    errorMsg = "";
                }
            }

            public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                if (errorCode != CefLoadHandler.ErrorCode.ERR_NONE && errorCode != CefLoadHandler.ErrorCode.ERR_ABORTED) {
                    errorMsg = "<html><head>";
                    errorMsg = String.valueOf(errorMsg) + "<title>Error while loading</title>";
                    errorMsg = String.valueOf(errorMsg) + "</head><body>";
                    errorMsg = String.valueOf(errorMsg) + "<h1>" + errorCode + "</h1>";
                    errorMsg = String.valueOf(errorMsg) + "<h3>Failed to load " + failedUrl + "</h3>";
                    errorMsg = String.valueOf(errorMsg) + "<p>" + (errorText == null ? "" : errorText) + "</p>";
                    errorMsg = String.valueOf(errorMsg) + "</body></html>";
                    browser.stopLoad();
                    logger.fine("load error, stopped!");
                }
            }
        });
        cefClient.addRequestHandler((CefRequestHandler)new CefMapRequestHandler());
        this.setSize(new Dimension(1000, 750));
        this.cefBrowser = cefClient.createBrowser(this.actUrl, osrEnabled, false);
        this.browserUI = this.cefBrowser.getUIComponent();
        this.browserUI.setPreferredSize(this.getSize());
        this.add(this.browserUI, "Center");
        this.browserUI.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                logger.fine("Mouse pressed, x:" + e.getX() + ", y:" + e.getY());
                PSJTextField target = PSO.mainpanel.getTxtSuchFeld();
                if (target.hasFocus()) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                    target.setFocusable(true);
                }
            }
        });
    }

    public void mapReady() {
        initialView = MapDataLoader.getMapstatehelper().getViewAt(0);
        this.mapReady = true;
    }

    public boolean isMapReady() {
        return this.mapReady;
    }

    public void reset() {
        this.clearMapSelection();
        this.setMapMode(PSO.Modus == 5 ? 2 : 0);
        String script = ScriptBuilder.getRestoreViewScript(initialView.getMapCenter(), initialView.getMapZoom());
        MapDataLoader.getMapstatehelper().reset();
        this.cefBrowser.executeJavaScript(script, "", 0);
    }

    public Component getNativeUI() {
        JPanel panel = (JPanel)this.browserUI;
        panel.getComponent(0);
        return panel.getComponent(0);
    }

    public void exportToPdf() {
        final String fileName = this.setPdfOutputFile();
        if (fileName.length() > 0) {
            CefPdfPrintSettings pdfSettings = new CefPdfPrintSettings();
            pdfSettings.landscape = true;
            pdfSettings.margin_type = CefPdfPrintSettings.MarginType.DEFAULT;
            Dimension d = this.browserUI.getSize();
            int pxToScreen = 180;
            pdfSettings.page_width = d.height * pxToScreen;
            logger.info("page_width: " + d.width * pxToScreen);
            pdfSettings.page_height = d.width * pxToScreen;
            logger.info("page_height: " + d.height * pxToScreen);
            this.cefBrowser.printToPDF(fileName, pdfSettings, new CefPdfPrintCallback(){

                public void onPdfPrintFinished(String path, boolean ok) {
                    try {
                        if (ok) {
                            BrowserLauncher.openURL(fileName);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private double calculatePrintMargin(boolean horizontal) {
        double stdMargin = 5.0;
        double pageWidth = 297.0;
        double pageHeight = 210.0;
        double pageRatio = 1.4142857142857144;
        Dimension d = this.getSize();
        double ratio = (double)d.width / (double)d.height;
        logger.fine("width: " + d.width);
        logger.fine("height: " + d.height);
        logger.fine("ratio: " + ratio);
        double marginW = 5.0;
        double marginH = 5.0;
        if (ratio > pageRatio) {
            marginH = 210.0 - 1.0 / ratio * 297.0;
            marginH += 5.0;
        } else {
            marginW += 297.0 - 1.0 / ratio * 210.0;
            marginW += 5.0;
        }
        logger.info("Margin: " + (horizontal ? (marginW *= 1.27) : (marginH *= 1.27)));
        return horizontal ? marginW : marginH;
    }

    private String setPdfOutputFile() {
        boolean CANCEL_PDF = false;
        boolean SAVE_PDF = true;
        int EXISTS_PDF = 2;
        int fileChooserResult = 2;
        String pdfFilename = "";
        JFileChooser chooser = new JFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        PSFileFilter filter = new PSFileFilter("pdf Dateien|pdf");
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        String defaultPath = PSEnvironment.getPSClientProperty("PS.PdfOutputDir", String.valueOf(PSEnvironment.getPSPath()) + "/dokumente");
        File f = new File(defaultPath);
        if (!f.exists()) {
            f.mkdir();
        }
        chooser.setCurrentDirectory(f);
        try {
            while (fileChooserResult == 2) {
                if (chooser.showSaveDialog(PSO.mainpanel) == 0) {
                    File file = chooser.getSelectedFile();
                    if (file.exists()) {
                        int fb = Feedback.showQuestion((Component)PSO.mainpanel, 13);
                        if (fb == 1) {
                            fileChooserResult = 2;
                            continue;
                        }
                        pdfFilename = file.getAbsolutePath();
                        if (!pdfFilename.endsWith(".pdf")) {
                            pdfFilename = String.valueOf(pdfFilename) + ".pdf";
                        }
                        fileChooserResult = 1;
                        continue;
                    }
                    pdfFilename = file.getAbsolutePath();
                    if (!pdfFilename.endsWith(".pdf")) {
                        pdfFilename = String.valueOf(pdfFilename) + ".pdf";
                    }
                    fileChooserResult = 1;
                    continue;
                }
                fileChooserResult = 0;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return pdfFilename;
    }

    public void setUrl(String url) {
        this.actUrl = url;
        if (this.cefBrowser != null) {
            this.cefBrowser.loadURL(this.actUrl);
        }
    }

    public String getUrl() {
        return this.actUrl;
    }

    public static String getMapAccessKey() {
        return mapAccessKey;
    }

    public static void setMapAccessKey(String key) {
        mapAccessKey = key;
    }

    public boolean isLrSelectionMode() {
        return this.lrSelectionMode;
    }

    public void setLrSelectionMode(boolean lrSelectionMode) {
        this.lrSelectionMode = lrSelectionMode;
    }

    public double getCurrentZoom() {
        return this.currentZoom;
    }

    public void setCurrentZoom(double currentZoom) {
        this.currentZoom = currentZoom;
    }

    public void zoomToPlz(String plz) {
        this.zoomToPlz(plz, 13.0);
    }

    public void zoomToPlz(String plz, double zoom) {
        try {
            if (plz.length() < 5) {
                plz = "0" + plz;
            }
            this.cefBrowser.executeJavaScript("zoomToArea('" + plz + "')", "", 0);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Illegal Argument: " + plz, ex);
        }
    }

    public void zoomToRegion(String regionName) {
        try {
            Point pt = MapDataLoader.getFeatureCentroid(regionName, MapDataLoader.AreaTypes.Kreise);
            if (pt != null) {
                String script = ScriptBuilder.getZoomToAreaScript(pt, 10.0);
                this.cefBrowser.executeJavaScript(script, "", 0);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Illegal Argument: " + regionName, ex);
        }
    }

    public void setBaseTileLayer(String type) {
        this.cefBrowser.executeJavaScript("setBaseLayer(type)", "", 0);
    }

    public void showPreviousView() {
        MapStateHelper.MapView mv = MapDataLoader.getMapstatehelper().getPreviousView();
        String script = ScriptBuilder.getRestoreViewScript(mv.getMapCenter(), mv.getMapZoom());
        this.cefBrowser.executeJavaScript(script, "", 0);
    }

    public void showNextView() {
        MapStateHelper.MapView mv = MapDataLoader.getMapstatehelper().getNextView();
        String script = ScriptBuilder.getRestoreViewScript(mv.getMapCenter(), mv.getMapZoom());
        this.cefBrowser.executeJavaScript(script, "", 0);
    }

    public int getMapMode() {
        return this.mapMode;
    }

    public void setMapMode(int mapMode) {
        logger.fine("setMapMode: " + mapMode);
        this.mapMode = mapMode;
        this.cefBrowser.executeJavaScript("setMapMode(" + mapMode + ");", "", 0);
        if (mapMode == 2) {
            this.setZBezEnabled(true);
        }
    }

    public void setZBezEnabled(boolean flag) {
        this.zbnEnabled = flag;
        this.cefBrowser.executeJavaScript("enableZbn(" + flag + ");", "", 0);
    }

    public boolean isZbnEnabled() {
        return this.zbnEnabled && this.currentZoom > 12.0;
    }

    public void requestMapSelection() {
        this.cefBrowser.executeJavaScript("reportSelection();", "", 0);
    }

    public void clearMapSelection() {
        this.cefBrowser.executeJavaScript("clearSelection();", "", 0);
    }

    public void enableDragboxSelection() {
        this.cefBrowser.executeJavaScript("enableDragbox();", "", 0);
    }

    public void enableCircleSelection(String mode) {
        this.cefBrowser.executeJavaScript("enableCircleSelect('" + mode + "');", "", 0);
    }

    public void enablePolygonSelection(String mode) {
        this.cefBrowser.executeJavaScript("enablePolySelect('" + mode + "');", "", 0);
    }

    public void enableInfoMode(boolean enable) {
        if (enable) {
            this.cefBrowser.executeJavaScript("enableInfo();", "", 0);
        } else {
            this.cefBrowser.executeJavaScript("disableInfo();", "", 0);
        }
    }

    public void selectArea(String area) {
        this.cefBrowser.executeJavaScript("selectArea('" + area + "');", "", 0);
    }

    public void selectPartialArea(String area, int selected, int all) {
        if (this.mapMode == 0 || this.mapMode == 2) {
            logger.fine("selectArea: " + area);
            this.cefBrowser.executeJavaScript("selectPartialArea('" + area + "'," + selected + ", " + all + ");", "", 0);
        }
    }

    public void deselectArea(String area) {
        this.cefBrowser.executeJavaScript("deselectArea('" + area + "');", "", 0);
    }

    public void toggleAreaSelection(String area) {
        this.cefBrowser.executeJavaScript("toggleAreaSelection('" + area + "');", "", 0);
    }

    public void isAreaSelected(String area) {
        this.cefBrowser.executeJavaScript("isAreaSelected('" + area + "');", "", 0);
    }

    public void zoomToSelection(Geometry g) {
        if (g != null) {
            String script = ScriptBuilder.getViewExtentScript(g);
            this.cefBrowser.executeJavaScript(script, "", 0);
        }
    }

    public void viewSelection() {
        this.cefBrowser.executeJavaScript("viewSelection();", "", 0);
    }

    public void setRasterLayer(int value) {
        String script = "setBaseLayer('" + rasterIdentifiers.get(value) + "');";
        this.cefBrowser.executeJavaScript(script, "", 0);
    }

    public void enableDataVisualization(int id) {
        logger.fine("visualization data id: " + id);
        String snippet = ScriptBuilder.getDataVisualizationScript(id);
        logger.fine(snippet);
        this.cefBrowser.executeJavaScript(snippet, "", 0);
    }

    public void disableDataVisualization() {
        this.cefBrowser.executeJavaScript("disableColorTable();", "", 0);
    }

    public DlgProgressKarte getProgressDlg() {
        return this.dlgProgress;
    }
}

