/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.textfield;

import java.awt.Color;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.math.BigInteger;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import prospektservice.PSEnvironment;
import prospektservice.textfield.JTextFieldFilter;

public class BorderJTextField
extends JTextField
implements FocusListener {
    private static final long serialVersionUID = 3256439192560349241L;
    private int MaxCharacters = 0;
    private int MinCharacters = 0;
    private int InputArt = 0;
    private int FieldMessage;
    private static final int SET_ABS_KDNR = 26;
    private static final int SET_EIN_KDNR = 35;
    boolean isValid;
    boolean isStatus;
    Border NewBorder = new LineBorder(Color.blue, 2);
    Border OldBorder = this.getBorder();
    KeyAdapter BorderKeyAdapter;

    public BorderJTextField(int Mi, int Ma, int Message, int Art) {
        this.MaxCharacters = Ma;
        this.MinCharacters = Mi;
        this.setActionCommand("" + Message);
        this.FieldMessage = Message;
        if (Art == 1) {
            super.setDocument(new JTextFieldFilter("0123456789"));
        }
        if (Art == 3) {
            super.setDocument(new JTextFieldFilter("0123456789 /-"));
        }
        this.InputArt = Art;
        if (this.MinCharacters == 0 && this.MaxCharacters == 0) {
            this.setValid(true);
        } else {
            this.setValid(false);
        }
        this.isStatus = true;
        super.addFocusListener(this);
        this.BorderKeyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (BorderJTextField.this.FieldMessage == 26 || BorderJTextField.this.FieldMessage == 35) {
                    if (BorderJTextField.this.getText().length() <= BorderJTextField.this.MinCharacters) {
                        if (BorderJTextField.this.isValid) {
                            BorderJTextField.this.setValid(false);
                        }
                    } else if (!BorderJTextField.this.isValid && BorderJTextField.this.checkKdNr(e, "")) {
                        BorderJTextField.this.setValid(true);
                    }
                } else if (BorderJTextField.this.MinCharacters != 0 && BorderJTextField.this.getText().length() <= BorderJTextField.this.MinCharacters) {
                    if (BorderJTextField.this.isValid && BorderJTextField.this.isStatus) {
                        BorderJTextField.this.setValid(false);
                    }
                } else if (!BorderJTextField.this.isValid && BorderJTextField.this.isStatus) {
                    BorderJTextField.this.setValid(true);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                int selLength = 0;
                BorderJTextField eventSource = (BorderJTextField)e.getSource();
                String selText = eventSource.getSelectedText();
                if (selText != null) {
                    selLength = selText.length();
                }
                if (BorderJTextField.this.MaxCharacters != 0 && BorderJTextField.this.getText().length() >= BorderJTextField.this.MaxCharacters && selLength == 0 && e.getKeyChar() != '\b') {
                    e.consume();
                } else if (BorderJTextField.this.InputArt == 2) {
                    char c = e.getKeyChar();
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                        if (c >= 'a' && c <= 'z') {
                            e.setKeyChar(Character.toUpperCase(c));
                        }
                    } else {
                        e.consume();
                    }
                }
            }
        };
        this.addKeyListener(this.BorderKeyAdapter);
    }

    @Override
    public void paste() {
        try {
            String content = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
            if (content.length() <= this.MaxCharacters && this.MaxCharacters > 0) {
                super.paste();
            }
        }
        catch (HeadlessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        switch (e.getID()) {
            case 1005: {
                this.fireActionPerformed();
            }
        }
    }

    @Override
    public void setEnabled(boolean Value) {
        if (!Value) {
            if (!this.isValid) {
                this.setValid(true);
            }
        } else if (this.MinCharacters != 0 && this.getText().length() <= this.MinCharacters) {
            if (this.isValid) {
                this.setValid(false);
            }
        } else if (this.FieldMessage == 35 || this.FieldMessage == 26) {
            if (this.checkKdNr(null, this.getText())) {
                this.setValid(true);
            }
        } else if (!this.isValid) {
            this.setValid(true);
        }
        super.setEnabled(Value);
    }

    public void setStatus(boolean Value) {
        boolean bl = this.isStatus = !Value;
        if (Value) {
            if (!this.isValid) {
                this.setValid(true);
            }
        } else if (this.MinCharacters != 0 && this.getText().length() <= this.MinCharacters) {
            if (this.isValid) {
                this.setValid(false);
            }
        } else if (!this.isValid) {
            this.setValid(true);
        }
    }

    public void setStatusDeterministic(boolean value) {
        this.setValid(false);
    }

    public void setInitText(String value) {
        if (this.MinCharacters != 0 && value.length() <= this.MinCharacters) {
            if (this.isValid && this.isStatus) {
                this.setValid(false);
            }
        } else if (!this.isValid && this.isStatus) {
            this.setValid(true);
        }
        super.setText(value);
    }

    @Override
    public void setText(String Value) {
        if (this.MinCharacters != 0 && Value.length() <= this.MinCharacters) {
            if (this.isValid && this.isStatus) {
                this.setValid(false);
            }
        } else if (!this.isValid && this.isStatus) {
            this.setValid(true);
        }
        if (this.FieldMessage == 26 || this.FieldMessage == 35) {
            if (this.checkKdNr(null, Value)) {
                this.setValid(true);
            } else {
                this.setValid(false);
            }
        }
        super.setText(Value);
        this.fireActionPerformed();
    }

    private void setValid(boolean Value) {
        this.firePropertyChange("InputValid", this.isValid, Value);
        this.isValid = Value;
        if (this.isValid) {
            this.setBorder(this.OldBorder);
        } else {
            this.setBorder(this.NewBorder);
        }
        this.repaint();
    }

    public boolean checkKdNr(KeyEvent e, String text) {
        String value = "";
        if (e != null) {
            JTextField jTextField = (JTextField)e.getSource();
            value = jTextField.getText();
        } else {
            value = text;
        }
        if (value.length() < 10) {
            return false;
        }
        if (Double.valueOf(value).equals(Double.valueOf("0"))) {
            return false;
        }
        try {
            String bla;
            long number = 0L;
            int i = 0;
            while (i <= 7) {
                bla = value.substring(i, i + 1);
                number += (long)(PSEnvironment.getIntValue(bla) * (i + 2));
                ++i;
            }
            BigInteger BigInt1 = BigInteger.valueOf(number);
            BigInteger BigInt2 = BigInteger.valueOf(97L);
            BigInt1 = BigInt1.mod(BigInt2);
            bla = value.substring(value.length() - 2, value.length());
            return BigInt1.intValue() == PSEnvironment.getIntValue(bla);
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        Point ttPoint = new Point(0, 0);
        ttPoint.x = 1;
        ttPoint.y = 27;
        return ttPoint;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.isEditable()) {
            this.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void setMaxCharacters(int maxCharacters) {
        this.MaxCharacters = maxCharacters;
    }

    public void setMinCharacters(int minChars) {
        this.MinCharacters = minChars;
    }

    public void updateTextFilter(String filter) {
        super.setDocument(new JTextFieldFilter(filter));
    }
}

