/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.printj2;

import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.print.PrintService;
import javax.print.attribute.standard.PrinterResolution;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.base.progress.ProgressEvent;
import prospektservice.base.progress.VolumeProgressDialog;
import prospektservice.printj2.PDFPrinterGraphics;
import prospektservice.printj2.PrintAZ;
import prospektservice.printj2.PrintAZ_Einzeln;
import prospektservice.printj2.PrintAZ_Landscape;
import prospektservice.printj2.PrintAZ_LandscapeZBN;
import prospektservice.printj2.PrintDetail;
import prospektservice.printj2.PrintKB;
import prospektservice.printj2.PrintLR;
import prospektservice.printj2.PrintPalette;
import prospektservice.printj2.PrintPaletteList;
import prospektservice.printj2.PrintPaletteNotification;
import prospektservice.printj2.PrintPaletteStorage;
import prospektservice.printj2.PrintVH;
import prospektservice.printj2.PrintVS;
import prospektservice.printj2.PrintZG;
import prospektservice.printj2.PrintableObject;

public class PSPrintControl {
    private static String[] jobNames = new String[]{"Kassenbeleg", "Auftraggeber", "Verteilstellen", "Zielgebiete", "Aufschriftzettel", "Verteilhinweise", "Leitregionen", "Aufschriftzettel Einzeln", "Detail\u00fcbersicht", "Aufschriftzettel Zustellbezirke", "Palettenleitzettel", "Kartenausschnitt", "Paletten\u00fcbersicht", "Lesecenter Beleg"};
    private static int printJobType = -1;
    private PrintableObject p;
    private PageFormat pf;
    private PrinterJob pj;
    private VolumeProgressDialog progress;
    private String additionalData;
    private ArrayList<PWPrintJob> jobs;
    private Hashtable cachedJobData;
    private boolean printToPdf = false;
    private boolean druckEinfach;
    private boolean druckPaletteWithPLZ;
    private boolean openPdf;
    private PWPrintJob actJob;
    private PrintService printService = null;
    private PDFPrinterGraphics pdfGraphics;
    private int docCnt = -1;
    private boolean pdfMultiDoc = false;
    private Book multiDocBook;
    private boolean resetPdfWhenIdle = false;
    private boolean autoSplitPdf = false;
    private int autoSPlitPageCnt = 500;

    public PSPrintControl() {
        if (PSEnvironment.getPSClientProperty("PS.PrintToPDF", "").equals("1")) {
            this.printToPdf = true;
        }
        if (PSEnvironment.getPSClientProperty("PS.OpenPDF", "").equals("1")) {
            this.openPdf = true;
        }
        if (PSEnvironment.getPSClientProperty("PS.AutoSplitPDF", "").equals("1")) {
            this.autoSplitPdf = true;
        }
        if (!this.printToPdf) {
            String defaultPrinter = PSEnvironment.getPSClientProperty("PS.SelectedPrinter", "");
            try {
                PrintService[] ps = PrinterJob.lookupPrintServices();
                int i = 0;
                while (i < ps.length) {
                    if (ps[i].getName().equals(defaultPrinter)) {
                        this.printService = ps[i];
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.jobs = new ArrayList();
        this.cachedJobData = new Hashtable();
    }

    public void resetPrintCtrl() {
        this.jobs.removeAll(this.jobs);
    }

    public boolean newPrintJob(int type) {
        boolean result = false;
        if (PSEnvironment.DEBUG) {
            System.out.println("New printJob with type = " + type);
            System.out.println("printToPdf = " + this.printToPdf);
        }
        String docName = "";
        this.pj = PrinterJob.getPrinterJob();
        if (type < jobNames.length) {
            docName = jobNames[type];
        }
        this.pj.setJobName("POSTAKTUELL MANAGER " + docName);
        if (this.printService == null && !this.printToPdf) {
            if (this.pj.printDialog()) {
                PrinterResolution[] supportedResolutions;
                this.printService = this.pj.getPrintService();
                PWPrintJob newJob = new PWPrintJob();
                newJob.jobType = type;
                newJob.printJob = this.pj;
                this.jobs.add(newJob);
                result = true;
                System.out.println(this.printService.getName());
                PrinterResolution[] printerResolutionArray = supportedResolutions = (PrinterResolution[])this.printService.getSupportedAttributeValues(PrinterResolution.class, null, null);
                int n = supportedResolutions.length;
                int n2 = 0;
                while (n2 < n) {
                    PrinterResolution supportedResolution = printerResolutionArray[n2];
                    int[] resolution = supportedResolution.getResolution(100);
                    System.out.println(String.valueOf(resolution[0]) + "x" + resolution[1]);
                    ++n2;
                }
            }
        } else {
            PWPrintJob newJob;
            try {
                PrinterResolution[] supportedResolutions;
                this.pj.setPrintService(this.printService);
                System.out.println(this.printService.getName());
                PrinterResolution[] printerResolutionArray = supportedResolutions = (PrinterResolution[])this.printService.getSupportedAttributeValues(PrinterResolution.class, null, null);
                int n = supportedResolutions.length;
                int n3 = 0;
                while (n3 < n) {
                    PrinterResolution supportedResolution = printerResolutionArray[n3];
                    int[] resolution = supportedResolution.getResolution(100);
                    System.out.println(String.valueOf(resolution[0]) + "x" + resolution[1]);
                    ++n3;
                }
            }
            catch (PrinterException supportedResolutions) {
                // empty catch block
            }
            if (this.pdfMultiDoc) {
                newJob = new PWPrintJob(this.multiDocBook);
                newJob.jobType = type;
                newJob.printJob = this.pj;
                this.jobs.add(newJob);
            } else {
                newJob = new PWPrintJob();
                newJob.jobType = type;
                newJob.printJob = this.pj;
                this.jobs.add(newJob);
            }
            result = true;
        }
        if (this.jobs.size() == 1) {
            this.setNewJob();
        }
        return result;
    }

    public boolean newPrintJob(int type, int pages) {
        boolean result = false;
        String docName = "";
        if (PSEnvironment.DEBUG) {
            System.out.println("New printJob with type = " + type + ", pages=" + pages);
            System.out.println("printToPdf = " + this.printToPdf);
        }
        if (pages == 0) {
            return result;
        }
        this.pj = PrinterJob.getPrinterJob();
        if (type < jobNames.length) {
            docName = jobNames[type];
        }
        this.pj.setJobName("Prospektservice Online " + docName);
        if (this.printService == null && !this.printToPdf) {
            if (this.pj.printDialog()) {
                this.printService = this.pj.getPrintService();
                PWPrintJob newJob = new PWPrintJob();
                newJob.pageCnt = pages;
                newJob.jobType = type;
                newJob.printJob = this.pj;
                this.jobs.add(newJob);
                result = true;
            }
        } else {
            try {
                this.pj.setPrintService(this.printService);
            }
            catch (PrinterException newJob) {
                // empty catch block
            }
            if (this.pdfMultiDoc) {
                PWPrintJob newJob = new PWPrintJob(this.multiDocBook);
                newJob.pageCnt = pages;
                newJob.printJob = this.pj;
                newJob.jobType = type;
                this.jobs.add(newJob);
            } else {
                PWPrintJob newJob = new PWPrintJob();
                newJob.pageCnt = pages;
                newJob.jobType = type;
                newJob.printJob = this.pj;
                this.jobs.add(newJob);
            }
            result = true;
        }
        if (this.jobs.size() == 1) {
            this.setNewJob();
        }
        return result;
    }

    public void newPdfMultiJob(int numDocuments) {
        if (PSEnvironment.DEBUG) {
            System.out.println("A new multi doc with " + numDocuments + " docs");
        }
        this.docCnt = numDocuments;
        this.multiDocBook = new Book();
        this.pdfMultiDoc = true;
    }

    public boolean newBlankoPrintJob(int type, int pages, int modus, String data) {
        boolean result = false;
        String docName = "";
        this.pj = PrinterJob.getPrinterJob();
        if (type < jobNames.length) {
            docName = jobNames[type];
        }
        this.pj.setJobName("Prospektservice Online " + docName);
        if (this.printService == null && !this.printToPdf) {
            if (this.pj.printDialog()) {
                this.printService = this.pj.getPrintService();
                this.actJob = new PWPrintJob();
                this.actJob.pageCnt = pages;
                this.actJob.jobType = type;
                this.actJob.printJob = this.pj;
                this.actJob.printMode = modus;
                this.jobs.add(this.actJob);
                result = true;
            }
        } else {
            try {
                this.pj.setPrintService(this.printService);
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
            if (this.pdfMultiDoc) {
                this.actJob = new PWPrintJob(this.multiDocBook);
                this.actJob.pageCnt = pages;
                this.actJob.printJob = this.pj;
                this.actJob.jobType = type;
                this.actJob.printMode = modus;
                this.jobs.add(this.actJob);
            } else {
                this.actJob = new PWPrintJob();
                this.actJob.pageCnt = pages;
                this.actJob.jobType = type;
                this.actJob.printMode = modus;
                this.actJob.printJob = this.pj;
                this.jobs.add(this.actJob);
            }
            result = true;
        }
        this.addJobData(data, type);
        return result;
    }

    public PWPrintJob getCurrentJob() {
        return this.actJob;
    }

    public void setNewJob() {
        if (this.jobs.size() > 0) {
            this.actJob = this.jobs.get(0);
            if (this.actJob.jobType != 8 && this.actJob.pageCnt > 2) {
                this.initProgress(this.actJob.bk);
            }
        } else {
            if (this.resetPdfWhenIdle) {
                this.printToPdf = !this.printToPdf;
                this.resetPdfWhenIdle = false;
            }
            PrintAZ.resetBundleCnt();
        }
    }

    public void setAdditionalJobData(String data) {
        this.additionalData = data;
    }

    public void setJobMode(int mode) {
        this.actJob.printMode = mode;
    }

    public synchronized void addJobData(String data, int type) {
        try {
            if (this.actJob == null) {
                return;
            }
            Book bk = this.actJob.bk;
            this.pf = new PageFormat();
            this.pf.setOrientation(1);
            Paper paper = this.pf.getPaper();
            paper.setSize(594.72, 841.68);
            paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
            this.pf.setPaper(paper);
            switch (type) {
                case 4: {
                    this.pf.setOrientation(0);
                    this.p = new PrintAZ_Landscape(data);
                    break;
                }
                case 9: {
                    this.pf.setOrientation(0);
                    this.p = new PrintAZ_LandscapeZBN(data);
                    break;
                }
                case 7: {
                    StringTokenizer tmain = new StringTokenizer(data, "+");
                    int anzVH = tmain.countTokens() - 1;
                    this.p = new PrintAZ_Einzeln(String.valueOf(tmain.nextToken()) + (anzVH > 0 ? "+" + tmain.nextToken() : ""));
                    if (anzVH <= 1) break;
                    bk.append(this.p, this.pf);
                    int i = 1;
                    while (i < anzVH) {
                        ++this.actJob.pageCnt;
                        this.p = new PrintVH(String.valueOf(i + 1) + "+" + tmain.nextToken() + (tmain.hasMoreTokens() ? "+" + tmain.nextToken() : ""));
                        if (tmain.hasMoreTokens()) {
                            bk.append(this.p, this.pf);
                        }
                        i += 2;
                    }
                    break;
                }
                case 0: 
                case 1: 
                case 13: {
                    this.p = new PrintKB(data, this.actJob.jobType);
                    if (!PrintKB.isFlgDruckKoop() || this.actJob.pageCnt <= 1) break;
                    bk.append(this.p, this.pf);
                    this.p = new PrintKB("", 14);
                    if (!this.actJob.isPdfMultiDoc) break;
                    ++this.actJob.pageCntDone;
                    break;
                }
                case 2: {
                    this.p = new PrintVS(data);
                    ((PrintVS)this.p).setNumPages(this.actJob.pageCnt);
                    break;
                }
                case 3: {
                    this.p = new PrintZG(data);
                    ((PrintZG)this.p).setNumPages(this.actJob.pageCnt);
                    break;
                }
                case 5: {
                    this.p = new PrintVH(data);
                    break;
                }
                case 6: {
                    StringTokenizer tLR = new StringTokenizer(data, "|");
                    int lrPages = (int)((double)(tLR.countTokens() - 2) * 0.25);
                    this.actJob.pageCnt = (int)Math.ceil(lrPages) + 1;
                    String useAlways = String.valueOf(tLR.hasMoreTokens() ? tLR.nextToken() : "") + "|" + (tLR.hasMoreTokens() ? tLR.nextToken() : "");
                    this.initProgress(bk);
                    int i = 0;
                    while (i < this.actJob.pageCnt) {
                        String tmp = String.valueOf(useAlways) + "|";
                        if (tLR.hasMoreTokens()) {
                            tmp = String.valueOf(tmp) + tLR.nextToken() + "|";
                        }
                        if (tLR.hasMoreTokens()) {
                            tmp = String.valueOf(tmp) + tLR.nextToken() + "|";
                        }
                        if (tLR.hasMoreTokens()) {
                            tmp = String.valueOf(tmp) + tLR.nextToken() + "|";
                        }
                        if (tLR.hasMoreTokens()) {
                            tmp = String.valueOf(tmp) + tLR.nextToken() + "|";
                        }
                        this.p = new PrintLR(tmp);
                        if (i < this.actJob.pageCnt - 1) {
                            bk.append(this.p, this.pf);
                        }
                        this.progress.setProgressValue(bk.getNumberOfPages());
                        ++i;
                    }
                    break;
                }
                case 8: {
                    StringTokenizer st = new StringTokenizer(data, "+");
                    if (st.countTokens() < 2) {
                        return;
                    }
                    st.nextToken();
                    StringTokenizer t = new StringTokenizer(st.nextToken(), "|");
                    int firstPageTokens = 0;
                    double realTokens = t.countTokens();
                    firstPageTokens = PrintDetail.getDruckDetailAddress() && PrintDetail.getDruckDetailInfo() ? 34 : (PrintDetail.getDruckDetailAddress() && !PrintDetail.getDruckDetailInfo() ? 58 : (!PrintDetail.getDruckDetailAddress() && PrintDetail.getDruckDetailInfo() ? 49 : 87));
                    realTokens -= (double)(firstPageTokens * 6);
                    if (realTokens < 0.0) {
                        realTokens = 0.0;
                    }
                    double realPages = realTokens / 6.0 / 81.0;
                    this.actJob.pageCnt = (int)Math.ceil(realPages) + 1;
                    if (this.actJob.pageCnt > 3) {
                        this.actJob.pageCnt = 3;
                    }
                    this.initProgress(bk);
                    int i = 0;
                    while (i < this.actJob.pageCnt) {
                        this.p = new PrintDetail(data);
                        ((PrintDetail)this.p).setDetailAddress(this.additionalData);
                        ((PrintDetail)this.p).setNumPages(this.actJob.pageCnt);
                        if (i < this.actJob.pageCnt - 1) {
                            bk.append(this.p, this.pf);
                        }
                        this.progress.setProgressValue(bk.getNumberOfPages());
                        ++i;
                    }
                    break;
                }
                case 10: {
                    this.pf.setOrientation(0);
                    this.p = new PrintPalette(data);
                    break;
                }
                case 12: {
                    this.p = new PrintPaletteList(data);
                    ((PrintPaletteList)this.p).setNumPages(this.actJob.pageCnt);
                    break;
                }
                case 11: {
                    break;
                }
                case 14: {
                    this.p = new PrintPaletteNotification(data);
                    break;
                }
                case 15: {
                    this.p = new PrintPaletteStorage(data, 15);
                    break;
                }
                case 16: {
                    this.p = new PrintPaletteStorage(data, 16);
                    break;
                }
                case 17: {
                    this.p = new PrintPaletteStorage(data, 17);
                    break;
                }
                case 18: {
                    this.p = new PrintPaletteStorage(data, 18);
                    break;
                }
                case 19: {
                    this.p = new PrintPaletteStorage(data, 19);
                }
            }
            this.p.setPrintModus(this.actJob.printMode);
            bk.append(this.p, this.pf);
            this.actJob.printJob.setPageable(bk);
            if (PSEnvironment.DEBUG) {
                System.out.println("NumberOfPages -> " + bk.getNumberOfPages());
                System.out.println("totalPages -> " + this.actJob.pageCnt);
            }
            if (!this.actJob.isPdfMultiDoc) {
                if (bk.getNumberOfPages() == this.actJob.pageCnt) {
                    if (this.printToPdf) {
                        this.commitPDF(this.actJob);
                        this.setNewJob();
                    } else {
                        PrinterJob pj = this.actJob.getPrintJob();
                        if (PSEnvironment.DEBUG) {
                            System.out.println("progress == null -> " + (this.progress == null));
                        }
                        if (this.progress != null) {
                            this.progress.closeProgressDialog();
                            this.progress = null;
                        }
                        if (this.jobs.size() > 0) {
                            this.jobs.remove(0);
                        }
                        this.commit(pj);
                        this.setNewJob();
                    }
                }
            } else {
                if (PSEnvironment.DEBUG) {
                    System.out.println("jobtype -> " + this.actJob.jobType);
                    System.out.println("pageCntDone -> " + this.actJob.pageCntDone);
                    System.out.println("actJob.pageCnt -> " + this.actJob.pageCnt);
                    System.out.println("docCnt -> " + this.docCnt);
                }
                if (++this.actJob.pageCntDone == this.actJob.pageCnt) {
                    --this.docCnt;
                    if (this.docCnt == 0) {
                        this.commitMultiPDF(this.actJob);
                        this.pdfMultiDoc = false;
                        if (this.jobs.size() > 0) {
                            this.jobs.remove(this.actJob);
                        }
                    } else {
                        if (this.progress != null) {
                            this.progress.closeProgressDialog();
                            this.progress = null;
                        }
                        if (this.jobs.size() > 0) {
                            this.jobs.remove(this.actJob);
                        }
                        this.setNewJob();
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void commit(final PrinterJob job) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    job.print();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        t.start();
    }

    private void commitPDF(final PWPrintJob job) {
        Thread t = new Thread(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    int orientation;
                    PDFPrinterGraphics g = new PDFPrinterGraphics();
                    PageFormat format = job.bk.getPageFormat(0);
                    int n = orientation = format.getOrientation() == 0 ? 1 : 0;
                    if (!PSPrintControl.this.autoSplitPdf || job.bk.getNumberOfPages() < PSPrintControl.this.autoSPlitPageCnt) {
                        int pageCnt = job.bk.getNumberOfPages();
                        if (!g.initPdf(orientation, pageCnt)) return;
                        int i = 0;
                        while (i < pageCnt) {
                            PrintableObject p = (PrintableObject)job.bk.getPrintable(i);
                            p.setPrintModus(job.printMode);
                            p.print(g, job.bk.getPageFormat(i), i);
                            ++i;
                        }
                        if (PSPrintControl.this.p instanceof PrintPaletteNotification) {
                            ((PrintPaletteNotification)PSPrintControl.this.p).endPrintJob();
                        }
                        g.dispose();
                        return;
                    } else {
                        String fileName;
                        int pageCnt = PSPrintControl.this.autoSPlitPageCnt;
                        int totalCnt = job.bk.getNumberOfPages();
                        int counter = 0;
                        g.setAutoSplitDocument(true);
                        if (!g.initPdf(orientation, pageCnt)) return;
                        String baseFileName = g.getPdfFileName();
                        baseFileName = baseFileName.substring(0, baseFileName.indexOf("_"));
                        do {
                            int i = 0;
                            while (i < pageCnt) {
                                PrintableObject p = (PrintableObject)job.bk.getPrintable(i + counter);
                                p.setPrintModus(job.printMode);
                                p.print(g, job.bk.getPageFormat(i + counter), i + counter);
                                ++i;
                            }
                            g.dispose();
                            counter += pageCnt;
                            if (PSEnvironment.DEBUG) {
                                System.out.println("totalCnt = " + totalCnt);
                                System.out.println("counter = " + counter);
                                System.out.println("pageCnt = " + pageCnt);
                            }
                            if (counter + pageCnt > totalCnt && (pageCnt = totalCnt - counter) <= 0) return;
                            fileName = String.valueOf(baseFileName) + "_" + PSEnvironment.Format(counter + 1, "0000") + "_" + PSEnvironment.Format(counter + pageCnt, "0000") + ".pdf";
                            System.out.println("calling init pdf, pageCnt = " + pageCnt);
                        } while (g.initPdf(orientation, pageCnt, fileName) && counter < totalCnt);
                    }
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        t.start();
        if (this.jobs.size() > 0) {
            this.jobs.remove(0);
        }
        this.actJob = null;
        if (this.progress != null) {
            this.progress.closeProgressDialog();
        }
    }

    private void commitMultiPDF(final PWPrintJob job) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    PrintableObject pOld = null;
                    PDFPrinterGraphics g = new PDFPrinterGraphics();
                    g.setPdfMultiDoc(true);
                    PageFormat format = job.bk.getPageFormat(0);
                    int orientation = format.getOrientation() == 0 ? 1 : 0;
                    int pageCnt = job.bk.getNumberOfPages();
                    if (g.initPdf(orientation, pageCnt)) {
                        boolean newSubDoc = false;
                        Class<?> c = null;
                        int cnt = -1;
                        int i = 0;
                        while (i < pageCnt) {
                            PrintableObject p = (PrintableObject)job.bk.getPrintable(i);
                            p.setPrintModus(job.printMode);
                            if (!p.getClass().equals(c)) {
                                if (pOld != null && pOld instanceof PrintPaletteNotification) {
                                    ((PrintPaletteNotification)pOld).endPrintJob();
                                }
                                cnt = 0;
                                c = p.getClass();
                            } else {
                                ++cnt;
                            }
                            p.print(g, job.bk.getPageFormat(i), cnt);
                            if (i + 1 < pageCnt) {
                                format = job.bk.getPageFormat(i + 1);
                                orientation = format.getOrientation() == 0 ? 1 : 0;
                                g.setPageOrientation(orientation);
                                g.NewPage();
                            }
                            pOld = p;
                            if (i == pageCnt - 1 && p instanceof PrintPaletteNotification) {
                                ((PrintPaletteNotification)p).endPrintJob();
                            }
                            ++i;
                        }
                        g.dispose();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        t.start();
        if (this.jobs.size() > 0) {
            this.jobs.remove(0);
        }
        this.actJob = null;
        if (this.progress != null) {
            this.progress.closeProgressDialog();
        }
    }

    private void initProgress(final Book bk) {
        this.progress = new VolumeProgressDialog(PSO.mainpanel, true, false, this.actJob.pageCnt, 100, false){

            @Override
            public void progressDialogStarted(ProgressEvent ppe) {
            }

            @Override
            public void progressDialogBroken(ProgressEvent ppe) {
            }

            @Override
            public void progressDialogChanged(ProgressEvent ppe) {
                if (!PSPrintControl.this.pdfMultiDoc) {
                    PSPrintControl.this.progress.setProgressValue(bk.getNumberOfPages() + 1);
                    PSPrintControl.this.progress.setProgressLabel("Seite " + (bk.getNumberOfPages() + 1) + " / " + ((PSPrintControl)PSPrintControl.this).actJob.pageCnt);
                } else {
                    PSPrintControl.this.progress.setProgressValue(((PSPrintControl)PSPrintControl.this).actJob.pageCntDone);
                    PSPrintControl.this.progress.setProgressLabel("Seite " + ((PSPrintControl)PSPrintControl.this).actJob.pageCntDone + " / " + ((PSPrintControl)PSPrintControl.this).actJob.pageCnt);
                }
                PSPrintControl.this.progress.showProgressDialog();
            }

            @Override
            public void progressDialogEndet(ProgressEvent ppe) {
            }
        };
        this.progress.setPureVolumeProgress(true);
        this.progress.setProgressTitle("Druckaufbereitung...");
        this.progress.setProgressLabel("Seite " + bk.getNumberOfPages() + " / " + this.actJob.pageCnt);
        this.progress.run();
        this.progress.setActionButtonVisible(false);
    }

    public void setPrintService(PrintService service) {
        this.printService = service;
    }

    public void setPrintToPdf(boolean flag) {
        this.printToPdf = flag;
    }

    public boolean getPrintToPdf() {
        return this.printToPdf;
    }

    public void setOpenPdf(boolean flag) {
        this.openPdf = flag;
    }

    public boolean getOpenPdf() {
        return this.openPdf;
    }

    public void setDruckEinfach(boolean value) {
        this.druckEinfach = value;
        if (value) {
            PSO.cc.SendMessage(48, "1");
        } else {
            PSO.cc.SendMessage(48, "0");
        }
    }

    public boolean isDruckEinfach() {
        return this.druckEinfach;
    }

    public boolean isDruckPaletteWithPLZ() {
        return this.druckPaletteWithPLZ;
    }

    public void setDruckPaletteWithPLZ(boolean b) {
        this.druckPaletteWithPLZ = b;
    }

    public void setPageCount(int cnt) {
        if (this.actJob != null) {
            this.actJob.pageCnt = cnt;
            if (this.progress != null) {
                this.progress.closeProgressDialog();
            }
            this.initProgress(this.actJob.bk);
        }
    }

    public String getPrinterName() {
        String result = "";
        if (this.printService != null) {
            result = this.printService.getName();
        }
        return result;
    }

    public void setResetPdfWhenIdle(boolean flag) {
        this.resetPdfWhenIdle = flag;
    }

    public boolean isAutoSplitEnabled() {
        return this.autoSplitPdf;
    }

    public void setAutoSplitEnabled(boolean flag) {
        this.autoSplitPdf = flag;
    }

    public class PWPrintJob {
        public int jobType;
        public int pageCnt;
        public int printMode;
        public boolean showPrintDlg = false;
        public PrinterJob printJob;
        public Book bk;
        public boolean isPdfMultiDoc = false;
        public int pageCntDone = 0;

        public PWPrintJob() {
            this.bk = new Book();
        }

        public PWPrintJob(Book multiJobBook) {
            this.isPdfMultiDoc = true;
            this.bk = multiJobBook;
        }

        public PrinterJob getPrintJob() {
            return this.printJob;
        }
    }
}

