/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.effect;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swinghelper.layer.JXLayer;
import org.jdesktop.swinghelper.layer.painter.ComponentPainter;
import org.jdesktop.swinghelper.layer.painter.model.BufferedPainterModel;
import prospektservice.PSO;

public class TabbedAnimatingChangeListener
implements ChangeListener {
    private int index;
    private Timer timer;
    private ComponentPainter<JComponent> painter;
    private float delta;
    private boolean updateMap = false;

    public TabbedAnimatingChangeListener(boolean doRefresh) {
        this(100, 0.1f, doRefresh);
    }

    public void setInitialIndex(int value) {
        this.index = value;
    }

    public TabbedAnimatingChangeListener(int delay, final float delta, boolean doRefresh) {
        this.updateMap = doRefresh;
        this.delta = delta;
        this.painter = new AnimationPainter();
        this.timer = new Timer(delay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedAnimatingChangeListener.this.painter.repaint();
                BufferedPainterModel model = TabbedAnimatingChangeListener.this.painter.getModel();
                if (model.getAlpha() <= delta) {
                    model.setAlpha(0.0f);
                    TabbedAnimatingChangeListener.this.timer.stop();
                    if (TabbedAnimatingChangeListener.this.updateMap) {
                        PSO.mainpanel.updateMapAfterTabSwitch();
                    }
                    return;
                }
                model.setAlpha(model.getAlpha() - delta);
            }
        });
    }

    public float getDelta() {
        return this.delta;
    }

    public boolean isAnimating() {
        return this.timer.isRunning();
    }

    public void setDelta(float delta) {
        if (delta <= 0.0f || delta > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.delta = delta;
    }

    public int getDelay() {
        return this.timer.getDelay();
    }

    public void setDelay(int delay) {
        this.timer.setDelay(delay);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JTabbedPane pane = (JTabbedPane)e.getSource();
        JXLayer layer = (JXLayer)pane.getSelectedComponent();
        JXLayer oldLayer = (JXLayer)pane.getComponentAt(this.index);
        BufferedPainterModel model = this.painter.getModel();
        model.setAlpha(1.0f - model.getAlpha());
        this.painter.setComponent((JComponent)oldLayer);
        oldLayer.setPainter(layer.getPainter());
        layer.setPainter(this.painter);
        this.painter.repaint();
        this.timer.start();
        this.index = pane.getSelectedIndex();
    }

    private class AnimationPainter
    extends ComponentPainter<JComponent> {
        public AnimationPainter() {
            this.getModel().setAlpha(0.0f);
        }

        public void paint(Graphics2D g2, JXLayer<JComponent> l) {
            l.paint((Graphics)g2);
            super.paint(g2, l);
        }
    }
}

