/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.base.PSImageIcon;
import prospektservice.printj2.PrintAZ;
import prospektservice.printj2.PrintPalette;

public class DlgFontSelection
extends JDialog {
    private static final long serialVersionUID = 3976734766030467640L;
    public static final int FONT_AZ = 0;
    public static final int FONT_PALETTE = 1;
    private static final int WIDTH = 450;
    private static final int HEIGTH = 300;
    private JPanel labelPanel;
    private JPanel listPanel;
    private JPanel previewPanel;
    private JPanel btnPanel;
    private JList lstFontNames;
    private JComboBox cmbFontSizes;
    private JTextArea txtPreview;
    private JButton btnItalic;
    private JButton btnBold;
    private JButton btnUnderline;
    private JButton btnCancel;
    private JButton btnOk;
    String[] fontSizes = new String[]{"2", "4", "6", "8", "10", "12", "14", "16", "18"};
    private Vector<Font> usedFonts = new Vector();
    private Font currentFont;
    private boolean boldSelected;
    private boolean italicSelected;
    private boolean underlineSelected;
    private Border defaultBtnBorder;
    private PSO pso;
    private ResourceBundle localProperty;
    private int freitextType = 0;

    public DlgFontSelection(Frame f, int fontTarget) {
        super(f, "Schriftauswahl", true);
        this.pso = (PSO)f;
        this.setLocationRelativeTo(this.pso);
        this.setSize(450, 2);
        this.setResizable(false);
        this.freitextType = fontTarget;
        this.localProperty = ResourceBundle.getBundle("properties.DlgFontSelection", PSEnvironment.getEnvironmentLanguage());
        this.listPanel = new JPanel();
        AbsoluteLayout al = new AbsoluteLayout();
        this.listPanel.setLayout(al);
        JLabel lblFontNames = new JLabel(this.localProperty.getString("lblFontType"));
        this.listPanel.add((Component)lblFontNames, new AbsoluteConstraints(10, 10, 100, 20));
        Font[] allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        DefaultListModel<String> lstModel = new DefaultListModel<String>();
        String lastFontName = "";
        int i = 0;
        while (i < allFonts.length) {
            if (!allFonts[i].getFamily().equals(lastFontName)) {
                lstModel.addElement(allFonts[i].getFontName());
                this.usedFonts.addElement(allFonts[i]);
            }
            lastFontName = allFonts[i].getFamily();
            ++i;
        }
        this.lstFontNames = new JList(lstModel);
        this.lstFontNames.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = DlgFontSelection.this.lstFontNames.getSelectedIndex();
                Font f = (Font)DlgFontSelection.this.usedFonts.elementAt(index);
                int newSize = DlgFontSelection.this.txtPreview.getFont().getSize();
                int style = DlgFontSelection.this.currentFont.getStyle();
                DlgFontSelection.this.currentFont = f.deriveFont(style, newSize);
                DlgFontSelection.this.txtPreview.setFont(DlgFontSelection.this.currentFont);
            }
        });
        JScrollPane listScrollView = new JScrollPane();
        listScrollView.getViewport().add(this.lstFontNames);
        this.listPanel.add((Component)listScrollView, new AbsoluteConstraints(10, 30, 200, 100));
        JLabel lblFontSizes = new JLabel(this.localProperty.getString("lblFontAttributes"));
        this.listPanel.add((Component)lblFontSizes, new AbsoluteConstraints(220, 10, 100, 20));
        this.cmbFontSizes = new JComboBox();
        this.cmbFontSizes.setEditable(true);
        this.cmbFontSizes.setModel(new DefaultComboBoxModel<String>(this.fontSizes));
        this.cmbFontSizes.setSelectedIndex(4);
        this.cmbFontSizes.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if (pce.getPropertyName().equals("ValueSet")) {
                    int newSize = Integer.parseInt(pce.getNewValue().toString());
                    DlgFontSelection.this.currentFont = DlgFontSelection.this.currentFont.deriveFont((float)newSize);
                    DlgFontSelection.this.txtPreview.setFont(DlgFontSelection.this.currentFont);
                }
            }
        });
        this.cmbFontSizes.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if ((e.getKeyChar() < '0' || e.getKeyChar() > '9') && e.getKeyChar() != '\b' && e.getKeyChar() != '\u007f') {
                    e.consume();
                }
            }
        });
        this.cmbFontSizes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    int newSize = PSEnvironment.getIntValue((String)DlgFontSelection.this.cmbFontSizes.getSelectedItem());
                    DlgFontSelection.this.currentFont = DlgFontSelection.this.currentFont.deriveFont((float)newSize);
                    DlgFontSelection.this.txtPreview.setFont(DlgFontSelection.this.currentFont);
                }
            }
        });
        this.listPanel.add((Component)this.cmbFontSizes, new AbsoluteConstraints(220, 30, 100, 25));
        this.btnBold = new JButton();
        this.btnBold.setIcon(new PSImageIcon("./images/bold.gif"));
        this.btnBold.setPreferredSize(new Dimension(24, 24));
        this.btnBold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DlgFontSelection.this.boldSelected) {
                    DlgFontSelection.this.currentFont = DlgFontSelection.this.currentFont.deriveFont(DlgFontSelection.this.currentFont.getStyle() | 1);
                    DlgFontSelection.this.boldSelected = true;
                    DlgFontSelection.this.btnBold.setBorder(BorderFactory.createLoweredBevelBorder());
                } else {
                    DlgFontSelection.this.currentFont = DlgFontSelection.this.currentFont.deriveFont(DlgFontSelection.this.currentFont.getStyle() & 0xFFFFFFFE);
                    DlgFontSelection.this.boldSelected = false;
                    DlgFontSelection.this.btnBold.setBorder(DlgFontSelection.this.defaultBtnBorder);
                }
                DlgFontSelection.this.txtPreview.setFont(DlgFontSelection.this.currentFont);
            }
        });
        this.listPanel.add((Component)this.btnBold, new AbsoluteConstraints(322, 30, 24, 24));
        this.defaultBtnBorder = this.btnBold.getBorder();
        this.btnItalic = new JButton();
        this.btnItalic.setIcon(new PSImageIcon("./images/italic.gif"));
        this.btnItalic.setPreferredSize(new Dimension(24, 24));
        this.btnItalic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DlgFontSelection.this.italicSelected) {
                    DlgFontSelection.this.currentFont = DlgFontSelection.this.currentFont.deriveFont(DlgFontSelection.this.currentFont.getStyle() | 2);
                    DlgFontSelection.this.italicSelected = true;
                    DlgFontSelection.this.btnItalic.setBorder(BorderFactory.createLoweredBevelBorder());
                } else {
                    DlgFontSelection.this.currentFont = DlgFontSelection.this.currentFont.deriveFont(DlgFontSelection.this.currentFont.getStyle() & 0xFFFFFFFD);
                    DlgFontSelection.this.italicSelected = false;
                    DlgFontSelection.this.btnItalic.setBorder(DlgFontSelection.this.defaultBtnBorder);
                }
                DlgFontSelection.this.txtPreview.setFont(DlgFontSelection.this.currentFont);
            }
        });
        this.listPanel.add((Component)this.btnItalic, new AbsoluteConstraints(347, 30, 24, 24));
        JLabel txtPdfHint = new JLabel(this.localProperty.getString("lblPdfHint"));
        this.listPanel.add((Component)txtPdfHint, new AbsoluteConstraints(220, 55, 220, 85));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.listPanel, "North");
        this.previewPanel = new JPanel();
        this.txtPreview = new JTextArea();
        this.txtPreview.setBorder(BorderFactory.createLoweredBevelBorder());
        this.txtPreview.setPreferredSize(new Dimension(430, 100));
        this.txtPreview.setLineWrap(true);
        this.txtPreview.setWrapStyleWord(true);
        this.txtPreview.setEditable(false);
        this.txtPreview.setText("Franz jagt im komplett verwahrlosten Taxi quer durch Bayern. 1234567890");
        this.previewPanel.add(this.txtPreview);
        this.getContentPane().add((Component)this.previewPanel, "Center");
        this.btnPanel = new JPanel();
        this.btnPanel.setLayout(new FlowLayout());
        this.btnOk = new JButton(this.localProperty.getString("btnOk"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DlgFontSelection.this.freitextType == 0) {
                    PrintAZ.setFreitextFont(DlgFontSelection.this.currentFont);
                    ((DlgFontSelection)DlgFontSelection.this).pso.DF.setAZFreitextFont(DlgFontSelection.this.currentFont);
                } else if (DlgFontSelection.this.freitextType == 1) {
                    PrintPalette.setFreitextFont(DlgFontSelection.this.currentFont);
                    ((DlgFontSelection)DlgFontSelection.this).pso.DF.setPaletteFreitextFont(DlgFontSelection.this.currentFont);
                }
                DlgFontSelection.this.dispose();
            }
        });
        this.btnPanel.add(this.btnOk);
        this.btnCancel = new JButton(this.localProperty.getString("btnCancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgFontSelection.this.dispose();
            }
        });
        this.btnPanel.add(this.btnCancel);
        this.getContentPane().add((Component)this.btnPanel, "South");
        this.pack();
        this.currentFont = this.txtPreview.getFont();
        if (this.freitextType == 0) {
            if (PrintAZ.getFreitextFont() != null) {
                this.restoreFontSetting(PrintAZ.getFreitextFont());
            }
        } else if (this.freitextType == 1 && PrintPalette.getFreitextFont() != null) {
            this.restoreFontSetting(PrintPalette.getFreitextFont());
        }
    }

    private void restoreFontSetting(Font f) {
        this.currentFont = f;
        String fontName = this.currentFont.getFontName();
        if (fontName.indexOf("Kursiv") > -1) {
            fontName = fontName.substring(0, fontName.indexOf("Kursiv")).trim();
        }
        if (fontName.indexOf("Fett") > -1) {
            fontName = fontName.substring(0, fontName.indexOf("Fett")).trim();
        }
        this.lstFontNames.setSelectedValue(fontName, true);
        String fontSize = String.valueOf(f.getSize());
        if (this.isPredefinedSize(fontSize)) {
            this.cmbFontSizes.setSelectedItem(fontSize);
        } else {
            this.cmbFontSizes.configureEditor(this.cmbFontSizes.getEditor(), fontSize);
            this.cmbFontSizes.firePropertyChange("ValueSet", (long)this.currentFont.getSize(), Long.valueOf(fontSize));
        }
        if (this.currentFont.isBold()) {
            this.boldSelected = true;
            this.btnBold.setBorder(BorderFactory.createLoweredBevelBorder());
        }
        if (this.currentFont.isItalic()) {
            this.italicSelected = true;
            this.btnItalic.setBorder(BorderFactory.createLoweredBevelBorder());
        }
        this.txtPreview.setFont(this.currentFont);
    }

    private boolean isPredefinedSize(String size) {
        boolean result = false;
        int i = 0;
        while (i < this.fontSizes.length) {
            if (this.fontSizes[i].equals(size)) {
                result = true;
            }
            ++i;
        }
        return result;
    }
}

