/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import prospektservice.Feedback;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;

public class DlgBicSearch
extends JDialog {
    private static final long serialVersionUID = 8971936515392779119L;
    private JTextField txtBLZ;
    private JTable tblResults;
    private DefaultTableModel dtm;
    private ResourceBundle localProperty;

    public DlgBicSearch() {
        this.setModal(true);
        this.setResizable(false);
        this.setSize(new Dimension(450, 400));
        this.setLocationRelativeTo(PSO.mainpanel);
        this.localProperty = ResourceBundle.getBundle("properties.DlgBicSearch", PSUser.getLanguage());
        this.setTitle(this.localProperty.getString("dlgTitle"));
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new BorderLayout());
        JLabel lblDesc = new JLabel(this.localProperty.getString("lblDesc"));
        searchPanel.add((Component)lblDesc, "North");
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new FlowLayout(1));
        JLabel lblBLZ = new JLabel(this.localProperty.getString("lblBLZ"));
        inputPanel.add(lblBLZ);
        this.txtBLZ = new JTextField();
        this.txtBLZ.setPreferredSize(new Dimension(100, 20));
        this.txtBLZ.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (!PSEnvironment.isNumeric(e.getKeyChar()) || DlgBicSearch.this.txtBLZ.getText().length() >= 8) {
                    e.consume();
                }
            }
        });
        inputPanel.add(this.txtBLZ);
        JButton btnSearch = new JButton(this.localProperty.getString("btnSearch"));
        this.getRootPane().setDefaultButton(btnSearch);
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String blz = DlgBicSearch.this.txtBLZ.getText();
                if (blz.length() == 8) {
                    DlgBicSearch.this.dtm.setRowCount(0);
                    PSO.cc.SendMessage(382, blz);
                }
            }
        });
        inputPanel.add(btnSearch);
        searchPanel.add((Component)inputPanel, "Center");
        Vector<String> headers = new Vector<String>();
        headers.add("Kreditinstitut");
        headers.add("PLZ");
        headers.add("Ort");
        headers.add("BIC");
        this.dtm = new DefaultTableModel(){
            private static final long serialVersionUID = 1010476947563076491L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.dtm.setColumnIdentifiers(headers);
        this.tblResults = new JTable(this.dtm);
        this.tblResults.setPreferredSize(new Dimension(400, 250));
        JScrollPane tableScrollPane = new JScrollPane();
        tableScrollPane.setViewportView(this.tblResults);
        this.tblResults.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DlgBicSearch.this.applyResult();
                }
            }
        });
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(1));
        JButton btnOk = new JButton(this.localProperty.getString("btnOk"));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBicSearch.this.applyResult();
            }
        });
        btnPanel.add(btnOk);
        JButton btnCancel = new JButton(this.localProperty.getString("btnCancel"));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgBicSearch.this.dispose();
            }
        });
        btnPanel.add(btnCancel);
        this.getContentPane().add((Component)searchPanel, "North");
        this.getContentPane().add((Component)tableScrollPane, "Center");
        this.getContentPane().add((Component)btnPanel, "South");
    }

    public void setSearchResponse(String data) {
        if (data.trim().length() > 0) {
            String[] rows = data.split("\\|");
            int i = 0;
            while (i < rows.length) {
                Object[] rowData = rows[i].split(";");
                this.dtm.addRow(rowData);
                ++i;
            }
        } else {
            Feedback.showMessage((Component)this, this.localProperty.getString("msgTitle"), this.localProperty.getString("msgText"));
        }
    }

    private void applyResult() {
        int rowIndex = 0;
        if (this.dtm.getRowCount() > 1) {
            rowIndex = this.tblResults.getSelectedRow();
        }
        String bic = (String)this.dtm.getValueAt(rowIndex, 3);
        PSO.mainpanel.AE.txtAbsender_BIC.setText(bic);
        String bank = (String)this.dtm.getValueAt(rowIndex, 0);
        PSO.mainpanel.AE.txtAbsender_Geldinstitut.setText(bank);
        this.dispose();
    }
}

