/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.datamodels;

import java.io.StringReader;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.datamodels.PsoTableModel;

public class TableDetail
extends PsoTableModel {
    private static final long serialVersionUID = 3689913972392604977L;
    private DOMParser parser = new DOMParser();
    private boolean detailKomplett = false;
    private boolean detailEA = false;

    public void initColumnNames() {
        switch (PSO.Modus) {
            case 3: {
                this.setDbHeader(PSO.TableDetailZSP);
                break;
            }
            case 4: {
                this.setDbHeader(PSO.TableDetailBFAH);
                break;
            }
            case 0: 
            case 1: {
                if (this.detailEA) {
                    this.setDbHeader(PSO.TableDetailEASelektion);
                    break;
                }
                if (this.detailKomplett) {
                    this.setDbHeader(PSO.TableDetailOrteKpl);
                    break;
                }
                this.setDbHeader(PSO.TableDetailOrte);
                break;
            }
            case 5: {
                this.setDbHeader(PSO.TableDetailZBN);
            }
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        int n;
        switch (PSO.Modus) {
            case 3: {
                if (col != 3 || super.getValueAt(row, col).equals("c/f")) break;
                return super.getValueAt(row, 0) + " " + super.getValueAt(row, 3);
            }
            case 4: {
                if (col != 2 || super.getValueAt(row, col).equals("c/f")) break;
                return super.getValueAt(row, 0) + " " + super.getValueAt(row, 2);
            }
            case 0: 
            case 5: {
                if (this.detailEA) {
                    if (super.getValueAt(row, col).equals("false")) {
                        return "";
                    }
                    if (super.getValueAt(row, col).equals("true")) {
                        return "X";
                    }
                    if (col != 3 || super.getValueAt(row, col).equals("c/f")) break;
                    return (super.getValueAt(row, 3) + " " + super.getValueAt(row, 5)).trim();
                }
                if (!(this.detailKomplett || col != 0 || super.getValueAt(row, col).equals("c/f") || super.getValueAt(row, 7).equals("c/f") || super.getValueAt(row, 7).toString().trim().length() <= 0)) {
                    return super.getValueAt(row, 7) + " - " + super.getValueAt(row, 0);
                }
                if (col != 5 || super.getValueAt(row, col).equals("c/f")) break;
                return (super.getValueAt(row, 5) + " " + super.getValueAt(row, 6)).trim();
            }
        }
        String result = (String)super.getValueAt(row, col);
        if (!result.equals("c/f")) {
            return result;
        }
        if (row == this.lastFetchedRow[0] || row > this.lastFetchedRow[0] && row < this.lastFetchedRow[0] + this.BLOCK_SIZE && this.lastFetchedRow[0] > -1 || row == this.lastFetchedRow[1] || row > this.lastFetchedRow[1] && row < this.lastFetchedRow[1] + this.BLOCK_SIZE && this.lastFetchedRow[1] > -1) {
            return "c/f";
        }
        int rowToGet = this.optimizeRequest(row);
        PSO.cc.SendMessage(275, String.valueOf(rowToGet + 1) + "+" + this.BLOCK_SIZE);
        if (this.lastRowIndex == 0) {
            int n2 = this.lastRowIndex;
            n = n2;
            this.lastRowIndex = n2 + 1;
        } else {
            int n3 = this.lastRowIndex;
            n = n3;
            this.lastRowIndex = n3 - 1;
        }
        this.lastFetchedRow[n] = rowToGet;
        return "n/a";
    }

    public void setData(String Data) {
        try {
            this.parser.parse(new InputSource(new StringReader(Data)));
            Document doc = this.parser.getDocument();
            if (PSEnvironment.DEBUG) {
                System.out.println("passing Doc to model...");
            }
            super.setData(doc);
        }
        catch (SAXParseException Ex) {
            if (PSEnvironment.DEBUG) {
                if (PSEnvironment.DEBUG) {
                    System.out.println(Ex.getLineNumber());
                }
                Ex.printStackTrace();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDetailKpl(boolean flag) {
        this.detailKomplett = flag;
        this.workDoc = null;
        this.cachDoc = null;
        this.initColumnNames();
    }

    public void setDetailEA(boolean flag) {
        this.detailEA = flag;
        this.workDoc = null;
        this.cachDoc = null;
        this.initColumnNames();
    }
}

