/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base.progress;

import java.awt.Cursor;
import javax.swing.JProgressBar;
import prospektservice.base.progress.ProgressPanel;

public class VolumeProgressPanel
extends ProgressPanel {
    private static final long serialVersionUID = 4121138034625624375L;
    private boolean isPureVolumeProgress = false;

    public VolumeProgressPanel(int maxValue) {
        super(maxValue, 1000, true);
        this.initVolumeProgressPanel();
    }

    public VolumeProgressPanel(int maxValue, int stepMillisecondDuration) {
        super(maxValue, stepMillisecondDuration, true);
        this.initVolumeProgressPanel();
    }

    public VolumeProgressPanel(int maxValue, int stepMillisecondDuration, boolean isMessagesVisible) {
        super(maxValue, stepMillisecondDuration, isMessagesVisible);
        this.initVolumeProgressPanel();
    }

    public void changeProgressStepDuration(int millisecondsDuration) {
        if (millisecondsDuration != this.progressStepDuration) {
            this.progressStepDuration = millisecondsDuration;
            this.remainSecondsDuration = (this.currentProgressMaximum - this.progressBar.getValue()) * millisecondsDuration / 1000;
            this.startProgressTimer();
            this.fireProgressEvent(106);
        }
    }

    public void restartVolumeProgress(int lastStepMillisecondsDuration) {
        this.ppInstance.setCursor(Cursor.getPredefinedCursor(3));
        this.currentProgressMaximum += lastStepMillisecondsDuration / this.progressStepDuration;
        this.progressBar.setMaximum(this.currentProgressMaximum);
        this.progressStepDuration = lastStepMillisecondsDuration;
        this.remainSecondsDuration = lastStepMillisecondsDuration <= 0 ? 0 : (lastStepMillisecondsDuration < 1000 ? 1 : lastStepMillisecondsDuration / 1000);
        this.progressBar.repaint();
        this.refreshProgressMessages();
        this.restartProgress();
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setPureVolumeProgress(boolean flag) {
        this.isPureVolumeProgress = flag;
    }

    public boolean isPureVolumeProgress() {
        return this.isPureVolumeProgress;
    }

    @Override
    protected void changeProgressValue() {
        if (this.isPureVolumeProgress) {
            this.fireProgressEvent(102);
        } else {
            super.changeProgressValue();
        }
    }

    private void initVolumeProgressPanel() {
        this.remainSecondsDuration = this.currentProgressMaximum * this.progressStepDuration / 1000;
        if (this.isProgressMessagesVisible) {
            this.refreshProgressMessages();
        }
        this.ppInstance = this;
    }
}

