/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base.progress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import prospektservice.PSUser;
import prospektservice.base.PamDialog;
import prospektservice.base.progress.ProgressAdapter;
import prospektservice.base.progress.ProgressEvent;
import prospektservice.base.progress.ProgressListener;
import prospektservice.base.progress.ProgressPanel;

public abstract class ProgressDialog
extends Thread {
    private Frame parentFrame;
    public static boolean debugMessageEnabled = true;
    protected static ResourceBundle localProperty;
    private static int dlgWidthToScreen;
    private static int dlgHeghtToScreen;
    private static int dlgBorderWidth;
    private static int dlgBorderHeight;
    protected boolean AUTO_START = true;
    protected boolean AUTO_CLOSE = true;
    protected JDialog prgDialog;
    private JLabel progressLabel;
    protected JPanel progressPanel;
    protected ProgressPanel workProgressPanel;
    protected ProgressListener workProgressListener;
    protected JPanel actionPanel;
    protected JButton actionButton;
    public static final Component horizSpaceBox;
    public static final Component vertiSpaceBox;

    static {
        dlgWidthToScreen = 3;
        dlgHeghtToScreen = 3;
        dlgBorderWidth = 5;
        dlgBorderHeight = 5;
        horizSpaceBox = Box.createRigidArea(new Dimension(40, 20));
        vertiSpaceBox = Box.createRigidArea(new Dimension(20, 40));
    }

    public ProgressDialog(JFrame parentFrame, boolean isAutoClose, boolean isAutoStop) {
        this.AUTO_START = isAutoClose;
        this.AUTO_CLOSE = isAutoStop;
        localProperty = ResourceBundle.getBundle("properties.ProgressDialog", PSUser.getLanguage());
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension prgDialogDim = new Dimension(screenDim.width / dlgWidthToScreen, screenDim.height / dlgHeghtToScreen);
        int dlgPanelsWidth = prgDialogDim.width - 2 * dlgBorderWidth;
        int charHeight = parentFrame.getFontMetrics(parentFrame.getFont()).getHeight();
        Window[] children = parentFrame.getOwnedWindows();
        int i = 0;
        while (i < children.length) {
            JDialog dlg;
            Window actWnd = children[i];
            if (actWnd instanceof JDialog && (dlg = (JDialog)actWnd).isFocused()) {
                this.prgDialog = new PamDialog(dlg, false);
                break;
            }
            ++i;
        }
        if (this.prgDialog == null) {
            this.prgDialog = new PamDialog((Frame)parentFrame, false);
        }
        this.prgDialog.getContentPane().setLayout(new BorderLayout());
        this.prgDialog.setSize(prgDialogDim);
        this.prgDialog.setResizable(false);
        this.prgDialog.setAlwaysOnTop(true);
        this.prgDialog.setDefaultCloseOperation(0);
        JPanel labelPanel = new JPanel(new FlowLayout(1));
        labelPanel.setBorder(BorderFactory.createEmptyBorder(dlgBorderWidth, dlgBorderWidth, dlgBorderWidth, dlgBorderWidth));
        Dimension labelPanelDim = new Dimension(dlgPanelsWidth, charHeight + 10);
        labelPanel.setSize(labelPanelDim);
        this.progressPanel = new JPanel(new FlowLayout(1));
        this.progressPanel.setBorder(BorderFactory.createEmptyBorder(dlgBorderWidth, dlgBorderWidth, dlgBorderWidth, dlgBorderWidth));
        this.actionPanel = new JPanel(new FlowLayout(1));
        this.actionPanel.setBorder(BorderFactory.createEmptyBorder(dlgBorderWidth, dlgBorderWidth, dlgBorderWidth, dlgBorderWidth));
        this.prgDialog.getContentPane().add((Component)labelPanel, "North");
        this.prgDialog.getContentPane().add((Component)this.progressPanel, "Center");
        this.prgDialog.getContentPane().add((Component)this.actionPanel, "South");
        this.progressLabel = new JLabel(localProperty.getString("ProgressLabelText"));
        this.progressLabel.setAlignmentX(0.5f);
        labelPanel.add(this.progressLabel);
        this.workProgressListener = new ProgressAdapter(){

            @Override
            public void progressStarted(ProgressEvent ppe) {
                ProgressDialog.this.printDebugMessage("progressStarted", "progressStartedValue=" + ppe.getProgressValue());
                ProgressDialog.this.actionButton.setText(localProperty.getString("BreakButtonText"));
                ProgressDialog.this.actionButton.setActionCommand(localProperty.getString("BreakButtonText"));
                ProgressDialog.this.setActionButtonVisible(true);
                ProgressDialog.this.progressDialogStarted(ppe);
            }

            @Override
            public void progressBroken(ProgressEvent ppe) {
                ProgressDialog.this.printDebugMessage("progressBroken", "progressBrokenValue=" + ppe.getProgressValue());
                ProgressDialog.this.actionButton.setText(localProperty.getString("RestartButtonText"));
                ProgressDialog.this.actionButton.setActionCommand(localProperty.getString("RestartButtonText"));
                if (!ProgressDialog.this.AUTO_CLOSE) {
                    ProgressDialog.this.setActionButtonVisible(ProgressDialog.this.actionButton.isVisible());
                }
                ProgressDialog.this.progressDialogBroken(ppe);
                if (ProgressDialog.this.AUTO_CLOSE) {
                    ProgressDialog.this.closeAll();
                }
            }

            @Override
            public void progressChanged(ProgressEvent ppe) {
                ProgressDialog.this.printDebugMessage("progressChanged", "progressChangedValue=" + ppe.getProgressValue());
                ProgressDialog.this.progressDialogChanged(ppe);
            }

            @Override
            public void progressEndet(ProgressEvent ppe) {
                ProgressDialog.this.printDebugMessage("progressEndet", "progressEndetValue=" + ppe.getProgressValue());
                ProgressDialog.this.actionButton.setText(localProperty.getString("StopButtonText"));
                ProgressDialog.this.actionButton.setActionCommand(localProperty.getString("StopButtonText"));
                if (!ProgressDialog.this.AUTO_CLOSE) {
                    ProgressDialog.this.setActionButtonVisible(ProgressDialog.this.actionButton.isVisible());
                }
                ProgressDialog.this.progressDialogEndet(ppe);
                if (ProgressDialog.this.AUTO_CLOSE) {
                    ProgressDialog.this.closeAll();
                }
            }
        };
        this.actionButton = new JButton(localProperty.getString("StartButtonText"));
        this.actionButton.setActionCommand(localProperty.getString("StartButtonText"));
        this.actionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(localProperty.getString("StartButtonText"))) {
                    ProgressDialog.this.workProgressPanel.startProgress();
                } else if (e.getActionCommand().equals(localProperty.getString("BreakButtonText"))) {
                    ProgressDialog.this.workProgressPanel.breakProgress();
                } else if (e.getActionCommand().equals(localProperty.getString("RestartButtonText"))) {
                    ProgressDialog.this.workProgressPanel.restartProgress();
                } else if (e.getActionCommand().equals(localProperty.getString("StopButtonText"))) {
                    ProgressDialog.this.closeAll();
                }
            }
        });
        this.actionButton.setVisible(true);
        this.actionPanel.add(this.actionButton);
    }

    @Override
    public void run() {
        this.prgDialog.setVisible(true);
        if (this.AUTO_START) {
            this.workProgressPanel.startProgress();
        }
    }

    public void showProgressDialog() {
        this.prgDialog.setVisible(true);
    }

    public void printDebugMessage(String methodName, String message) {
        if (debugMessageEnabled) {
            System.out.println(String.valueOf(this.getClass().getName()) + "." + methodName + "{} ==> " + message);
        }
    }

    public void setProgressTitle(String newTitle) {
        this.prgDialog.setTitle(newTitle);
        this.prgDialog.repaint();
    }

    public void setProgressLabel(String newContent) {
        this.progressLabel.setText(newContent);
        this.prgDialog.repaint();
    }

    public String getProgressLabel() {
        return this.progressLabel.getText();
    }

    public void setActionButtonVisible(boolean isVisible) {
        this.actionButton.setVisible(isVisible);
        this.prgDialog.repaint();
    }

    public void setActionButtonText(int idText) {
        switch (idText) {
            case 1: {
                this.actionButton.setText(localProperty.getString("StartButtonText"));
                break;
            }
            case 2: {
                this.actionButton.setText(localProperty.getString("BreakButtonText"));
                break;
            }
            case 3: {
                this.actionButton.setText(localProperty.getString("RestartButtonText"));
                break;
            }
            case 4: {
                this.actionButton.setText(localProperty.getString("StopButtonText"));
                break;
            }
            default: {
                this.actionButton.setText(localProperty.getString("StartButtonText"));
            }
        }
    }

    public void closeProgressDialog() {
        this.AUTO_CLOSE = true;
        this.workProgressPanel.endProgress();
    }

    private void closeAll() {
        this.printDebugMessage("closeAll", "ProgressDialog  dispose ... ");
        try {
            this.interrupt();
            this.workProgressPanel.finalize();
            this.workProgressListener = null;
            this.prgDialog.setVisible(false);
            this.prgDialog.dispose();
            this.finalize();
        }
        catch (Throwable trw) {
            this.printDebugMessage("dispose", trw.getMessage());
        }
    }

    public abstract void progressDialogStarted(ProgressEvent var1);

    public abstract void progressDialogBroken(ProgressEvent var1);

    public abstract void progressDialogChanged(ProgressEvent var1);

    public abstract void progressDialogEndet(ProgressEvent var1);
}

