/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.base;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.SoftBevelBorder;
import prospektservice.PSEnvironment;

public class TBJButton
extends JButton {
    private static final long serialVersionUID = 3258415014871185204L;
    public static final int POPUP_ITEMS_DEFAULT = 0;
    public static final int POPUP_ITEMS_RADIO = 1;
    public static final int POPUP_ITEMS_CHECKBOX = 2;
    private String label = "";
    private boolean TextVisible = false;
    private Border brdOver = new SoftBevelBorder(0);
    private Border brdPressed = new SoftBevelBorder(1);
    private JPopupMenu popupMenu;
    private boolean isMenuButton = false;

    public TBJButton(Icon icNorm, Icon icOver) {
        super(icNorm);
        this.setFont((Font)UIManager.get("TBJButton.font"));
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.setRolloverEnabled(true);
        this.setFocusPainted(false);
        this.setPreferredSize(new Dimension(32, 32));
        if (PSEnvironment.isMacOSPlatform()) {
            this.setBorderPainted(false);
        }
        this.setRolloverIcon(icOver);
        this.setPressedIcon(icOver);
    }

    public boolean isTextVisible() {
        return this.TextVisible;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        int id = e.getID();
        switch (id) {
            case 505: {
                if (!PSEnvironment.isMacOSPlatform()) break;
                this.setBorderPainted(false);
                break;
            }
            case 504: {
                if (!this.isEnabled() || !PSEnvironment.isMacOSPlatform()) break;
                this.setBorder(this.brdOver);
                break;
            }
            case 501: {
                if (!this.isEnabled() || !this.isMenuButton) break;
                this.popupMenu.show(this, 0, this.getHeight());
                break;
            }
        }
    }

    public void setPressedBorder(Border value) {
        this.brdPressed = value;
        this.repaint();
    }

    public void setRolloverBorder(Border value) {
        this.brdOver = value;
        this.repaint();
    }

    @Override
    public void setText(String value) {
        this.label = value;
        if (this.TextVisible) {
            super.setText(value);
        }
    }

    public void setTextVisible(boolean value) {
        this.TextVisible = value;
        if (this.TextVisible) {
            super.setText(this.label);
            this.setPreferredSize(new Dimension(70, 50));
        } else {
            super.setText("");
            this.setPreferredSize(new Dimension(32, 32));
        }
    }

    public void setMenu(String[] menuItems, String[] menuActions, int type) {
        this.isMenuButton = true;
        this.popupMenu = new JPopupMenu();
        switch (type) {
            case 0: {
                int i = 0;
                while (i < menuItems.length) {
                    JMenuItem mi = new JMenuItem(menuItems[i]);
                    mi.setActionCommand(menuActions[i]);
                    this.popupMenu.add(menuItems[i]);
                    ++i;
                }
                break;
            }
            case 1: {
                ButtonGroup bg = new ButtonGroup();
                int i = 0;
                while (i < menuItems.length) {
                    JRadioButtonMenuItem mi = new JRadioButtonMenuItem(menuItems[i]);
                    mi.setActionCommand(menuActions[i]);
                    bg.add(mi);
                    this.popupMenu.add(mi);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < menuItems.length) {
                    JCheckBoxMenuItem mi = new JCheckBoxMenuItem(menuItems[i]);
                    mi.setActionCommand(menuActions[i]);
                    this.popupMenu.add(mi);
                    ++i;
                }
                break;
            }
        }
    }

    public void setMenuItemListener(ActionListener al) {
        int i = 0;
        while (i < this.popupMenu.getComponentCount()) {
            JMenuItem mi = (JMenuItem)this.popupMenu.getComponent(i);
            mi.addActionListener(al);
            ++i;
        }
    }

    public void setIcons(ImageIcon iconNormal, ImageIcon iconHot) {
        this.setIcon(iconNormal);
        this.setRolloverIcon(iconHot);
    }
}

