/*
 * Decompiled with CFR 0.152.
 */
package de.codesolutions.pam.map;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.awt.Color;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import prospektservice.AKManager;
import prospektservice.PSEnvironment;
import prospektservice.definitions.DefAKcolors;

public class ScriptBuilder {
    private static final String alpha = "0.45";
    private static final String rgba = "'rgba(";
    private static final String rgbaEnd = ")'";
    private static Map<Integer, String> visualizationData;

    public static void init() {
        visualizationData = new HashMap<Integer, String>();
        visualizationData.put(2, ScriptBuilder.prepareDataVisualization(2));
        visualizationData.put(3, ScriptBuilder.prepareDataVisualization(3));
    }

    public static String getZoomToAreaScript(Point pt, double zoom) {
        System.out.println("x:" + pt.getX());
        System.out.println("y:" + pt.getY());
        String result = "viewObj.setCenter(transform([" + pt.getX() + ", " + pt.getY() + "], 'EPSG:4326', 'EPSG:3857'));viewObj.setZoom(" + zoom + ");";
        return result;
    }

    public static String getRestoreViewScript(Point pt, double zoom) {
        String result = "mapObj.getView().setCenter([" + pt.getX() + ", " + pt.getY() + "]);viewObj.setZoom(" + zoom + ");";
        return result;
    }

    public static String getViewExtentScript(Geometry g) {
        String result = "viewObj.fit(WKTReader.readGeometry('" + g.toText() + "', {dataProjection: 'EPSG:4326',featureProjection: 'EPSG:3857'}));";
        return result;
    }

    public static String getDataVisualizationScript(int id) {
        return visualizationData.get(id);
    }

    public static void updateColorTable(int id, DefAKcolors colors) {
        String oldVal = visualizationData.get(id);
        String newVal = oldVal.substring(0, oldVal.indexOf("var classes = ["));
        newVal = String.valueOf(newVal) + "var classes = [";
        int i = 0;
        while (i < 10) {
            String actColor = "";
            Color c = i < 5 ? colors.unselected.elementAt(i) : colors.selected.elementAt(i - 5);
            actColor = String.valueOf(c.getRed()) + "," + c.getGreen() + "," + c.getBlue();
            newVal = String.valueOf(newVal) + rgba + actColor + "," + alpha + rgbaEnd;
            if (i < 9) {
                newVal = String.valueOf(newVal) + ",";
            }
            ++i;
        }
        newVal = String.valueOf(newVal) + "];";
        newVal = String.valueOf(newVal) + "setAreaColorTable(table,classes);";
        visualizationData.put(id, newVal);
    }

    private static String prepareDataVisualization(int id) {
        String result = String.valueOf(ScriptBuilder.createDataTable(id)) + ScriptBuilder.createColorTable(id);
        result = String.valueOf(result) + "setAreaColorTable(table,classes);";
        return result;
    }

    private static String createDataTable(int id) {
        String result = "var table = {";
        Hashtable<String, Integer> akData = AKManager.dataLoad(id);
        Set<Map.Entry<String, Integer>> dataSet = akData.entrySet();
        Iterator<Map.Entry<String, Integer>> iter = dataSet.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Integer> pair = iter.next();
            result = String.valueOf(result) + "'" + pair.getKey() + "': " + pair.getValue();
            if (!iter.hasNext()) continue;
            result = String.valueOf(result) + ",";
        }
        result = String.valueOf(result) + "};";
        return result;
    }

    private static String createColorTableOld() {
        String result = "var classes = [";
        int i = 1;
        while (i < 11) {
            String sel = i < 6 ? ".NotSelected" : ".Selected";
            String index = i < 6 ? "" + i : "" + (i - 5);
            String actColor = PSEnvironment.getPSClientProperty("PS.MapColor.Slot" + index + sel);
            result = String.valueOf(result) + rgba + actColor + "," + alpha + rgbaEnd;
            if (i < 10) {
                result = String.valueOf(result) + ",";
            }
            ++i;
        }
        result = String.valueOf(result) + "];";
        return result;
    }

    private static String createColorTable(int id) {
        AKManager.AKload(id, 0);
        DefAKcolors colors = AKManager.getAKcolors();
        String result = "var classes = [";
        int i = 0;
        while (i < 10) {
            String actColor = "";
            Color c = i < 5 ? colors.unselected.elementAt(i) : colors.selected.elementAt(i - 5);
            actColor = String.valueOf(c.getRed()) + "," + c.getGreen() + "," + c.getBlue();
            result = String.valueOf(result) + rgba + actColor + "," + alpha + rgbaEnd;
            if (i < 9) {
                result = String.valueOf(result) + ",";
            }
            ++i;
        }
        result = String.valueOf(result) + "];";
        return result;
    }
}

