/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.awt.RuntimeOptions;
import apple.laf.JRSUIControl;
import com.apple.laf.AquaButtonBorder;
import com.apple.laf.AquaIcon;
import com.apple.laf.AquaImageFactory;
import com.apple.laf.AquaKeyBindings;
import com.apple.laf.AquaMenuBarBorder;
import com.apple.laf.AquaMenuBorder;
import com.apple.laf.AquaMnemonicHandler;
import com.apple.laf.AquaTableHeaderBorder;
import com.apple.laf.AquaUtils;
import com.apple.laf.ScreenPopupFactory;
import com.apple.resources.MacOSXResourceBundle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.PopupFactory;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import sun.security.action.LoadLibraryAction;
import sun.swing.SwingLazyValue;

public class AquaLookAndFeel
extends BasicLookAndFeel {
    static final String sOldPropertyPrefix = "com.apple.macos.";
    static final String sPropertyPrefix = "apple.laf.";
    private static final String PKG_PREFIX = "com.apple.laf.";
    private static final String kAquaImageFactoryName = "com.apple.laf.AquaImageFactory";
    private static final String kAquaFontsName = "com.apple.laf.AquaFonts";
    private int fOldAntiAliasingHint = 0;

    @Override
    public String getName() {
        return "Mac OS X";
    }

    @Override
    public String getID() {
        return "Aqua";
    }

    @Override
    public String getDescription() {
        return "Aqua Look and Feel for Mac OS X";
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return false;
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return true;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public void initialize() {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                JRSUIControl.initJRSUI();
                return null;
            }
        });
        super.initialize();
        ScreenPopupFactory screenPopupFactory = new ScreenPopupFactory();
        screenPopupFactory.setActive(true);
        PopupFactory.setSharedInstance(screenPopupFactory);
        this.fOldAntiAliasingHint = RuntimeOptions.getTextAntialiasing();
        if (this.fOldAntiAliasingHint == 0) {
            RuntimeOptions.setTextAntialiasing(2);
        }
        RuntimeOptions.getCurrentOptions().optionsUpdated();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(AquaMnemonicHandler.getInstance());
    }

    @Override
    public void uninitialize() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(AquaMnemonicHandler.getInstance());
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        if (popupFactory != null && popupFactory instanceof ScreenPopupFactory) {
            ((ScreenPopupFactory)popupFactory).setActive(false);
        }
        RuntimeOptions.setTextAntialiasing(this.fOldAntiAliasingHint);
        RuntimeOptions.getCurrentOptions().optionsUpdated();
        super.uninitialize();
    }

    @Override
    protected ActionMap getAudioActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("AuditoryCues.actionMap");
        if (actionMap != null) {
            return actionMap;
        }
        Object[] objectArray = (Object[])UIManager.get("AuditoryCues.cueList");
        if (objectArray != null) {
            actionMap = new ActionMapUIResource();
            for (int i = objectArray.length - 1; i >= 0; --i) {
                actionMap.put(objectArray[i], this.createAudioAction(objectArray[i]));
            }
        }
        UIManager.getLookAndFeelDefaults().put("AuditoryCues.actionMap", actionMap);
        return actionMap;
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults uIDefaults = new UIDefaults();
        try {
            this.initClassDefaults(uIDefaults);
            super.initSystemColorDefaults(uIDefaults);
            super.initComponentDefaults(uIDefaults);
            this.initSystemColorDefaults(uIDefaults);
            this.initComponentDefaults(uIDefaults);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return uIDefaults;
    }

    private void initResourceBundle(UIDefaults uIDefaults) {
        uIDefaults.setDefaultLocale(Locale.getDefault());
        try {
            ResourceBundle resourceBundle = MacOSXResourceBundle.getMacResourceBundle("com.apple.laf.resources.aqua");
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                uIDefaults.put(string, resourceBundle.getString(string));
            }
        }
        catch (Exception exception) {
            uIDefaults.addResourceBundle("com.apple.laf.resources.aqua");
        }
    }

    @Override
    protected void initComponentDefaults(UIDefaults uIDefaults) {
        Color color;
        InsetsUIResource insetsUIResource;
        this.initResourceBundle(uIDefaults);
        InsetsUIResource insetsUIResource2 = insetsUIResource = new InsetsUIResource(0, 0, 0, 0);
        Boolean bl = Boolean.TRUE;
        Boolean bl2 = AquaUtils.shouldUseOpaqueButtons() ? Boolean.TRUE : Boolean.FALSE;
        UIDefaults.ActiveValue activeValue = new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults uIDefaults) {
                return new DefaultListCellRenderer.UIResource();
            }
        };
        BorderUIResource.EmptyBorderUIResource emptyBorderUIResource = new BorderUIResource.EmptyBorderUIResource(2, 0, 2, 0);
        ColorUIResource colorUIResource = new ColorUIResource(255, 255, 204);
        ColorUIResource colorUIResource2 = new ColorUIResource(Color.black);
        ColorUIResource colorUIResource3 = new ColorUIResource(Color.white);
        ColorUIResource colorUIResource4 = new ColorUIResource(0.5f, 0.5f, 0.5f);
        ColorUIResource colorUIResource5 = new ColorUIResource(0.25f, 0.25f, 0.25f);
        ColorUIResource colorUIResource6 = new ColorUIResource(1.0f, 0.4f, 0.4f);
        SwingLazyValue swingLazyValue = new SwingLazyValue("javax.swing.plaf.basic.BasicBorders$MarginBorder");
        Integer n = new Integer(0);
        InsetsUIResource insetsUIResource3 = insetsUIResource;
        Integer n2 = new Integer(500);
        SwingLazyValue swingLazyValue2 = new SwingLazyValue("com.apple.laf.AquaTextFieldBorder", "getTextFieldBorder");
        SwingLazyValue swingLazyValue3 = swingLazyValue;
        SwingLazyValue swingLazyValue4 = new SwingLazyValue("com.apple.laf.AquaScrollRegionBorder", "getScrollRegionBorder");
        SwingLazyValue swingLazyValue5 = new SwingLazyValue("com.apple.laf.AquaGroupBorder", "getBorderForTitledBorder");
        SwingLazyValue swingLazyValue6 = new SwingLazyValue("com.apple.laf.AquaGroupBorder", "getTitlelessBorder");
        AquaTableHeaderBorder aquaTableHeaderBorder = AquaTableHeaderBorder.getListHeaderBorder();
        BorderUIResource.EmptyBorderUIResource emptyBorderUIResource2 = new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0);
        Color color2 = AquaImageFactory.getSelectionBackgroundColorUIResource();
        Color color3 = AquaImageFactory.getSelectionForegroundColorUIResource();
        Color color4 = AquaImageFactory.getSelectionInactiveBackgroundColorUIResource();
        Color color5 = AquaImageFactory.getSelectionInactiveForegroundColorUIResource();
        Color color6 = AquaImageFactory.getTextSelectionForegroundColorUIResource();
        Color color7 = AquaImageFactory.getTextSelectionBackgroundColorUIResource();
        ColorUIResource colorUIResource7 = new ColorUIResource(212, 212, 212);
        ColorUIResource colorUIResource8 = colorUIResource4;
        ColorUIResource colorUIResource9 = colorUIResource2;
        ColorUIResource colorUIResource10 = colorUIResource3;
        ColorUIResource colorUIResource11 = colorUIResource3;
        SwingLazyValue swingLazyValue7 = new SwingLazyValue("javax.swing.plaf.basic.BasicBorders", "getInternalFrameBorder");
        ColorUIResource colorUIResource12 = new ColorUIResource(new Color(65, 105, 170));
        Color color8 = AquaImageFactory.getFocusRingColorUIResource();
        BorderUIResource.LineBorderUIResource lineBorderUIResource = new BorderUIResource.LineBorderUIResource(color8);
        Color color9 = color = AquaImageFactory.getWindowBackgroundColorUIResource();
        Color color10 = color;
        Color color11 = color;
        SwingLazyValue swingLazyValue8 = new SwingLazyValue(kAquaFontsName, "getControlTextFont");
        SwingLazyValue swingLazyValue9 = new SwingLazyValue(kAquaFontsName, "getControlTextSmallFont");
        SwingLazyValue swingLazyValue10 = new SwingLazyValue(kAquaFontsName, "getAlertHeaderFont");
        SwingLazyValue swingLazyValue11 = new SwingLazyValue(kAquaFontsName, "getMenuFont");
        SwingLazyValue swingLazyValue12 = new SwingLazyValue(kAquaFontsName, "getViewFont");
        ColorUIResource colorUIResource13 = new ColorUIResource(Color.white);
        ColorUIResource colorUIResource14 = colorUIResource2;
        ColorUIResource colorUIResource15 = colorUIResource3;
        Color color12 = color8;
        ColorUIResource colorUIResource16 = colorUIResource13;
        ColorUIResource colorUIResource17 = colorUIResource4;
        ColorUIResource colorUIResource18 = colorUIResource2;
        ColorUIResource colorUIResource19 = colorUIResource2;
        AquaMenuBorder aquaMenuBorder = new AquaMenuBorder();
        UIDefaults.LazyInputMap lazyInputMap = new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"});
        SwingLazyValue swingLazyValue13 = new SwingLazyValue(kAquaImageFactoryName, "getConfirmImageIcon");
        SwingLazyValue swingLazyValue14 = new SwingLazyValue(kAquaImageFactoryName, "getCautionImageIcon");
        SwingLazyValue swingLazyValue15 = new SwingLazyValue(kAquaImageFactoryName, "getStopImageIcon");
        SwingLazyValue swingLazyValue16 = new SwingLazyValue(kAquaImageFactoryName, "getLockImageIcon");
        Object[] objectArray = new Object[]{"control", color, "Button.background", color11, "Button.foreground", colorUIResource2, "Button.disabledText", colorUIResource4, "Button.select", colorUIResource6, "Button.border", new SwingLazyValue("com.apple.laf.AquaButtonBorder", "getDynamicButtonBorder"), "Button.font", swingLazyValue8, "Button.textIconGap", new Integer(4), "Button.textShiftOffset", n, "Button.focusInputMap", lazyInputMap, "Button.margin", new InsetsUIResource(0, 2, 0, 2), "Button.opaque", bl2, "CheckBox.background", color11, "CheckBox.foreground", colorUIResource2, "CheckBox.disabledText", colorUIResource4, "CheckBox.select", colorUIResource6, "CheckBox.icon", new SwingLazyValue("com.apple.laf.AquaButtonCheckBoxUI", "getSizingCheckBoxIcon"), "CheckBox.font", swingLazyValue8, "CheckBox.border", AquaButtonBorder.getBevelButtonBorder(), "CheckBox.margin", new InsetsUIResource(1, 1, 0, 1), "CheckBox.focusInputMap", lazyInputMap, "CheckBoxMenuItem.font", swingLazyValue11, "CheckBoxMenuItem.acceleratorFont", swingLazyValue11, "CheckBoxMenuItem.background", colorUIResource13, "CheckBoxMenuItem.foreground", colorUIResource14, "CheckBoxMenuItem.selectionBackground", color12, "CheckBoxMenuItem.selectionForeground", colorUIResource15, "CheckBoxMenuItem.disabledBackground", colorUIResource16, "CheckBoxMenuItem.disabledForeground", colorUIResource17, "CheckBoxMenuItem.acceleratorForeground", colorUIResource18, "CheckBoxMenuItem.acceleratorSelectionForeground", colorUIResource19, "CheckBoxMenuItem.acceleratorDelimiter", "", "CheckBoxMenuItem.border", aquaMenuBorder, "CheckBoxMenuItem.margin", insetsUIResource2, "CheckBoxMenuItem.borderPainted", Boolean.TRUE, "CheckBoxMenuItem.checkIcon", new SwingLazyValue(kAquaImageFactoryName, "getMenuItemCheckIcon"), "CheckBoxMenuItem.dashIcon", new SwingLazyValue(kAquaImageFactoryName, "getMenuItemDashIcon"), "ColorChooser.background", color9, "ComboBox.font", swingLazyValue8, "ComboBox.background", color11, "ComboBox.foreground", colorUIResource14, "ComboBox.selectionBackground", color12, "ComboBox.selectionForeground", colorUIResource15, "ComboBox.disabledBackground", colorUIResource16, "ComboBox.disabledForeground", colorUIResource17, "ComboBox.ancestorInputMap", AquaKeyBindings.getComboBoxInputMap(), "DesktopIcon.border", swingLazyValue7, "Desktop.background", colorUIResource12, "EditorPane.focusInputMap", AquaKeyBindings.getMultiLineTextInputMap(), "EditorPane.font", swingLazyValue8, "EditorPane.background", colorUIResource10, "EditorPane.foreground", colorUIResource9, "EditorPane.selectionBackground", color7, "EditorPane.selectionForeground", color6, "EditorPane.caretForeground", colorUIResource9, "EditorPane.caretBlinkRate", n2, "EditorPane.inactiveForeground", colorUIResource8, "EditorPane.inactiveBackground", colorUIResource11, "EditorPane.border", swingLazyValue3, "EditorPane.margin", insetsUIResource3, "FileChooser.newFolderIcon", AquaIcon.SystemIcon.folderIcon, "FileChooser.upFolderIcon", AquaIcon.SystemIcon.folderIcon, "FileChooser.homeFolderIcon", AquaIcon.SystemIcon.desktopIcon, "FileChooser.detailsViewIcon", AquaIcon.SystemIcon.computerIcon, "FileChooser.listViewIcon", AquaIcon.SystemIcon.computerIcon, "FileView.directoryIcon", AquaIcon.SystemIcon.folderIcon, "FileView.fileIcon", AquaIcon.SystemIcon.documentIcon, "FileView.computerIcon", AquaIcon.SystemIcon.desktopIcon, "FileView.hardDriveIcon", AquaIcon.SystemIcon.hardDriveIcon, "FileView.floppyDriveIcon", AquaIcon.SystemIcon.floppyIcon, "FileChooser.cancelButtonMnemonic", n, "FileChooser.saveButtonMnemonic", n, "FileChooser.openButtonMnemonic", n, "FileChooser.updateButtonMnemonic", n, "FileChooser.helpButtonMnemonic", n, "FileChooser.directoryOpenButtonMnemonic", n, "FileChooser.lookInLabelMnemonic", n, "FileChooser.fileNameLabelMnemonic", n, "FileChooser.filesOfTypeLabelMnemonic", n, "Focus.color", color8, "FormattedTextField.focusInputMap", AquaKeyBindings.getFormattedTextFieldInputMap(), "FormattedTextField.font", swingLazyValue8, "FormattedTextField.background", colorUIResource10, "FormattedTextField.foreground", colorUIResource9, "FormattedTextField.inactiveForeground", colorUIResource8, "FormattedTextField.inactiveBackground", colorUIResource11, "FormattedTextField.selectionBackground", color7, "FormattedTextField.selectionForeground", color6, "FormattedTextField.caretForeground", colorUIResource9, "FormattedTextField.caretBlinkRate", n2, "FormattedTextField.border", swingLazyValue2, "FormattedTextField.margin", insetsUIResource, "IconButton.font", swingLazyValue9, "InternalFrame.titleFont", swingLazyValue11, "InternalFrame.background", color, "InternalFrame.borderColor", color, "InternalFrame.borderShadow", Color.red, "InternalFrame.borderDarkShadow", Color.green, "InternalFrame.borderHighlight", Color.blue, "InternalFrame.borderLight", Color.yellow, "InternalFrame.opaque", Boolean.FALSE, "InternalFrame.border", null, "InternalFrame.icon", null, "InternalFrame.paletteBorder", null, "InternalFrame.paletteTitleFont", swingLazyValue11, "InternalFrame.paletteBackground", color, "InternalFrame.optionDialogBorder", null, "InternalFrame.optionDialogTitleFont", swingLazyValue11, "InternalFrame.optionDialogBackground", color, "InternalFrame.closeIcon", new SwingLazyValue("com.apple.laf.AquaInternalFrameUI", "exportCloseIcon"), "InternalFrame.maximizeIcon", new SwingLazyValue("com.apple.laf.AquaInternalFrameUI", "exportZoomIcon"), "InternalFrame.iconifyIcon", new SwingLazyValue("com.apple.laf.AquaInternalFrameUI", "exportMinimizeIcon"), "InternalFrame.minimizeIcon", new SwingLazyValue("com.apple.laf.AquaInternalFrameUI", "exportMinimizeIcon"), "InternalFrame.closeSound", null, "InternalFrame.maximizeSound", null, "InternalFrame.minimizeSound", null, "InternalFrame.restoreDownSound", null, "InternalFrame.restoreUpSound", null, "InternalFrame.activeTitleBackground", color, "InternalFrame.activeTitleForeground", colorUIResource9, "InternalFrame.inactiveTitleBackground", color, "InternalFrame.inactiveTitleForeground", colorUIResource8, "InternalFrame.windowBindings", new Object[]{"shift ESCAPE", "showSystemMenu", "ctrl SPACE", "showSystemMenu", "ESCAPE", "hideSystemMenu"}, "TitledBorder.font", swingLazyValue8, "TitledBorder.titleColor", colorUIResource2, "TitledBorder.aquaVariant", swingLazyValue5, "InsetBorder.aquaVariant", swingLazyValue6, "Label.font", swingLazyValue8, "Label.background", color11, "Label.foreground", colorUIResource2, "Label.disabledForeground", colorUIResource4, "Label.disabledShadow", colorUIResource5, "Label.opaque", bl, "Label.border", null, "List.font", swingLazyValue12, "List.background", colorUIResource3, "List.foreground", colorUIResource2, "List.selectionBackground", color2, "List.selectionForeground", color3, "List.selectionInactiveBackground", color4, "List.selectionInactiveForeground", color5, "List.focusCellHighlightBorder", lineBorderUIResource, "List.border", null, "List.cellRenderer", activeValue, "List.sourceListBackgroundPainter", new SwingLazyValue("com.apple.laf.AquaListUI", "getSourceListBackgroundPainter"), "List.sourceListSelectionBackgroundPainter", new SwingLazyValue("com.apple.laf.AquaListUI", "getSourceListSelectionBackgroundPainter"), "List.sourceListFocusedSelectionBackgroundPainter", new SwingLazyValue("com.apple.laf.AquaListUI", "getSourceListFocusedSelectionBackgroundPainter"), "List.evenRowBackgroundPainter", new SwingLazyValue("com.apple.laf.AquaListUI", "getListEvenBackgroundPainter"), "List.oddRowBackgroundPainter", new SwingLazyValue("com.apple.laf.AquaListUI", "getListOddBackgroundPainter"), "List.focusInputMap", AquaKeyBindings.getListInputMap(), "Menu.font", swingLazyValue11, "Menu.acceleratorFont", swingLazyValue11, "Menu.background", colorUIResource13, "Menu.foreground", colorUIResource14, "Menu.selectionBackground", color12, "Menu.selectionForeground", colorUIResource15, "Menu.disabledBackground", colorUIResource16, "Menu.disabledForeground", colorUIResource17, "Menu.acceleratorForeground", colorUIResource18, "Menu.acceleratorSelectionForeground", colorUIResource19, "Menu.border", aquaMenuBorder, "Menu.borderPainted", Boolean.FALSE, "Menu.margin", insetsUIResource2, "Menu.arrowIcon", new SwingLazyValue(kAquaImageFactoryName, "getMenuArrowIcon"), "Menu.consumesTabs", Boolean.TRUE, "Menu.menuPopupOffsetY", new Integer(1), "Menu.submenuPopupOffsetY", new Integer(-4), "MenuBar.font", swingLazyValue11, "MenuBar.background", colorUIResource13, "MenuBar.foreground", colorUIResource14, "MenuBar.border", new AquaMenuBarBorder(), "MenuBar.margin", new InsetsUIResource(0, 8, 0, 8), "MenuBar.selectionBackground", color12, "MenuBar.selectionForeground", colorUIResource15, "MenuBar.disabledBackground", colorUIResource16, "MenuBar.disabledForeground", colorUIResource17, "MenuBar.backgroundPainter", new SwingLazyValue("com.apple.laf.AquaMenuPainter", "getMenuBarPainter"), "MenuBar.selectedBackgroundPainter", new SwingLazyValue("com.apple.laf.AquaMenuPainter", "getSelectedMenuBarItemPainter"), "MenuItem.font", swingLazyValue11, "MenuItem.acceleratorFont", swingLazyValue11, "MenuItem.background", colorUIResource13, "MenuItem.foreground", colorUIResource14, "MenuItem.selectionBackground", color12, "MenuItem.selectionForeground", colorUIResource15, "MenuItem.disabledBackground", colorUIResource16, "MenuItem.disabledForeground", colorUIResource17, "MenuItem.acceleratorForeground", colorUIResource18, "MenuItem.acceleratorSelectionForeground", colorUIResource19, "MenuItem.acceleratorDelimiter", "", "MenuItem.border", aquaMenuBorder, "MenuItem.margin", insetsUIResource2, "MenuItem.borderPainted", Boolean.TRUE, "MenuItem.selectedBackgroundPainter", new SwingLazyValue("com.apple.laf.AquaMenuPainter", "getSelectedMenuItemPainter"), "OptionPane.font", swingLazyValue10, "OptionPane.messageFont", swingLazyValue8, "OptionPane.buttonFont", swingLazyValue8, "OptionPane.background", color, "OptionPane.foreground", colorUIResource2, "OptionPane.messageForeground", colorUIResource2, "OptionPane.border", new BorderUIResource.EmptyBorderUIResource(12, 21, 17, 21), "OptionPane.messageAreaBorder", emptyBorderUIResource2, "OptionPane.buttonAreaBorder", new BorderUIResource.EmptyBorderUIResource(13, 0, 0, 0), "OptionPane.minimumSize", new DimensionUIResource(262, 90), "OptionPane.errorIcon", swingLazyValue15, "OptionPane.informationIcon", swingLazyValue13, "OptionPane.warningIcon", swingLazyValue14, "OptionPane.questionIcon", swingLazyValue13, "_SecurityDecisionIcon", swingLazyValue16, "OptionPane.windowBindings", new Object[]{"ESCAPE", "close"}, "OptionPane.errorSound", null, "OptionPane.informationSound", null, "OptionPane.questionSound", null, "OptionPane.warningSound", null, "OptionPane.buttonClickThreshhold", new Integer(500), "OptionPane.yesButtonMnemonic", "", "OptionPane.noButtonMnemonic", "", "OptionPane.okButtonMnemonic", "", "OptionPane.cancelButtonMnemonic", "", "Panel.font", swingLazyValue8, "Panel.background", color9, "Panel.foreground", colorUIResource2, "Panel.opaque", bl, "PasswordField.focusInputMap", AquaKeyBindings.getTextFieldInputMap(), "PasswordField.font", swingLazyValue8, "PasswordField.background", colorUIResource10, "PasswordField.foreground", colorUIResource9, "PasswordField.inactiveForeground", colorUIResource8, "PasswordField.inactiveBackground", colorUIResource11, "PasswordField.selectionBackground", color7, "PasswordField.selectionForeground", color6, "PasswordField.caretForeground", colorUIResource9, "PasswordField.caretBlinkRate", n2, "PasswordField.border", swingLazyValue2, "PasswordField.margin", insetsUIResource, "PasswordField.echoChar", new Character('\u25cf'), "PopupMenu.font", swingLazyValue11, "PopupMenu.background", colorUIResource13, "PopupMenu.foreground", colorUIResource14, "PopupMenu.selectionBackground", color12, "PopupMenu.selectionForeground", colorUIResource15, "PopupMenu.border", aquaMenuBorder, "ProgressBar.font", swingLazyValue8, "ProgressBar.foreground", colorUIResource2, "ProgressBar.background", color11, "ProgressBar.selectionForeground", colorUIResource2, "ProgressBar.selectionBackground", colorUIResource3, "ProgressBar.border", new BorderUIResource(BorderFactory.createEmptyBorder()), "ProgressBar.repaintInterval", new Integer(20), "RadioButton.background", color11, "RadioButton.foreground", colorUIResource2, "RadioButton.disabledText", colorUIResource4, "RadioButton.select", colorUIResource6, "RadioButton.icon", new SwingLazyValue("com.apple.laf.AquaButtonRadioUI", "getSizingRadioButtonIcon"), "RadioButton.font", swingLazyValue8, "RadioButton.border", AquaButtonBorder.getBevelButtonBorder(), "RadioButton.margin", new InsetsUIResource(1, 1, 0, 1), "RadioButton.focusInputMap", lazyInputMap, "RadioButtonMenuItem.font", swingLazyValue11, "RadioButtonMenuItem.acceleratorFont", swingLazyValue11, "RadioButtonMenuItem.background", colorUIResource13, "RadioButtonMenuItem.foreground", colorUIResource14, "RadioButtonMenuItem.selectionBackground", color12, "RadioButtonMenuItem.selectionForeground", colorUIResource15, "RadioButtonMenuItem.disabledBackground", colorUIResource16, "RadioButtonMenuItem.disabledForeground", colorUIResource17, "RadioButtonMenuItem.acceleratorForeground", colorUIResource18, "RadioButtonMenuItem.acceleratorSelectionForeground", colorUIResource19, "RadioButtonMenuItem.acceleratorDelimiter", "", "RadioButtonMenuItem.border", aquaMenuBorder, "RadioButtonMenuItem.margin", insetsUIResource2, "RadioButtonMenuItem.borderPainted", Boolean.TRUE, "RadioButtonMenuItem.checkIcon", new SwingLazyValue(kAquaImageFactoryName, "getMenuItemCheckIcon"), "RadioButtonMenuItem.dashIcon", new SwingLazyValue(kAquaImageFactoryName, "getMenuItemDashIcon"), "Separator.background", null, "Separator.foreground", new ColorUIResource(212, 212, 212), "ScrollBar.border", null, "ScrollBar.focusInputMap", AquaKeyBindings.getScrollBarInputMap(), "ScrollBar.focusInputMap.RightToLeft", AquaKeyBindings.getScrollBarRightToLeftInputMap(), "ScrollBar.width", new Integer(16), "ScrollBar.background", colorUIResource3, "ScrollBar.foreground", colorUIResource2, "ScrollPane.font", swingLazyValue8, "ScrollPane.background", colorUIResource3, "ScrollPane.foreground", colorUIResource2, "ScrollPane.border", swingLazyValue4, "ScrollPane.viewportBorder", null, "ScrollPane.ancestorInputMap", AquaKeyBindings.getScrollPaneInputMap(), "ScrollPane.ancestorInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[0]), "Viewport.font", swingLazyValue8, "Viewport.background", colorUIResource3, "Viewport.foreground", colorUIResource2, "Slider.foreground", colorUIResource2, "Slider.background", color11, "Slider.font", swingLazyValue9, "Slider.tickColor", new ColorUIResource(Color.GRAY), "Slider.border", null, "Slider.focusInsets", new InsetsUIResource(2, 2, 2, 2), "Slider.focusInputMap", AquaKeyBindings.getSliderInputMap(), "Slider.focusInputMap.RightToLeft", AquaKeyBindings.getSliderRightToLeftInputMap(), "Spinner.font", swingLazyValue8, "Spinner.background", color11, "Spinner.foreground", colorUIResource2, "Spinner.border", null, "Spinner.arrowButtonSize", new Dimension(16, 5), "Spinner.ancestorInputMap", AquaKeyBindings.getSpinnerInputMap(), "Spinner.editorBorderPainted", Boolean.TRUE, "Spinner.editorAlignment", 11, "SplitPane.background", color9, "SplitPane.border", swingLazyValue4, "SplitPane.dividerSize", new Integer(9), "SplitPaneDivider.border", null, "SplitPaneDivider.horizontalGradientVariant", new SwingLazyValue("com.apple.laf.AquaSplitPaneDividerUI", "getHorizontalSplitDividerGradientVariant"), "TabbedPane.font", swingLazyValue8, "TabbedPane.smallFont", swingLazyValue9, "TabbedPane.useSmallLayout", Boolean.FALSE, "TabbedPane.background", color10, "TabbedPane.foreground", colorUIResource2, "TabbedPane.opaque", bl, "TabbedPane.textIconGap", new Integer(4), "TabbedPane.tabInsets", new InsetsUIResource(0, 10, 3, 10), "TabbedPane.leftTabInsets", new InsetsUIResource(0, 10, 3, 10), "TabbedPane.rightTabInsets", new InsetsUIResource(0, 10, 3, 10), "TabbedPane.tabAreaInsets", new InsetsUIResource(3, 9, -1, 9), "TabbedPane.contentBorderInsets", new InsetsUIResource(8, 0, 0, 0), "TabbedPane.selectedTabPadInsets", new InsetsUIResource(0, 0, 0, 0), "TabbedPane.tabsOverlapBorder", Boolean.TRUE, "Table.font", swingLazyValue12, "Table.foreground", colorUIResource2, "Table.background", colorUIResource3, "Table.selectionForeground", color3, "Table.selectionBackground", color2, "Table.selectionInactiveBackground", color4, "Table.selectionInactiveForeground", color5, "Table.gridColor", colorUIResource3, "Table.focusCellBackground", color6, "Table.focusCellForeground", color7, "Table.focusCellHighlightBorder", lineBorderUIResource, "Table.scrollPaneBorder", swingLazyValue4, "Table.ancestorInputMap", AquaKeyBindings.getTableInputMap(), "Table.ancestorInputMap.RightToLeft", AquaKeyBindings.getTableRightToLeftInputMap(), "TableHeader.font", swingLazyValue9, "TableHeader.foreground", colorUIResource2, "TableHeader.background", colorUIResource3, "TableHeader.cellBorder", aquaTableHeaderBorder, "TextArea.focusInputMap", AquaKeyBindings.getMultiLineTextInputMap(), "TextArea.font", swingLazyValue8, "TextArea.background", colorUIResource10, "TextArea.foreground", colorUIResource9, "TextArea.inactiveForeground", colorUIResource8, "TextArea.inactiveBackground", colorUIResource11, "TextArea.selectionBackground", color7, "TextArea.selectionForeground", color6, "TextArea.caretForeground", colorUIResource9, "TextArea.caretBlinkRate", n2, "TextArea.border", swingLazyValue3, "TextArea.margin", insetsUIResource, "TextComponent.selectionBackgroundInactive", colorUIResource7, "TextField.focusInputMap", AquaKeyBindings.getTextFieldInputMap(), "TextField.font", swingLazyValue8, "TextField.background", colorUIResource10, "TextField.foreground", colorUIResource9, "TextField.inactiveForeground", colorUIResource8, "TextField.inactiveBackground", colorUIResource11, "TextField.selectionBackground", color7, "TextField.selectionForeground", color6, "TextField.caretForeground", colorUIResource9, "TextField.caretBlinkRate", n2, "TextField.border", swingLazyValue2, "TextField.margin", insetsUIResource, "TextPane.focusInputMap", AquaKeyBindings.getMultiLineTextInputMap(), "TextPane.font", swingLazyValue8, "TextPane.background", colorUIResource10, "TextPane.foreground", colorUIResource9, "TextPane.selectionBackground", color7, "TextPane.selectionForeground", color6, "TextPane.caretForeground", colorUIResource9, "TextPane.caretBlinkRate", n2, "TextPane.inactiveForeground", colorUIResource8, "TextPane.inactiveBackground", colorUIResource11, "TextPane.border", swingLazyValue3, "TextPane.margin", insetsUIResource3, "ToggleButton.background", color11, "ToggleButton.foreground", colorUIResource2, "ToggleButton.disabledText", colorUIResource4, "ToggleButton.border", new SwingLazyValue("com.apple.laf.AquaButtonBorder", "getDynamicButtonBorder"), "ToggleButton.font", swingLazyValue8, "ToggleButton.focusInputMap", lazyInputMap, "ToggleButton.margin", new InsetsUIResource(2, 2, 2, 2), "ToolBar.font", swingLazyValue8, "ToolBar.background", color9, "ToolBar.foreground", new ColorUIResource(Color.gray), "ToolBar.dockingBackground", color9, "ToolBar.dockingForeground", color2, "ToolBar.floatingBackground", color9, "ToolBar.floatingForeground", new ColorUIResource(Color.darkGray), "ToolBar.border", new SwingLazyValue("com.apple.laf.AquaToolBarUI", "getToolBarBorder"), "ToolBar.separatorSize", null, "ToolBarButton.margin", new InsetsUIResource(3, 3, 3, 3), "ToolBarButton.insets", new InsetsUIResource(1, 1, 1, 1), "ToolTip.font", swingLazyValue9, "ToolTip.background", colorUIResource, "ToolTip.foreground", colorUIResource2, "ToolTip.border", emptyBorderUIResource, "Tree.font", swingLazyValue12, "Tree.background", colorUIResource3, "Tree.foreground", colorUIResource2, "Tree.hash", colorUIResource3, "Tree.line", colorUIResource3, "Tree.textForeground", colorUIResource2, "Tree.textBackground", colorUIResource3, "Tree.selectionForeground", color3, "Tree.selectionBackground", color2, "Tree.selectionInactiveBackground", color4, "Tree.selectionInactiveForeground", color5, "Tree.selectionBorderColor", color2, "Tree.editorBorderSelectionColor", null, "Tree.leftChildIndent", new Integer(7), "Tree.rightChildIndent", new Integer(13), "Tree.rowHeight", new Integer(19), "Tree.scrollsOnExpand", Boolean.FALSE, "Tree.openIcon", new SwingLazyValue(kAquaImageFactoryName, "getTreeOpenFolderIcon"), "Tree.closedIcon", new SwingLazyValue(kAquaImageFactoryName, "getTreeFolderIcon"), "Tree.leafIcon", new SwingLazyValue(kAquaImageFactoryName, "getTreeDocumentIcon"), "Tree.expandedIcon", new SwingLazyValue(kAquaImageFactoryName, "getTreeExpandedIcon"), "Tree.collapsedIcon", new SwingLazyValue(kAquaImageFactoryName, "getTreeCollapsedIcon"), "Tree.rightToLeftCollapsedIcon", new SwingLazyValue(kAquaImageFactoryName, "getTreeRightToLeftCollapsedIcon"), "Tree.changeSelectionWithFocus", Boolean.TRUE, "Tree.drawsFocusBorderAroundIcon", Boolean.FALSE, "Tree.focusInputMap", AquaKeyBindings.getTreeInputMap(), "Tree.focusInputMap.RightToLeft", AquaKeyBindings.getTreeRightToLeftInputMap(), "Tree.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancel"})};
        uIDefaults.putDefaults(objectArray);
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
    }

    @Override
    protected void initClassDefaults(UIDefaults uIDefaults) {
        Object[] objectArray = new Object[]{"ButtonUI", "com.apple.laf.AquaButtonUI", "CheckBoxUI", "com.apple.laf.AquaButtonCheckBoxUI", "CheckBoxMenuItemUI", "com.apple.laf.AquaMenuItemUI", "LabelUI", "com.apple.laf.AquaLabelUI", "ListUI", "com.apple.laf.AquaListUI", "MenuUI", "com.apple.laf.AquaMenuUI", "MenuItemUI", "com.apple.laf.AquaMenuItemUI", "OptionPaneUI", "com.apple.laf.AquaOptionPaneUI", "PanelUI", "com.apple.laf.AquaPanelUI", "RadioButtonMenuItemUI", "com.apple.laf.AquaMenuItemUI", "RadioButtonUI", "com.apple.laf.AquaButtonRadioUI", "ProgressBarUI", "com.apple.laf.AquaProgressBarUI", "RootPaneUI", "com.apple.laf.AquaRootPaneUI", "SliderUI", "com.apple.laf.AquaSliderUI", "ScrollBarUI", "com.apple.laf.AquaScrollBarUI", "TabbedPaneUI", "com.apple.laf.AquaTabbedPaneUI", "TableUI", "com.apple.laf.AquaTableUI", "ToggleButtonUI", "com.apple.laf.AquaButtonToggleUI", "ToolBarUI", "com.apple.laf.AquaToolBarUI", "ToolTipUI", "com.apple.laf.AquaToolTipUI", "TreeUI", "com.apple.laf.AquaTreeUI", "InternalFrameUI", "com.apple.laf.AquaInternalFrameUI", "DesktopIconUI", "com.apple.laf.AquaInternalFrameDockIconUI", "DesktopPaneUI", "com.apple.laf.AquaInternalFramePaneUI", "EditorPaneUI", "com.apple.laf.AquaEditorPaneUI", "TextFieldUI", "com.apple.laf.AquaTextFieldUI", "TextPaneUI", "com.apple.laf.AquaTextPaneUI", "ComboBoxUI", "com.apple.laf.AquaComboBoxUI", "PopupMenuUI", "com.apple.laf.AquaPopupMenuUI", "TextAreaUI", "com.apple.laf.AquaTextAreaUI", "MenuBarUI", "com.apple.laf.AquaMenuBarUI", "FileChooserUI", "com.apple.laf.AquaFileChooserUI", "PasswordFieldUI", "com.apple.laf.AquaTextPasswordFieldUI", "TableHeaderUI", "com.apple.laf.AquaTableHeaderUI", "FormattedTextFieldUI", "com.apple.laf.AquaTextFieldFormattedUI", "SpinnerUI", "com.apple.laf.AquaSpinnerUI", "SplitPaneUI", "com.apple.laf.AquaSplitPaneUI", "ScrollPaneUI", "com.apple.laf.AquaScrollPaneUI", "PopupMenuSeparatorUI", "com.apple.laf.AquaPopupMenuSeparatorUI", "SeparatorUI", "com.apple.laf.AquaPopupMenuSeparatorUI", "ToolBarSeparatorUI", "com.apple.laf.AquaToolBarSeparatorUI", "ColorChooserUI", "javax.swing.plaf.basic.BasicColorChooserUI", "ViewportUI", "javax.swing.plaf.basic.BasicViewportUI"};
        uIDefaults.putDefaults(objectArray);
    }
}

