/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.awt.ClientPropertyApplicator;
import apple.laf.JRSUIConstants;
import com.apple.laf.AquaButtonBorder;
import com.apple.laf.AquaComboBoxButton;
import com.apple.laf.AquaComboBoxPopup;
import com.apple.laf.AquaComboBoxRenderer;
import com.apple.laf.AquaListUI;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class AquaComboBoxUI
extends BasicComboBoxUI
implements AquaUtilControlSize.Sizeable {
    static final String POPDOWN_CLIENT_PROPERTY_KEY = "JComboBox.isPopDown";
    static final String ISSQUARE_CLIENT_PROPERTY_KEY = "JComboBox.isSquare";
    private boolean wasOpaque;
    Action highlightNextAction = new ComboBoxAction(){

        @Override
        public void performComboBoxAction(AquaComboBoxUI aquaComboBoxUI) {
            int n = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (n < AquaComboBoxUI.this.comboBox.getModel().getSize() - 1) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(n + 1);
                AquaComboBoxUI.this.listBox.ensureIndexIsVisible(n + 1);
            }
            AquaComboBoxUI.this.comboBox.repaint();
        }
    };
    Action highlightPreviousAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI aquaComboBoxUI) {
            int n = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (n > 0) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(n - 1);
                AquaComboBoxUI.this.listBox.ensureIndexIsVisible(n - 1);
            }
            AquaComboBoxUI.this.comboBox.repaint();
        }
    };
    Action highlightFirstAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI aquaComboBoxUI) {
            AquaComboBoxUI.this.listBox.setSelectedIndex(0);
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(0);
        }
    };
    Action highlightLastAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI aquaComboBoxUI) {
            int n = AquaComboBoxUI.this.listBox.getModel().getSize();
            AquaComboBoxUI.this.listBox.setSelectedIndex(n - 1);
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(n - 1);
        }
    };
    Action highlightPageUpAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI aquaComboBoxUI) {
            int n;
            int n2 = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (n2 != (n = AquaComboBoxUI.this.listBox.getFirstVisibleIndex())) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(n);
                return;
            }
            int n3 = ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getVisibleRect().height / ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getCellBounds((int)0, (int)0).height;
            int n4 = n - n3;
            if (n4 < 0) {
                n4 = 0;
            }
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(n4);
            AquaComboBoxUI.this.listBox.setSelectedIndex(n4);
        }
    };
    Action highlightPageDownAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI aquaComboBoxUI) {
            int n;
            int n2 = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (n2 != (n = AquaComboBoxUI.this.listBox.getLastVisibleIndex())) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(n);
                return;
            }
            int n3 = ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getVisibleRect().height / ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getCellBounds((int)0, (int)0).height;
            int n4 = n + n3;
            int n5 = AquaComboBoxUI.this.listBox.getModel().getSize() - 1;
            if (n4 > n5) {
                n4 = n5;
            }
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(n4);
            AquaComboBoxUI.this.listBox.setSelectedIndex(n4);
        }
    };
    protected static final String IS_TABLE_CELL_EDITOR = "JComboBox.isTableCellEditor";
    static Action triggerSelectionAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AquaComboBoxUI.triggerSelectionEvent((JComboBox)actionEvent.getSource(), actionEvent);
        }
    };
    static Action toggleSelectionAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (!jComboBox.isEnabled()) {
                return;
            }
            if (jComboBox.isEditable()) {
                return;
            }
            AquaComboBoxUI aquaComboBoxUI = (AquaComboBoxUI)jComboBox.getUI();
            if (jComboBox.isPopupVisible()) {
                jComboBox.setSelectedIndex(aquaComboBoxUI.getPopup().getList().getSelectedIndex());
                jComboBox.setPopupVisible(false);
                return;
            }
            jComboBox.setPopupVisible(true);
        }
    };
    static final ClientPropertyApplicator<JComboBox, AquaComboBoxUI> APPLICATOR = new ClientPropertyApplicator<JComboBox, AquaComboBoxUI>(new ClientPropertyApplicator.Property[]{new ClientPropertyApplicator.Property<AquaComboBoxUI>("Frame.active"){

        @Override
        public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
            if (Boolean.FALSE.equals(object) && aquaComboBoxUI.comboBox != null) {
                aquaComboBoxUI.comboBox.hidePopup();
            }
            if (aquaComboBoxUI.listBox != null) {
                aquaComboBoxUI.listBox.repaint();
            }
        }
    }, new ClientPropertyApplicator.Property<AquaComboBoxUI>("editable"){

        @Override
        public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
            if (aquaComboBoxUI.comboBox == null) {
                return;
            }
            aquaComboBoxUI.comboBox.repaint();
        }
    }, new ClientPropertyApplicator.Property<AquaComboBoxUI>("background"){

        @Override
        public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
            Color color = (Color)object;
            if (aquaComboBoxUI.arrowButton != null) {
                aquaComboBoxUI.arrowButton.setBackground(color);
            }
            if (aquaComboBoxUI.listBox != null) {
                aquaComboBoxUI.listBox.setBackground(color);
            }
        }
    }, new ClientPropertyApplicator.Property<AquaComboBoxUI>("foreground"){

        @Override
        public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
            Color color = (Color)object;
            if (aquaComboBoxUI.arrowButton != null) {
                aquaComboBoxUI.arrowButton.setForeground(color);
            }
            if (aquaComboBoxUI.listBox != null) {
                aquaComboBoxUI.listBox.setForeground(color);
            }
        }
    }, new ClientPropertyApplicator.Property<AquaComboBoxUI>("JComboBox.isPopDown"){

        @Override
        public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
            if (!(aquaComboBoxUI.arrowButton instanceof AquaComboBoxButton)) {
                return;
            }
            ((AquaComboBoxButton)aquaComboBoxUI.arrowButton).setIsPopDown(Boolean.TRUE.equals(object));
        }
    }, new ClientPropertyApplicator.Property<AquaComboBoxUI>("JComboBox.isSquare"){

        @Override
        public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
            if (!(aquaComboBoxUI.arrowButton instanceof AquaComboBoxButton)) {
                return;
            }
            ((AquaComboBoxButton)aquaComboBoxUI.arrowButton).setIsSquare(Boolean.TRUE.equals(object));
        }
    }}){

        @Override
        public AquaComboBoxUI convertJComponentToTarget(JComboBox jComboBox) {
            ComboBoxUI comboBoxUI = jComboBox.getUI();
            if (comboBoxUI instanceof AquaComboBoxUI) {
                return (AquaComboBoxUI)comboBoxUI;
            }
            return null;
        }
    };

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaComboBoxUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        LookAndFeel.installProperty(jComponent, "opaque", Boolean.FALSE);
        this.wasOpaque = jComponent.isOpaque();
        jComponent.setOpaque(false);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.setOpaque(this.wasOpaque);
        super.uninstallUI(jComponent);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        AquaUtilControlSize.addSizePropertyListener(this.comboBox);
    }

    @Override
    protected void uninstallListeners() {
        AquaUtilControlSize.removeSizePropertyListener(this.comboBox);
        super.uninstallListeners();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        APPLICATOR.attachAndApplyClientProperties(this.comboBox);
    }

    @Override
    protected void uninstallComponents() {
        APPLICATOR.removeFrom(this.comboBox);
        super.uninstallComponents();
    }

    @Override
    protected ItemListener createItemListener() {
        return new ItemListener(){
            long lastBlink = 0L;

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                if (!AquaComboBoxUI.this.popup.isVisible()) {
                    return;
                }
                long l = System.currentTimeMillis();
                if (l - 1000L < this.lastBlink) {
                    return;
                }
                this.lastBlink = l;
                JList<Object> jList = AquaComboBoxUI.this.popup.getList();
                ListUI listUI = jList.getUI();
                if (!(listUI instanceof AquaListUI)) {
                    return;
                }
                final AquaListUI aquaListUI = (AquaListUI)listUI;
                final int n = AquaComboBoxUI.this.comboBox.getSelectedIndex();
                ListModel<Object> listModel = jList.getModel();
                if (listModel == null) {
                    return;
                }
                final Object object = listModel.getElementAt(n);
                AquaUtils.blinkMenu(new AquaUtils.Selectable(){

                    @Override
                    public void paintSelected(boolean bl) {
                        aquaListUI.repaintCell(object, n, bl);
                    }
                });
            }
        };
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected ListCellRenderer createRenderer() {
        return new AquaComboBoxRenderer(this.comboBox);
    }

    @Override
    protected ComboPopup createPopup() {
        return new AquaComboBoxPopup(this.comboBox);
    }

    @Override
    protected JButton createArrowButton() {
        return new AquaComboBoxButton(this, this.comboBox, this.currentValuePane, this.listBox);
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new AquaComboBoxEditor();
    }

    @Override
    protected FocusListener createFocusListener() {
        return new BasicComboBoxUI.FocusHandler(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AquaComboBoxUI.this.hasFocus = false;
                if (!focusEvent.isTemporary()) {
                    AquaComboBoxUI.this.setPopupVisible(AquaComboBoxUI.this.comboBox, false);
                }
                AquaComboBoxUI.this.comboBox.repaint();
                AccessibleContext accessibleContext = AquaComboBoxUI.this.comboBox.getAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                }
            }
        };
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap actionMap = this.comboBox.getActionMap();
        actionMap.put("aquaSelectNext", this.highlightNextAction);
        actionMap.put("aquaSelectPrevious", this.highlightPreviousAction);
        actionMap.put("aquaEnterPressed", triggerSelectionAction);
        actionMap.put("aquaSpacePressed", toggleSelectionAction);
        actionMap.put("aquaSelectHome", this.highlightFirstAction);
        actionMap.put("aquaSelectEnd", this.highlightLastAction);
        actionMap.put("aquaSelectPageUp", this.highlightPageUpAction);
        actionMap.put("aquaSelectPageDown", this.highlightPageDownAction);
    }

    public ComboPopup getPopup() {
        return this.popup;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new AquaComboBoxLayoutManager();
    }

    protected static boolean isTableCellEditor(JComponent jComponent) {
        return Boolean.TRUE.equals(jComponent.getClientProperty(IS_TABLE_CELL_EDITOR));
    }

    protected static boolean isPopdown(JComboBox jComboBox) {
        return jComboBox.isEditable() || Boolean.TRUE.equals(jComboBox.getClientProperty(POPDOWN_CLIENT_PROPERTY_KEY));
    }

    protected static void triggerSelectionEvent(JComboBox jComboBox, ActionEvent actionEvent) {
        if (!jComboBox.isEnabled()) {
            return;
        }
        AquaComboBoxUI aquaComboBoxUI = (AquaComboBoxUI)jComboBox.getUI();
        if (aquaComboBoxUI.getPopup().getList().getSelectedIndex() < 0) {
            jComboBox.setPopupVisible(false);
        }
        if (AquaComboBoxUI.isTableCellEditor(jComboBox)) {
            jComboBox.setSelectedIndex(aquaComboBoxUI.getPopup().getList().getSelectedIndex());
            return;
        }
        if (jComboBox.isPopupVisible()) {
            jComboBox.setSelectedIndex(aquaComboBoxUI.getPopup().getList().getSelectedIndex());
            jComboBox.setPopupVisible(false);
            return;
        }
        JRootPane jRootPane = SwingUtilities.getRootPane(jComboBox);
        if (jRootPane == null) {
            return;
        }
        InputMap inputMap = jRootPane.getInputMap(2);
        ActionMap actionMap = jRootPane.getActionMap();
        if (inputMap == null || actionMap == null) {
            return;
        }
        Object object = inputMap.get(KeyStroke.getKeyStroke(10, 0));
        if (object == null) {
            return;
        }
        Action action = actionMap.get(object);
        if (action == null) {
            return;
        }
        action.actionPerformed(new ActionEvent(jRootPane, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
    }

    @Override
    public void applySizeFor(JComponent jComponent, JRSUIConstants.Size size) {
        if (this.arrowButton == null) {
            return;
        }
        Border border = this.arrowButton.getBorder();
        if (!(border instanceof AquaButtonBorder)) {
            return;
        }
        AquaButtonBorder aquaButtonBorder = (AquaButtonBorder)border;
        this.arrowButton.setBorder(aquaButtonBorder.deriveBorderForSize(size));
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension;
        Insets insets;
        Object object;
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        boolean bl = this.comboBox.isEditable();
        if (!bl && this.arrowButton != null && this.arrowButton instanceof AquaComboBoxButton) {
            object = (AquaComboBoxButton)this.arrowButton;
            insets = ((JComponent)object).getInsets();
            Insets insets2 = new Insets(0, 5, 0, 25);
            dimension = this.getDisplaySize();
            dimension.width += insets2.left + insets2.right;
            dimension.width += insets.left + insets.right;
            dimension.width += insets.right + 10;
            dimension.height += insets2.top + insets2.bottom;
            dimension.height += insets.top + insets.bottom;
            dimension.height = Math.max(27, dimension.height);
        } else if (bl && this.arrowButton != null && this.editor != null) {
            dimension = super.getMinimumSize(jComponent);
            object = this.arrowButton.getMargin();
            dimension.height += ((Insets)object).top + ((Insets)object).bottom;
        } else {
            dimension = super.getMinimumSize(jComponent);
        }
        object = jComponent.getBorder();
        if (object != null) {
            insets = object.getBorderInsets(jComponent);
            dimension.height += insets.top + insets.bottom;
            dimension.width += insets.left + insets.right;
        }
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    class AquaComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        AquaComboBoxLayoutManager() {
            super(AquaComboBoxUI.this);
        }

        @Override
        public void layoutContainer(Container container) {
            if (AquaComboBoxUI.this.arrowButton != null && !AquaComboBoxUI.this.comboBox.isEditable()) {
                Insets insets = AquaComboBoxUI.this.comboBox.getInsets();
                int n = AquaComboBoxUI.this.comboBox.getWidth();
                int n2 = AquaComboBoxUI.this.comboBox.getHeight();
                AquaComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, n - (insets.left + insets.right), n2 - (insets.top + insets.bottom));
                return;
            }
            JComboBox jComboBox = (JComboBox)container;
            int n = jComboBox.getWidth();
            int n3 = jComboBox.getHeight();
            Insets insets = AquaComboBoxUI.this.getInsets();
            int n4 = n3 - (insets.top + insets.bottom);
            if (AquaComboBoxUI.this.arrowButton != null) {
                AquaComboBoxUI.this.arrowButton.setBounds(n - (insets.right + 20), insets.top, 20, n4);
            }
            if (AquaComboBoxUI.this.editor != null) {
                Rectangle rectangle = AquaComboBoxUI.this.rectangleForCurrentValue();
                rectangle.width += 4;
                AquaComboBoxUI.this.editor.setBounds(rectangle);
            }
        }
    }

    abstract class ComboBoxAction
    extends AbstractAction {
        ComboBoxAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!AquaComboBoxUI.this.comboBox.isEnabled() || !AquaComboBoxUI.this.comboBox.isShowing()) {
                return;
            }
            if (AquaComboBoxUI.this.comboBox.isPopupVisible()) {
                AquaComboBoxUI aquaComboBoxUI = (AquaComboBoxUI)AquaComboBoxUI.this.comboBox.getUI();
                this.performComboBoxAction(aquaComboBoxUI);
            } else {
                AquaComboBoxUI.this.comboBox.setPopupVisible(true);
            }
        }

        abstract void performComboBoxAction(AquaComboBoxUI var1);
    }

    class AquaCustomComboTextField
    extends JTextField {
        public AquaCustomComboTextField() {
            InputMap inputMap = this.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke("DOWN"), AquaComboBoxUI.this.highlightNextAction);
            inputMap.put(KeyStroke.getKeyStroke("KP_DOWN"), AquaComboBoxUI.this.highlightNextAction);
            inputMap.put(KeyStroke.getKeyStroke("UP"), AquaComboBoxUI.this.highlightPreviousAction);
            inputMap.put(KeyStroke.getKeyStroke("KP_UP"), AquaComboBoxUI.this.highlightPreviousAction);
            inputMap.put(KeyStroke.getKeyStroke("HOME"), AquaComboBoxUI.this.highlightFirstAction);
            inputMap.put(KeyStroke.getKeyStroke("END"), AquaComboBoxUI.this.highlightLastAction);
            inputMap.put(KeyStroke.getKeyStroke("PAGE_UP"), AquaComboBoxUI.this.highlightPageUpAction);
            inputMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), AquaComboBoxUI.this.highlightPageDownAction);
            final Action action = this.getActionMap().get("notify-field-accept");
            inputMap.put(KeyStroke.getKeyStroke("ENTER"), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AquaComboBoxUI.this.popup.isVisible()) {
                        AquaComboBoxUI.triggerSelectionEvent(AquaComboBoxUI.this.comboBox, actionEvent);
                        if (AquaComboBoxUI.this.editor instanceof AquaCustomComboTextField) {
                            ((AquaCustomComboTextField)AquaComboBoxUI.this.editor).selectAll();
                        }
                    } else {
                        action.actionPerformed(actionEvent);
                    }
                }
            });
        }

        @Override
        public void setText(String string) {
            if (this.getText().equals(string)) {
                return;
            }
            super.setText(string);
        }
    }

    class AquaComboBoxEditor
    extends BasicComboBoxEditor
    implements UIResource,
    DocumentListener {
        protected AquaComboBoxEditor() {
            this.editor = new AquaCustomComboTextField();
            this.editor.addFocusListener(this);
            this.editor.getDocument().addDocumentListener(this);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            AquaComboBoxUI.this.arrowButton.repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            AquaComboBoxUI.this.arrowButton.repaint();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.editorTextChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.editorTextChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.editorTextChanged();
        }

        protected void editorTextChanged() {
            if (!AquaComboBoxUI.this.popup.isVisible()) {
                return;
            }
            String string = this.editor.getText();
            ListModel listModel = AquaComboBoxUI.this.listBox.getModel();
            int n = listModel.getSize();
            for (int i = 0; i < n; ++i) {
                String string2;
                Object e = listModel.getElementAt(i);
                if (e == null || (string2 = e.toString()) == null || !string2.equals(string)) continue;
                AquaComboBoxUI.this.popup.getList().setSelectedIndex(i);
                return;
            }
            AquaComboBoxUI.this.popup.getList().clearSelection();
        }
    }
}

