/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIStateFactory;
import com.apple.laf.AquaButtonBorder;
import com.apple.laf.AquaButtonToggleUI;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.View;

public abstract class AquaButtonLabeledUI
extends AquaButtonToggleUI
implements AquaUtilControlSize.Sizeable {
    protected static LazySizingIcon regularIcon = new LazySizingIcon(18);
    protected static LazySizingIcon smallIcon = new LazySizingIcon(16);
    protected static LazySizingIcon miniIcon = new LazySizingIcon(14);
    protected AquaButtonBorder widgetBorder = this.getPainter();
    private static Dimension size = new Dimension();
    private static final Rectangle prefViewRect = new Rectangle();
    private static final Rectangle prefIconRect = new Rectangle();
    private static final Rectangle prefTextRect = new Rectangle();
    private static Insets prefInsets = new Insets(0, 0, 0, 0);

    @Override
    public void applySizeFor(JComponent jComponent, JRSUIConstants.Size size) {
        super.applySizeFor(jComponent, size);
        this.widgetBorder = (AquaButtonBorder)this.widgetBorder.deriveBorderForSize(size);
    }

    public Icon getDefaultIcon(JComponent jComponent) {
        JRSUIConstants.Size size = AquaUtilControlSize.getUserSizeFrom(jComponent);
        if (size == JRSUIConstants.Size.REGULAR) {
            return (Icon)regularIcon.get();
        }
        if (size == JRSUIConstants.Size.SMALL) {
            return (Icon)smallIcon.get();
        }
        if (size == JRSUIConstants.Size.MINI) {
            return (Icon)miniIcon.get();
        }
        return (Icon)regularIcon.get();
    }

    @Override
    protected void setThemeBorder(AbstractButton abstractButton) {
        super.setThemeBorder(abstractButton);
        abstractButton.setBorder(AquaButtonBorder.getBevelButtonBorder());
    }

    protected abstract AquaButtonBorder getPainter();

    @Override
    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object2 = AquaUtils.beginFont(graphics2D);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        size = abstractButton.getSize(size);
        Insets insets = jComponent.getInsets();
        AquaButtonLabeledUI.viewRect.x = 0;
        AquaButtonLabeledUI.viewRect.y = 0;
        AquaButtonLabeledUI.viewRect.width = abstractButton.getWidth();
        AquaButtonLabeledUI.viewRect.height = abstractButton.getHeight();
        AquaButtonLabeledUI.iconRect.height = 0;
        AquaButtonLabeledUI.iconRect.width = 0;
        AquaButtonLabeledUI.iconRect.y = 0;
        AquaButtonLabeledUI.iconRect.x = 0;
        AquaButtonLabeledUI.textRect.height = 0;
        AquaButtonLabeledUI.textRect.width = 0;
        AquaButtonLabeledUI.textRect.y = 0;
        AquaButtonLabeledUI.textRect.x = 0;
        Icon icon = abstractButton.getIcon();
        boolean bl = jComponent.getParent() instanceof CellRendererPane;
        if (abstractButton.isOpaque() || bl) {
            graphics.setColor(abstractButton.getBackground());
            graphics.fillRect(0, 0, AquaButtonLabeledUI.size.width, AquaButtonLabeledUI.size.height);
        }
        if (((AbstractButton)jComponent).isBorderPainted() && !bl && (object = jComponent.getBorder()) instanceof AquaButtonBorder) {
            ((AquaButtonBorder)object).paintButton(jComponent, graphics, AquaButtonLabeledUI.viewRect.x, AquaButtonLabeledUI.viewRect.y, AquaButtonLabeledUI.viewRect.width, AquaButtonLabeledUI.viewRect.height);
        }
        AquaButtonLabeledUI.viewRect.x = insets.left;
        AquaButtonLabeledUI.viewRect.y = insets.top;
        AquaButtonLabeledUI.viewRect.width = abstractButton.getWidth() - (insets.right + AquaButtonLabeledUI.viewRect.x);
        AquaButtonLabeledUI.viewRect.height = abstractButton.getHeight() - (insets.bottom + AquaButtonLabeledUI.viewRect.y);
        object = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), icon != null ? icon : this.getDefaultIcon(abstractButton), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        if (icon == null) {
            this.widgetBorder.paintButton(jComponent, graphics, AquaButtonLabeledUI.iconRect.x, AquaButtonLabeledUI.iconRect.y, AquaButtonLabeledUI.iconRect.width, AquaButtonLabeledUI.iconRect.height);
        } else {
            if (!buttonModel.isEnabled()) {
                icon = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = abstractButton.getPressedIcon();
                if (icon == null) {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (buttonModel.isSelected()) {
                if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                    icon = abstractButton.getRolloverSelectedIcon();
                    if (icon == null) {
                        icon = abstractButton.getSelectedIcon();
                    }
                } else {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                icon = abstractButton.getRolloverIcon();
            }
            if (icon == null) {
                icon = abstractButton.getIcon();
            }
            icon.paintIcon(jComponent, graphics, AquaButtonLabeledUI.iconRect.x, AquaButtonLabeledUI.iconRect.y);
        }
        if (object != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, textRect);
            } else {
                this.paintText(graphics, abstractButton, textRect, (String)object);
            }
        }
        AquaUtils.endFont(graphics2D, object2);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (jComponent.getComponentCount() > 0) {
            return null;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        String string = abstractButton.getText();
        Icon icon = abstractButton.getIcon();
        if (icon == null) {
            icon = this.getDefaultIcon(abstractButton);
        }
        Font font = abstractButton.getFont();
        FontMetrics fontMetrics = abstractButton.getFontMetrics(font);
        AquaButtonLabeledUI.prefViewRect.y = 0;
        AquaButtonLabeledUI.prefViewRect.x = 0;
        AquaButtonLabeledUI.prefViewRect.width = Short.MAX_VALUE;
        AquaButtonLabeledUI.prefViewRect.height = Short.MAX_VALUE;
        AquaButtonLabeledUI.prefIconRect.height = 0;
        AquaButtonLabeledUI.prefIconRect.width = 0;
        AquaButtonLabeledUI.prefIconRect.y = 0;
        AquaButtonLabeledUI.prefIconRect.x = 0;
        AquaButtonLabeledUI.prefTextRect.height = 0;
        AquaButtonLabeledUI.prefTextRect.width = 0;
        AquaButtonLabeledUI.prefTextRect.y = 0;
        AquaButtonLabeledUI.prefTextRect.x = 0;
        SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, string, icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), prefViewRect, prefIconRect, prefTextRect, string == null ? 0 : abstractButton.getIconTextGap());
        int n = Math.min(AquaButtonLabeledUI.prefIconRect.x, AquaButtonLabeledUI.prefTextRect.x);
        int n2 = Math.max(AquaButtonLabeledUI.prefIconRect.x + AquaButtonLabeledUI.prefIconRect.width, AquaButtonLabeledUI.prefTextRect.x + AquaButtonLabeledUI.prefTextRect.width);
        int n3 = Math.min(AquaButtonLabeledUI.prefIconRect.y, AquaButtonLabeledUI.prefTextRect.y);
        int n4 = Math.max(AquaButtonLabeledUI.prefIconRect.y + AquaButtonLabeledUI.prefIconRect.height, AquaButtonLabeledUI.prefTextRect.y + AquaButtonLabeledUI.prefTextRect.height);
        int n5 = n2 - n;
        int n6 = n4 - n3;
        prefInsets = abstractButton.getInsets(prefInsets);
        return new Dimension(n5 += AquaButtonLabeledUI.prefInsets.left + AquaButtonLabeledUI.prefInsets.right, n6 += AquaButtonLabeledUI.prefInsets.top + AquaButtonLabeledUI.prefInsets.bottom);
    }

    public static abstract class LabeledButtonBorder
    extends AquaButtonBorder {
        public LabeledButtonBorder(AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
            super(sizeDescriptor);
        }

        public LabeledButtonBorder(LabeledButtonBorder labeledButtonBorder) {
            super(labeledButtonBorder);
        }

        @Override
        protected AquaPainter<? extends JRSUIState> createPainter() {
            AquaPainter<JRSUIState.ValueState> aquaPainter = AquaPainter.create(JRSUIStateFactory.getLabeledButton());
            ((JRSUIState.ValueState)aquaPainter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
            ((JRSUIState.ValueState)aquaPainter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
            return aquaPainter;
        }

        @Override
        protected void doButtonPaint(AbstractButton abstractButton, ButtonModel buttonModel, Graphics graphics, int n, int n2, int n3, int n4) {
            ((JRSUIState)this.painter.state).set(AquaUtilControlSize.getUserSizeFrom(abstractButton));
            ((JRSUIState.ValueState)this.painter.state).setValue(buttonModel.isSelected() ? (LabeledButtonBorder.isIndeterminate(abstractButton) ? 2.0 : 1.0) : 0.0);
            super.doButtonPaint(abstractButton, buttonModel, graphics, n, n2, n3, n4);
        }

        @Override
        protected JRSUIConstants.State getButtonState(AbstractButton abstractButton, ButtonModel buttonModel) {
            JRSUIConstants.State state = super.getButtonState(abstractButton, buttonModel);
            if (state == JRSUIConstants.State.INACTIVE) {
                return JRSUIConstants.State.INACTIVE;
            }
            if (state == JRSUIConstants.State.DISABLED) {
                return JRSUIConstants.State.DISABLED;
            }
            if (buttonModel.isArmed() && buttonModel.isPressed()) {
                return JRSUIConstants.State.PRESSED;
            }
            if (buttonModel.isSelected()) {
                return JRSUIConstants.State.ACTIVE;
            }
            return state;
        }

        static boolean isIndeterminate(AbstractButton abstractButton) {
            return "indeterminate".equals(abstractButton.getClientProperty("JButton.selectedState"));
        }
    }

    protected static class LazySizingIcon
    extends AquaUtils.LazySingleton<Icon> {
        final int iconSize;

        public LazySizingIcon(int n) {
            this.iconSize = n;
        }

        @Override
        protected Icon getInstance() {
            return new ImageIcon(new BufferedImage(this.iconSize, this.iconSize, 3));
        }
    }
}

