/*
 * Decompiled with CFR 0.152.
 */
package com.apple.eawt;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEventListener;
import com.apple.eawt.ApplicationListener;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.OpenURIHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.PrintFilesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitStrategy;
import com.apple.eawt._AppDockIconHandler;
import com.apple.eawt._AppEventHandler;
import com.apple.eawt._AppMenuBarHandler;
import com.apple.eawt._AppMiscHandlers;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PopupMenu;
import java.beans.Beans;
import java.security.AccessController;
import javax.swing.JMenuBar;
import sun.security.action.LoadLibraryAction;

public class Application {
    static Application sApplication = null;
    final _AppEventHandler eventHandler = _AppEventHandler.getInstance();
    final _AppMenuBarHandler menuBarHandler = _AppMenuBarHandler.getInstance();
    final _AppDockIconHandler iconHandler = new _AppDockIconHandler();

    private static native void nativeInitializeApplicationDelegate();

    private static void checkSecurity() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        securityManager.checkPermission(new RuntimePermission("canProcessApplicationEvents"));
    }

    public static Application getApplication() {
        Application.checkSecurity();
        return sApplication;
    }

    @Deprecated
    public Application() {
        Application.checkSecurity();
    }

    public void addAppEventListener(AppEventListener appEventListener) {
        this.eventHandler.addListener(appEventListener);
    }

    public void removeAppEventListener(AppEventListener appEventListener) {
        this.eventHandler.removeListener(appEventListener);
    }

    public void setAboutHandler(AboutHandler aboutHandler) {
        this.eventHandler.aboutDispatcher.setHandler(aboutHandler);
    }

    public void setPreferencesHandler(PreferencesHandler preferencesHandler) {
        this.eventHandler.preferencesDispatcher.setHandler(preferencesHandler);
    }

    public void setOpenFileHandler(OpenFilesHandler openFilesHandler) {
        this.eventHandler.openFilesDispatcher.setHandler(openFilesHandler);
    }

    public void setPrintFileHandler(PrintFilesHandler printFilesHandler) {
        this.eventHandler.printFilesDispatcher.setHandler(printFilesHandler);
    }

    public void setOpenURIHandler(OpenURIHandler openURIHandler) {
        this.eventHandler.openURIDispatcher.setHandler(openURIHandler);
    }

    public void setQuitHandler(QuitHandler quitHandler) {
        this.eventHandler.quitDispatcher.setHandler(quitHandler);
    }

    public void setQuitStrategy(QuitStrategy quitStrategy) {
        this.eventHandler.setDefaultQuitStrategy(quitStrategy);
    }

    public void enableSuddenTermination() {
        _AppMiscHandlers.enableSuddenTermination();
    }

    public void disableSuddenTermination() {
        _AppMiscHandlers.disableSuddenTermination();
    }

    public void requestForeground(boolean bl) {
        _AppMiscHandlers.requestActivation(bl);
    }

    public void requestUserAttention(boolean bl) {
        _AppMiscHandlers.requestUserAttention(bl);
    }

    public void openHelpViewer() {
        _AppMiscHandlers.openHelpViewer();
    }

    public void setDockMenu(PopupMenu popupMenu) {
        this.iconHandler.setDockMenu(popupMenu);
    }

    public PopupMenu getDockMenu() {
        return this.iconHandler.getDockMenu();
    }

    public void setDockIconImage(Image image) {
        this.iconHandler.setDockIconImage(image);
    }

    public Image getDockIconImage() {
        return this.iconHandler.getDockIconImage();
    }

    public void setDockIconBadge(String string) {
        this.iconHandler.setDockIconBadge(string);
    }

    public void setDefaultMenuBar(JMenuBar jMenuBar) {
        this.menuBarHandler.setDefaultMenuBar(jMenuBar);
    }

    @Deprecated
    public void addApplicationListener(ApplicationListener applicationListener) {
        this.eventHandler.legacyHandler.addLegacyAppListener(applicationListener);
    }

    @Deprecated
    public void removeApplicationListener(ApplicationListener applicationListener) {
        this.eventHandler.legacyHandler.removeLegacyAppListener(applicationListener);
    }

    @Deprecated
    public void setEnabledPreferencesMenu(boolean bl) {
        this.menuBarHandler.setPreferencesMenuItemVisible(true);
        this.menuBarHandler.setPreferencesMenuItemEnabled(bl);
    }

    @Deprecated
    public void setEnabledAboutMenu(boolean bl) {
        this.menuBarHandler.setAboutMenuItemEnabled(bl);
    }

    @Deprecated
    public boolean getEnabledPreferencesMenu() {
        return this.menuBarHandler.isPreferencesMenuItemEnabled();
    }

    @Deprecated
    public boolean getEnabledAboutMenu() {
        return this.menuBarHandler.isAboutMenuItemEnabled();
    }

    @Deprecated
    public boolean isAboutMenuItemPresent() {
        return this.menuBarHandler.isAboutMenuItemVisible();
    }

    @Deprecated
    public void addAboutMenuItem() {
        this.menuBarHandler.setAboutMenuItemVisible(true);
    }

    @Deprecated
    public void removeAboutMenuItem() {
        this.menuBarHandler.setAboutMenuItemVisible(false);
    }

    @Deprecated
    public boolean isPreferencesMenuItemPresent() {
        return this.menuBarHandler.isPreferencesMenuItemVisible();
    }

    @Deprecated
    public void addPreferencesMenuItem() {
        this.menuBarHandler.setPreferencesMenuItemVisible(true);
    }

    @Deprecated
    public void removePreferencesMenuItem() {
        this.menuBarHandler.setPreferencesMenuItemVisible(false);
    }

    @Deprecated
    public static Point getMouseLocationOnScreen() {
        return MouseInfo.getPointerInfo().getLocation();
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        Application.checkSecurity();
        if (!Beans.isDesignTime()) {
            Application.nativeInitializeApplicationDelegate();
        }
        sApplication = new Application();
    }
}

