/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CToolkit;
import apple.awt.OSXSurfaceData;
import apple.awt.RuntimeOptions;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import sun.awt.SunHints;
import sun.font.AppleNativeStrike;
import sun.font.FontStrike;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.pipe.TextPipe;

public class CTextPipe
implements TextPipe {
    static final boolean sRenderString;
    static final boolean sRenderGlyphs;
    static final boolean sRenderUnicodes;

    static native void init(boolean var0);

    native void doDrawString(SurfaceData var1, long var2, String var4, double var5, double var7);

    native void doDrawGlyphs(SurfaceData var1, long var2, GlyphVector var4, float var5, float var6);

    native void doUnicodes(SurfaceData var1, long var2, char[] var4, int var5, int var6, float var7, float var8);

    native void doOneUnicode(SurfaceData var1, long var2, char var4, float var5, float var6);

    long getNativeStrikePtr(SunGraphics2D sunGraphics2D) {
        FontStrike fontStrike = sunGraphics2D.getFontInfo().fontStrike;
        if (!(fontStrike instanceof AppleNativeStrike)) {
            return 0L;
        }
        return ((AppleNativeStrike)fontStrike).getNativeStrikePtr();
    }

    void drawGlyphVectorAsShape(SunGraphics2D sunGraphics2D, GlyphVector glyphVector, float f, float f2) {
        assert (CToolkit.stdio("CTextPipe.drawGlyphVectorAsShape"));
        int n = glyphVector.getNumGlyphs();
        for (int i = 0; i < n; ++i) {
            Shape shape = glyphVector.getGlyphOutline(i, f, f2);
            sunGraphics2D.fill(shape);
        }
    }

    void drawTextAsShape(SunGraphics2D sunGraphics2D, String string, double d, double d2) {
        assert (CToolkit.stdio("CTextPipe.drawTextAsShape"));
        Object object = sunGraphics2D.getRenderingHint(SunHints.KEY_ANTIALIASING);
        FontRenderContext fontRenderContext = sunGraphics2D.getFontRenderContext();
        sunGraphics2D.setRenderingHint(SunHints.KEY_ANTIALIASING, fontRenderContext.isAntiAliased() ? SunHints.VALUE_ANTIALIAS_ON : SunHints.VALUE_ANTIALIAS_OFF);
        Font font = sunGraphics2D.getFont();
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
        int n = glyphVector.getNumGlyphs();
        for (int i = 0; i < n; ++i) {
            Shape shape = glyphVector.getGlyphOutline(i, (float)d, (float)d2);
            sunGraphics2D.fill(shape);
        }
        sunGraphics2D.setRenderingHint(SunHints.KEY_ANTIALIASING, object);
    }

    @Override
    public void drawString(SunGraphics2D sunGraphics2D, String string, double d, double d2) {
        assert (CToolkit.stdio("CTextPipe.drawString:" + sunGraphics2D.getFont()));
        if (!sRenderString) {
            return;
        }
        long l = this.getNativeStrikePtr(sunGraphics2D);
        if (OSXSurfaceData.IsSimpleColor(sunGraphics2D.paint) && l != 0L) {
            OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
            oSXSurfaceData.drawString(this, sunGraphics2D, l, string, d, d2);
        } else {
            this.drawTextAsShape(sunGraphics2D, string, d, d2);
        }
    }

    @Override
    public void drawGlyphVector(SunGraphics2D sunGraphics2D, GlyphVector glyphVector, float f, float f2) {
        assert (CToolkit.stdio("CTextPipe.drawGlyphVector:" + sunGraphics2D.getFont()));
        if (!sRenderGlyphs) {
            return;
        }
        Font font = sunGraphics2D.getFont();
        sunGraphics2D.setFont(glyphVector.getFont());
        long l = this.getNativeStrikePtr(sunGraphics2D);
        if (OSXSurfaceData.IsSimpleColor(sunGraphics2D.paint) && l != 0L) {
            OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
            oSXSurfaceData.drawGlyphs(this, sunGraphics2D, l, glyphVector, f, f2);
        } else {
            this.drawGlyphVectorAsShape(sunGraphics2D, glyphVector, f, f2);
        }
        sunGraphics2D.setFont(font);
    }

    @Override
    public void drawChars(SunGraphics2D sunGraphics2D, char[] cArray, int n, int n2, int n3, int n4) {
        assert (CToolkit.stdio("CTextPipe.drawChars:" + sunGraphics2D.getFont()));
        if (!sRenderUnicodes || n2 <= 0 || cArray == null) {
            return;
        }
        long l = this.getNativeStrikePtr(sunGraphics2D);
        if (OSXSurfaceData.IsSimpleColor(sunGraphics2D.paint) && l != 0L) {
            OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
            oSXSurfaceData.drawUnicodes(this, sunGraphics2D, l, cArray, n, n2, n3, n4);
        } else {
            this.drawTextAsShape(sunGraphics2D, new String(cArray, n, n2), n3, n4);
        }
    }

    public CTextPipe traceWrap() {
        return new Tracer();
    }

    static {
        RuntimeOptions runtimeOptions = RuntimeOptions.getCurrentOptions();
        sRenderString = runtimeOptions.RenderString;
        sRenderGlyphs = runtimeOptions.RenderGlyphs;
        sRenderUnicodes = runtimeOptions.RenderUnicodes;
        CTextPipe.init(runtimeOptions.AlwaysUseCoreText);
    }

    public static class Tracer
    extends CTextPipe {
        void doDrawString(SurfaceData surfaceData, long l, String string, float f, float f2) {
            GraphicsPrimitive.tracePrimitive("QuartzDrawString");
            super.doDrawString(surfaceData, l, string, f, f2);
        }

        @Override
        void doDrawGlyphs(SurfaceData surfaceData, long l, GlyphVector glyphVector, float f, float f2) {
            GraphicsPrimitive.tracePrimitive("QuartzDrawGlyphs");
            super.doDrawGlyphs(surfaceData, l, glyphVector, f, f2);
        }

        @Override
        void doUnicodes(SurfaceData surfaceData, long l, char[] cArray, int n, int n2, float f, float f2) {
            GraphicsPrimitive.tracePrimitive("QuartzDrawUnicodes");
            super.doUnicodes(surfaceData, l, cArray, n, n2, f, f2);
        }

        @Override
        void doOneUnicode(SurfaceData surfaceData, long l, char c, float f, float f2) {
            GraphicsPrimitive.tracePrimitive("QuartzDrawUnicode");
            super.doOneUnicode(surfaceData, l, c, f, f2);
        }
    }
}

