/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.OSXOffScreenSurfaceData;
import apple.awt.RuntimeOptions;
import java.awt.Canvas;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Transparency;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import sun.security.action.LoadLibraryAction;

public class CImage
extends BufferedImage {
    static Creator creator;
    long fNSImage = 0L;

    static Creator getCreator() {
        return creator;
    }

    private static native long getNativeImageFromIconSelector(int var0);

    private static native long getNativeFileSystemIconFor(String var0);

    private static native long getNativeImageFromContentsOf(String var0);

    private static native long getNativeImageFromName(String var0);

    private static native int getNativeWidth(long var0);

    private static native int getNativeHeight(long var0);

    private static native void setNativeSize(long var0, float var2, float var3);

    CImage(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    synchronized void setNativeNSImageSize(float f, float f2) {
        if ((double)f <= 0.0 || (double)f2 <= 0.0) {
            return;
        }
        CImage.setNativeSize(this.fNSImage, f, f2);
    }

    private synchronized void setNSImage(long l) {
        if (this.fNSImage != 0L) {
            this._release(this.fNSImage);
        }
        this.fNSImage = l;
    }

    private void setNSImage() {
        long l = this.makeNSImage(this);
        this.setNSImage(l);
    }

    private long makeNSImage(BufferedImage bufferedImage) {
        return OSXOffScreenSurfaceData.makeNSImage(bufferedImage);
    }

    synchronized long getNSImage() {
        return this.fNSImage;
    }

    private native void _release(long var1);

    void dispose() {
        this.finalize();
    }

    protected synchronized void finalize() {
        if (this.fNSImage != 0L) {
            this._release(this.fNSImage);
            this.fNSImage = 0L;
        }
    }

    static int OSTypeToInt(String string) {
        byte[] byArray = string.getBytes();
        int n = Math.min(byArray.length, 4);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                n2 <<= 8;
            }
            n2 |= byArray[i] & 0xFF;
        }
        return n2;
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        creator = new Creator();
    }

    public static class Creator {
        Creator() {
        }

        public BufferedImage createImage(long l) {
            return this.createImage(l, CImage.getNativeWidth(l), CImage.getNativeHeight(l));
        }

        public BufferedImage createImage(long l, int n, int n2) {
            if (l == 0L) {
                throw new Error("Unable to instantiate CImage with null native image reference.");
            }
            return this.createImageWithSize(l, n, n2);
        }

        public BufferedImage createImageUsingNativeSize(long l) {
            if (l == 0L) {
                return null;
            }
            int n = CImage.getNativeWidth(l);
            int n2 = CImage.getNativeHeight(l);
            return this.createImageWithSize(l, n, n2);
        }

        public BufferedImage createImageWithSize(long l, int n, int n2) {
            Transparency transparency;
            CImage cImage = new CImage(n, n2, 3);
            cImage.setNSImage(l);
            if (!GraphicsEnvironment.isHeadless()) {
                transparency = (OSXOffScreenSurfaceData)OSXOffScreenSurfaceData.createData(cImage);
                ((OSXOffScreenSurfaceData)transparency).copyNSImagePixels(l);
            }
            if (RuntimeOptions.getRenderer() == 1) {
                return cImage;
            }
            transparency = new BufferedImage(n, n2, 3);
            Graphics2D graphics2D = ((BufferedImage)transparency).createGraphics();
            graphics2D.drawImage(cImage, 0, 0, n, n2, null);
            graphics2D.dispose();
            return transparency;
        }

        public CImage createImage(int n, int n2) {
            return new CImage(n, n2, 3);
        }

        public BufferedImage createImageOfFile(String string, int n, int n2) {
            long l = CImage.getNativeFileSystemIconFor(string);
            return this.createImage(l, n, n2);
        }

        public BufferedImage createImageFromFile(String string, int n, int n2) {
            long l = CImage.getNativeImageFromContentsOf(string);
            CImage.setNativeSize(l, n, n2);
            return this.createImage(l, n, n2);
        }

        public BufferedImage createSystemImageFromSelector(String string, int n, int n2) {
            long l = CImage.getNativeImageFromIconSelector(CImage.OSTypeToInt(string));
            return this.createImage(l, n, n2);
        }

        public Image createImageFromName(String string, int n, int n2) {
            long l = CImage.getNativeImageFromName(string);
            return this.createImage(l, n, n2);
        }

        public Image createImageFromName(String string) {
            return this.createImageUsingNativeSize(CImage.getNativeImageFromName(string));
        }

        public CImage createImage(Image image) {
            CImage cImage = null;
            if (image != null) {
                Canvas canvas = new Canvas();
                if (!(image instanceof BufferedImage)) {
                    MediaTracker mediaTracker = new MediaTracker(canvas);
                    mediaTracker.addImage(image, 0);
                    try {
                        mediaTracker.waitForAll();
                    }
                    catch (InterruptedException interruptedException) {
                        System.err.println("ImageTracker interrupted.");
                        Thread.dumpStack();
                        return cImage;
                    }
                }
                int n = Math.max(image.getWidth(canvas), 1);
                int n2 = Math.max(image.getHeight(canvas), 1);
                cImage = new CImage(n, n2, 3);
                Graphics2D graphics2D = cImage.createGraphics();
                graphics2D.drawImage(image, 0, 0, n, n2, null);
                graphics2D.dispose();
                cImage.setNSImage();
            }
            return cImage;
        }
    }
}

