/*
 * Decompiled with CFR 0.152.
 */
package tests.junittests;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import javax.swing.JFrame;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefAuthCallback;
import org.cef.callback.CefRequestCallback;
import org.cef.handler.CefCookieAccessFilter;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefResourceHandler;
import org.cef.handler.CefResourceRequestHandler;
import org.cef.misc.BoolRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;
import org.cef.network.CefURLRequest;
import org.junit.jupiter.api.Assertions;
import tests.junittests.TestResourceHandler;
import tests.junittests.TestSetupContext;

class TestFrame
extends JFrame
implements CefLifeSpanHandler,
CefLoadHandler,
CefRequestHandler,
CefResourceRequestHandler {
    private static final long serialVersionUID = -5570653778104813836L;
    private boolean isClosed_ = false;
    private CountDownLatch countdown_ = new CountDownLatch(1);
    private HashMap<String, ResourceContent> resourceMap_ = null;
    protected final CefClient client_ = CefApp.getInstance().createClient();
    protected CefBrowser browser_ = null;

    TestFrame() {
        Assertions.assertNotNull((Object)this.client_);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                boolean isClosed = TestFrame.this.isClosed_;
                if (isClosed) {
                    TestFrame.this.browser_.setCloseAllowed();
                }
                if (TestSetupContext.debugPrint()) {
                    System.out.println("windowClosing CefBrowser.close(" + isClosed + ")");
                }
                TestFrame.this.browser_.close(isClosed);
                if (!TestFrame.this.isClosed_) {
                    TestFrame.this.isClosed_ = true;
                }
                if (isClosed) {
                    if (TestSetupContext.debugPrint()) {
                        System.out.println("windowClosing Frame.dispose");
                    }
                    TestFrame.this.dispose();
                }
            }
        });
        this.client_.addLifeSpanHandler((CefLifeSpanHandler)this);
        this.client_.addLoadHandler((CefLoadHandler)this);
        this.client_.addRequestHandler((CefRequestHandler)this);
        this.setupTest();
    }

    protected void createBrowser(String startURL) {
        Assertions.assertNull((Object)this.browser_);
        this.browser_ = this.client_.createBrowser(startURL, false, false);
        Assertions.assertNotNull((Object)this.browser_);
        this.getContentPane().add(this.browser_.getUIComponent(), "Center");
        this.pack();
        this.setSize(800, 600);
        this.setVisible(true);
    }

    protected void setupTest() {
    }

    protected void cleanupTest() {
        if (TestSetupContext.debugPrint()) {
            System.out.println("cleanupTest");
        }
        this.client_.dispose();
        this.countdown_.countDown();
    }

    protected final void terminateTest() {
        if (TestSetupContext.debugPrint()) {
            System.out.println("terminateTest");
        }
        if (!this.isClosed_) {
            this.dispatchEvent(new WindowEvent(this, 201));
        }
    }

    public final void awaitCompletion() {
        try {
            this.countdown_.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (TestSetupContext.debugPrint()) {
            System.out.println("awaitCompletion returned");
        }
    }

    protected void addResource(String url, String content, String mimeType) {
        this.addResource(url, content, mimeType, null);
    }

    protected void addResource(String url, String content, String mimeType, HashMap<String, String> headerMap) {
        if (this.resourceMap_ == null) {
            this.resourceMap_ = new HashMap();
        }
        Assertions.assertNull((Object)this.resourceMap_.get(url));
        ResourceContent rc = new ResourceContent();
        rc.content = content;
        rc.mimeType = mimeType;
        rc.headerMap = headerMap;
        this.resourceMap_.put(url, rc);
    }

    public void onAfterCreated(CefBrowser browser) {
        if (TestSetupContext.debugPrint()) {
            System.out.println("onAfterCreated id=" + browser.getIdentifier());
        }
    }

    public boolean onBeforePopup(CefBrowser browser, CefFrame frame, String target_url, String target_frame_name) {
        return false;
    }

    public void onAfterParentChanged(CefBrowser browser) {
    }

    public boolean doClose(CefBrowser browser) {
        boolean result = browser.doClose();
        if (TestSetupContext.debugPrint()) {
            System.out.println("doClose id=" + browser.getIdentifier() + " CefBrowser.doClose=" + result);
        }
        return result;
    }

    public void onBeforeClose(CefBrowser browser) {
        if (TestSetupContext.debugPrint()) {
            System.out.println("onBeforeClose id=" + browser.getIdentifier());
        }
        this.cleanupTest();
    }

    public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
    }

    public void onLoadStart(CefBrowser browser, CefFrame frame, CefRequest.TransitionType transitionType) {
    }

    public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
    }

    public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
    }

    public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean user_gesture, boolean is_redirect) {
        return false;
    }

    public CefResourceRequestHandler getResourceRequestHandler(CefBrowser browser, CefFrame frame, CefRequest request, boolean isNavigation, boolean isDownload, String requestInitiator, BoolRef disableDefaultHandling) {
        return this;
    }

    public boolean getAuthCredentials(CefBrowser browser, String origin_url, boolean isProxy, String host, int port, String realm, String scheme, CefAuthCallback callback) {
        return false;
    }

    public boolean onQuotaRequest(CefBrowser browser, String origin_url, long new_size, CefRequestCallback callback) {
        return false;
    }

    public boolean onCertificateError(CefBrowser browser, CefLoadHandler.ErrorCode cert_error, String request_url, CefRequestCallback callback) {
        return false;
    }

    public void onPluginCrashed(CefBrowser browser, String pluginPath) {
    }

    public void onRenderProcessTerminated(CefBrowser browser, CefRequestHandler.TerminationStatus status) {
    }

    public CefCookieAccessFilter getCookieAccessFilter(CefBrowser browser, CefFrame frame, CefRequest request) {
        return null;
    }

    public boolean onBeforeResourceLoad(CefBrowser browser, CefFrame frame, CefRequest request) {
        return false;
    }

    public CefResourceHandler getResourceHandler(CefBrowser browser, CefFrame frame, CefRequest request) {
        if (this.resourceMap_ != null) {
            ResourceContent rc;
            String url = request.getURL();
            int idx = url.indexOf(63);
            if (idx > 0) {
                url = url.substring(0, idx);
            }
            if ((rc = this.resourceMap_.get(url)) != null) {
                if (TestSetupContext.debugPrint()) {
                    System.out.println("Found resource for: " + url);
                }
                return new TestResourceHandler(rc.content, rc.mimeType, rc.headerMap);
            }
        }
        return null;
    }

    public void onResourceRedirect(CefBrowser browser, CefFrame frame, CefRequest request, CefResponse response, StringRef new_url) {
    }

    public boolean onResourceResponse(CefBrowser browser, CefFrame frame, CefRequest request, CefResponse response) {
        return false;
    }

    public void onResourceLoadComplete(CefBrowser browser, CefFrame frame, CefRequest request, CefResponse response, CefURLRequest.Status status, long receivedContentLength) {
    }

    public void onProtocolExecution(CefBrowser browser, CefFrame frame, CefRequest request, BoolRef allowOsExecution) {
    }

    private class ResourceContent {
        String content;
        String mimeType;
        HashMap<String, String> headerMap;

        private ResourceContent() {
        }
    }
}

