/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geojson;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.geojson.GeoJSONDataStore;
import org.geotools.data.geojson.GeoJSONFeatureReader;
import org.geotools.data.geojson.GeoJSONReader;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoJSONFeatureSource
extends ContentFeatureSource {
    private static final Logger LOGGER = Logging.getLogger((String)GeoJSONFeatureSource.class.getName());
    private FeatureCollection<?, ?> collection = null;

    public GeoJSONFeatureSource(ContentEntry entry, Query query) {
        super(entry, query);
        if (this.schema == null) {
            this.schema = this.getDataStore().schema;
        }
        if (this.schema == null) {
            try {
                this.schema = this.buildFeatureType();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public GeoJSONDataStore getDataStore() {
        return (GeoJSONDataStore)super.getDataStore();
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        this.collection = this.fetchFeatures();
        FeatureCollection sub = this.collection.subCollection(query.getFilter());
        ReferencedEnvelope bounds = sub.getBounds();
        if (bounds.getCoordinateReferenceSystem() == null) {
            bounds = new ReferencedEnvelope((Envelope)bounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        return bounds;
    }

    private FeatureCollection<?, ?> fetchFeatures() throws IOException {
        LOGGER.fine("fetching reader from datastore");
        GeoJSONReader reader = this.getDataStore().read();
        this.collection = reader.getFeatures();
        LOGGER.fine("Got " + this.collection.size() + " features");
        return this.collection;
    }

    protected int getCountInternal(Query query) throws IOException {
        this.collection = this.fetchFeatures();
        FeatureCollection sub = this.collection.subCollection(query.getFilter());
        return sub.size();
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return new GeoJSONFeatureReader(this.getState(), query);
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        if (this.schema == null) {
            FeatureCollection<?, ?> collection = this.fetchFeatures();
            SimpleFeatureType sch = (SimpleFeatureType)collection.getSchema();
            SimpleFeatureTypeBuilder sb = new SimpleFeatureTypeBuilder();
            sb.setName(this.getState().getEntry().getTypeName());
            for (AttributeDescriptor att : sch.getAttributeDescriptors()) {
                sb.add(att);
            }
            if (sch.getCoordinateReferenceSystem() != null) {
                sb.setCRS(sch.getCoordinateReferenceSystem());
            } else {
                sb.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            }
            sb.setDescription(sch.getDescription());
            this.schema = sb.buildFeatureType();
        }
        return this.schema;
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return super.handleVisitor(query, visitor);
    }
}

