/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geojson;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geojson.feature.FeatureJSON;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class GeoJSONWriter {
    private FeatureJSON writer = new FeatureJSON();
    private OutputStream out;
    private DefaultFeatureCollection collection = null;

    public GeoJSONWriter(OutputStream outputStream) {
        this.out = outputStream instanceof BufferedOutputStream ? outputStream : new BufferedOutputStream(outputStream);
        this.collection = new DefaultFeatureCollection();
    }

    public void setSchema(SimpleFeatureType schema) throws IOException {
        this.writer.setEncodeNullValues(true);
        this.writer.setFeatureType(schema);
        if (schema.getCoordinateReferenceSystem() != null) {
            this.writer.writeCRS(schema.getCoordinateReferenceSystem(), this.out);
        }
    }

    public void write(SimpleFeature currentFeature) throws IOException {
        this.collection.add(currentFeature);
    }

    public void close() throws IOException {
        this.writer.writeFeatureCollection((FeatureCollection)this.collection, this.out);
        this.out.close();
        this.writer = null;
    }
}

