/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaMenuPainter;
import com.apple.laf.ScreenMenuBar;
import com.apple.laf.ScreenMenuBarProvider;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MenuBar;
import java.security.AccessController;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.basic.BasicMenuBarUI;
import sun.security.action.GetPropertyAction;

public class AquaMenuBarUI
extends BasicMenuBarUI
implements ScreenMenuBarProvider {
    ScreenMenuBar fScreenMenuBar;
    boolean useScreenMenuBar = AquaMenuBarUI.getScreenMenuBarProperty();

    @Override
    public void uninstallUI(JComponent jComponent) {
        if (this.fScreenMenuBar != null) {
            JFrame jFrame = (JFrame)jComponent.getTopLevelAncestor();
            if (jFrame.getMenuBar() == this.fScreenMenuBar) {
                jFrame.setMenuBar(null);
            }
            this.fScreenMenuBar = null;
        }
        super.uninstallUI(jComponent);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaMenuBarUI();
    }

    @Override
    protected void installKeyboardActions() {
        if (!this.useScreenMenuBar) {
            super.installKeyboardActions();
        }
    }

    @Override
    protected void uninstallKeyboardActions() {
        if (!this.useScreenMenuBar) {
            super.uninstallKeyboardActions();
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        AquaMenuPainter.sPainter.paintMenuBarBackground(graphics, jComponent.getWidth(), jComponent.getHeight(), jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (AquaMenuBarUI.isScreenMenuBar((JMenuBar)jComponent)) {
            if (this.setScreenMenuBar((JFrame)jComponent.getTopLevelAncestor())) {
                // empty if block
            }
            return new Dimension(0, 0);
        }
        return null;
    }

    void clearScreenMenuBar(JFrame jFrame) {
        if (this.useScreenMenuBar) {
            jFrame.setMenuBar(null);
        }
    }

    boolean setScreenMenuBar(JFrame jFrame) {
        if (this.useScreenMenuBar) {
            try {
                this.getScreenMenuBar();
            }
            catch (Throwable throwable) {
                return false;
            }
            jFrame.setMenuBar(this.fScreenMenuBar);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScreenMenuBar getScreenMenuBar() {
        if (!this.useScreenMenuBar) {
            return null;
        }
        AquaMenuBarUI aquaMenuBarUI = this;
        synchronized (aquaMenuBarUI) {
            if (this.fScreenMenuBar == null) {
                this.fScreenMenuBar = new ScreenMenuBar(this.menuBar);
            }
        }
        return this.fScreenMenuBar;
    }

    public static final boolean isScreenMenuBar(JMenuBar jMenuBar) {
        MenuBarUI menuBarUI = jMenuBar.getUI();
        if (menuBarUI instanceof AquaMenuBarUI) {
            if (!((AquaMenuBarUI)menuBarUI).useScreenMenuBar) {
                return false;
            }
            Container container = jMenuBar.getTopLevelAncestor();
            if (container instanceof JFrame) {
                boolean bl;
                MenuBar menuBar = ((JFrame)container).getMenuBar();
                boolean bl2 = bl = ((JFrame)container).getJMenuBar() == jMenuBar;
                if (menuBar == null) {
                    return bl;
                }
                return menuBar instanceof ScreenMenuBar && bl;
            }
        }
        return false;
    }

    private static String getPrivSysProp(String string) {
        return AccessController.doPrivileged(new GetPropertyAction(string));
    }

    static boolean getScreenMenuBarProperty() {
        String[] stringArray = new String[]{""};
        boolean bl = false;
        try {
            stringArray[0] = AquaMenuBarUI.getPrivSysProp("apple.laf.useScreenMenuBar");
            if (stringArray[0] != null && stringArray[0].equals("true")) {
                bl = true;
            } else {
                stringArray[0] = AquaMenuBarUI.getPrivSysProp("com.apple.macos.useScreenMenuBar");
                if (stringArray[0] != null && stringArray[0].equals("true")) {
                    System.err.println("com.apple.macos.useScreenMenuBar has been deprecated. Please switch to apple.laf.useScreenMenuBar");
                    bl = true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }
}

