/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.printj2;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import prospektservice.Feedback;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.base.PSFileFilter;
import prospektservice.printj2.PrintableObject;

public class ScreenAreaPrinter {
    private Component actPane;
    private Image img;
    private static final int xOffSet = 0;
    private static final int yOffSet = 50;
    private static final int PRINT_WIDTH = 780;
    private static final int MAX_HEIGHT = 495;

    public ScreenAreaPrinter(Component c) {
        try {
            this.actPane = c;
            this.renderImage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ScreenAreaPrinter(Component c, int quality) {
        try {
            try {
                this.actPane = c;
                this.actPane.setSize(c.getWidth() * quality, c.getHeight() * quality);
                this.renderImage();
            }
            catch (OutOfMemoryError oome) {
                JOptionPane.showMessageDialog(null, "Es steht nicht gen\u00fcgend Arbeitsspeicher zum Speichern in der gew\u00fcnschten Aufl\u00f6sung zur Verf\u00fcgung.");
                this.actPane.setSize(c.getWidth() / quality, c.getHeight() / quality);
            }
        }
        finally {
            this.actPane.setSize(c.getWidth() / quality, c.getHeight() / quality);
        }
    }

    public void renderImage() {
        Dimension d = this.actPane.getSize();
        this.img = this.actPane.createImage(d.width, d.height);
        this.actPane.paint(this.img.getGraphics());
    }

    public void finish() {
        this.img.flush();
        this.img = null;
    }

    public String saveImage(String fileFormat, float compRatio) throws IOException {
        boolean loopDlg;
        String fileName = "";
        JFileChooser chooser = new JFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        PSFileFilter filter = new PSFileFilter(String.valueOf(fileFormat) + " Dateien" + "|" + fileFormat);
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        File file = new File(PSEnvironment.getPSPath());
        chooser.setCurrentDirectory(file);
        do {
            loopDlg = false;
            if (chooser.showSaveDialog(PSO.mainpanel) == 0) {
                int fb;
                file = chooser.getSelectedFile();
                fileName = file.getAbsolutePath();
                if (!fileName.endsWith("." + fileFormat)) {
                    File tmp;
                    fileName = String.valueOf(fileName) + "." + fileFormat;
                    file = tmp = new File(fileName);
                }
                if (!file.exists() || (fb = Feedback.showQuestion((Component)PSO.mainpanel, 13)) != 1) continue;
                loopDlg = true;
                continue;
            }
            return "";
        } while (loopDlg);
        try {
            ImageWriter iw = null;
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(fileFormat);
            while (iter.hasNext()) {
                iw = iter.next();
            }
            ImageOutputStream out = ImageIO.createImageOutputStream(new File(fileName));
            ImageWriteParam iwp = iw.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(compRatio);
            iw.setOutput(out);
            IIOImage iioImg = new IIOImage((RenderedImage)((Object)this.img), null, null);
            iw.write(null, iioImg, iwp);
            out.flush();
            out.close();
            return fileName;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public void printImage(Graphics g) {
        int x = 0;
        int[] imgDimensions = this.scaleImage();
        x = (780 - imgDimensions[0]) / 2;
        g.drawImage(this.img, x, 50, imgDimensions[0], imgDimensions[1], PSEnvironment.mainframe);
    }

    public boolean printBmpImage(Graphics g, PrintableObject p) {
        String tmpFile = "export/tmp.bmp";
        boolean result = true;
        try {
            int x = 0;
            BMPFile bmp = new BMPFile();
            File dataDir = new File(String.valueOf(PSEnvironment.getPSPath()) + "export");
            if (!dataDir.exists()) {
                dataDir.mkdirs();
            }
            int[] imgDimensions = this.scaleImage();
            bmp.saveBitmap(String.valueOf(PSEnvironment.getPSPath()) + tmpFile, this.img, imgDimensions[0], imgDimensions[1]);
            if (imgDimensions[0] < 780) {
                x = (780 - imgDimensions[0]) / 2;
            }
            p.drawImage(x, 50, imgDimensions[0], imgDimensions[1], tmpFile, g);
            File file = new File(tmpFile);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private int[] scaleImage() {
        int actWidth = this.img.getWidth(this.actPane);
        int actHeight = this.img.getHeight(this.actPane);
        float balance = (float)actWidth / 780.0f;
        actWidth = 780;
        if ((actHeight = Math.round((float)actHeight / balance)) > 445) {
            balance = (float)actHeight / 445.0f;
            actHeight = Math.round((float)actHeight / balance);
            actWidth = Math.round((float)actWidth / balance);
        }
        this.img = this.img.getScaledInstance(actWidth, actHeight, 4);
        int[] dimensions = new int[]{actWidth, actHeight};
        return dimensions;
    }

    public static class BMPFile {
        private static final int BITMAPFILEHEADER_SIZE = 14;
        private static final int BITMAPINFOHEADER_SIZE = 40;
        private byte[] bitmapFileHeader = new byte[14];
        private byte[] bfType = new byte[]{66, 77};
        private int bfSize = 0;
        private int bfReserved1 = 0;
        private int bfReserved2 = 0;
        private int bfOffBits = 54;
        private byte[] bitmapInfoHeader = new byte[40];
        private int biSize = 40;
        private int biWidth = 0;
        private int biHeight = 0;
        private int biPlanes = 1;
        private int biBitCount = 24;
        private int biCompression = 0;
        private int biSizeImage = 196608;
        private int biXPelsPerMeter = 0;
        private int biYPelsPerMeter = 0;
        private int biClrUsed = 0;
        private int biClrImportant = 0;
        private int[] bitmap;
        private FileOutputStream fo;

        public void saveBitmap(String parFilename, Image parImage, int parWidth, int parHeight) {
            try {
                this.fo = new FileOutputStream(parFilename);
                this.save(parImage, parWidth, parHeight);
                this.fo.flush();
                this.fo.close();
            }
            catch (Exception saveEx) {
                saveEx.printStackTrace();
            }
        }

        private void save(Image parImage, int parWidth, int parHeight) {
            try {
                this.convertImage(parImage, parWidth, parHeight);
                this.writeBitmapFileHeader();
                this.writeBitmapInfoHeader();
                this.writeBitmap();
            }
            catch (Exception saveEx) {
                saveEx.printStackTrace();
            }
        }

        private boolean convertImage(Image parImage, int parWidth, int parHeight) {
            this.bitmap = new int[parWidth * parHeight];
            PixelGrabber pg = new PixelGrabber(parImage, 0, 0, parWidth, parHeight, this.bitmap, 0, parWidth);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
            int pad = (4 - parWidth * 3 % 4) * parHeight;
            this.biSizeImage = parWidth * parHeight * 3 + pad;
            this.bfSize = this.biSizeImage + 14 + 40;
            this.biWidth = parWidth;
            this.biHeight = parHeight;
            return true;
        }

        private void writeBitmap() {
            int rowIndex;
            byte[] rgb = new byte[3];
            int size = this.biWidth * this.biHeight - 1;
            int pad = 4 - this.biWidth * 3 % 4;
            if (pad == 4) {
                pad = 0;
            }
            int rowCount = 1;
            int padCount = 0;
            int lastRowIndex = rowIndex = size - this.biWidth;
            try {
                int j = 0;
                while (j < size) {
                    int value = this.bitmap[rowIndex];
                    rgb[0] = (byte)(value & 0xFF);
                    rgb[1] = (byte)(value >> 8 & 0xFF);
                    rgb[2] = (byte)(value >> 16 & 0xFF);
                    this.fo.write(rgb);
                    if (rowCount == this.biWidth) {
                        padCount += pad;
                        int i = 1;
                        while (i <= pad) {
                            this.fo.write(0);
                            ++i;
                        }
                        rowCount = 1;
                        lastRowIndex = rowIndex = lastRowIndex - this.biWidth;
                    } else {
                        ++rowCount;
                    }
                    ++rowIndex;
                    ++j;
                }
                this.bfSize += padCount - pad;
                this.biSizeImage += padCount - pad;
            }
            catch (Exception wb) {
                wb.printStackTrace();
            }
        }

        private void writeBitmapFileHeader() {
            try {
                this.fo.write(this.bfType);
                this.fo.write(this.intToDWord(this.bfSize));
                this.fo.write(this.intToWord(this.bfReserved1));
                this.fo.write(this.intToWord(this.bfReserved2));
                this.fo.write(this.intToDWord(this.bfOffBits));
                this.fo.flush();
            }
            catch (Exception wbfh) {
                wbfh.printStackTrace();
            }
        }

        private void writeBitmapInfoHeader() {
            try {
                this.fo.write(this.intToDWord(this.biSize));
                this.fo.write(this.intToDWord(this.biWidth));
                this.fo.write(this.intToDWord(this.biHeight));
                this.fo.write(this.intToWord(this.biPlanes));
                this.fo.write(this.intToWord(this.biBitCount));
                this.fo.write(this.intToDWord(this.biCompression));
                this.fo.write(this.intToDWord(this.biSizeImage));
                this.fo.write(this.intToDWord(this.biXPelsPerMeter));
                this.fo.write(this.intToDWord(this.biYPelsPerMeter));
                this.fo.write(this.intToDWord(this.biClrUsed));
                this.fo.write(this.intToDWord(this.biClrImportant));
                this.fo.flush();
            }
            catch (Exception wbih) {
                wbih.printStackTrace();
            }
        }

        private byte[] intToWord(int parValue) {
            byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF)};
            return retValue;
        }

        private byte[] intToDWord(int parValue) {
            byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF), (byte)(parValue >> 16 & 0xFF), (byte)(parValue >> 24 & 0xFF)};
            return retValue;
        }
    }
}

